/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.ExportHelperService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.rate.RateHelper;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExportHelperServiceImpl
extends BaseSecureServiceImpl
implements ExportHelperService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContainer<Organization> getSupplierContainer(ServiceInvocationContext sic, BaseProduct product) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-get-supplier");
        try {
            this.checkContext(sic);
            EntityContainer entityContainer = EntityStorage.get().resolve(GeneralProductHelper.getSupplier((BaseProduct)product));
            return entityContainer;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContainer<Organization> getAgencyContainer(ServiceInvocationContext sic, BaseProduct product) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-get-agency");
        try {
            this.checkContext(sic);
            EntityContainer entityContainer = EntityStorage.get().resolve(GeneralProductHelper.getAgency((BaseProduct)product));
            return entityContainer;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContainer<Organization> getSubagencyContainer(ServiceInvocationContext sic, BaseProduct product) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-get-subagency");
        try {
            this.checkContext(sic);
            EntityContainer entityContainer = EntityStorage.get().resolve(GeneralProductHelper.getSubagency((BaseProduct)product));
            return entityContainer;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiscUtil.Pair<Map<String, List<GeneralProductFop>>, List<GeneralProductCommission>> getFopsAndCommissions(ServiceInvocationContext sic, BaseProduct product, String VendorFopsElementName, String SubagentFopsElementName, String ClientFopsElementName) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-get-fops-and-commissions");
        try {
            this.checkContext(sic);
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            LinkedHashMap fops = new LinkedHashMap();
            ArrayList commissions = new ArrayList();
            HashMap<ContractType, String> fopsElementNames = new HashMap<ContractType, String>();
            fopsElementNames.put(ContractType.VENDOR, VendorFopsElementName);
            fopsElementNames.put(ContractType.SUBAGENCY, SubagentFopsElementName);
            fopsElementNames.put(ContractType.CLIENT, ClientFopsElementName);
            for (GeneralProductContractRelationData contractRelation : handler.getUnmodifiableContractRelations(product)) {
                ContractType contractType;
                String fopsElementName;
                if (contractRelation.getDescription() != null && (fopsElementName = (String)fopsElementNames.get(contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()))) != null) {
                    ArrayList contractTypeFops = (ArrayList)fops.get(fopsElementName);
                    if (contractTypeFops == null) {
                        contractTypeFops = new ArrayList();
                        fops.put(fopsElementName, contractTypeFops);
                    }
                    contractTypeFops.addAll(contractRelation.getFops());
                }
                commissions.addAll(contractRelation.getCommissions());
            }
            MiscUtil.Pair result = new MiscUtil.Pair();
            result.setFirst(fops);
            result.setSecond(commissions);
            MiscUtil.Pair pair = result;
            return pair;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getTotalEquivalentFareFromAirProductHelper(ServiceInvocationContext sic, BaseProduct product) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-get-total-equivalent-fare-from-air-product-helper");
        try {
            this.checkContext(sic);
            BigDecimal bigDecimal = AirProductHelper.getTotalEquivalentFare((Product)((Product)product));
            return bigDecimal;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getCurrencyRateForAirProduct(ServiceInvocationContext sic, GeneralProductCommission commission, BaseProduct product) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-get-currency-rate-for-air-product");
        try {
            this.checkContext(sic);
            BigDecimal bigDecimal = RateHelper.getCurrencyRate(null, (String)commission.getAmount().getCurrency(), (Product)((Product)product), (boolean)RulesHelper.isFeeForRefund((EntityReference)commission.getCommissionProperties()), new ArrayList());
            return bigDecimal;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getCurrencyRate(ServiceInvocationContext sic, GeneralProductCommission commission, Date issueDate) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-get-currency-rate");
        try {
            this.checkContext(sic);
            BigDecimal bigDecimal = RateHelper.getCurrencyRate((String)commission.getAmount().getCurrency(), (Date)issueDate, new ArrayList());
            return bigDecimal;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<String> getEntityUids(ServiceInvocationContext sic, Class<BaseEntity> cls) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-get-entity-uids");
        try {
            this.checkContext(sic);
            try {
                List list = LogicalStorage.get().getEntityStorage().getEntityUids(cls, null, null, true, true, SortOrder.DESC, null);
                return list;
            }
            catch (Throwable t) {
                this.log.error("get entity uids failed", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<BaseAsset> getAssets(ServiceInvocationContext sic, ItemExportSettings item) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-get-assets");
        try {
            this.checkContext(sic);
            try {
                List list = AssetsStorage.get().search(XSHelper.getClass((String)item.getObjectId()), new SearchQuery()).getData();
                return list;
            }
            catch (Throwable t) {
                this.log.error("get assets failed", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<String> getDictionaryCodes(ServiceInvocationContext sic, Class<? extends BaseDictionary> cls) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-getDictionaryCodes");
        try {
            this.checkContext(sic);
            try {
                ArrayList<String> arrayList = new ArrayList<String>(DictionaryCache.get().getAll(cls).keySet());
                return arrayList;
            }
            catch (Throwable t) {
                this.log.error("get dictionary codes failed", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<BaseDictionary> getDictionaries(ServiceInvocationContext sic, Class<? extends BaseDictionary> cls, List<String> codes) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportHelperService-getDictionaries");
        try {
            this.checkContext(sic);
            try {
                ArrayList<BaseDictionary> result = new ArrayList<BaseDictionary>();
                Map map = DictionaryCache.get().getAll(cls);
                for (String code : codes) {
                    BaseDictionary dict = (BaseDictionary)map.get(code);
                    if (dict == null) continue;
                    result.add(dict);
                }
                ArrayList<BaseDictionary> arrayList = result;
                return arrayList;
            }
            catch (Throwable t) {
                this.log.error("get dictionaries failed", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

