/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.model.export.TreeDataWrapper;
import com.gridnine.xtrip.common.fx.rpc.ExportSettingsService;
import com.gridnine.xtrip.common.meta.export.BaseExportedElementType;
import com.gridnine.xtrip.common.meta.export.ExportedCollectionType;
import com.gridnine.xtrip.common.meta.export.ExportedElementDataType;
import com.gridnine.xtrip.common.meta.export.ExportedEntityType;
import com.gridnine.xtrip.common.meta.export.ExportedObjectsMetadataHelper;
import com.gridnine.xtrip.common.meta.export.ExportedPropertyType;
import com.gridnine.xtrip.common.meta.export.ExportedRootEntityType;
import com.gridnine.xtrip.common.model.export.ElementExportSettings;
import com.gridnine.xtrip.common.model.export.finance.v2.FinanceDocumentExport;
import com.gridnine.xtrip.common.model.export.finance.v2.ShipmentExport;
import com.gridnine.xtrip.common.model.export.xml.MetadataBasedExportObjectsXmlHelper;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.Map;

public class ExportSettingsServiceImpl
extends BaseSecureServiceImpl
implements ExportSettingsService {
    public TreeDataWrapper getDataTree(ServiceInvocationContext ctx, String entityId) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportSettingsServiceImpl-getDataTree");
        try {
            this.checkContext(ctx);
            try {
                TreeDataWrapper rootWrap = new TreeDataWrapper();
                ElementExportSettings root = new ElementExportSettings();
                ExportedRootEntityType entityType = (ExportedRootEntityType)ExportedObjectsMetadataHelper.getEntityType((String)entityId);
                root.setName("root");
                rootWrap.setSettings(root);
                rootWrap.setDoc(ExportedObjectsMetadataHelper.getDocumentation((BaseExportedElementType)entityType, null));
                boolean isFinanceDocumentExport = entityId.equals(FinanceDocumentExport.class.getName());
                boolean isShipmentExport = entityId.equals(ShipmentExport.class.getName());
                this.toWrapper(rootWrap, (ExportedEntityType)entityType, isFinanceDocumentExport, isShipmentExport);
                TreeDataWrapper treeDataWrapper = rootWrap;
                return treeDataWrapper;
            }
            catch (Throwable t) {
                this.log.error("failed load finance data for person", t);
                throw new ServiceException("failed load finance data for person", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public String generateXsdSchema(ServiceInvocationContext ctx, ElementExportSettings settings, String entityId) throws ServiceException {
        DebugUtil.setThreadName((String)"ExportSettingsServiceImpl-generateXsdSchema");
        try {
            this.checkContext(ctx);
            try {
                String string = MetadataBasedExportObjectsXmlHelper.generateXsd((ExportedRootEntityType)((ExportedRootEntityType)ExportedObjectsMetadataHelper.getEntityType((String)entityId)), (ElementExportSettings)settings);
                return string;
            }
            catch (Throwable t) {
                this.log.error("failed to generate xsd schema", t);
                throw new ServiceException("failed to generate xsd schema", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private void toWrapper(TreeDataWrapper wrapper, ExportedEntityType type, boolean isFinanceDocumentExport, boolean isShipmentExport) {
        ElementExportSettings child;
        TreeDataWrapper wrapChild;
        for (ExportedPropertyType item : ExportedObjectsMetadataHelper.getAllProperties((ExportedEntityType)type).values()) {
            wrapChild = new TreeDataWrapper();
            child = new ElementExportSettings();
            child.setName(item.getId());
            wrapChild.setDoc(ExportedObjectsMetadataHelper.getDocumentation((BaseExportedElementType)item, (ExportedEntityType)type));
            wrapChild.setSettings(child);
            wrapper.getChildren().add(wrapChild);
            if (item.getType() != ExportedElementDataType.ENTITY) continue;
            this.toWrapper(wrapChild, ExportedObjectsMetadataHelper.getEntityType((String)item.getEntityId()), isFinanceDocumentExport, isShipmentExport);
        }
        for (ExportedPropertyType item : ExportedObjectsMetadataHelper.getAllCollections((ExportedEntityType)type).values()) {
            if (this.filter(type, (ExportedCollectionType)item, isFinanceDocumentExport, isShipmentExport)) continue;
            wrapChild = new TreeDataWrapper();
            child = new ElementExportSettings();
            child.setName(item.getId());
            wrapChild.setDoc(ExportedObjectsMetadataHelper.getDocumentation((BaseExportedElementType)item, (ExportedEntityType)type));
            wrapChild.setSettings(child);
            wrapper.getChildren().add(wrapChild);
            for (Map.Entry collElm : ExportedObjectsMetadataHelper.getAllPossibleElements((ExportedCollectionType)item).entrySet()) {
                ExportedEntityType entityType = ExportedObjectsMetadataHelper.getEntityType((String)((String)collElm.getValue()));
                TreeDataWrapper wrap = new TreeDataWrapper();
                ElementExportSettings collElmWrapper = new ElementExportSettings();
                wrap.setDoc(ExportedObjectsMetadataHelper.getDocumentation((BaseExportedElementType)entityType, null));
                collElmWrapper.setName((String)collElm.getKey());
                wrap.setSettings(collElmWrapper);
                wrapChild.getChildren().add(wrap);
                this.toWrapper(wrap, entityType, isFinanceDocumentExport, isShipmentExport);
            }
        }
    }

    private boolean filter(ExportedEntityType type, ExportedCollectionType item, boolean isFinanceDocumentExport, boolean isShipmentExport) {
        if (isFinanceDocumentExport && type.getId().equals(ShipmentExport.class.getName()) && item.getId().equals("financeDocuments")) {
            return true;
        }
        return isShipmentExport && type.getId().equals(FinanceDocumentExport.class.getName()) && item.getId().equals("shipments");
    }
}

