/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.FinanceDocumentsService;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ShipmentProperties;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FinanceDocumentsServiceImpl
extends BaseSecureServiceImpl
implements FinanceDocumentsService {
    public List<String> getInvalidFinanceDocumentProducts(ServiceInvocationContext context, Collection<NestedEntityReference<BookingFile, BaseProduct>> productReferences) throws ServiceException {
        DebugUtil.setThreadName((String)"FinanceDocumentsServiceImpl-getInavlidFinanceDocumentProducts");
        HashSet<String> bookingFileNumbers = new HashSet<String>();
        try {
            this.checkContext(context);
            ArrayList<String> result = new ArrayList<String>();
            for (NestedEntityReference<BookingFile, BaseProduct> productRef : productReferences) {
                EntityContainer bookingCtr = EntityStorage.get().resolve(productRef);
                if (bookingCtr == null) continue;
                BookingFile bookingFile = (BookingFile)bookingCtr.getEntity();
                bookingFileNumbers.add(bookingFile.getNumber());
                BaseProduct product = BookingHelper.findProductByUid((String)productRef.getNestedEntityUid(), (BookingFile)bookingFile);
                if (FinanceDocumentsHelper.isValidProductForFinanceDocument((BaseProduct)product)) continue;
                result.add(BookingHelper.generateShortProductName((BaseProduct)product));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            Xeption xe = Xeption.forDeveloper((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            for (String bookingNumber : bookingFileNumbers) {
                IncidentsHelper.addStackTraceElement((Throwable)xe, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"bookingFileNumber", (String)bookingNumber)});
            }
            throw xe;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Map<NestedEntityReference<BookingFile, BaseProduct>, Set<FinanceDocumentsHelper.FinanceDocumentProductData>> getFinanceDocumentProductDatas(ServiceInvocationContext context, Collection<NestedEntityReference<BookingFile, BaseProduct>> productReferences, EntityReference<Organization> contextSubagency, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FinanceDocumentsServiceImpl-getFinanceDocumentDatas");
        HashSet<String> bookingFileNumbers = new HashSet<String>();
        try {
            this.checkContext(context);
            Map<NestedEntityReference<BookingFile, BaseProduct>, BaseProduct> products = this.getProducts(productReferences, bookingFileNumbers);
            Map map = FinanceDocumentHelper.getShipmentFinanceDocumentProductDatas(products, contextSubagency, (Date)date);
            return map;
        }
        catch (Exception e) {
            this.log.error("unable to get finance data for bookings " + bookingFileNumbers, (Throwable)e);
            Xeption xe = Xeption.forDeveloper((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            for (String bookingNumber : bookingFileNumbers) {
                IncidentsHelper.addStackTraceElement((Throwable)xe, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"bookingFileNumber", (String)bookingNumber)});
            }
            throw xe;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Map<NestedEntityReference<BookingFile, BaseProduct>, Set<FinanceDocumentsHelper.FinanceDocumentProductData>> getFinancePrepaymentDocumentProductDatas(ServiceInvocationContext context, Collection<NestedEntityReference<BookingFile, BaseProduct>> productReferences) throws ServiceException {
        DebugUtil.setThreadName((String)"FinanceDocumentsServiceImpl-getFinancePrepaymentDocumentProductDatas");
        HashSet<String> bookingFileNumbers = new HashSet<String>();
        try {
            this.checkContext(context);
            Map<NestedEntityReference<BookingFile, BaseProduct>, BaseProduct> products = this.getProducts(productReferences, bookingFileNumbers);
            Map map = FinanceDocumentHelper.getFinancePrepaymentDocumentProductDatas(products);
            return map;
        }
        catch (Exception e) {
            Xeption xe = Xeption.forDeveloper((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            for (String bookingNumber : bookingFileNumbers) {
                IncidentsHelper.addStackTraceElement((Throwable)xe, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"bookingFileNumber", (String)bookingNumber)});
            }
            throw xe;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Map<EntityReference<Shipment>, Map<NestedEntityReference<BookingFile, BaseProduct>, FinanceDocumentsHelper.FinanceDocumentProductData>> getCorrectionShipmentFinanceDocumentProductDatas(ServiceInvocationContext context, Collection<NestedEntityReference<BookingFile, BaseProduct>> productReferences) throws ServiceException {
        DebugUtil.setThreadName((String)"FinanceDocumentsServiceImpl-getCorrectionShipmentFinanceDocumentProductDatas");
        HashSet<String> bookingFileNumbers = new HashSet<String>();
        try {
            this.checkContext(context);
            Map<NestedEntityReference<BookingFile, BaseProduct>, BaseProduct> products = this.getProducts(productReferences, bookingFileNumbers);
            Map map = FinanceDocumentHelper.getCorrectionShipmentFinanceDocumentProductDatas(products);
            return map;
        }
        catch (Exception e) {
            Xeption xe = Xeption.forDeveloper((String)e.getMessage(), (Throwable)e, (Object[])new Object[0]);
            for (String bookingNumber : bookingFileNumbers) {
                IncidentsHelper.addStackTraceElement((Throwable)xe, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"bookingFileNumber", (String)bookingNumber)});
            }
            throw xe;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private Map<NestedEntityReference<BookingFile, BaseProduct>, BaseProduct> getProducts(Collection<NestedEntityReference<BookingFile, BaseProduct>> productReferences, Set<String> bookingFileNumbers) {
        HashMap<NestedEntityReference<BookingFile, BaseProduct>, BaseProduct> products = new HashMap<NestedEntityReference<BookingFile, BaseProduct>, BaseProduct>();
        for (NestedEntityReference<BookingFile, BaseProduct> productReference : productReferences) {
            EntityContainer bookingFileContainer = EntityStorage.get().resolve(productReference);
            if (bookingFileContainer == null) continue;
            BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
            bookingFileNumbers.add(bookingFile.getNumber());
            BaseProduct product = BookingHelper.findProductByUid((String)productReference.getNestedEntityUid(), (BookingFile)bookingFile);
            if (product == null) continue;
            products.putAll(Stream.of(Stream.of(product), BookingHelper.getConnectedProducts((BaseProduct)product).stream(), GeneralProductHelper.getHandler((BaseProduct)product).getRelatedProducts(product).stream()).flatMap(item -> item).distinct().collect(Collectors.toMap(item -> new NestedEntityReference(bookingFileContainer, (BaseEntity)item, BookingHelper.generateShortProductName((BaseProduct)item)), item -> item)));
        }
        return products;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShipmentProperties getShipmentProperties(ServiceInvocationContext context, EntityReference<Organization> organization, boolean strict) throws ServiceException {
        DebugUtil.setThreadName((String)"FinanceDocumentsServiceImpl-getShipmentProperties");
        try {
            this.checkContext(context);
            ShipmentProperties shipmentProperties = FinanceDocumentHelper.getShipmentProperties(organization, (boolean)strict);
            return shipmentProperties;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinanceDocumentsProperties getFinanceDocumentProperties(ServiceInvocationContext context, EntityReference<Organization> organization, boolean strict) throws ServiceException {
        DebugUtil.setThreadName((String)"FinanceDocumentsServiceImpl-getFinanceDocumentProperties");
        try {
            this.checkContext(context);
            FinanceDocumentsProperties financeDocumentsProperties = FinanceDocumentHelper.getFinanceDocumentsProperties(organization, (boolean)strict);
            return financeDocumentsProperties;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinanceDocumentsHelper.FinanceConsolidatedDocumentsShipmentsData getFinanceConsolidatedDocumentsShipmentsData(ServiceInvocationContext context, List<MiscUtil.Pair<EntityReference<Shipment>, Boolean>> shipmentReferences) throws ServiceException {
        DebugUtil.setThreadName((String)"FinanceDocumentsServiceImpl-getFinanceConsolidatedDocumentsShipmentsData");
        try {
            this.checkContext(context);
            FinanceDocumentsHelper.FinanceConsolidatedDocumentsShipmentsData financeConsolidatedDocumentsShipmentsData = FinanceDocumentHelper.getFinanceConsolidatedDocumentsShipmentsData(shipmentReferences);
            return financeConsolidatedDocumentsShipmentsData;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<EntityReference<FinanceDocument>, List<EntityReference<FinanceDocument>>> getGroupedDocuments(ServiceInvocationContext context, List<EntityReference<FinanceDocument>> financeDocuments) throws ServiceException {
        DebugUtil.setThreadName((String)"FinanceDocumentsServiceImpl-getGroupFinanceDocuments");
        try {
            this.checkContext(context);
            EntityStorageContext esc = EntityStorageHelper.createContext();
            LinkedHashMap result = new LinkedHashMap();
            for (EntityReference<FinanceDocument> financeDocument : financeDocuments) {
                EntityContainer financeDocumentCtr = EntityStorageHelper.resolve(financeDocument, (EntityStorageContext)esc);
                if (financeDocumentCtr == null) continue;
                ArrayList relatedDocuments = new ArrayList();
                if (!FinanceDocumentsHelper.isPrepayment((FinanceDocumentType)((FinanceDocument)financeDocumentCtr.getEntity()).getType())) {
                    for (EntityReference relatedShipment : ((FinanceDocument)financeDocumentCtr.getEntity()).getRelatedShipments()) {
                        EntityContainer shipmentContainer = EntityStorageHelper.resolve((EntityReference)relatedShipment, (EntityStorageContext)esc);
                        if (shipmentContainer == null) continue;
                        relatedDocuments.addAll(((Shipment)shipmentContainer.getEntity()).getFinanceDocuments());
                    }
                }
                result.put(financeDocument, relatedDocuments);
            }
            LinkedHashMap linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BillingItem> getBillingItems(ServiceInvocationContext context, List<NestedEntityReference<BillingItemsList, BillingItem>> billingItems) throws ServiceException {
        DebugUtil.setThreadName((String)"FinanceDocumentsServiceImpl-getBillingItems");
        try {
            this.checkContext(context);
            List list = FinanceDocumentHelper.getBillingItems(billingItems, (EntityStorageContext)new EntityStorageContext());
            return list;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

