/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.DimensionValue;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.fx.rpc.FinanceServiceProperties;
import com.gridnine.xtrip.common.fx.rpc.FinanceServiceResult;
import com.gridnine.xtrip.common.fx.rpc.TransactionData;
import com.gridnine.xtrip.common.fx.rpc.TransactionDataForBookingFile;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.BasicPaymentDocumentIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationData;
import com.gridnine.xtrip.common.model.finance.FinanceInitializationDataIndex;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.BalanceHelper;
import com.gridnine.xtrip.common.model.helpers.BillingTransactionHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.CreditLimitInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationBalanceIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.BillingTransaction;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FinanceServiceImpl
extends BaseSecureServiceImpl
implements FinanceService {
    public FinanceServiceResult loadDataForPerson(ServiceInvocationContext ctx, FinanceServiceProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"FxFinanceServiceImpl-loadDataForPerson");
        try {
            this.checkContext(ctx);
            try {
                FinanceServiceResult result = FinanceServiceImpl.loadDataPer(properties);
                FinanceServiceResult financeServiceResult = this.loadBalancePer(properties, result);
                return financeServiceResult;
            }
            catch (Throwable t) {
                this.log.error("failed load finance data for person", t);
                throw new ServiceException("failed load finance data for person", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChartOfAccountsSettingsDisabled(ServiceInvocationContext context, EntityReference<Organization> organization) throws ServiceException {
        DebugUtil.setThreadName((String)"FxFinanceServiceImpl-isChartOfAccountsSettingsDisabled");
        try {
            this.checkContext(context);
            EntityContainer chartOfAccountsSettingsContainer = EntityStorage.get().resolve(FinanceHelper.getChartOfAccountsSettings(organization, (boolean)false));
            boolean bl = chartOfAccountsSettingsContainer != null ? FinanceHelper.isChartOfAccountsSettingsDisabled((ChartOfAccountsSettings)((ChartOfAccountsSettings)chartOfAccountsSettingsContainer.getEntity())) : true;
            return bl;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EntityReference<Organization>> getSupplierList(ServiceInvocationContext context, EntityReference<Organization> organization) throws ServiceException {
        DebugUtil.setThreadName((String)"FxFinanceServiceImpl-getSupplierList");
        try {
            this.checkContext(context);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), organization));
            List indexes = EntityStorage.get().search(ContractIndex.class, query).getData();
            List<EntityReference<Organization>> list = indexes.stream().map(iitem -> iitem.getSupplier()).collect(Collectors.toList());
            return list;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public static FinanceServiceResult loadDataPer(FinanceServiceProperties properties) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.agent.name(), (Object)properties.getAgentRef()));
        if (properties.getClientRef() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BillingTransactionIndex.Property.client.name(), (Object)properties.getClientRef()));
        }
        if (properties.getStartDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)MiscUtil.clearTime((Date)properties.getStartDate())));
        }
        if (properties.getEndDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)MiscUtil.setDayEndTime((Date)properties.getEndDate())));
        }
        query.getCriteria().getOrders().put(BillingTransactionIndex.Property.transactionDate.name(), SortOrder.DESC);
        query.getCriteria().getOrders().put(BillingTransactionIndex.Property.category.name(), SortOrder.DESC);
        query.getCriteria().getOrders().put("uid", SortOrder.ASC);
        query.setLimit(properties.getLimit());
        query.setResultMode(ResultMode.DATA_AND_COUNT);
        query.setOffset(properties.getOffset());
        SearchResult searchResult = EntityStorage.get().search(BillingTransactionIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
        ArrayList<TransactionData> list = new ArrayList<TransactionData>();
        FinanceServiceImpl.fillingTransactionData((SearchResult<BillingTransactionIndex>)searchResult, list);
        FinanceServiceResult result = new FinanceServiceResult();
        result.setTransactionData(list);
        result.setOffset(query.getOffset());
        return result;
    }

    private FinanceServiceResult loadBalancePer(FinanceServiceProperties properties, FinanceServiceResult result) throws Exception {
        BigDecimal balanceAmount = BillingTransactionHelper.calculateBillingTransactionsSum(null, (EntityReference)properties.getClientRef(), null, (EntityReference)properties.getAgentRef(), null, null, (String)properties.getCurrency(), null, null, (boolean)false, (boolean)false, (boolean)false);
        CreditLimitInfo clientCreditLimit = null;
        if (properties.getAgencyRef() != null) {
            for (CreditLimitInfo creditLimit : properties.getCreditLimitInfo()) {
                if (creditLimit.getCreditor() == null || !creditLimit.getCreditor().getUid().equals(properties.getAgencyRef().getUid())) continue;
                clientCreditLimit = creditLimit;
                break;
            }
        }
        BigDecimal creditAmount = BigDecimal.ZERO;
        if (clientCreditLimit != null) {
            if (clientCreditLimit.getCreditLimit() != null) {
                creditAmount = creditAmount.add(clientCreditLimit.getCreditLimit());
            }
            if (clientCreditLimit.getTerminalCreditLimit() != null && MiscUtil.isBetween((Date)clientCreditLimit.getTerminalCreditDateStart(), (Date)clientCreditLimit.getTerminalCreditDateEnd(), (Date)new Date())) {
                creditAmount = creditAmount.add(clientCreditLimit.getTerminalCreditLimit());
            }
        }
        BigDecimal availableAmount = balanceAmount.add(creditAmount);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(MiscUtil.clearTime((Date)properties.getStartDate()));
        calendar.add(5, -1);
        BigDecimal startDateBalanceAmount = BillingTransactionHelper.calculateBillingTransactionsSum(null, (EntityReference)properties.getClientRef(), null, (EntityReference)properties.getAgentRef(), null, null, (String)properties.getCurrency(), null, (Date)calendar.getTime(), (boolean)false, (boolean)false, (boolean)false);
        BigDecimal endDateBalanceAmount = BillingTransactionHelper.calculateBillingTransactionsSum(null, (EntityReference)properties.getClientRef(), null, (EntityReference)properties.getAgentRef(), null, null, (String)properties.getCurrency(), null, (Date)MiscUtil.setDayEndTime((Date)properties.getEndDate()), (boolean)false, (boolean)false, (boolean)false);
        result.setBalanceAmount(balanceAmount);
        result.setAvailableAmount(availableAmount);
        result.setStartDateBalanceAmount(startDateBalanceAmount);
        result.setEndDateBalanceAmount(endDateBalanceAmount);
        return result;
    }

    public FinanceServiceResult loadDataForOrganization(ServiceInvocationContext ctx, FinanceServiceProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"FxOrganizationFinanceServiceImpl-loadDataForOrganization");
        try {
            this.checkContext(ctx);
            try {
                FinanceServiceResult result;
                boolean isCalcInNewFinBlock = this.isCalcInNewFinBlockForOrg(properties);
                if (isCalcInNewFinBlock) {
                    result = this.loadDataOrgNewFinBlock(properties);
                } else {
                    result = FinanceServiceImpl.loadDataOrg(properties);
                    this.loadOldBalanceOrg(properties, result);
                }
                result.setNewTransaction(isCalcInNewFinBlock);
                result.setOffset(properties.getOffset());
                FinanceServiceResult financeServiceResult = result;
                return financeServiceResult;
            }
            catch (Throwable t) {
                this.log.error("failed load finance data for organization", t);
                throw new ServiceException("failed load finance data for organization", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private boolean isCalcInNewFinBlockForOrg(FinanceServiceProperties properties) {
        FinanceInitializationDataIndex index = FinanceHelper.getFinanceInitializationDataIndex((EntityReference)properties.getClientRef(), (boolean)false, (String[])new String[0]);
        if (index == null) {
            return false;
        }
        if (index.getDate() == null) {
            return false;
        }
        if (index.isUseNewFinanceModuleOnly()) {
            return true;
        }
        return (properties.getStartDate() == null || !properties.getStartDate().before(index.getDate())) && (properties.getEndDate() == null || !properties.getEndDate().before(index.getDate()));
    }

    private FinanceServiceResult loadDataOrgNewFinBlock(FinanceServiceProperties properties) throws Exception {
        FinanceServiceResult result = new FinanceServiceResult();
        EntityReference<ChartOfAccountsElement> supplierAccountsEl = this.getChartOfAccountsElement((EntityReference<Organization>)properties.getClientRef(), ChartOfAccountsElementType.SUPPLIER, properties.getCurrency());
        if (supplierAccountsEl == null) {
            return result;
        }
        BasicChartOfAccountsElementSettings settings = this.getBasicChartOfAccountElementSettings(supplierAccountsEl);
        this.fillingDimensionType(result, settings);
        SearchResult<TransactionSplitIndex> searchResult = this.getTransactionSplitsForOrg(supplierAccountsEl, properties, settings, ResultMode.DATA_AND_COUNT, true);
        EntityReference<ChartOfAccountsElement> holdAccountsEl = this.getChartOfAccountsElement((EntityReference<Organization>)properties.getClientRef(), ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE, properties.getCurrency());
        List holdTransactions = holdAccountsEl == null ? Collections.emptyList() : this.getTransactionSplitsForOrg(holdAccountsEl, properties, settings, ResultMode.DATA_ONLY, false).getData();
        List<TransactionSplitIndexWrapper> wraps = this.getTransactionWrapListFromSplitIndex(searchResult.getData(), holdTransactions);
        List<TransactionData> transactionDataList = this.getTransactionDataListFromWraps(wraps, settings);
        result.setTransactionData(transactionDataList);
        this.loadBalanceDebitCreditForOrg(supplierAccountsEl, settings, properties, result);
        return result;
    }

    private void fillingDimensionType(FinanceServiceResult result, BasicChartOfAccountsElementSettings settings) {
        if (settings != null) {
            result.setDimensionType1(settings.getDimension1() == null ? null : settings.getDimension1().getType());
            result.setDimensionType2(settings.getDimension2() == null ? null : settings.getDimension2().getType());
            result.setDimensionType3(settings.getDimension3() == null ? null : settings.getDimension3().getType());
        }
    }

    private SearchCriterion toCriterion(String propertyName, Set<EntityReference<Organization>> suppliers) {
        if (suppliers.size() == 1) {
            return SearchCriterion.eq((String)propertyName, suppliers.iterator().next());
        }
        ArrayList<SearchCriterion> crits = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> item : suppliers) {
            crits.add(SearchCriterion.eq((String)propertyName, item));
        }
        return SearchCriterion.or((SearchCriterion[])crits.toArray(new SearchCriterion[crits.size()]));
    }

    private EntityReference<ChartOfAccountsElement> getChartOfAccountsElement(EntityReference<Organization> orgRef, ChartOfAccountsElementType chartOfAccountElType, String currencyCode) {
        EntityReference chartOfAccountsSettings = FinanceHelper.getChartOfAccountsSettings(orgRef);
        if (chartOfAccountsSettings == null) {
            return null;
        }
        return FinanceHelper.getChartOfAccountsElement(orgRef, (EntityReference)chartOfAccountsSettings, (ChartOfAccountsElementType)chartOfAccountElType, (DictionaryReference)new CurrencyInfoReference(currencyCode));
    }

    private SearchResult<TransactionSplitIndex> getTransactionSplitsForOrg(EntityReference<ChartOfAccountsElement> chartOfAccountsElement, FinanceServiceProperties properties, BasicChartOfAccountsElementSettings settings, ResultMode resultMode, boolean withLimit) {
        TransactionSplitIndex.Property agencyIndexProperty;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), (Object)chartOfAccountsElement.getUid()));
        if (properties.getAgencyRef() != null && (agencyIndexProperty = this.searchOrganizationDimension(settings)) != null) {
            String agencyValue = FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)properties.getAgencyRef());
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)agencyIndexProperty.name(), (Object)agencyValue));
        }
        if (properties.getStartDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)TransactionSplitIndex.Property.operationDate.name(), (Object)properties.getStartDate()));
        }
        if (properties.getEndDate() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)TransactionSplitIndex.Property.operationDate.name(), (Object)properties.getEndDate()));
        }
        query.getCriteria().getOrders().put(TransactionSplitIndex.Property.operationDate.name(), SortOrder.DESC);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
        query.getCriteria().getOrders().put(TransactionSplitIndex.Property.credit.name(), SortOrder.DESC);
        query.getCriteria().getOrders().put("uid", SortOrder.ASC);
        if (withLimit) {
            query.setLimit(properties.getLimit());
            query.setOffset(properties.getOffset());
        }
        query.setResultMode(resultMode);
        return EntityStorage.get().search(TransactionSplitIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
    }

    private TransactionSplitIndex.Property searchOrganizationDimension(BasicChartOfAccountsElementSettings settings) {
        if (settings.getDimension1() != null && settings.getDimension1().getType() != null && settings.getDimension1().getType().equals((Object)DimensionType.ORGANIZATION)) {
            return TransactionSplitIndex.Property.dimension1;
        }
        if (settings.getDimension2() != null && settings.getDimension2().getType() != null && settings.getDimension2().getType().equals((Object)DimensionType.ORGANIZATION)) {
            return TransactionSplitIndex.Property.dimension2;
        }
        if (settings.getDimension3() != null && settings.getDimension3().getType() != null && settings.getDimension3().getType().equals((Object)DimensionType.ORGANIZATION)) {
            return TransactionSplitIndex.Property.dimension3;
        }
        return null;
    }

    private List<TransactionSplitIndexWrapper> getTransactionWrapListFromSplitIndex(List<TransactionSplitIndex> data, List<TransactionSplitIndex> holdTransactions) {
        List holdTransUids = holdTransactions.stream().map(tr -> tr.getSource().getUid()).collect(Collectors.toList());
        ArrayList<TransactionSplitIndexWrapper> wrappers = new ArrayList<TransactionSplitIndexWrapper>();
        data.forEach(index -> wrappers.add(new TransactionSplitIndexWrapper((TransactionSplitIndex)index, holdTransUids.contains(index.getSource().getUid()))));
        return wrappers;
    }

    private List<TransactionData> getTransactionDataListFromWraps(List<TransactionSplitIndexWrapper> wraps, BasicChartOfAccountsElementSettings settings) {
        ArrayList<TransactionData> listData = new ArrayList<TransactionData>();
        wraps.forEach(wrap -> {
            EntityReference ref;
            TransactionData transactionData = new TransactionData();
            TransactionSplitIndex transactionIndex = ((TransactionSplitIndexWrapper)wrap).index;
            transactionData.setStatus(((TransactionSplitIndexWrapper)wrap).status);
            BillingTransactionCategory category = transactionIndex.isCredit() ? BillingTransactionCategory.CREDIT : BillingTransactionCategory.DEBIT;
            transactionData.setCategory(category);
            transactionData.setTransactionSum(FinanceHelper.round((BigDecimal)ModelHelper.long2BigDecimal((long)transactionIndex.getAmount())));
            transactionData.setTransactionDate(transactionIndex.getOperationDate());
            this.fillingDimensionValue(transactionData, transactionIndex, settings);
            if (transactionIndex.getBookingUid() != null) {
                ref = EntityStorage.get().actualize(new EntityReference(transactionIndex.getBookingUid(), BookingFile.class, ""));
                transactionData.setBookingFileRef(ref);
                transactionData.setProductUid(transactionIndex.getProductUid());
            } else if (transactionIndex.getDocumentUid() != null) {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)transactionIndex.getDocumentUid()));
                List res = EntityStorage.get().search(BasicPaymentDocumentIndex.class, query).getData();
                if (!res.isEmpty() && res.get(0) != null) {
                    EntityReference ref2 = ((BasicPaymentDocumentIndex)res.get(0)).getSource();
                    transactionData.setDocumentRef(ref2);
                }
            }
            if (TextUtil.nonBlank((String)transactionIndex.getTransactionUid())) {
                ref = EntityStorage.get().actualize(new EntityReference(transactionIndex.getTransactionUid(), BillingTransaction.class, ""));
                transactionData.setSourceBillingTransaction(ref);
            }
            transactionData.setSourceTransaction(transactionIndex.getSource());
            transactionData.setDescription(transactionIndex.getDescription());
            listData.add(transactionData);
        });
        return listData;
    }

    private void loadBalanceDebitCreditForOrg(EntityReference<ChartOfAccountsElement> accountsElRef, BasicChartOfAccountsElementSettings settings, FinanceServiceProperties properties, FinanceServiceResult result) throws Exception {
        TransactionSplitIndex.Property indexProperty = this.searchOrganizationDimension(settings);
        HashMap<FinanceHelper.Dimension, String> dimensions = new HashMap<FinanceHelper.Dimension, String>();
        if (indexProperty != null && properties.getAgencyRef() != null) {
            String value = FinanceHelper.getDimensionValue((DimensionType)DimensionType.ORGANIZATION, (Object)properties.getAgencyRef());
            switch (indexProperty) {
                case dimension1: {
                    dimensions.put(FinanceHelper.Dimension.DIMENSION_1, value);
                    break;
                }
                case dimension2: {
                    dimensions.put(FinanceHelper.Dimension.DIMENSION_2, value);
                    break;
                }
                case dimension3: {
                    dimensions.put(FinanceHelper.Dimension.DIMENSION_3, value);
                }
            }
        }
        BigDecimal balanceAmount = FinanceHelper.calculateBalance(accountsElRef, null, null, null, (boolean)true, dimensions, (FinanceHelper.RoundingParameters)FinanceHelper.RoundingParameters.HALF_UP_2);
        result.setBalanceAmount(balanceAmount);
        BigDecimal balanceAmountNoHistorical = FinanceHelper.calculateBalance(accountsElRef, null, null, null, (boolean)false, dimensions, (FinanceHelper.RoundingParameters)FinanceHelper.RoundingParameters.HALF_UP_2);
        result.setBalanceAmountNoHistorical(balanceAmountNoHistorical);
        if (properties.getStartDate() != null) {
            result.setStartDateBalanceAmount(FinanceHelper.calculateBalance(accountsElRef, null, (Date)MiscUtil.getBeforeTime((Date)properties.getStartDate()), null, (boolean)true, dimensions, (FinanceHelper.RoundingParameters)FinanceHelper.RoundingParameters.HALF_UP_2));
        }
        if (properties.getEndDate() != null) {
            result.setEndDateBalanceAmount(FinanceHelper.calculateBalance(accountsElRef, null, (Date)properties.getEndDate(), null, (boolean)true, dimensions, (FinanceHelper.RoundingParameters)FinanceHelper.RoundingParameters.HALF_UP_2));
        }
        result.setDebitAmount(FinanceHelper.round((BigDecimal)FinanceHelper.calculateBalance(accountsElRef, (Date)(properties.getStartDate() != null ? MiscUtil.getBeforeTime((Date)properties.getStartDate()) : null), (Date)properties.getEndDate(), null, (boolean)true, dimensions, (boolean)false)));
        result.setCreditAmount(FinanceHelper.round((BigDecimal)FinanceHelper.calculateBalance(accountsElRef, (Date)(properties.getStartDate() != null ? MiscUtil.getBeforeTime((Date)properties.getStartDate()) : null), (Date)properties.getEndDate(), null, (boolean)true, dimensions, (boolean)true)));
        BigDecimal availableAmount = MiscUtil.guarded((BigDecimal)balanceAmount);
        if (properties.getAgencyRef() != null && properties.getCreditLimitInfo() != null) {
            for (CreditLimitInfo limitInfo : properties.getCreditLimitInfo()) {
                if (limitInfo.getCreditor() == null || !limitInfo.getCreditor().getUid().equals(properties.getAgencyRef().getUid())) continue;
                availableAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{availableAmount, FinanceServiceImpl.calculateCredit(limitInfo)});
                break;
            }
        }
        result.setAvailableAmount(availableAmount);
    }

    public MiscUtil.Pair<List<TransactionDataForBookingFile>, BigDecimal> loadTransactionForBookingFile(ServiceInvocationContext ctx, EntityReference<BookingFile> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"FxBookingFinanceServiceImpl-loadDataForPayments");
        try {
            HashMap dimensionTypeWrapperHashMap;
            ArrayList listUidHoldTransactionSplit;
            ArrayList transactionData;
            List transactionSplitIndexList;
            this.checkContext(ctx);
            try {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), (Object)ref.getUid()));
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
                transactionSplitIndexList = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
                transactionData = new ArrayList();
                if (transactionSplitIndexList.isEmpty()) {
                    MiscUtil.Pair pair = new MiscUtil.Pair(transactionData, (Object)BigDecimal.ZERO);
                    return pair;
                }
                listUidHoldTransactionSplit = new ArrayList();
                dimensionTypeWrapperHashMap = new HashMap();
            }
            catch (Throwable t) {
                this.log.error("failed load finance data for payments", t);
                throw new ServiceException("failed load finance data for payments", t);
            }
            ValueHolder valueHolder = new ValueHolder((Object)BigDecimal.ZERO);
            List<ChartOfAccountsElementType> holdTypes = Arrays.asList(ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT, ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE);
            Map<String, List<TransactionSplitIndex>> map = transactionSplitIndexList.stream().filter(index -> {
                EntityContainer accountContainer = EntityStorage.get().load(ChartOfAccountsElement.class, index.getAccountUid());
                if (accountContainer == null) {
                    return false;
                }
                if (holdTypes.contains(((ChartOfAccountsElement)accountContainer.getEntity()).getType())) {
                    valueHolder.setValue((Object)MiscUtil.sum((BigDecimal[])new BigDecimal[]{(BigDecimal)valueHolder.getValue(), index.isCredit() ? MiscUtil.negate((BigDecimal)ModelHelper.long2BigDecimal((long)index.getAmount())) : ModelHelper.long2BigDecimal((long)index.getAmount())}));
                }
                if (holdTypes.contains(((ChartOfAccountsElement)accountContainer.getEntity()).getType())) {
                    listUidHoldTransactionSplit.add(index.getSource().getUid());
                }
                if (!((ChartOfAccountsElement)accountContainer.getEntity()).getType().equals((Object)ChartOfAccountsElementType.SUPPLIER)) {
                    return false;
                }
                EntityReference settingsRef = ((ChartOfAccountsElement)accountContainer.getEntity()).getSettings();
                ChartOfAccountsSettings accountSettings = (ChartOfAccountsSettings)EntityStorage.get().resolve(settingsRef).getEntity();
                dimensionTypeWrapperHashMap.put(index.getAccountUid(), new DimensionTypeWrapper(accountSettings.getSupplierSettings()));
                return true;
            }).collect(Collectors.groupingBy(index -> {
                if (index.getProductUid() == null) {
                    return "";
                }
                return index.getProductUid();
            }));
            map.forEach((key, value) -> value.sort((o1, o2) -> {
                if (o2.getProductUid() == null || o2.getProductUid().equals("")) {
                    return -1;
                }
                if (o1.getProductUid() == null || o1.getProductUid().equals("")) {
                    return 1;
                }
                return o1.getProductUid().compareTo(o2.getProductUid());
            }));
            new HashSet<Map.Entry<String, List<TransactionSplitIndex>>>(map.entrySet()).forEach(entrySet -> ((List)entrySet.getValue()).forEach(index -> {
                TransactionDataForBookingFile element = new TransactionDataForBookingFile();
                this.fillingTransactionDataDimensionTypeAndValue(dimensionTypeWrapperHashMap, element, (TransactionSplitIndex)index);
                element.setTransactionSum(FinanceHelper.round((BigDecimal)ModelHelper.long2BigDecimal((long)index.getAmount())));
                element.setCredit(index.isCredit());
                element.setTransactionDate(index.getOperationDate());
                element.setDescription(index.getDescription());
                element.setProductUid((String)entrySet.getKey());
                element.setAgencyRef(index.getOrganization());
                if (listUidHoldTransactionSplit.contains(index.getSource().getUid())) {
                    element.setStatus(BillingTransactionStatus.HOLD);
                } else {
                    element.setStatus(BillingTransactionStatus.ACTIVE);
                }
                transactionData.add(element);
            }));
            MiscUtil.Pair result = new MiscUtil.Pair();
            result.setFirst(transactionData);
            result.setSecond(valueHolder.getValue());
            MiscUtil.Pair pair = result;
            return pair;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private void fillingTransactionDataDimensionTypeAndValue(Map<String, DimensionTypeWrapper> dimensionTypeWrapperHashMap, TransactionDataForBookingFile element, TransactionSplitIndex index) {
        DimensionTypeWrapper dimensionTypeWrapper = dimensionTypeWrapperHashMap.get(index.getAccountUid());
        if (dimensionTypeWrapper != null) {
            element.setDimensionType1(dimensionTypeWrapper.dimensionType1);
            element.setDimensionType2(dimensionTypeWrapper.dimensionType2);
            element.setDimensionType3(dimensionTypeWrapper.dimensionType3);
            if (index.getDimension1() != null) {
                element.setDimensionValue1(FinanceHelper.getDimensionObject((DimensionType)dimensionTypeWrapper.dimensionType1, (String)index.getDimension1()));
            }
            if (index.getDimension2() != null) {
                element.setDimensionValue2(FinanceHelper.getDimensionObject((DimensionType)dimensionTypeWrapper.dimensionType2, (String)index.getDimension2()));
            }
            if (index.getDimension3() != null) {
                element.setDimensionValue3(FinanceHelper.getDimensionObject((DimensionType)dimensionTypeWrapper.dimensionType3, (String)index.getDimension3()));
            }
        }
    }

    private void fillingDimensionValue(TransactionData element, TransactionSplitIndex index, BasicChartOfAccountsElementSettings settings) {
        if (settings != null) {
            if (settings.getDimension1() != null && index.getDimension1() != null) {
                element.setDimensionValue1(FinanceHelper.getDimensionObject((DimensionType)settings.getDimension1().getType(), (String)index.getDimension1()));
            }
            if (settings.getDimension2() != null && index.getDimension2() != null) {
                element.setDimensionValue2(FinanceHelper.getDimensionObject((DimensionType)settings.getDimension2().getType(), (String)index.getDimension2()));
            }
            if (settings.getDimension3() != null && index.getDimension3() != null) {
                element.setDimensionValue3(FinanceHelper.getDimensionObject((DimensionType)settings.getDimension3().getType(), (String)index.getDimension3()));
            }
        }
    }

    public FinanceServiceResult loadTransactionAndBalanceForEditor(ServiceInvocationContext ctx, FinanceServiceProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"FxBalanceEditorFinanceServiceImpl-loadTransactionAndBalanceForEditor");
        try {
            this.checkContext(ctx);
            try {
                CreditLimitInfo creditLimitInfo;
                FinanceServiceResult result = new FinanceServiceResult();
                EntityReference ref = properties.getAccountsElementEntityReference();
                EntityContainer accountCtr = EntityStorage.get().resolve(ref);
                Map dimensions = properties.getDimensions();
                BigDecimal balanceAmount = FinanceHelper.calculateBalance((EntityReference)ref, null, null, null, (boolean)true, (Map)dimensions, (FinanceHelper.RoundingParameters)FinanceHelper.RoundingParameters.HALF_UP_2);
                result.setBalanceAmount(balanceAmount);
                BigDecimal balanceAmountNoHistorical = FinanceHelper.calculateBalance((EntityReference)ref, null, null, null, (boolean)false, (Map)dimensions, (FinanceHelper.RoundingParameters)FinanceHelper.RoundingParameters.HALF_UP_2);
                result.setBalanceAmountNoHistorical(balanceAmountNoHistorical);
                if (((ChartOfAccountsElement)accountCtr.getEntity()).getType().equals((Object)ChartOfAccountsElementType.SUPPLIER) && properties.getCreditorForSearch() != null && (creditLimitInfo = ProfileHelper.getOrganizationCreditLimit((EntityReference)((ChartOfAccountsElement)accountCtr.getEntity()).getOrganization(), (EntityReference)properties.getCreditorForSearch())) != null) {
                    if (creditLimitInfo.isUnlimited()) {
                        result.setUnlimited(true);
                    } else {
                        BigDecimal creditAmountFromSupplier = FinanceServiceImpl.getCreditAmountFromSupplier(creditLimitInfo);
                        result.setCreditAmountFromSupplier(creditAmountFromSupplier);
                        result.setAvailableAmount(balanceAmount.add(creditAmountFromSupplier));
                    }
                }
                if (properties.getStartDate() != null) {
                    result.setStartDateBalanceAmount(FinanceHelper.calculateBalance((EntityReference)ref, null, (Date)MiscUtil.getBeforeTime((Date)properties.getStartDate()), (Date)properties.getCalculationDateEnd(), (boolean)true, (Map)dimensions, (FinanceHelper.RoundingParameters)FinanceHelper.RoundingParameters.HALF_UP_2));
                }
                if (properties.getEndDate() != null) {
                    result.setEndDateBalanceAmount(FinanceHelper.calculateBalance((EntityReference)ref, null, (Date)properties.getEndDate(), (Date)properties.getCalculationDateEnd(), (boolean)true, (Map)dimensions, (FinanceHelper.RoundingParameters)FinanceHelper.RoundingParameters.HALF_UP_2));
                }
                result.setDebitAmount(FinanceHelper.round((BigDecimal)FinanceHelper.calculateBalance((EntityReference)ref, (Date)(properties.getStartDate() != null ? MiscUtil.getBeforeTime((Date)properties.getStartDate()) : null), (Date)properties.getEndDate(), (Date)properties.getCalculationDateEnd(), (boolean)true, (Map)dimensions, (boolean)false)));
                result.setCreditAmount(FinanceHelper.round((BigDecimal)FinanceHelper.calculateBalance((EntityReference)ref, (Date)(properties.getStartDate() != null ? MiscUtil.getBeforeTime((Date)properties.getStartDate()) : null), (Date)properties.getEndDate(), (Date)properties.getCalculationDateEnd(), (boolean)true, (Map)dimensions, (boolean)true)));
                SearchQuery query = new SearchQuery();
                if (!properties.getSorting().isEmpty()) {
                    properties.getSorting().forEach(pair -> {
                        SortOrder cfr_ignored_0 = (SortOrder)query.getCriteria().getOrders().put(pair.getFirst(), pair.getSecond());
                    });
                } else {
                    query.getCriteria().getOrders().put(TransactionSplitIndex.Property.operationDate.name(), SortOrder.DESC);
                    query.getCriteria().getOrders().put(TransactionSplitIndex.Property.calculationDate.name(), SortOrder.DESC);
                }
                query.getCriteria().getOrders().put("uid", SortOrder.ASC);
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.accountUid.name(), (Object)ref.getUid()));
                if (dimensions.get(FinanceHelper.Dimension.DIMENSION_1) != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension1.name(), dimensions.get(FinanceHelper.Dimension.DIMENSION_1)));
                }
                if (dimensions.get(FinanceHelper.Dimension.DIMENSION_2) != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension2.name(), dimensions.get(FinanceHelper.Dimension.DIMENSION_2)));
                }
                if (dimensions.get(FinanceHelper.Dimension.DIMENSION_3) != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.dimension3.name(), dimensions.get(FinanceHelper.Dimension.DIMENSION_3)));
                }
                if (properties.getStartDate() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.ge((String)TransactionSplitIndex.Property.operationDate.name(), (Object)properties.getStartDate()));
                }
                if (properties.getEndDate() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.le((String)TransactionSplitIndex.Property.operationDate.name(), (Object)properties.getEndDate()));
                }
                if (properties.getCalculationDateStart() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.ge((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)properties.getCalculationDateStart()));
                }
                if (properties.getCalculationDateEnd() != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.le((String)TransactionSplitIndex.Property.calculationDate.name(), (Object)properties.getCalculationDateEnd()));
                }
                if (!properties.isShowHistoricalTransactions()) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
                }
                query.setLimit(properties.getLimit());
                query.setOffset(properties.getOffset());
                query.setResultMode(ResultMode.DATA_AND_COUNT);
                BasicChartOfAccountsElementSettings settings = this.getBasicChartOfAccountElementSettings((EntityReference<ChartOfAccountsElement>)ref);
                SearchResult indexList = EntityStorage.get().search(TransactionSplitIndex.class, query);
                indexList.getData().forEach(index -> {
                    if (index.getSource() == null) {
                        return;
                    }
                    TransactionData element = new TransactionData();
                    this.fillingDimensionValue(element, (TransactionSplitIndex)index, settings);
                    element.setHistorical(index.isHistorical());
                    element.setDescription(index.getDescription());
                    element.setTransactionDate(index.getOperationDate());
                    element.setCredit(index.isCredit());
                    element.setCalculationDate(index.getCalculationDate());
                    element.setTransactionSum(FinanceHelper.round((BigDecimal)ModelHelper.long2BigDecimal((long)index.getAmount())));
                    element.setTransactionReference(index.getSource());
                    result.getTransactionData().add(element);
                });
                result.setOffset(query.getOffset());
                FinanceServiceResult financeServiceResult = result;
                return financeServiceResult;
            }
            catch (Throwable t) {
                this.log.error("failed load transaction and balance for Balance editor", t);
                throw new ServiceException("failed load transaction and balance for Balance editor", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public DimensionValue loadDimensionValueForTransaction(ServiceInvocationContext ctx, EntityReference<Transaction> transactionRef) throws ServiceException {
        DebugUtil.setThreadName((String)"FxFinanceServiceImpl-loadDimensionValueForTransaction");
        try {
            EntityReference chartOfAccountsElementDebit;
            BasicChartOfAccountsElementSettings settingsDebit;
            EntityContainer trCtr;
            DimensionValue result;
            block15: {
                this.checkContext(ctx);
                try {
                    result = new DimensionValue();
                    trCtr = EntityStorage.get().resolve(transactionRef);
                    if (trCtr != null) break block15;
                    DimensionValue dimensionValue = result;
                    return dimensionValue;
                }
                catch (Throwable t) {
                    this.log.error("failed load dimension value for transaction", t);
                    throw new ServiceException("failed load dimension value for transaction", t);
                }
            }
            List splits = ((Transaction)trCtr.getEntity()).getSplits();
            TransactionSplit splitCredit = ((TransactionSplit)splits.get(0)).isCredit() ? (TransactionSplit)splits.get(0) : (TransactionSplit)splits.get(1);
            TransactionSplit splitDebit = ((TransactionSplit)splits.get(0)).isCredit() ? (TransactionSplit)splits.get(1) : (TransactionSplit)splits.get(0);
            EntityReference chartOfAccountsElementCredit = splitCredit.getAccount();
            BasicChartOfAccountsElementSettings settingsCredit = this.getBasicChartOfAccountElementSettings((EntityReference<ChartOfAccountsElement>)chartOfAccountsElementCredit);
            if (settingsCredit != null) {
                if (settingsCredit.getDimension1() != null && splitCredit.getDimension1() != null) {
                    result.setCreditDimensionValue1(FinanceHelper.getDimensionObject((DimensionType)settingsCredit.getDimension1().getType(), (String)splitCredit.getDimension1()));
                }
                if (settingsCredit.getDimension2() != null && splitCredit.getDimension2() != null) {
                    result.setCreditDimensionValue2(FinanceHelper.getDimensionObject((DimensionType)settingsCredit.getDimension2().getType(), (String)splitCredit.getDimension2()));
                }
                if (settingsCredit.getDimension3() != null && splitCredit.getDimension3() != null) {
                    result.setCreditDimensionValue3(FinanceHelper.getDimensionObject((DimensionType)settingsCredit.getDimension3().getType(), (String)splitCredit.getDimension3()));
                }
            }
            if ((settingsDebit = this.getBasicChartOfAccountElementSettings((EntityReference<ChartOfAccountsElement>)(chartOfAccountsElementDebit = splitDebit.getAccount()))) != null) {
                if (settingsDebit.getDimension1() != null && splitDebit.getDimension1() != null) {
                    result.setDebitDimensionValue1(FinanceHelper.getDimensionObject((DimensionType)settingsDebit.getDimension1().getType(), (String)splitDebit.getDimension1()));
                }
                if (settingsDebit.getDimension2() != null && splitDebit.getDimension2() != null) {
                    result.setDebitDimensionValue2(FinanceHelper.getDimensionObject((DimensionType)settingsDebit.getDimension2().getType(), (String)splitDebit.getDimension2()));
                }
                if (settingsDebit.getDimension3() != null && splitDebit.getDimension3() != null) {
                    result.setDebitDimensionValue3(FinanceHelper.getDimensionObject((DimensionType)settingsDebit.getDimension3().getType(), (String)splitDebit.getDimension3()));
                }
            }
            DimensionValue dimensionValue = result;
            return dimensionValue;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTransaction(ServiceInvocationContext ctx, EntityContainer<Transaction> transactionEntityContainer) throws ServiceException {
        DebugUtil.setThreadName((String)"FxFinanceServiceImpl-saveTransaction");
        try {
            this.checkContext(ctx);
            try {
                FinanceHelper.save(transactionEntityContainer);
            }
            catch (Throwable t) {
                this.log.error("failed load save transaction", t);
                throw new ServiceException("failed load save transaction", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTransaction(ServiceInvocationContext ctx, List<EntityReference<Transaction>> transactionRefList) throws ServiceException {
        DebugUtil.setThreadName((String)"FxFinanceServiceImpl-deleteTransaction");
        try {
            this.checkContext(ctx);
            try {
                transactionRefList.forEach(ref -> {
                    try {
                        FinanceHelper.delete((EntityContainer)EntityStorage.get().resolve(ref));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Throwable t) {
                this.log.error("failed load delete transaction", t);
                throw new ServiceException("failed load delete transaction", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public BasicChartOfAccountsElementSettings loadAccountsElementSettings(ServiceInvocationContext ctx, EntityReference<ChartOfAccountsElement> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"FxOrganizationFinanceServiceImpl-loadAccountsElementSettings");
        try {
            this.checkContext(ctx);
            try {
                BasicChartOfAccountsElementSettings basicChartOfAccountsElementSettings = this.getBasicChartOfAccountElementSettings(ref);
                return basicChartOfAccountsElementSettings;
            }
            catch (Throwable t) {
                this.log.error("failed load accounts element settings", t);
                throw new ServiceException("failed load accounts element settings", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public EntityReference<ChartOfAccountsSettings> getChartOfAccountsSettings(ServiceInvocationContext ctx, EntityReference<Organization> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"FxBalanceEditorFinanceServiceImpl-getChartOfAccountsSettings");
        try {
            this.checkContext(ctx);
            try {
                EntityReference entityReference = FinanceHelper.getChartOfAccountsSettings(ref);
                return entityReference;
            }
            catch (Throwable t) {
                this.log.error("failed load accounts element settings", t);
                throw new ServiceException("failed load accounts element settings", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<TransactionDataForBookingFile> loadTransactionForBankTransferOrder(ServiceInvocationContext ctx, EntityReference<? extends BasePaymentDocument> refDocument, EntityReference<Contract> refContract) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPaymentDocumentFinanceServiceImpl-loadTransactionForBankTransferOrder");
        try {
            EntityReference refOrganization;
            block25: {
                this.checkContext(ctx);
                try {
                    if (refContract != null) break block25;
                    ArrayList<TransactionDataForBookingFile> arrayList = new ArrayList<TransactionDataForBookingFile>();
                    return arrayList;
                }
                catch (Throwable t) {
                    this.log.error("failed load finance data for bank transfer order", t);
                    throw new ServiceException("failed load finance data for bank transfer order", t);
                }
            }
            EntityContainer contract = EntityStorage.get().resolve(refContract);
            if (contract == null) {
                ArrayList<TransactionDataForBookingFile> arrayList = new ArrayList<TransactionDataForBookingFile>();
                return arrayList;
            }
            ContractType typeContract = ((Contract)contract.getEntity()).getContractType();
            EntityContainer ctrDocument = EntityStorage.get().resolve(refDocument);
            if (ctrDocument == null) {
                ArrayList<TransactionDataForBookingFile> arrayList = new ArrayList<TransactionDataForBookingFile>();
                return arrayList;
            }
            if (ContractType.VENDOR.equals((Object)typeContract)) {
                refOrganization = ((BasePaymentDocument)ctrDocument.getEntity()).getOrganization();
            } else if (ContractType.SUBAGENCY.equals((Object)typeContract) || ContractType.CLIENT.equals((Object)typeContract)) {
                refOrganization = ((BasePaymentDocument)ctrDocument.getEntity()).getPayer();
                if (Person.class.isAssignableFrom(refOrganization.getType())) {
                    ArrayList<TransactionDataForBookingFile> arrayList = new ArrayList<TransactionDataForBookingFile>();
                    return arrayList;
                }
            } else {
                ArrayList<TransactionDataForBookingFile> arrayList = new ArrayList<TransactionDataForBookingFile>();
                return arrayList;
            }
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.documentUid.name(), (Object)refDocument.getUid()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.organization.name(), (Object)refOrganization));
            List listTransactionIndex = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
            ArrayList<TransactionDataForBookingFile> resultList = new ArrayList<TransactionDataForBookingFile>();
            if (listTransactionIndex.isEmpty()) {
                ArrayList<TransactionDataForBookingFile> arrayList = resultList;
                return arrayList;
            }
            for (TransactionSplitIndex index : listTransactionIndex) {
                TransactionDataForBookingFile element = new TransactionDataForBookingFile();
                EntityContainer accountContainer = EntityStorage.get().load(ChartOfAccountsElement.class, index.getAccountUid());
                if (accountContainer == null || !((ChartOfAccountsElement)accountContainer.getEntity()).getType().equals((Object)ChartOfAccountsElementType.SUPPLIER)) continue;
                element.setStatus(BillingTransactionStatus.ACTIVE);
                EntityReference settingsRef = ((ChartOfAccountsElement)accountContainer.getEntity()).getSettings();
                EntityContainer ctrAccountSettings = EntityStorage.get().resolve(settingsRef);
                if (ctrAccountSettings == null) continue;
                BasicChartOfAccountsElementSettings supplierSettings = ((ChartOfAccountsSettings)ctrAccountSettings.getEntity()).getSupplierSettings();
                if (supplierSettings != null) {
                    if (supplierSettings.getDimension1() != null) {
                        element.setDimensionType1(supplierSettings.getDimension1().getType());
                    }
                    if (supplierSettings.getDimension2() != null) {
                        element.setDimensionType2(supplierSettings.getDimension2().getType());
                    }
                    if (supplierSettings.getDimension3() != null) {
                        element.setDimensionType3(supplierSettings.getDimension3().getType());
                    }
                }
                this.fillingDimensionValue((TransactionData)element, index, supplierSettings);
                element.setHistorical(index.isHistorical());
                element.setDescription(index.getDescription());
                element.setTransactionDate(index.getOperationDate());
                element.setCredit(index.isCredit());
                element.setTransactionSum(FinanceHelper.round((BigDecimal)ModelHelper.long2BigDecimal((long)index.getAmount())));
                element.setTransactionReference(index.getSource());
                resultList.add(element);
            }
            ArrayList<TransactionDataForBookingFile> arrayList = resultList;
            return arrayList;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<TransactionDataForBookingFile> loadTransactionForSlip(ServiceInvocationContext ctx, EntityReference<? extends BasePaymentDocument> refDocument, EntityReference<Organization> refAgency) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPaymentDocumentFinanceServiceImpl-loadTransactionForSlip");
        try {
            block14: {
                this.checkContext(ctx);
                try {
                    if (refAgency != null) break block14;
                    ArrayList<TransactionDataForBookingFile> arrayList = new ArrayList<TransactionDataForBookingFile>();
                    return arrayList;
                }
                catch (Throwable t) {
                    this.log.error("failed load finance data for slip", t);
                    throw new ServiceException("failed load finance data for slip", t);
                }
            }
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.documentUid.name(), (Object)refDocument.getUid()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.organization.name(), refAgency));
            List listTransactionIndex = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
            ArrayList<TransactionDataForBookingFile> resultList = new ArrayList<TransactionDataForBookingFile>();
            if (listTransactionIndex.isEmpty()) {
                ArrayList<TransactionDataForBookingFile> arrayList = resultList;
                return arrayList;
            }
            for (TransactionSplitIndex index : listTransactionIndex) {
                TransactionDataForBookingFile element = new TransactionDataForBookingFile();
                EntityContainer accountContainer = EntityStorage.get().load(ChartOfAccountsElement.class, index.getAccountUid());
                if (accountContainer == null || !((ChartOfAccountsElement)accountContainer.getEntity()).getType().equals((Object)ChartOfAccountsElementType.CASH)) continue;
                element.setStatus(BillingTransactionStatus.ACTIVE);
                EntityReference settingsRef = ((ChartOfAccountsElement)accountContainer.getEntity()).getSettings();
                EntityContainer ctrAccountSettings = EntityStorage.get().resolve(settingsRef);
                if (ctrAccountSettings == null) continue;
                BasicChartOfAccountsElementSettings cashSettings = ((ChartOfAccountsSettings)ctrAccountSettings.getEntity()).getAgentSettings();
                if (cashSettings != null) {
                    if (cashSettings.getDimension1() != null) {
                        element.setDimensionType1(cashSettings.getDimension1().getType());
                    }
                    if (cashSettings.getDimension2() != null) {
                        element.setDimensionType2(cashSettings.getDimension2().getType());
                    }
                    if (cashSettings.getDimension3() != null) {
                        element.setDimensionType3(cashSettings.getDimension3().getType());
                    }
                }
                this.fillingDimensionValue((TransactionData)element, index, cashSettings);
                element.setHistorical(index.isHistorical());
                element.setDescription(index.getDescription());
                element.setTransactionDate(index.getOperationDate());
                element.setCredit(index.isCredit());
                element.setTransactionSum(FinanceHelper.round((BigDecimal)ModelHelper.long2BigDecimal((long)index.getAmount())));
                element.setTransactionReference(index.getSource());
                resultList.add(element);
            }
            ArrayList<TransactionDataForBookingFile> arrayList = resultList;
            return arrayList;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private BasicChartOfAccountsElementSettings getBasicChartOfAccountElementSettings(EntityReference<ChartOfAccountsElement> ref) {
        EntityContainer accountsElementContainer = EntityStorage.get().resolve(ref);
        if (EntityStorageHelper.isEmpty((EntityContainer)accountsElementContainer)) {
            throw Xeption.forDeveloper((String)"Chart of accounts element {0} is not found", (Object[])new Object[]{ref});
        }
        if (((ChartOfAccountsElement)accountsElementContainer.getEntity()).getSettings() == null) {
            throw Xeption.forDeveloper((String)"Settings for chart of accounts element {0} are absent", (Object[])new Object[]{accountsElementContainer.toReference()});
        }
        EntityContainer settingsContainer = EntityStorage.get().resolve(((ChartOfAccountsElement)accountsElementContainer.getEntity()).getSettings());
        if (EntityStorageHelper.isEmpty((EntityContainer)settingsContainer)) {
            throw Xeption.forDeveloper((String)"Settings {0} of chart of accounts element {0} are not found", (Object[])new Object[]{((ChartOfAccountsElement)accountsElementContainer.getEntity()).getSettings(), accountsElementContainer.toReference()});
        }
        return FinanceHelper.getChartOfAccountsElementSettings((ChartOfAccountsSettings)((ChartOfAccountsSettings)settingsContainer.getEntity()), (ChartOfAccountsElementType)((ChartOfAccountsElement)accountsElementContainer.getEntity()).getType());
    }

    public static FinanceServiceResult loadDataOrg(FinanceServiceProperties properties) throws ServiceException {
        SearchQuery query = new SearchQuery();
        List criterions = query.getCriteria().getCriterions();
        criterions.add(SearchCriterion.eq((String)BillingTransactionIndex.Property.client.name(), (Object)properties.getClientRef()));
        if (properties.getAgencyRef() != null) {
            criterions.add(SearchCriterion.eq((String)BillingTransactionIndex.Property.agency.name(), (Object)properties.getAgencyRef()));
        }
        if (properties.getStartDate() != null) {
            criterions.add(SearchCriterion.ge((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)properties.getStartDate()));
        }
        if (properties.getEndDate() != null) {
            criterions.add(SearchCriterion.le((String)BillingTransactionIndex.Property.transactionDate.name(), (Object)properties.getEndDate()));
        }
        criterions.add(SearchCriterion.eq((String)BillingTransactionIndex.Property.transactionCurrency.name(), (Object)properties.getCurrency()));
        query.getCriteria().getOrders().put(BillingTransactionIndex.Property.transactionDate.name(), SortOrder.DESC);
        query.getCriteria().getOrders().put(BillingTransactionIndex.Property.category.name(), SortOrder.DESC);
        query.getCriteria().getOrders().put("uid", SortOrder.ASC);
        query.setLimit(properties.getLimit());
        query.setResultMode(ResultMode.DATA_AND_COUNT);
        query.setOffset(properties.getOffset());
        SearchResult searchResult = EntityStorage.get().search(BillingTransactionIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true));
        ArrayList<TransactionData> list = new ArrayList<TransactionData>();
        FinanceServiceImpl.fillingTransactionData((SearchResult<BillingTransactionIndex>)searchResult, list);
        FinanceServiceResult result = new FinanceServiceResult();
        result.setTransactionData(list);
        result.setOffset(query.getOffset());
        return result;
    }

    private static void fillingTransactionData(SearchResult<BillingTransactionIndex> searchResult, List<TransactionData> list) {
        searchResult.getData().forEach(index -> {
            TransactionData data = new TransactionData();
            data.setClientRef(index.getClient());
            data.setAgencyRef(index.getAgency());
            data.setTransactionSum(FinanceHelper.round((BigDecimal)index.getTransactionSum()));
            data.setPaymentType(index.getPaymentType());
            data.setContractType(index.getContractType());
            data.setTransactionDate(index.getTransactionDate());
            data.setCurrency(index.getTransactionCurrency());
            data.setCategory(index.getCategory());
            data.setAgentRef(index.getAgent());
            data.setType(index.getType());
            data.setReferencedEntity(index.getReferencedEntity());
            data.setStatus(index.getStatus());
            data.setSourceBillingTransaction(index.getSource());
            data.setDescription(index.getDescription());
            data.setFinDocNumber(index.getFinDocNumber());
            list.add(data);
        });
    }

    private void loadOldBalanceOrg(FinanceServiceProperties properties, FinanceServiceResult result) throws Exception {
        BigDecimal balanceAmount = BillingTransactionHelper.calculateBillingTransactionsSum(null, (EntityReference)properties.getClientRef(), (EntityReference)properties.getAgencyRef(), null, null, null, (String)properties.getCurrency(), null, null, (boolean)false, (boolean)false, (boolean)false);
        BigDecimal availableAmount = BigDecimal.ZERO;
        if (properties.getAgencyRef() != null && properties.getCreditLimitInfo() != null) {
            for (CreditLimitInfo limitInfo : properties.getCreditLimitInfo()) {
                if (limitInfo.getCreditor() == null || !limitInfo.getCreditor().getUid().equals(properties.getAgencyRef().getUid())) continue;
                availableAmount = availableAmount.add(balanceAmount.add(FinanceServiceImpl.calculateCredit(limitInfo)));
                break;
            }
        } else {
            availableAmount = availableAmount.add(balanceAmount);
        }
        BigDecimal startDateBalanceAmount = BigDecimal.ZERO;
        if (properties.getStartDate() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(MiscUtil.setDayEndTime((Date)properties.getStartDate()));
            calendar.add(5, -1);
            startDateBalanceAmount = startDateBalanceAmount.add(BillingTransactionHelper.calculateBillingTransactionsSum(null, (EntityReference)properties.getClientRef(), (EntityReference)properties.getAgencyRef(), null, null, null, (String)properties.getCurrency(), null, (Date)calendar.getTime(), (boolean)false, (boolean)false, (boolean)false));
        }
        BigDecimal endDateBalanceAmount = BigDecimal.ZERO;
        if (properties.getEndDate() != null) {
            endDateBalanceAmount = endDateBalanceAmount.add(BillingTransactionHelper.calculateBillingTransactionsSum(null, (EntityReference)properties.getClientRef(), (EntityReference)properties.getAgencyRef(), null, null, null, (String)properties.getCurrency(), null, (Date)MiscUtil.setDayEndTime((Date)properties.getEndDate()), (boolean)false, (boolean)false, (boolean)false));
        }
        BigDecimal debitAmount = BigDecimal.ZERO;
        BigDecimal creditAmount = BigDecimal.ZERO;
        creditAmount = creditAmount.add(BillingTransactionHelper.calculateBillingTransactionsSum(null, (EntityReference)properties.getClientRef(), (EntityReference)properties.getAgencyRef(), null, (BillingTransactionCategory)BillingTransactionCategory.CREDIT, null, (String)properties.getCurrency(), (Date)properties.getStartDate(), (Date)properties.getEndDate(), (boolean)false, (boolean)false, (boolean)false)).negate();
        debitAmount = debitAmount.add(BillingTransactionHelper.calculateBillingTransactionsSum(null, (EntityReference)properties.getClientRef(), (EntityReference)properties.getAgencyRef(), null, (BillingTransactionCategory)BillingTransactionCategory.DEBIT, null, (String)properties.getCurrency(), (Date)properties.getStartDate(), (Date)properties.getEndDate(), (boolean)false, (boolean)false, (boolean)false));
        result.setCreditAmount(creditAmount);
        result.setDebitAmount(debitAmount);
        result.setBalanceAmount(balanceAmount);
        result.setAvailableAmount(availableAmount);
        result.setStartDateBalanceAmount(startDateBalanceAmount);
        result.setEndDateBalanceAmount(endDateBalanceAmount);
    }

    private static BigDecimal getCreditAmountFromSupplier(CreditLimitInfo creditLimitInfo) {
        BigDecimal credit = BigDecimal.ZERO;
        Date currentDate = new Date();
        Date terminalCreditDateStart = creditLimitInfo.getTerminalCreditDateStart();
        Date terminalCreditDateEnd = creditLimitInfo.getTerminalCreditDateEnd();
        if (creditLimitInfo.getCreditLimit() != null) {
            credit = credit.add(creditLimitInfo.getCreditLimit());
        }
        if (!(creditLimitInfo.getTerminalCreditLimit() == null || terminalCreditDateStart == null && terminalCreditDateEnd == null || terminalCreditDateStart != null && terminalCreditDateStart.after(currentDate) || terminalCreditDateEnd != null && terminalCreditDateEnd.before(currentDate))) {
            credit = credit.add(creditLimitInfo.getTerminalCreditLimit());
        }
        return credit;
    }

    private static BigDecimal calculateCredit(CreditLimitInfo agencyCreditLimit) {
        BigDecimal creditAmount = BigDecimal.ZERO;
        if (agencyCreditLimit.getCreditLimit() != null) {
            creditAmount = creditAmount.add(agencyCreditLimit.getCreditLimit());
        }
        if (agencyCreditLimit.getTerminalCreditLimit() != null && MiscUtil.isBetween((Date)agencyCreditLimit.getTerminalCreditDateStart(), (Date)agencyCreditLimit.getTerminalCreditDateEnd(), (Date)new Date())) {
            creditAmount = creditAmount.add(agencyCreditLimit.getTerminalCreditLimit());
        }
        return creditAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContainer<FinanceInitializationData> loadFinanceInitializationData(ServiceInvocationContext context, EntityReference<Organization> organization) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-loadFinanceInitializationData");
        try {
            this.checkContext(context);
            EntityContainer entityContainer = EntityStorage.get().resolve(FinanceHelper.getFinanceInitializationData(organization));
            return entityContainer;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal calculateAgentBalance(ServiceInvocationContext context, EntityReference<Organization> agency, EntityReference<Person> agent, EntityReference<CashRegisterWorkplace> cashRegisterWorkplace, Date startOperationDate, Date endOperationDate, Date calculationDate, DictionaryReference<CurrencyInfo> currency) throws ServiceException {
        DebugUtil.setThreadName((String)"FxFinanceServiceImpl-calculateAgentBalance");
        try {
            this.checkContext(context);
            boolean individualCashRemains = ProfileHelper.isOrganizationIndividualCashRemains(agency);
            BigDecimal amount = null;
            amount = individualCashRemains ? BalanceHelper.calculateBalance(agency, (Date)MiscUtil.getBeforeTime((Date)startOperationDate), (Date)endOperationDate, (Date)calculationDate, (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_REMAINS_AGENT, currency, Collections.singletonMap(DimensionType.AGENT, agent)) : BalanceHelper.calculateBalance(agency, (Date)MiscUtil.getBeforeTime((Date)startOperationDate), (Date)endOperationDate, (Date)calculationDate, (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_REMAINS_AGENT, currency, Collections.singletonMap(DimensionType.CASH_REGISTER_WORKPLACE, cashRegisterWorkplace));
            BigDecimal bigDecimal = amount;
            return bigDecimal;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Collection<EntityReference<Organization>> setUnlimitedCreditLimit(ServiceInvocationContext context, List<String> balanceIndicesUids, boolean unlimited) throws ServiceException {
        DebugUtil.setThreadName((String)"FxFinanceServiceImpl-setUnlimitedCreditLimit");
        try {
            this.checkContext(context);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"uid", balanceIndicesUids));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)OrganizationBalanceIndex.Property.client.name(), null));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)OrganizationBalanceIndex.Property.agency.name(), null));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)OrganizationBalanceIndex.Property.unlimited.name(), (Object)unlimited));
            query.getPreferredProperties().add(OrganizationBalanceIndex.Property.client.name());
            query.getPreferredProperties().add(OrganizationBalanceIndex.Property.agency.name());
            Map<EntityReference, List> customerToSuppliers = EntityStorage.get().search(OrganizationBalanceIndex.class, query).getData().stream().filter(index -> Organization.class.equals((Object)index.getClient().getType())).filter(index -> Organization.class.equals((Object)index.getAgency().getType())).collect(Collectors.toMap(index -> index.getClient(), index -> Collections.singletonList(index.getAgency()), (first, second) -> Stream.of(first, second).flatMap(Collection::stream).collect(Collectors.toList())));
            HashSet changedOrganizations = new HashSet();
            for (Map.Entry<EntityReference, List> entry : customerToSuppliers.entrySet()) {
                EntityReference customerRef = entry.getKey();
                List suppliers = entry.getValue();
                LockUtil.lock((EntityReference)customerRef, customer -> {
                    if (customer == null) {
                        return;
                    }
                    boolean changed = false;
                    for (EntityReference supplier : suppliers) {
                        CreditLimitInfo creditLimit = ProfileHelper.getOrganizationCreditLimit((EntityContainer)customer, (EntityReference)supplier);
                        if (creditLimit == null && unlimited) {
                            creditLimit = new CreditLimitInfo();
                            creditLimit.setCreditor(supplier);
                            ((Organization)customer.getEntity()).getFinanceRestrictions().getCreditLimits().add(creditLimit);
                        }
                        if (creditLimit == null || creditLimit.isUnlimited() == unlimited) continue;
                        creditLimit.setUnlimited(unlimited);
                        changed = true;
                    }
                    if (changed) {
                        customer.getVersionInfo().setDataSource("set-unlimited-credit-limit");
                        EntityStorage.get().save(customer, true);
                        changedOrganizations.add(customerRef);
                    }
                });
            }
            HashSet hashSet = changedOrganizations;
            return hashSet;
        }
        catch (Throwable e) {
            this.log.error("failed to set unlimited credit limit", e);
            throw new ServiceException("failed to set unlimited credit limit", e);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private class DimensionTypeWrapper {
        private DimensionType dimensionType1;
        private DimensionType dimensionType2;
        private DimensionType dimensionType3;

        private DimensionTypeWrapper(BasicChartOfAccountsElementSettings settings) {
            if (settings != null) {
                this.dimensionType1 = settings.getDimension1() == null ? null : settings.getDimension1().getType();
                this.dimensionType2 = settings.getDimension2() == null ? null : settings.getDimension2().getType();
                this.dimensionType3 = settings.getDimension3() == null ? null : settings.getDimension3().getType();
            }
        }
    }

    private class TransactionSplitIndexWrapper {
        private final TransactionSplitIndex index;
        private final BillingTransactionStatus status;

        private TransactionSplitIndexWrapper(TransactionSplitIndex index, boolean isHold) {
            this.index = index;
            this.status = isHold ? BillingTransactionStatus.HOLD : BillingTransactionStatus.ACTIVE;
        }
    }
}

