/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.fx.rpc.DictQueryPseudoProperties;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCode;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.rpc.DictServiceImpl;
import java.util.Date;

public class FxRpcCorrectionsPublisher
implements Publisher {
    public void publish() throws Exception {
        DictServiceImpl.registerPseudoPropertyHandler((String)DictQueryPseudoProperties.CODE_SYSTEM, criterion -> {
            if (criterion.getValues() == null || criterion.getValues().length == 0) {
                return item -> false;
            }
            String value = ((CodeSystem)criterion.getValues()[0]).name();
            return item -> item.getCodeVariants().containsKey(value);
        });
        DictServiceImpl.registerPseudoPropertyHandler((String)DictQueryPseudoProperties.AIRLINE_DATE, criterion -> {
            if (criterion.getValues() == null || criterion.getValues().length == 0) {
                return item -> false;
            }
            Date value = (Date)criterion.getValues()[0];
            return item -> {
                Airline airline = (Airline)item;
                return DictHelper.isAirlineFitByDates((Airline)airline, (Date)value);
            };
        });
        DictServiceImpl.registerPseudoPropertyHandler((String)DictQueryPseudoProperties.CURRENCY_RATE_CURRENCY, criterion -> {
            if (criterion.getValues() == null || criterion.getValues().length == 0) {
                return item -> false;
            }
            CurrencyInfoReference value = (CurrencyInfoReference)criterion.getValues()[0];
            return item -> MiscUtil.equals((Object)value.getCode(), (Object)((CurrencyRate)item).getCurrency());
        });
        DictServiceImpl.registerPseudoPropertyHandler((String)DictQueryPseudoProperties.CURRENCY_RATE_BASE_CURRENCY, criterion -> {
            if (criterion.getValues() == null || criterion.getValues().length == 0) {
                return item -> false;
            }
            CurrencyInfoReference value = (CurrencyInfoReference)criterion.getValues()[0];
            return item -> MiscUtil.equals((Object)value.getCode(), (Object)((CurrencyRate)item).getBaseCurrency());
        });
        DictServiceImpl.registerPseudoPropertyHandler((String)DictQueryPseudoProperties.CLASS_OF_SERVICE_CODES, criterion -> {
            if (criterion.getValues() == null || criterion.getValues().length == 0) {
                return item -> false;
            }
            String filterValue = ((String)criterion.getValues()[0]).trim().toLowerCase();
            return item -> ((ClassOfServiceCode)item).getCodes().stream().anyMatch(code -> TextUtil.contains((String)code.toLowerCase(), (String)filterValue));
        });
    }
}

