/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.PCIDSSService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.Date;
import java.util.Optional;

public class PCIDSSServiceImpl
extends BaseSecureServiceImpl
implements PCIDSSService {
    public int testCirConnection(ServiceInvocationContext sic, String cirServerAddress, String token) throws ServiceException {
        DebugUtil.setThreadName((String)"FXPCIDSSService-test-cir-connection");
        try {
            this.checkContext(sic);
            try {
                int n = CirHelper.testCirConnection((String)cirServerAddress, (String)token);
                return n;
            }
            catch (Throwable t) {
                this.log.error("test cir connection failed", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Card updateCard(ServiceInvocationContext sic, Card card, PCIDSSServerExchangeSettings settings, EntityReference<?> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"FXPCIDSSService-update-card");
        try {
            this.checkContext(sic);
            try {
                String agencyToken = this.getAgencyToken(settings, ref);
                Card card2 = CirHelper.updateCard((Card)card, (PCIDSSServerExchangeSettings)settings, (String)agencyToken);
                return card2;
            }
            catch (Throwable t) {
                this.log.error("update card failed", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public String prepareNewCard(ServiceInvocationContext sic, Card card, PCIDSSServerExchangeSettings settings, EntityReference<?> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"FXPCIDSSService-prepare-new-card");
        try {
            this.checkContext(sic);
            try {
                String agencyToken = this.getAgencyToken(settings, ref);
                String string = CirHelper.prepareNewCard((Card)card, (String)agencyToken, (PCIDSSServerExchangeSettings)settings);
                return string;
            }
            catch (Throwable t) {
                this.log.error("prepare card failed", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCard(ServiceInvocationContext sic, Card card, PCIDSSServerExchangeSettings settings, EntityReference<?> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"FXPCIDSSService-delete-card");
        try {
            this.checkContext(sic);
            try {
                String agencyToken = this.getAgencyToken(settings, ref);
                CirHelper.deleteCard((Card)card, (PCIDSSServerExchangeSettings)settings, (String)agencyToken);
            }
            catch (Throwable t) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("deletion of the card failed", t);
                }
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<String, Date> createAddNewCardLink(ServiceInvocationContext sic, EntityReference<Person> person, String callbackUrl) throws ServiceException {
        DebugUtil.setThreadName((String)"FXPCIDSSService-delete-card");
        try {
            this.checkContext(sic);
            try {
                MiscUtil.Pair pair = CirHelper.createAddNewCardLink(person, (String)callbackUrl);
                return pair;
            }
            catch (Throwable t) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("creation add card link failed", t);
                }
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private String getAgencyToken(PCIDSSServerExchangeSettings settings, EntityReference<?> reference) throws Exception {
        MiscUtil.Pair cirToken = CirHelper.cirToken((PCIDSSServerExchangeSettings)settings, reference);
        return Optional.ofNullable(cirToken).map(MiscUtil.Pair::getSecond).orElseThrow(() -> new Exception("No token found for " + reference.getCaption()));
    }
}

