/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.PersonalDataService;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.PersonalDataOrganizationSearchData;
import com.gridnine.xtrip.common.model.PersonalDataPersonSearchData;
import com.gridnine.xtrip.common.model.assets.LongRunningTaskInfo;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataOrganizationRequest;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataPersonRequest;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestStatus;
import com.gridnine.xtrip.common.model.personal.data.PersonalDataRequestType;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.model.tasks.LongRunningTasksManager;
import com.gridnine.xtrip.server.model.tasks.standard.PersonalDataErasureOrganizationProcessTask;
import com.gridnine.xtrip.server.model.tasks.standard.PersonalDataErasureOrganizationSearchTask;
import com.gridnine.xtrip.server.model.tasks.standard.PersonalDataErasurePersonProcessTask;
import com.gridnine.xtrip.server.model.tasks.standard.PersonalDataErasurePersonSearchTask;
import com.gridnine.xtrip.server.model.tasks.standard.PersonalDataRestrictionPersonProcessTask;
import com.gridnine.xtrip.server.model.tasks.standard.PersonalDataRestrictionPersonRestoreTask;
import com.gridnine.xtrip.server.model.tasks.standard.PersonalDataRestrictionPersonSearchTask;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;

public class PersonalDataServiceImpl
extends BaseSecureServiceImpl
implements PersonalDataService {
    public EntityReference<PersonalDataPersonRequest> createErasurePersonRequest(ServiceInvocationContext context, PersonalDataPersonSearchData searchData) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-createErasurePersonRequest");
        try {
            this.checkContext(context);
            try {
                PersonalDataPersonRequest request = new PersonalDataPersonRequest();
                request.setType(PersonalDataRequestType.ERASURE_PERSON);
                request.setStatus(PersonalDataRequestStatus.NEW);
                request.setSearchData(searchData);
                EntityContainer requestContainer = EntityContainer.create((BaseEntity)request);
                requestContainer.getVersionInfo().setDataSource("create-erasure-person-request");
                EntityStorage.get().save(requestContainer, true);
                EntityReference entityReference = requestContainer.toReference();
                return entityReference;
            }
            catch (Throwable t) {
                this.log.error("erasure person request create failed", t);
                throw new ServiceException("erasure person request create failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasurePersonSearchStart(ServiceInvocationContext context, EntityReference<PersonalDataPersonRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-erasurePersonSearchStart");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.NEW && request.getStatus() != PersonalDataRequestStatus.SEARCH_INTERRUPTED && request.getStatus() != PersonalDataRequestStatus.SEARCH_FAILED && request.getStatus() != PersonalDataRequestStatus.SEARCH_DONE) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    LongRunningTaskInfo taskInfo = ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(PersonalDataErasurePersonSearchTask.class, null, null, requestReference, true);
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setTaskUid(taskInfo.getUid());
                            updatedRequest.setStatus(PersonalDataRequestStatus.SEARCHING);
                            updatedRequest.getSearchResults().clear();
                            updatedRequestContainer.getVersionInfo().setDataSource("search-start");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("erasure person search start failed", t);
                throw new ServiceException("erasure person search start failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasurePersonSearchStop(ServiceInvocationContext context, EntityReference<PersonalDataPersonRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-erasurePersonSearchStop");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.SEARCHING) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    if (request.getTaskUid() != null) {
                        ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).stopTask(request.getTaskUid());
                    }
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_INTERRUPTED);
                            updatedRequestContainer.getVersionInfo().setDataSource("search-interrupted");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("erasure person search stop failed", t);
                throw new ServiceException("erasure person search stop failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasurePersonProcessStart(ServiceInvocationContext context, EntityReference<PersonalDataPersonRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-erasurePersonProcessStart");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.SEARCH_DONE && request.getStatus() != PersonalDataRequestStatus.PROCESS_INTERRUPTED && request.getStatus() != PersonalDataRequestStatus.PROCESS_FAILED) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    LongRunningTaskInfo taskInfo = ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(PersonalDataErasurePersonProcessTask.class, null, null, requestReference, true);
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setTaskUid(taskInfo.getUid());
                            updatedRequest.setStatus(PersonalDataRequestStatus.PROCESSING);
                            updatedRequestContainer.getVersionInfo().setDataSource("process-start");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("erasure person process start failed", t);
                throw new ServiceException("erasure person process start failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasurePersonProcessStop(ServiceInvocationContext context, EntityReference<PersonalDataPersonRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-erasurePersonProcessStop");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.PROCESSING) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    if (request.getTaskUid() != null) {
                        ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).stopTask(request.getTaskUid());
                    }
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setStatus(PersonalDataRequestStatus.PROCESS_INTERRUPTED);
                            updatedRequestContainer.getVersionInfo().setDataSource("process-interrupted");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("erasure person process stop failed", t);
                throw new ServiceException("erasure person process stop failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public EntityReference<PersonalDataOrganizationRequest> createErasureOrganizationRequest(ServiceInvocationContext context, PersonalDataOrganizationSearchData searchData) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-createErasureOrganizationRequest");
        try {
            this.checkContext(context);
            try {
                PersonalDataOrganizationRequest request = new PersonalDataOrganizationRequest();
                request.setType(PersonalDataRequestType.ERASURE_ORGANIZATION);
                request.setNumber("00000001");
                request.setStatus(PersonalDataRequestStatus.NEW);
                request.setSearchData(searchData);
                EntityContainer requestContainer = EntityContainer.create((BaseEntity)request);
                requestContainer.getVersionInfo().setDataSource("create-erasure-organization-request");
                EntityStorage.get().save(requestContainer, true);
                EntityReference entityReference = requestContainer.toReference();
                return entityReference;
            }
            catch (Throwable t) {
                this.log.error("erasure organization request create failed", t);
                throw new ServiceException("erasure organization request create failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasureOrganizationSearchStart(ServiceInvocationContext context, EntityReference<PersonalDataOrganizationRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-erasureOrganizationSearchStart");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.NEW && request.getStatus() != PersonalDataRequestStatus.SEARCH_INTERRUPTED && request.getStatus() != PersonalDataRequestStatus.SEARCH_FAILED && request.getStatus() != PersonalDataRequestStatus.SEARCH_DONE) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    LongRunningTaskInfo taskInfo = ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(PersonalDataErasureOrganizationSearchTask.class, null, null, requestReference, true);
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataOrganizationRequest updatedRequest = (PersonalDataOrganizationRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setTaskUid(taskInfo.getUid());
                            updatedRequest.setStatus(PersonalDataRequestStatus.SEARCHING);
                            updatedRequest.getSearchResults().clear();
                            updatedRequestContainer.getVersionInfo().setDataSource("search-start");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("erasure organization search start failed", t);
                throw new ServiceException("erasure organization search start failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasureOrganizationSearchStop(ServiceInvocationContext context, EntityReference<PersonalDataOrganizationRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-erasureOrganizationSearchStop");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.SEARCHING) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    if (request.getTaskUid() != null) {
                        ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).stopTask(request.getTaskUid());
                    }
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataOrganizationRequest updatedRequest = (PersonalDataOrganizationRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_INTERRUPTED);
                            updatedRequestContainer.getVersionInfo().setDataSource("search-interrupted");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("erasure organization search stop failed", t);
                throw new ServiceException("erasure organization search stop failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasureOrganizationProcessStart(ServiceInvocationContext context, EntityReference<PersonalDataOrganizationRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-erasureOrganizationProcessStart");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.SEARCH_DONE && request.getStatus() != PersonalDataRequestStatus.PROCESS_INTERRUPTED && request.getStatus() != PersonalDataRequestStatus.PROCESS_FAILED) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    LongRunningTaskInfo taskInfo = ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(PersonalDataErasureOrganizationProcessTask.class, null, null, requestReference, true);
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataOrganizationRequest updatedRequest = (PersonalDataOrganizationRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setTaskUid(taskInfo.getUid());
                            updatedRequest.setStatus(PersonalDataRequestStatus.PROCESSING);
                            updatedRequestContainer.getVersionInfo().setDataSource("process-start");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("erasure organization process start failed", t);
                throw new ServiceException("erasure organization process start failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasureOrganizationProcessStop(ServiceInvocationContext context, EntityReference<PersonalDataOrganizationRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-erasureOrganizationProcessStop");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataOrganizationRequest request = (PersonalDataOrganizationRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.PROCESSING) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    if (request.getTaskUid() != null) {
                        ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).stopTask(request.getTaskUid());
                    }
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataOrganizationRequest updatedRequest = (PersonalDataOrganizationRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setStatus(PersonalDataRequestStatus.PROCESS_INTERRUPTED);
                            updatedRequestContainer.getVersionInfo().setDataSource("process-interrupted");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("erasure organization process stop failed", t);
                throw new ServiceException("erasure organization process stop failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public EntityReference<PersonalDataPersonRequest> createRestrictionPersonRequest(ServiceInvocationContext context, PersonalDataPersonSearchData searchData) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-createRestrictionPersonRequest");
        try {
            this.checkContext(context);
            try {
                PersonalDataPersonRequest request = new PersonalDataPersonRequest();
                request.setType(PersonalDataRequestType.RESTRICTION_PERSON);
                request.setNumber("00000001");
                request.setStatus(PersonalDataRequestStatus.NEW);
                request.setSearchData(searchData);
                EntityContainer requestContainer = EntityContainer.create((BaseEntity)request);
                requestContainer.getVersionInfo().setDataSource("create-restriction-person-request");
                EntityStorage.get().save(requestContainer, true);
                EntityReference entityReference = requestContainer.toReference();
                return entityReference;
            }
            catch (Throwable t) {
                this.log.error("restriction person request create failed", t);
                throw new ServiceException("restriction person request create failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restrictionPersonSearchStart(ServiceInvocationContext context, EntityReference<PersonalDataPersonRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-restrictionPersonSearchStart");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.NEW && request.getStatus() != PersonalDataRequestStatus.SEARCH_INTERRUPTED && request.getStatus() != PersonalDataRequestStatus.SEARCH_FAILED && request.getStatus() != PersonalDataRequestStatus.SEARCH_DONE) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    LongRunningTaskInfo taskInfo = ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(PersonalDataRestrictionPersonSearchTask.class, null, null, requestReference, true);
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setTaskUid(taskInfo.getUid());
                            updatedRequest.setStatus(PersonalDataRequestStatus.SEARCHING);
                            updatedRequest.getSearchResults().clear();
                            updatedRequestContainer.getVersionInfo().setDataSource("search-start");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("restriction person search start failed", t);
                throw new ServiceException("restriction person search start failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restrictionPersonSearchStop(ServiceInvocationContext context, EntityReference<PersonalDataPersonRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-restrictionPersonSearchStop");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.SEARCHING) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    if (request.getTaskUid() != null) {
                        ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).stopTask(request.getTaskUid());
                    }
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setStatus(PersonalDataRequestStatus.SEARCH_INTERRUPTED);
                            updatedRequestContainer.getVersionInfo().setDataSource("search-interrupted");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("restriction person search stop failed", t);
                throw new ServiceException("restriction person search stop failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restrictionPersonProcessStart(ServiceInvocationContext context, EntityReference<PersonalDataPersonRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-restrictionPersonProcessStart");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.SEARCH_DONE && request.getStatus() != PersonalDataRequestStatus.PROCESS_INTERRUPTED && request.getStatus() != PersonalDataRequestStatus.PROCESS_FAILED) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    LongRunningTaskInfo taskInfo = ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(PersonalDataRestrictionPersonProcessTask.class, null, null, requestReference, true);
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setTaskUid(taskInfo.getUid());
                            updatedRequest.setStatus(PersonalDataRequestStatus.PROCESSING);
                            updatedRequestContainer.getVersionInfo().setDataSource("process-start");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("restriction person process start failed", t);
                throw new ServiceException("restriction person process start failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restrictionPersonProcessStop(ServiceInvocationContext context, EntityReference<PersonalDataPersonRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-restrictionPersonProcessStop");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.PROCESSING) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    if (request.getTaskUid() != null) {
                        ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).stopTask(request.getTaskUid());
                    }
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setStatus(PersonalDataRequestStatus.PROCESS_INTERRUPTED);
                            updatedRequestContainer.getVersionInfo().setDataSource("process-interrupted");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("restriction person process stop failed", t);
                throw new ServiceException("restriction person process stop failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restrictionPersonRestoreStart(ServiceInvocationContext context, EntityReference<PersonalDataPersonRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-restrictionPersonRestoreStart");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.PROCESS_DONE && request.getStatus() != PersonalDataRequestStatus.RESTORE_INTERRUPTED && request.getStatus() != PersonalDataRequestStatus.RESTORE_FAILED) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    LongRunningTaskInfo taskInfo = ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).addTask(PersonalDataRestrictionPersonRestoreTask.class, null, null, requestReference, true);
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setTaskUid(taskInfo.getUid());
                            updatedRequest.setStatus(PersonalDataRequestStatus.RESTORING);
                            updatedRequestContainer.getVersionInfo().setDataSource("restore-start");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("restriction person restoration start failed", t);
                throw new ServiceException("restriction person restoration start failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restrictionPersonRestoreStop(ServiceInvocationContext context, EntityReference<PersonalDataPersonRequest> requestReference) throws ServiceException {
        DebugUtil.setThreadName((String)"FxPersonalDataServiceImpl-restrictionPersonProcessStop");
        try {
            this.checkContext(context);
            try {
                EntityContainer requestContainer = EntityStorage.get().resolve(requestReference);
                if (requestContainer != null) {
                    PersonalDataPersonRequest request = (PersonalDataPersonRequest)requestContainer.getEntity();
                    if (request.getStatus() != PersonalDataRequestStatus.RESTORING) {
                        throw new Exception(String.format("invalid request status %s", request.getStatus()));
                    }
                    if (request.getTaskUid() != null) {
                        ((LongRunningTasksManager)Environment.getPublished(LongRunningTasksManager.class)).stopTask(request.getTaskUid());
                    }
                    LockUtil.lock(requestReference, updatedRequestContainer -> {
                        if (updatedRequestContainer != null) {
                            PersonalDataPersonRequest updatedRequest = (PersonalDataPersonRequest)updatedRequestContainer.getEntity();
                            updatedRequest.setStatus(PersonalDataRequestStatus.RESTORE_INTERRUPTED);
                            updatedRequestContainer.getVersionInfo().setDataSource("restore-interrupted");
                            EntityStorage.get().save(updatedRequestContainer, true);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.log.error("restriction person process stop failed", t);
                throw new ServiceException("restriction person process stop failed", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

