/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.ProductRefundCreditSlipResult;
import com.gridnine.xtrip.common.fx.rpc.ProductRefundCreditSlipService;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.math.BigDecimal;
import java.util.List;

public class ProductRefundCreditSlipServiceImpl
extends BaseSecureServiceImpl
implements ProductRefundCreditSlipService {
    public ProductRefundCreditSlipResult loadDataForProductRefund(ServiceInvocationContext ctx, BaseProduct product) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProductRefundCreditSlipServiceImpl-loadDataForProductRefund");
        try {
            this.checkContext(ctx);
            try {
                ProductRefundCreditSlipResult result = new ProductRefundCreditSlipResult();
                Money amount = new Money();
                amount.setValue(BigDecimal.ZERO);
                GeneralProductContractRelationData contractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
                if (contractRelation != null) {
                    ProductHandler productHandler;
                    List fops;
                    DictionaryReference currency = contractRelation.getGeneralData().getCurrency();
                    if (currency != null && currency.getCode() != null) {
                        amount.setCurrency(currency.getCode());
                    }
                    if ((fops = contractRelation.getFops()) != null) {
                        BigDecimal value = null;
                        for (GeneralProductFop fop : fops) {
                            if (fop.getEquivalentAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
                            value = MiscUtil.sum((BigDecimal[])new BigDecimal[]{value, fop.getEquivalentAmount()});
                        }
                        amount.setValue(value);
                    }
                    if (ProductCategory.MCO == (productHandler = HandlersRegistry.get().findProductHandler(product.getClass())).getProductCategory(product) && MCOCategory.PENALTY == productHandler.getMCOCategory(product)) {
                        amount.setValue(MiscUtil.negate((BigDecimal)amount.getValue()));
                    }
                }
                result.setAmount(amount);
                ProductRefundCreditSlipResult productRefundCreditSlipResult = result;
                return productRefundCreditSlipResult;
            }
            catch (Throwable t) {
                this.log.error("failed load refund data for product", t);
                throw new ServiceException("failed load refund data for product", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    protected void checkContext(ServiceInvocationContext ctx) throws ServiceException {
        this.checkContext(ctx, false);
    }
}

