/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.ProfileService;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ProfileServiceImpl
extends BaseSecureServiceImpl
implements ProfileService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiscUtil.Pair<Boolean, String> validatePersonCode(ServiceInvocationContext ctx, String code, String uid) throws ServiceException {
        try {
            DebugUtil.setThreadName((String)"FxProfileServiceImpl-validatePersonCode");
            this.checkContext(ctx);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.code.name(), (Object)code));
            query.getCriteria().getCriterions().add(SearchCriterion.icontains((String)PersonIndex.Property.types.name(), (String)PersonType.AGENT.name()));
            List personIndexList = EntityStorage.get().search(PersonIndex.class, query).getData();
            for (PersonIndex item : personIndexList) {
                boolean equalObjects = item.getSource().getUid().equals(uid);
                if (equalObjects && personIndexList.size() == 1) {
                    MiscUtil.Pair pair = new MiscUtil.Pair((Object)Boolean.TRUE, null);
                    return pair;
                }
                if (equalObjects) continue;
                Person person = (Person)EntityStorage.get().load(Person.class, item.getSource().getUid()).getEntity();
                if (person.getEmployments().isEmpty()) {
                    MiscUtil.Pair pair = new MiscUtil.Pair((Object)Boolean.FALSE, (Object)item.getName());
                    return pair;
                }
                for (PersonEmployment empl : person.getEmployments()) {
                    if (empl.getClosed() != null && DateUtils.toLocalDate((Date)empl.getClosed()).compareTo(LocalDate.now()) <= 0) continue;
                    MiscUtil.Pair pair = new MiscUtil.Pair((Object)Boolean.FALSE, (Object)item.getName());
                    return pair;
                }
            }
            MiscUtil.Pair pair = new MiscUtil.Pair((Object)Boolean.TRUE, null);
            return pair;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiscUtil.Pair<Boolean, String> validateOrganizationCode(ServiceInvocationContext ctx, String code, String organizationUid) throws ServiceException {
        try {
            DebugUtil.setThreadName((String)"FxProfileServiceImpl-validateOrganizationCode");
            this.checkContext(ctx);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)code));
            query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"containerUid", (Object)organizationUid));
            query.getPreferredProperties().add(OrganizationIndex.Property.name.name());
            query.setLimit(1);
            List organizationIndices = EntityStorage.get().search(OrganizationIndex.class, query).getData();
            if (!organizationIndices.isEmpty()) {
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)Boolean.FALSE, (Object)((OrganizationIndex)organizationIndices.get(0)).getName().toString());
                return pair;
            }
            MiscUtil.Pair pair = new MiscUtil.Pair((Object)Boolean.TRUE, null);
            return pair;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnybodyWithEqualGetThereLogin(ServiceInvocationContext ctx, String getThereId, String personUid) throws ServiceException {
        try {
            String result;
            DebugUtil.setThreadName((String)"FxProfileServiceImpl-getAnybodyWithEqualGetThereLogin");
            this.checkContext(ctx);
            String string = result = ProfileHelper.getAnybodyWithEqualGetThereLogin((String)getThereId, (String)personUid);
            return string;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPersonDublicate(ServiceInvocationContext ctx, EntityReference<Organization> org, String firstName, String secondName, String name) throws ServiceException {
        try {
            DebugUtil.setThreadName((String)"FxProfileServiceImpl-check-person-for-dublicate");
            if (TextUtil.isBlank((String)name) && (TextUtil.isBlank((String)firstName) || TextUtil.isBlank((String)secondName))) {
                boolean bl = true;
                return bl;
            }
            this.checkContext(ctx);
            SearchQuery query = new SearchQuery();
            SearchCriterion firstAndSecondName = null;
            if (!TextUtil.isBlank((String)firstName) && !TextUtil.isBlank((String)secondName)) {
                firstAndSecondName = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.icontains((String)PersonIndex.Property.searchFirstNames.name(), (String)firstName), SearchCriterion.icontains((String)PersonIndex.Property.searchLastNames.name(), (String)secondName)});
            }
            String[] parsed = new String[]{};
            if (!TextUtil.isBlank((String)name)) {
                parsed = name.split("[\\s/\\\\]");
            }
            SearchCriterion firstAndSecondNameParsed = null;
            if (parsed.length > 1) {
                String nameParsed1 = parsed[0];
                String nameParsed2 = parsed[1];
                firstAndSecondNameParsed = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.icontains((String)PersonIndex.Property.searchFirstNames.name(), (String)nameParsed1), SearchCriterion.icontains((String)PersonIndex.Property.searchLastNames.name(), (String)nameParsed2)}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.icontains((String)PersonIndex.Property.searchFirstNames.name(), (String)nameParsed2), SearchCriterion.icontains((String)PersonIndex.Property.searchLastNames.name(), (String)nameParsed1)})});
            }
            if (firstAndSecondName == null && firstAndSecondNameParsed == null) {
                boolean nameParsed1 = false;
                return nameParsed1;
            }
            if (firstAndSecondName == null) {
                query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{firstAndSecondNameParsed, SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)org.getUid())}));
            } else if (firstAndSecondNameParsed == null) {
                query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{firstAndSecondName, SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)org.getUid())}));
            } else {
                query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{firstAndSecondName, firstAndSecondNameParsed}), SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)org.getUid())}));
            }
            List personIndexList = EntityStorage.get().search(PersonIndex.class, query).getData();
            ArrayList<String> actualEmployments = new ArrayList<String>();
            for (PersonIndex item : personIndexList) {
                Person person = (Person)EntityStorage.get().load(Person.class, item.getSource().getUid()).getEntity();
                Date now = new Date();
                for (PersonEmployment placeOfEmployment : person.getEmployments()) {
                    if (placeOfEmployment.getOrganization() == null || !MiscUtil.isBetween((Date)placeOfEmployment.getOpened(), (Date)placeOfEmployment.getClosed(), (Date)now)) continue;
                    try {
                        EntityStorage.get().actualize(placeOfEmployment.getOrganization());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    EntityContainer organizationContainer = null;
                    try {
                        organizationContainer = EntityStorage.get().resolve(placeOfEmployment.getOrganization());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (organizationContainer != null) {
                        Organization organization = (Organization)organizationContainer.getEntity();
                        Locale locale = LocaleHelper.getCurrentLocale();
                        String orgName = L10nStringHelper.getValue((L10nString)organization.getShortName(), (Locale)locale, (boolean)false);
                        if (TextUtil.isBlank((String)orgName)) {
                            orgName = L10nStringHelper.getValue((L10nString)organization.getFullName(), (Locale)locale, (boolean)false);
                        }
                        actualEmployments.add(orgName);
                        continue;
                    }
                    actualEmployments.add(placeOfEmployment.getOrganization().getCaption());
                }
            }
            boolean bl = !actualEmployments.isEmpty();
            return bl;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkEmails(ServiceInvocationContext ctx, String personUid, Set<String> emails, String getThereId, List<PersonEmployment> employments) throws ServiceException {
        try {
            DebugUtil.setThreadName((String)"FxProfileServiceImpl-checkEmails");
            this.checkContext(ctx);
            if (GetThereSynchronizationUtil.isGetThereEnabled() && TextUtil.isBlank((String)getThereId) && ProfileHelper.checkPersonParametersForGetThere(employments)) {
                for (String email : emails) {
                    String somebodyWithTheSameGetThereLogin = ProfileHelper.getAnybodyWithEqualGetThereLogin((String)email, (String)personUid);
                    if (somebodyWithTheSameGetThereLogin != null) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersonCostCode> getCostCodesToFill(ServiceInvocationContext ctx, EntityReference<Organization> organization) throws ServiceException {
        try {
            DebugUtil.setThreadName((String)"FxProfileServiceImpl-getCostCodesToFill");
            this.checkContext(ctx);
            EntityContainer orgContainer = EntityStorage.get().resolve(organization);
            if (EntityStorageHelper.nonEmpty((EntityContainer)orgContainer)) {
                List list = ProfileHelper.getCostCodesToFillInTravellerProfile((EntityContainer)orgContainer);
                return list;
            }
            List<PersonCostCode> list = Collections.emptyList();
            return list;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> checkDuplicatePassports(ServiceInvocationContext ctx, EntityReference<Person> person, List<MiscUtil.Pair<String, Date>> passports) throws ServiceException {
        try {
            DebugUtil.setThreadName((String)"FxProfileServiceImpl-checkDuplicatePassports");
            this.checkContext(ctx);
            List list = ProfileHelper.checkDuplicatePassports(person, passports);
            return list;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

