/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.ProfilesSynchronizationService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileValidationUtil;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.SabreProfilesLoadResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationResult;
import com.gridnine.xtrip.common.model.profile.SabreProfilesSynchronizationStatus;
import com.gridnine.xtrip.common.model.profile.SabreProfilesValidationResult;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.synchronization.getthere.GetThereSynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationHelper;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class ProfilesSynchronizationServiceImpl
extends BaseSecureServiceImpl
implements ProfilesSynchronizationService {
    public SabreProfilesSynchronizationResult sendOrganizationToSabreProfiles(ServiceInvocationContext ctx, EntityReference<Organization> orgRef, SabreProfilesPccSettings pccSettings, SabreProfilesValidationResult validationResult) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-sendOrganizationToSabreProfiles");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("sending Organization profile to Sabre Profiles: " + orgRef);
                EntityContainer orgCont = EntityStorage.get().resolve(orgRef);
                SabreProfilesSynchronizationResult sabreProfilesSynchronizationResult = SabreProfilesSynchronizationHelper.sendOrganization((EntityContainer)orgCont, (SabreProfilesPccSettings)pccSettings, (SabreProfilesValidationResult)validationResult);
                return sabreProfilesSynchronizationResult;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed sending organization profile to Sabre Profiles for %s", orgRef), t);
                throw new ServiceException(String.format("failed sending organization profile to Sabre Profiles for %s", orgRef), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public SabreProfilesSynchronizationResult sendPersonToSabreProfiles(ServiceInvocationContext ctx, EntityReference<Person> personRef, EntityReference<Organization> orgRef, List<EntityReference<Organization>> orgRefs, SabreProfilesPccSettings pccSettings, SabreProfilesValidationResult validationResult) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-sendPersonToSabreProfiles");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("sending person profile to Sabre Profiles: " + personRef);
                EntityContainer perCont = EntityStorage.get().resolve(personRef);
                SabreProfilesSynchronizationResult sabreProfilesSynchronizationResult = SabreProfilesSynchronizationHelper.sendPerson((EntityContainer)perCont, orgRef, orgRefs, (SabreProfilesPccSettings)pccSettings, (SabreProfilesValidationResult)validationResult);
                return sabreProfilesSynchronizationResult;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed sending person profile to Sabre Profiles for %s", personRef), t);
                throw new ServiceException(String.format("failed sending person profile to Sabre Profiles for %s", personRef), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<SabreProfilesSynchronizationStatus, List<Message>> validateAndSendPersonToSabreProfiles(ServiceInvocationContext ctx, List<SabreProfilesPccSettings> pccSettings, EntityReference<Person> personRef) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-validateAndSendPersonToSabreProfiles");
        try {
            this.checkContext(ctx);
            try {
                ArrayList messages = new ArrayList();
                SabreProfilesSynchronizationStatus result = SabreProfilesSynchronizationHelper.validateAndSendPerson(personRef, pccSettings, messages);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)result, messages);
                return pair;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed sending person profile to Sabre Profiles for %s", personRef), t);
                throw new ServiceException(String.format("failed sending person profile to Sabre Profiles for %s", personRef), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public SabreProfilesSynchronizationResult deleteOrganizationFromSabreProfiles(ServiceInvocationContext ctx, EntityReference<Organization> orgRef, SabreProfilesPccSettings pccSettings) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-deleteOrganizationFromSabreProfiles");
        try {
            this.checkContext(ctx);
            try {
                SabreProfilesSynchronizationResult response;
                this.log.debug("deleting Organization profile from Sabre Profiles: " + (orgRef != null ? orgRef.getCaption() : ""));
                SabreProfilesSynchronizationResult sabreProfilesSynchronizationResult = response = SabreProfilesSynchronizationHelper.deleteOrganization(orgRef, (SabreProfilesPccSettings)pccSettings);
                return sabreProfilesSynchronizationResult;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed deleting organization profile from Sabre Profiles for %s", orgRef), t);
                throw new ServiceException(String.format("failed deleting organization profile from Sabre Profiles for %s", orgRef), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public SabreProfilesSynchronizationResult deletePersonFromSabreProfiles(ServiceInvocationContext ctx, EntityReference<Person> personRef, SabreProfilesPccSettings pccSettings) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-deletePersonFromSabreProfiles");
        try {
            this.checkContext(ctx);
            try {
                SabreProfilesSynchronizationResult response;
                this.log.debug("deleting Person profile from Sabre Profiles: " + (personRef != null ? personRef.getCaption() : ""));
                SabreProfilesSynchronizationResult sabreProfilesSynchronizationResult = response = SabreProfilesSynchronizationHelper.deleteTraveler(personRef, (SabreProfilesPccSettings)pccSettings);
                return sabreProfilesSynchronizationResult;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed deleting person profile from Sabre Profiles for %s", personRef), t);
                throw new ServiceException(String.format("failed deleting person profile from Sabre Profiles for %s", personRef), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<String, String> sendPersonToGetThere(ServiceInvocationContext ctx, EntityReference<Person> perRef) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-sendTravelerToGetThere");
        try {
            this.checkContext(ctx);
            try {
                this.log.debug("sending Person profile to GetThere: " + (perRef != null ? perRef.getCaption() : ""));
                MiscUtil.Pair pair = GetThereSynchronizationHelper.sendPerson(perRef);
                return pair;
            }
            catch (Throwable t) {
                this.log.error(String.format("failed sending person profile to GetThere for %s", perRef), t);
                throw new ServiceException(String.format("failed sending person profile to GetThere for %s", perRef), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<Integer> sendPersonsListToGetThere(ServiceInvocationContext ctx, List<EntityReference<Person>> perRefs) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-sendPersonsListToGetThere-by-selection");
        try {
            this.checkContext(ctx);
            try {
                List list = GetThereSynchronizationHelper.validateAndSendPersons(perRefs);
                return list;
            }
            catch (Throwable t) {
                this.log.error("failed sending persons list to GetThere", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<Integer> sendPersonsListToGetThere(ServiceInvocationContext ctx, SearchQuery query) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-sendPersonsListToGetThere-by-query");
        try {
            this.checkContext(ctx);
            try {
                List perRefs = EntityStorage.get().search(PersonIndex.class, query).getData().stream().map(ind -> ind.getSource()).collect(Collectors.toList());
                List list = GetThereSynchronizationHelper.validateAndSendPersons(perRefs);
                return list;
            }
            catch (Throwable t) {
                this.log.error("failed sending persons list to GetThere", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public SabreProfilesValidationResult validatePersonSabreProfiles(ServiceInvocationContext sic, EntityReference<Person> perRef) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-validatePersonSabreProfiles");
        try {
            this.checkContext(sic);
            try {
                EntityContainer perCont = EntityStorage.get().resolve(perRef);
                SabreProfilesValidationResult sabreProfilesValidationResult = ProfileValidationUtil.validatePersonForSabreProfiles((EntityContainer)perCont);
                return sabreProfilesValidationResult;
            }
            catch (Throwable t) {
                this.log.error("failed validating sabre profile person " + perRef, t);
                throw new ServiceException("failed validating sabre profile person " + perRef, t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public SabreProfilesValidationResult validateOrganizationSabreProfiles(ServiceInvocationContext sic, EntityReference<Organization> orgRef) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-validatePersonSabreProfiles");
        try {
            this.checkContext(sic);
            try {
                EntityContainer orgCont = EntityStorage.get().resolve(orgRef);
                SabreProfilesValidationResult sabreProfilesValidationResult = ProfileValidationUtil.validateOrganizationForSabreProfiles((EntityContainer)orgCont);
                return sabreProfilesValidationResult;
            }
            catch (Throwable t) {
                this.log.error("failed validating sabre profile organization " + orgRef, t);
                throw new ServiceException("failed validating sabre profile organization " + orgRef, t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<Boolean, List<Message>> validatePersonForGetThere(ServiceInvocationContext sic, EntityReference<Person> ref, List<Message> errors) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-validatePersonForGetThere");
        try {
            EntityContainer perCont;
            MiscUtil.Pair pair;
            block7: {
                this.checkContext(sic);
                try {
                    pair = new MiscUtil.Pair();
                    perCont = EntityStorage.get().resolve(ref);
                    if (perCont != null) break block7;
                    errors.add(MessageHelper.createErrorMessage((String)"Cannot find person ", (Object[])new Object[0]));
                    pair.setFirst((Object)false);
                    pair.setSecond(errors);
                    MiscUtil.Pair pair2 = pair;
                    return pair2;
                }
                catch (Throwable t) {
                    this.log.error("failed validating get there person " + ref, t);
                    throw new ServiceException("failed validating get there person " + ref, t);
                }
            }
            boolean hasNoErrors = ProfileValidationUtil.validatePersonForGetThere((EntityContainer)perCont, errors);
            pair.setFirst((Object)hasNoErrors);
            pair.setSecond(errors);
            MiscUtil.Pair pair3 = pair;
            return pair3;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<SabreProfilesPccSettings> getPccSettingsForPerson(ServiceInvocationContext sic, EntityReference<Person> ref) throws ServiceException {
        try {
            this.checkContext(sic);
            EntityContainer personContainer = EntityStorage.get().resolve(ref);
            return ProfileSynchronizationUtil.getPccSettingsFromProfile((EntityContainer)personContainer);
        }
        catch (ServiceException e) {
            this.log.error("failed getting pcc settings for person " + ref, (Throwable)e);
            throw new ServiceException("failed getting pcc settings for person " + ref, (Throwable)e);
        }
    }

    public List<SabreProfilesPccSettings> getPccSettingsForOrganization(ServiceInvocationContext sic, EntityReference<Organization> ref) throws ServiceException {
        try {
            this.checkContext(sic);
            EntityContainer personContainer = EntityStorage.get().resolve(ref);
            return ProfileSynchronizationUtil.getPccSettingsFromProfiles((EntityContainer)personContainer);
        }
        catch (ServiceException e) {
            this.log.error("failed getting pcc settings for organization " + ref, (Throwable)e);
            throw new ServiceException("failed getting pcc settings for organization " + ref, (Throwable)e);
        }
    }

    public MiscUtil.Pair<SabreProfilesLoadResult, List<Message>> loadExistPerson(ServiceInvocationContext sic, EntityReference<Person> personRef, SabreProfilesPccSettings pccSettings, boolean checkSPUpdateDate, boolean saveIfNotSuccess) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-loadExistPerson");
        try {
            this.checkContext(sic);
            try {
                ArrayList messages = new ArrayList();
                SabreProfilesLoadResult result = SabreProfilesSynchronizationHelper.loadExistPerson(personRef, (SabreProfilesPccSettings)pccSettings, (boolean)checkSPUpdateDate, (boolean)saveIfNotSuccess, messages);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)result, messages);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed load exist person " + personRef, t);
                throw new ServiceException("failed load exist person " + personRef, t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Date getUpdateDateInSabreProfiles(ServiceInvocationContext sic, EntityReference<Person> personRef, SabreProfilesPccSettings pccSettings) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-getUpdateDateInSabreProfiles");
        try {
            this.checkContext(sic);
            try {
                Date date = SabreProfilesSynchronizationHelper.getUpdateDateInSabreProfiles(personRef, (SabreProfilesPccSettings)pccSettings);
                return date;
            }
            catch (Throwable t) {
                this.log.error("failed load last sabre profiles update date " + personRef, t);
                throw new ServiceException("failed load last sabre profiles update date " + personRef, t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public boolean isLoadAllowed(ServiceInvocationContext sic, EntityReference<Person> personRef) throws ServiceException {
        DebugUtil.setThreadName((String)"FxProfilesSynchronizationServiceImpl-isLoadAllowed");
        try {
            this.checkContext(sic);
            try {
                boolean bl = SabreProfilesSynchronizationUtil.isLoadAllowedByEmployments(personRef);
                return bl;
            }
            catch (Throwable t) {
                this.log.error("failed check load allowed " + personRef, t);
                throw new ServiceException("failed check load allowed " + personRef, t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

