/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.ServerLogsService;
import com.gridnine.xtrip.common.model.system.fs.ServerFile;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.fsprovider.FsProvider;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.List;

public class ServerLogsServiceImpl
extends BaseSecureServiceImpl
implements ServerLogsService {
    public List<String> getActiveNodes(ServiceInvocationContext context) throws ServiceException {
        DebugUtil.setThreadName((String)"ServerLogsServiceImpl-getActiveNodes");
        try {
            this.checkContext(context);
            try {
                List list = FsProvider.get().getActiveNodes();
                return list;
            }
            catch (Throwable t) {
                this.log.error("failed getting active nodes", t);
                throw new ServiceException("failed getting active nodes", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public ServerFile getFileForNode(ServiceInvocationContext context, String nodeId) throws ServiceException {
        DebugUtil.setThreadName((String)"ServerLogsServiceImpl-getFileForNode");
        try {
            this.checkContext(context);
            try {
                ServerFile serverFile = FsProvider.get().getFile(nodeId, "logs");
                return serverFile;
            }
            catch (Throwable t) {
                this.log.error("failed getting server file", t);
                throw new ServiceException("failed getting server file", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<Long, byte[]> getContent(ServiceInvocationContext context, String nodeId, String path, long offset) throws ServiceException {
        DebugUtil.setThreadName((String)"ServerLogsServiceImpl-getContent");
        try {
            this.checkContext(context);
            try {
                MiscUtil.Pair pair = FsProvider.get().getContent(nodeId, path, offset);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed getting content", t);
                throw new ServiceException("failed getting content", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

