/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.ShipmentsService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRules;
import com.gridnine.xtrip.common.model.finance.ShipmentProductAppliedRulesIndex;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ShipmentProperties;
import com.gridnine.xtrip.common.model.profile.TrashBinItem;
import com.gridnine.xtrip.common.model.profile.TrashBinItemIndex;
import com.gridnine.xtrip.common.model.profile.TrashBinItemType;
import com.gridnine.xtrip.common.model.rules.finance.Actions;
import com.gridnine.xtrip.common.model.rules.finance.Targets;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberPeriod;
import com.gridnine.xtrip.common.model.system.ConsecutiveNumberSerial;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.model.cn.ConsecutiveNumberHelper;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ShipmentsServiceImpl
extends BaseSecureServiceImpl
implements ShipmentsService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<NestedEntityReference<BookingFile, BaseProduct>, ShipmentsService.ProductData> getProductDatas(ServiceInvocationContext context, List<NestedEntityReference<BillingItemsList, BillingItem>> billingItemReferences) throws ServiceException {
        DebugUtil.setThreadName((String)"ShipmentsServiceImpl-getProductDatas");
        try {
            this.checkContext(context);
            ConcurrentHashMap<NestedEntityReference<BookingFile, BaseProduct>, ShipmentsService.ProductData> productDatas = new ConcurrentHashMap<NestedEntityReference<BookingFile, BaseProduct>, ShipmentsService.ProductData>();
            EntityStorageContext storageContext = new EntityStorageContext();
            Set productReferences = FinanceDocumentHelper.getBillingItems(billingItemReferences, (EntityStorageContext)storageContext).stream().map(BillingItem::getProduct).filter(Objects::nonNull).collect(Collectors.toSet());
            productReferences.stream().forEach(productRef -> {
                BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productRef, (EntityStorageContext)storageContext);
                if (product != null) {
                    ShipmentsService.ProductData productData = productDatas.computeIfAbsent((NestedEntityReference<BookingFile, BaseProduct>)productRef, item -> new ShipmentsService.ProductData());
                    productData.setProduct(product);
                }
            });
            ConcurrentHashMap<NestedEntityReference<BookingFile, BaseProduct>, ShipmentsService.ProductData> concurrentHashMap = productDatas;
            return concurrentHashMap;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShipmentWithSameNumberExists(ServiceInvocationContext context, String number, EntityReference<Shipment> currentShipment, EntityReference<Organization> supplier, NestedEntityReference<Contract, ContractCustomerInfo> contract, Date issueDate) throws ServiceException {
        DebugUtil.setThreadName((String)"ShipmentsServiceImpl-isShipmentWithSameNumberExists");
        try {
            boolean dateRequired;
            boolean contractRequired;
            boolean agencyRequired;
            this.checkContext(context);
            ShipmentProperties shipmentsProperties = ShipmentHelper.getShipmentsProperties(supplier, (boolean)false);
            if (shipmentsProperties == null) {
                boolean bl = false;
                return bl;
            }
            ConsecutiveNumberSerial serial = shipmentsProperties.getNumberSerial();
            ConsecutiveNumberPeriod period = shipmentsProperties.getNumberPeriod();
            boolean bl = this.searchExistShipment(number, currentShipment, supplier, contract, issueDate, period, agencyRequired = ConsecutiveNumberHelper.isAgencyRequred((ConsecutiveNumberSerial)serial), contractRequired = ConsecutiveNumberHelper.isContractRequred((ConsecutiveNumberSerial)serial), dateRequired = ConsecutiveNumberHelper.isDateRequred((ConsecutiveNumberPeriod)period)) || this.searchDeletedShipment(number, currentShipment, supplier, contract, issueDate, period, agencyRequired, contractRequired, dateRequired);
            return bl;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShipmentProductAppliedRulesIndex> getShipmentProductAppliedRulesIndices(ServiceInvocationContext context, EntityContainer<Shipment> shipment, String productName, Targets target, Actions action, int offset, int limit) throws ServiceException {
        DebugUtil.setThreadName((String)"ShipmentsServiceImpl-getShipmentProductAppliedRulesIndices");
        try {
            this.checkContext(context);
            SearchQuery query = new SearchQuery();
            query.setOffset(offset);
            query.setLimit(limit);
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentProductAppliedRulesIndex.Property.shipment.name(), (Object)shipment.toReference()));
            if (TextUtil.nonBlank((String)productName)) {
                String pattern = "%" + productName + "%";
                query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)ShipmentProductAppliedRulesIndex.Property.shortProductName.name(), (String)pattern));
            }
            if (target != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentProductAppliedRulesIndex.Property.target.name(), (Object)target.getId()));
            }
            if (action != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)ShipmentProductAppliedRulesIndex.Property.actions.name(), (Object)action.getId()));
            }
            Date date = shipment.getVersionInfo().getCreated();
            ArrayList<SearchCriterion> orCriterions = new ArrayList<SearchCriterion>();
            orCriterions.add(SearchCriterion.le((String)ShipmentProductAppliedRulesIndex.Property.calculationDate.name(), (Object)date));
            orCriterions.add(SearchCriterion.eq((String)ShipmentProductAppliedRulesIndex.Property.calculationDate.name(), (Object)date));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])orCriterions.toArray(new SearchCriterion[0])));
            List list = EntityStorage.get().search(ShipmentProductAppliedRulesIndex.class, query).getData();
            return list;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContainer<ShipmentProductAppliedRules> getShipmentProductAppliedRulesByDate(ServiceInvocationContext context, EntityContainer<ShipmentProductAppliedRules> shipmentProductAppliedRules, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"ShipmentsServiceImpl-getShipmentProductAppliedRulesByDate");
        try {
            this.checkContext(context);
            if (date == null) {
                EntityContainer<ShipmentProductAppliedRules> entityContainer = null;
                return entityContainer;
            }
            Integer versionNumber = LogicalStorage.get().getEntityStorage().getVersionInfos(shipmentProductAppliedRules.toReference()).stream().filter(item -> item.getModified() != null && !date.before(item.getModified())).map(VersionInfo::getVersionNumber).max(Comparator.naturalOrder()).orElse(null);
            if (versionNumber != null) {
                EntityContainer entityContainer = EntityStorage.get().load(shipmentProductAppliedRules.getEntityType(), shipmentProductAppliedRules.getUid(), versionNumber);
                return entityContainer;
            }
            EntityContainer<ShipmentProductAppliedRules> entityContainer = null;
            return entityContainer;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private boolean searchExistShipment(String number, EntityReference<Shipment> currentShipment, EntityReference<Organization> supplier, NestedEntityReference<Contract, ContractCustomerInfo> contract, Date issueDate, ConsecutiveNumberPeriod period, boolean agencyRequired, boolean contractRequired, boolean dateRequired) {
        SearchQuery query = new SearchQuery();
        query.setLimit(1);
        query.setResultMode(ResultMode.COUNT_ONLY);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.systemNumber.name(), (Object)number));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"containerUid", (Object)currentShipment.getUid()));
        if (agencyRequired) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.supplier.name(), supplier));
        }
        if (contractRequired) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.contract.name(), (Object)(contract != null ? new EntityReference(contract.getUid(), contract.getType(), contract.getCaption()) : null)));
        }
        if (dateRequired && issueDate != null) {
            Date endDate;
            Date startDate;
            switch (period) {
                case YEAR: {
                    startDate = MiscUtil.getYearBegin((Date)issueDate);
                    endDate = MiscUtil.getYearEnd((Date)issueDate);
                    break;
                }
                case MONTH: {
                    startDate = MiscUtil.getMonthBegin((Date)issueDate);
                    endDate = MiscUtil.getMonthEnd((Date)issueDate);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported period: " + period);
                }
            }
            query.getCriteria().getCriterions().add(SearchCriterion.between((String)ShipmentIndex.Property.date.name(), (Object)startDate, (Object)endDate));
        }
        return EntityStorage.get().search(ShipmentIndex.class, query).getTotalCount() > 0;
    }

    private boolean searchDeletedShipment(String number, EntityReference<Shipment> currentShipment, EntityReference<Organization> supplier, NestedEntityReference<Contract, ContractCustomerInfo> contract, Date issueDate, ConsecutiveNumberPeriod period, boolean agencyRequired, boolean contractRequired, boolean dateRequired) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TrashBinItemIndex.Property.type.name(), (Object)TrashBinItemType.SHIPMENT));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)TrashBinItemIndex.Property.deletedUid.name(), (Object)currentShipment.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TrashBinItemIndex.Property.number.name(), (Object)number));
        for (TrashBinItemIndex index : EntityStorage.get().search(TrashBinItemIndex.class, query).getData()) {
            EntityContainer shipmentContainer;
            EntityContainer trashBinItem = EntityStorage.get().resolve(index.getSource());
            if (EntityStorageHelper.isEmpty((EntityContainer)trashBinItem) || ((TrashBinItem)trashBinItem.getEntity()).getRestoreData() == null || ((TrashBinItem)trashBinItem.getEntity()).getRestoreData().getVersions().isEmpty() || EntityStorageHelper.isEmpty((EntityContainer)(shipmentContainer = (EntityContainer)((TrashBinItem)trashBinItem.getEntity()).getRestoreData().getVersions().get(0))) || agencyRequired && !MiscUtil.equals(supplier, (Object)((Shipment)shipmentContainer.getEntity()).getSupplier()) || contractRequired && contract != null && !MiscUtil.equals(contract, (Object)((Shipment)shipmentContainer.getEntity()).getContract())) continue;
            if (dateRequired && issueDate != null) {
                Date endDate;
                Date startDate;
                switch (period) {
                    case YEAR: {
                        startDate = MiscUtil.getYearBegin((Date)issueDate);
                        endDate = MiscUtil.getYearEnd((Date)issueDate);
                        break;
                    }
                    case MONTH: {
                        startDate = MiscUtil.getMonthBegin((Date)issueDate);
                        endDate = MiscUtil.getMonthEnd((Date)issueDate);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported period: " + period);
                    }
                }
                if (!MiscUtil.isBetween((Date)startDate, (Date)endDate, (Date)issueDate)) continue;
            }
            return true;
        }
        return false;
    }
}

