/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.model.AppConfigData;
import com.gridnine.xtrip.common.fx.model.PrefetchedData;
import com.gridnine.xtrip.common.fx.rpc.StandardFxService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.rest.jenkins.UserMessage;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.RenderHandlersRegistry;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.fx.prefetched.PrefetchedDataSupport;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.model.rest.jenkins.JenkinsUpdateMassageHolderServer;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class StandardFxServiceImpl
extends BaseSecureServiceImpl
implements StandardFxService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppConfigData getAppConfigData(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardFxServiceImpl-getAppConfigData");
        try {
            this.checkContext(ctx);
            AppConfigData result = new AppConfigData();
            AppConfiguration cfg = AppConfiguration.get();
            result.setRegionalVariation(cfg.getRegionalVariation());
            result.setOnlineGdsEnabled(cfg.isOnlineGdsEnabled());
            result.setIbeEnabled(cfg.isIbeEnabled());
            result.setTravelPolicyAuthEnabled(cfg.isTravelPolicyAuthEnabled());
            result.setCollectTechnicalFee(cfg.isCollectTechnicalFee());
            result.setCollectTechnicalFeeBeginDate(cfg.getCollectTechnicalFeeBeginDate());
            AppConfigData appConfigData = result;
            return appConfigData;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public PrefetchedData getPrefetchedData(ServiceInvocationContext context, String agencyUid, String salesPointUid, String cashUid, String cashRegisterUid, String cashRegisterWorkplaceUid) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardFxServiceImpl-getPrefetchedData");
        try {
            this.checkContext(context);
            try {
                PrefetchedData prefetchedData = PrefetchedDataSupport.get().getFilledData(agencyUid, salesPointUid, cashUid, cashRegisterUid, cashRegisterWorkplaceUid);
                return prefetchedData;
            }
            catch (Throwable t) {
                this.log.error("failed creating prefetched data", t);
                throw new ServiceException("failed creating prefetched data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Airline findAirline(ServiceInvocationContext ctx, String codeOrNumber) throws ServiceException {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-findAirline");
        try {
            this.checkContext(ctx);
            if (!AclHelper.isGranted(null, (String)Airline.class.getName(), (String)LogicalStorage.get().getUser(), (String)StandardRestrictionResourceOperations.VIEW.getId(), Collections.emptyList())) {
                Airline airline = null;
                return airline;
            }
            Airline result = DictHelper.findAirlineByAnyCode((String)codeOrNumber);
            if (result == null) {
                result = DictHelper.findAirlineByNumber((String)codeOrNumber);
            }
            Airline airline = result;
            return airline;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed searching airline " + codeOrNumber, t);
            throw new ServiceException("failed searching airline", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public EntityContainer<? extends BaseEntity> getReportContainer(EntityContainer<StockOrder> orderCtr, ServiceInvocationContext ctx) throws Exception {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-getReportContainer");
        try {
            this.checkContext(ctx);
            HashSet<Message> messageOfControl = new HashSet<Message>();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("key-report-params", new ReportParameters());
            data.put("order", orderCtr);
            EntityContainer ctr = ((RenderHandlersRegistry)Environment.getPublished(RenderHandlersRegistry.class)).get("stock-order-print-form").renderReport(data);
            if (ctr == null || ((ReportDocument)ctr.getEntity()).getFiles().isEmpty()) {
                EntityContainer<? extends BaseEntity> entityContainer = null;
                return entityContainer;
            }
            for (Message message : ((BaseReportDocument)ctr.getEntity()).getMessages()) {
                if (message.getType() != MessageType.ERROR) continue;
                messageOfControl.add(message);
            }
            if (!messageOfControl.isEmpty()) {
                ((BaseReportDocument)ctr.getEntity()).getMessages().retainAll(messageOfControl);
            }
            EntityContainer entityContainer = ctr;
            return entityContainer;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed getting report container", t);
            throw new ServiceException("failed getting report container", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public EntityReference<Document> getDocumentContent(EntityContainer<StockOrder> orderCtr, EntityContainer<? extends BaseEntity> reportCtr, ServiceInvocationContext ctx) throws Exception {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-getDocumentContent");
        try {
            this.checkContext(ctx);
            EntityContainer docCtr = new EntityContainer(Document.class);
            docCtr.setCreated(reportCtr.getCreated());
            docCtr.setCreatedBy(ctx.getUser());
            docCtr.setModifiedBy(ctx.getUser());
            docCtr.getVersionInfo().setDataSource("renderer");
            Document doc = (Document)docCtr.getEntity();
            doc.setCreated(reportCtr.getCreated());
            doc.setContentType(ContentType.EXCEL);
            ReportFile reportFile = (ReportFile)((ReportDocument)reportCtr.getEntity()).getFiles().get(0);
            doc.setName(reportFile.getName());
            doc.setOwner(orderCtr.toReference());
            doc.setTitle(reportFile.getTitle());
            doc.setContent(reportFile.getContent());
            doc.setCheckSum(MiscUtil.getCheckSum((byte[])reportFile.getContent()));
            docCtr = EntityStorage.get().save(docCtr, true);
            EntityCacheManager.get().check();
            EntityReference entityReference = docCtr.toReference();
            return entityReference;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed invoice generating", t);
            throw new ServiceException("failed invoice generating", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public UserMessage findJenkinsUpdateMassage(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"FxDictServiceImpl-findJenkinsUpdateMassageHolder");
        try {
            this.checkContext(ctx);
            UserMessage userMessage = JenkinsUpdateMassageHolderServer.get().getMessage();
            return userMessage;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed searching JenkinsUpdateMassageHolder whit uid", t);
            throw new ServiceException("failed searching JenkinsUpdateMassageHolder", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

