/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.uidata.AeroexpressTicketUIData;
import com.gridnine.xtrip.common.model.booking.air.uidata.AirProductUIData;
import com.gridnine.xtrip.common.model.booking.air.uidata.HotelProductUIData;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouch;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiHelper;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.transfer.TransferHelper;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.uidata.AdditionalServiceProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.AgencyMemoProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.AgentTouchProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CarRentalProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.DeliveryUIData;
import com.gridnine.xtrip.common.model.booking.uidata.InsuranceUIData;
import com.gridnine.xtrip.common.model.booking.uidata.TaxiProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.TransferProductXtripUIData;
import com.gridnine.xtrip.common.model.booking.uidata.UniversalProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.VisaProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.VoidingProductUIData;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductHelper;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.model.helpers.ProfileHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.Date;
import java.util.Optional;

public class StandardProductPrototypeServiceImpl
extends BaseSecureServiceImpl
implements StandardProductPrototypeService {
    public MiscUtil.Pair<AeroexpressTicket, AeroexpressTicketUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, AeroexpressTicket lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-aeroexpressTicket");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : AeroexpressTicketHelper.getAgency((AeroexpressTicket)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : AeroexpressTicketHelper.getSubagency((AeroexpressTicket)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference blankOwner = Optional.ofNullable(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.AEROEXPRESS_PROFILE_UID, null)).map(item -> EntityStorage.get().load(Organization.class, item)).map(EntityContainer::toReference).orElse(lastProduct.getBlankOwner());
                EntityReference supplier = AeroexpressTicketHelper.getSupplier((AeroexpressTicket)lastProduct);
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                DictionaryReference blankType = lastProduct.getBlankType();
                AeroexpressTicket product = new AeroexpressTicket();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                product.setBlankOwner(blankOwner);
                AeroexpressTicketHelper.setSupplier((AeroexpressTicket)product, (EntityReference)supplier);
                AeroexpressTicketHelper.setAgency((AeroexpressTicket)product, (EntityReference)agency);
                AeroexpressTicketHelper.setSubagency((AeroexpressTicket)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                product.setBlankType(blankType);
                AeroexpressTicketUIData productSupplementData = new AeroexpressTicketUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setSupplier(supplier);
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<AgencyMemoProduct, AgencyMemoProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, AgencyMemoProduct lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-agencyMemoProduct");
        try {
            this.checkContext(context);
            try {
                Date date = new Date();
                AgencyMemoProduct product = new AgencyMemoProduct();
                product.setIssueDate(date);
                product.setTicketType(TicketType.OWN);
                AgencyMemoProductUIData productSupplementData = new AgencyMemoProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<AgentTouch, AgentTouchProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, AgentTouch lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-agentTouch");
        try {
            this.checkContext(context);
            try {
                Date date = new Date();
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                AgentTouch product = new AgentTouch();
                product.setIssueDate(date);
                product.setTicketType(TicketType.OWN);
                product.setSalesPoint(salesPoint);
                AgentTouchProductUIData productSupplementData = new AgentTouchProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<Product, AirProductUIData> getPrototypeData(ServiceInvocationContext context, ProductCategory productCategory, AgentData agentData, Product lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-product");
        try {
            this.checkContext(context);
            try {
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : AirProductHelper.getAgency((Product)lastProduct);
                EntityReference subagency = agentData.getSubagency() != null ? agentData.getSubagency() : AirProductHelper.getSubagency((Product)lastProduct);
                EntityReference technicalProvider = ProfileHelper.findTechnicalProviderProfile();
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getCashier();
                Product product = new Product();
                product.setProductCategory(productCategory);
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                AirProductHelper.setAgency((Product)product, (EntityReference)agency);
                AirProductHelper.setSubagency((Product)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setCashier(agent);
                AirProductUIData productSupplementData = new AirProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                productSupplementData.setTechnicalProvider(technicalProvider);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<CarRentalProduct, CarRentalProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, CarRentalProduct lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-carRentalProduct");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : CarRentalProductHelper.getAgency((CarRentalProduct)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : CarRentalProductHelper.getSubagency((CarRentalProduct)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference blankOwner = lastProduct.getBlankOwner();
                EntityReference supplier = CarRentalProductHelper.getSupplier((CarRentalProduct)lastProduct);
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                DictionaryReference carsSupplier = lastProduct.getCarsSupplier();
                CarRentalProduct product = new CarRentalProduct();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                product.setBlankOwner(blankOwner);
                CarRentalProductHelper.setSupplier((CarRentalProduct)product, (EntityReference)supplier);
                CarRentalProductHelper.setAgency((CarRentalProduct)product, (EntityReference)agency);
                CarRentalProductHelper.setSubagency((CarRentalProduct)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                product.setCarsSupplier(carsSupplier);
                product.setNumberOfCars(1);
                CarRentalProductUIData productSupplementData = new CarRentalProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setSupplier(supplier);
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<Delivery, DeliveryUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, Delivery lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-delivery");
        try {
            this.checkContext(context);
            try {
                Date date = new Date();
                EntityReference agency = agentData.getSubagency() != null ? agentData.getSubagency() : lastProduct.getAgency();
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                Delivery product = new Delivery();
                product.setStatus(DeliveryStatus.PLANNED);
                product.setIssueDate(date);
                product.setTicketType(TicketType.OWN);
                product.setAgency(agency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                DeliveryUIData productSupplementData = new DeliveryUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setAgency(agency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<HotelProduct, HotelProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, HotelProduct lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-hotelProduct");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : HotelProductHelper.getAgency((HotelProduct)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : HotelProductHelper.getSubagency((HotelProduct)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getCashier();
                HotelProduct product = new HotelProduct();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                HotelProductHelper.setAgency((HotelProduct)product, (EntityReference)agency);
                HotelProductHelper.setSubagency((HotelProduct)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setCashier(agent);
                HotelProductUIData productSupplementData = new HotelProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<InsuranceAccident, InsuranceUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, InsuranceAccident lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-insuranceAccident");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : InsuranceAccidentHelper.getAgency((InsuranceAccident)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : InsuranceAccidentHelper.getSubagency((InsuranceAccident)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                InsuranceAccident product = new InsuranceAccident();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                InsuranceAccidentHelper.setAgency((InsuranceAccident)product, (EntityReference)agency);
                InsuranceAccidentHelper.setSubagency((InsuranceAccident)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                InsuranceUIData productSupplementData = new InsuranceUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<InsuranceTouristic, InsuranceUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, InsuranceTouristic lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-insuranceTouristic");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : InsuranceTouristicHelper.getAgency((InsuranceTouristic)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : InsuranceTouristicHelper.getSubagency((InsuranceTouristic)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                InsuranceTouristic product = new InsuranceTouristic();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                InsuranceTouristicHelper.setAgency((InsuranceTouristic)product, (EntityReference)agency);
                InsuranceTouristicHelper.setSubagency((InsuranceTouristic)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                InsuranceUIData productSupplementData = new InsuranceUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<MCOFees, BaseProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, MCOFees lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-mcoFees");
        try {
            this.checkContext(context);
            try {
                Date date = new Date();
                EntityReference agency = agentData.getSubagency() != null ? agentData.getSubagency() : lastProduct.getAgency();
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                DictionaryReference blankType = lastProduct.getBlankType();
                MCOFees product = new MCOFees();
                product.setStatus(ProductStatus.SELL);
                product.setIssueDate(date);
                product.setAgency(agency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                product.setBlankType(blankType);
                BaseProductUIData productSupplementData = new BaseProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setAgency(agency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<Transfer, TransferProductXtripUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, Transfer lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-transfer");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : TransferHelper.getAgency((Transfer)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : TransferHelper.getSubagency((Transfer)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                Transfer product = new Transfer();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                TransferHelper.setAgency((Transfer)product, (EntityReference)agency);
                TransferHelper.setSubagency((Transfer)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                product.setPassengersCount(Integer.valueOf(1));
                TransferProductXtripUIData productSupplementData = new TransferProductXtripUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<TaxiProduct, TaxiProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, TaxiProduct lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-transfer");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : TaxiHelper.getAgency((TaxiProduct)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : TaxiHelper.getSubagency((TaxiProduct)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                TaxiProduct product = new TaxiProduct();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                TaxiHelper.setAgency((TaxiProduct)product, (EntityReference)agency);
                TaxiHelper.setSubagency((TaxiProduct)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                TaxiProductUIData productSupplementData = new TaxiProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<VisaProduct, VisaProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, VisaProduct lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-visa");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : VisaProductHelper.getAgency((VisaProduct)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : VisaProductHelper.getSubagency((VisaProduct)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference blankOwner = lastProduct.getBlankOwner();
                EntityReference supplier = VisaProductHelper.getSupplier((VisaProduct)lastProduct);
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                VisaProduct product = new VisaProduct();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                product.setBlankOwner(blankOwner);
                VisaProductHelper.setSupplier((VisaProduct)product, (EntityReference)supplier);
                VisaProductHelper.setAgency((VisaProduct)product, (EntityReference)agency);
                VisaProductHelper.setSubagency((VisaProduct)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                VisaProductUIData productSupplementData = new VisaProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setSupplier(supplier);
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<AdditionalServiceProduct, AdditionalServiceProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, AdditionalServiceProduct lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-additional-service");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : AdditionalServiceProductHelper.getAgency((AdditionalServiceProduct)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : AdditionalServiceProductHelper.getSubagency((AdditionalServiceProduct)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference supplier = AdditionalServiceProductHelper.getSupplier((AdditionalServiceProduct)lastProduct);
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                AdditionalServiceProduct product = new AdditionalServiceProduct();
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.REFERRAL);
                product.setIssueDate(date);
                AdditionalServiceProductHelper.setSupplier((AdditionalServiceProduct)product, (EntityReference)supplier);
                AdditionalServiceProductHelper.setAgency((AdditionalServiceProduct)product, (EntityReference)agency);
                AdditionalServiceProductHelper.setSubagency((AdditionalServiceProduct)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                AdditionalServiceProductUIData productSupplementData = new AdditionalServiceProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<ProductVoiding, VoidingProductUIData> getPrototypeData(ServiceInvocationContext context, AgentData agentData, ProductVoiding lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"StandardProductPrototypeServiceImpl-getPrototypeData-productVoiding");
        try {
            this.checkContext(context);
            try {
                ProductVoiding product = new ProductVoiding();
                VoidingProductUIData productSupplementData = new VoidingProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<UniversalProduct, UniversalProductUIData> getPrototypeData(ServiceInvocationContext context, EntityReference<UniversalProductDescription> description, AgentData agentData, UniversalProduct lastProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"FxUniversalProductServiceImpl-getPrototypeData-universalProduct");
        try {
            this.checkContext(context);
            try {
                EntityReference subagency;
                EntityContainer descriptionContainer = EntityStorage.get().resolve(description);
                if (descriptionContainer == null) {
                    throw new Exception(String.format("failed loading universal product description %s", description));
                }
                Date date = new Date();
                EntityReference agency = agentData.getAgency() != null ? agentData.getAgency() : UniversalProductHelper.getAgency((UniversalProduct)lastProduct);
                EntityReference entityReference = subagency = agentData.getSubagency() != null ? agentData.getSubagency() : UniversalProductHelper.getSubagency((UniversalProduct)lastProduct);
                if (subagency == null) {
                    subagency = agency;
                }
                EntityReference blankOwner = ((UniversalProductDescription)descriptionContainer.getEntity()).isBlankOwnerAndSupplierAreAgency() ? agency : lastProduct.getBlankOwner();
                EntityReference supplier = ((UniversalProductDescription)descriptionContainer.getEntity()).isBlankOwnerAndSupplierAreAgency() ? agency : UniversalProductHelper.getSupplier((UniversalProduct)lastProduct);
                EntityReference salesPoint = agentData.getSalesPoint() != null ? agentData.getSalesPoint() : lastProduct.getSalesPoint();
                EntityReference agent = agentData.getAgent() != null ? agentData.getAgent() : lastProduct.getAgent();
                DictionaryReference blankType = lastProduct.getBlankType();
                boolean hasVat = lastProduct.isHasVat();
                UniversalProduct product = new UniversalProduct();
                product.setDescription(description);
                product.setStatus(ProductStatus.SELL);
                product.setTicketType(TicketType.OWN);
                product.setIssueDate(date);
                product.setBlankOwner(blankOwner);
                UniversalProductHelper.setSupplier((UniversalProduct)product, (EntityReference)supplier);
                UniversalProductHelper.setAgency((UniversalProduct)product, (EntityReference)agency);
                UniversalProductHelper.setSubagency((UniversalProduct)product, (EntityReference)subagency);
                product.setSalesPoint(salesPoint);
                product.setAgent(agent);
                product.setBlankType(blankType);
                product.setHasVat(hasVat);
                UniversalProductUIData productSupplementData = new UniversalProductUIData();
                productSupplementData.setRelatedProductUID(product.getUid());
                productSupplementData.setSupplier(supplier);
                productSupplementData.setAgency(agency);
                productSupplementData.setSubagency(subagency);
                MiscUtil.Pair pair = new MiscUtil.Pair((Object)product, (Object)productSupplementData);
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed create prototype data", t);
                throw new ServiceException("failed create prototype data", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

