/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.UniversalProductService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductRecalcFareData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class UniversalProductServiceImpl
extends BaseSecureServiceImpl
implements UniversalProductService {
    public UniversalProductRecalcFareData getUniversalProductRecalcFareData(ServiceInvocationContext ctx, UniversalProduct product) throws ServiceException {
        DebugUtil.setThreadName((String)"FxUniversalProductServiceImpl-getUniversalProductRecalcFareData");
        try {
            this.checkContext(ctx);
            try {
                UniversalProductRecalcFareData universalProductRecalcFareData = this.getData(product);
                return universalProductRecalcFareData;
            }
            catch (Throwable t) {
                this.log.error("failed load UniversalProductRecalcFareData", t);
                throw new ServiceException("failed load UniversalProductRecalcFareData", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillingAndSaveProduct(ServiceInvocationContext ctx, EntityReference<BookingFile> ref, String uidProduct, UniversalProductRecalcFareData result) throws ServiceException {
        DebugUtil.setThreadName((String)"FxUniversalProductServiceImpl-fillingAndSaveProduct");
        try {
            this.checkContext(ctx);
            try {
                EntityContainer ctr = EntityStorage.get().resolve(ref);
                if (ctr == null) {
                    throw new ServiceException("failed load booking file uid = " + ref.getUid());
                }
                Optional<BaseProduct> optProduct = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(el -> el.getProducts().stream()).filter(el -> TextUtil.isSame((String)el.getUid(), (String)uidProduct)).findFirst();
                if (optProduct.isPresent()) {
                    UniversalProduct product = (UniversalProduct)optProduct.get();
                    product.setRate(result.getRate());
                    product.setRateWithCoeff(result.getRateWithCoeff());
                    product.setEquivalentFare(RulesHelper.roundDouble((BigDecimal)product.getBaseFare().getValue().multiply(result.getRateWithCoeff()), (RoundingMode)result.getRoundingMode(), (RoundingValue)result.getRoundingValue()));
                    for (GeneralProductContractRelationData relation : UniversalProductHelper.getContractRelations((UniversalProduct)product)) {
                        ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
                        BigDecimal rate = contractType == ContractType.VENDOR ? result.getRate() : result.getRateWithCoeff();
                        for (GeneralProductCommission commission : relation.getCommissions()) {
                            if (commission.getAmount() != null && commission.getAmount().getValue() != null) {
                                commission.setEquivalentAmount(RulesHelper.roundDouble((BigDecimal)commission.getAmount().getValue().multiply(rate), (RoundingMode)result.getRoundingMode(), (RoundingValue)result.getRoundingValue()));
                                continue;
                            }
                            if (commission.getRate() == null) continue;
                            commission.setEquivalentAmount(RulesHelper.roundDouble((BigDecimal)product.getEquivalentFare().multiply(BigDecimal.valueOf(commission.getRate())).divide(BigDecimal.valueOf(100L)), (RoundingMode)result.getRoundingMode(), (RoundingValue)result.getRoundingValue()));
                        }
                    }
                    GeneralProductHelper.updateFops((BaseProduct)product);
                    EntityStorage.get().save(ctr, true);
                }
            }
            catch (Throwable t) {
                this.log.error("failed filling and save universal product (recalc fare data)", t);
                throw new ServiceException("failed filling and save universal product (recalc fare data)", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private UniversalProductRecalcFareData getData(UniversalProduct product) {
        UniversalProductRecalcFareData result = new UniversalProductRecalcFareData();
        List<ContractCustomerInfo> infos = this.collectContracts(product);
        Date now = new Date();
        for (ContractCustomerInfo info : infos) {
            for (ExchangeRateCondition condition : info.getExchangeRateConditions()) {
                if (condition.getRateType() == null || !MiscUtil.isBetween((Date)condition.getStartDate(), (Date)condition.getEndDate(), (Date)now)) continue;
                CurrencyRate currencyRate = DictHelper.findCurrencyRate((String)product.getBaseFare().getCurrency(), (Date)now, (CurrencyRateType)condition.getRateType(), null, (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product));
                if (currencyRate != null) {
                    result.setRate(BigDecimal.valueOf(currencyRate.getRate()));
                }
                result.setCoeff(BigDecimal.valueOf(condition.getCoefficient()));
                result.setRateWithCoeff(MiscUtil.mul((BigDecimal)result.getRate(), (BigDecimal)result.getCoeff()));
                result.setRoundingMode(condition.getRoundingMode() == null ? RoundingMode.NONE : condition.getRoundingMode());
                result.setRoundingValue(condition.getRoundingValue() == null ? RoundingValue.V_0_0_1 : condition.getRoundingValue());
                return result;
            }
        }
        return result;
    }

    private List<ContractCustomerInfo> collectContracts(UniversalProduct product) {
        EntityReference clientRef = product.getReservation().getBookingFile().getCustomerProfile();
        if (clientRef == null) {
            return Collections.emptyList();
        }
        EntityReference agencyRef = UniversalProductHelper.getAgency((UniversalProduct)product);
        if (agencyRef == null) {
            return Collections.emptyList();
        }
        final EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        final EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        HashSet<EntityReference<Organization>> suppliers = new HashSet<EntityReference<Organization>>();
        HashSet<EntityReference<Organization>> customers = new HashSet<EntityReference<Organization>>();
        suppliers.add(agencyRef);
        customers.add(clientRef);
        if (allAgenciesProfile != null) {
            suppliers.add(allAgenciesProfile);
        }
        if (allClientsProfile != null) {
            customers.add(allClientsProfile);
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(UniversalProductServiceImpl.toCriterion(ContractCustomerIndex.Property.supplier.name(), suppliers));
        query.getCriteria().getCriterions().add(UniversalProductServiceImpl.toCriterion(ContractCustomerIndex.Property.customer.name(), customers));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        Date date = product.getIssueDate();
        if (date != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        }
        final HashMap<EntityReference, EntityContainer> contractsMap = new HashMap<EntityReference, EntityContainer>();
        ArrayList<ContractCustomerIndex> contractIndexes = new ArrayList<ContractCustomerIndex>(EntityStorage.get().search(ContractCustomerIndex.class, query).getData());
        for (ContractCustomerIndex item : contractIndexes) {
            contractsMap.put(item.getSource(), EntityStorage.get().resolve(item.getSource()));
        }
        contractIndexes.sort(new Comparator<ContractCustomerIndex>(){

            @Override
            public int compare(ContractCustomerIndex o1, ContractCustomerIndex o2) {
                int index2;
                EntityContainer ctr1 = (EntityContainer)contractsMap.get(o1.getSource());
                EntityContainer ctr2 = (EntityContainer)contractsMap.get(o2.getSource());
                if (((Contract)ctr1.getEntity()).getPriority() != ((Contract)ctr2.getEntity()).getPriority()) {
                    return ((Contract)ctr1.getEntity()).getPriority() > ((Contract)ctr2.getEntity()).getPriority() ? -1 : 1;
                }
                int index1 = this.getGeneralityIndex(o1);
                if (index1 != (index2 = this.getGeneralityIndex(o2))) {
                    return index1 > index2 ? 1 : -1;
                }
                if (((Contract)ctr1.getEntity()).isTypicalContract() != ((Contract)ctr2.getEntity()).isTypicalContract()) {
                    return ((Contract)ctr1.getEntity()).isTypicalContract() ? 1 : -1;
                }
                return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
            }

            private int getGeneralityIndex(ContractCustomerIndex o1) {
                return (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getSupplier()) ? 4 : 0) + (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getCustomer()) ? 2 : 0) + (allClientsProfile != null && allClientsProfile.equals((Object)o1.getCustomer()) ? 1 : 0);
            }
        });
        ArrayList<ContractCustomerInfo> customerInfos = new ArrayList<ContractCustomerInfo>();
        for (ContractCustomerIndex index : contractIndexes) {
            EntityContainer ctr = (EntityContainer)contractsMap.get(index.getSource());
            ContractCustomerInfo info = (ContractCustomerInfo)CollectionUtil.find((Iterable)((Contract)ctr.getEntity()).getCustomers(), (String)index.getNavigationKey());
            if (info == null) continue;
            customerInfos.add(info);
        }
        return customerInfos;
    }

    private static SearchCriterion toCriterion(String propertyName, Set<EntityReference<Organization>> suppliers) {
        if (suppliers.size() == 1) {
            return SearchCriterion.eq((String)propertyName, suppliers.iterator().next());
        }
        ArrayList<SearchCriterion> crits = new ArrayList<SearchCriterion>();
        for (EntityReference<Organization> item : suppliers) {
            crits.add(SearchCriterion.eq((String)propertyName, item));
        }
        return SearchCriterion.or((SearchCriterion[])crits.toArray(new SearchCriterion[crits.size()]));
    }
}

