/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.WorklogService;
import com.gridnine.xtrip.common.fx.rpc.WorklogServiceResult;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.StandardTransactionActions;
import com.gridnine.xtrip.common.model.finance.TransactionAction;
import com.gridnine.xtrip.common.model.finance.TransactionDataHolder;
import com.gridnine.xtrip.common.model.finance.TransactionsComparisonResult;
import com.gridnine.xtrip.common.model.helpers.BalanceHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.WorklogHelper;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashIndex;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterIndex;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplaceIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.model.system.WorklogIndex;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.ibus.finance.FinanceIbusHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class WorklogServiceImpl
extends BaseSecureServiceImpl
implements WorklogService {
    public BigDecimal calculateBalanceCashRegisterWorkplace(ServiceInvocationContext sic, EntityReference<SalesPoint> salesPoint, EntityReference<CashRegisterWorkplace> cashRegisterWorkplace, EntityReference<Person> agent, EntityReference<Organization> agency, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-calculateBalanceCashRegisterWorkplace");
        try {
            BigDecimal remainsAmount;
            this.checkContext(sic);
            try {
                if (salesPoint == null) {
                    BigDecimal bigDecimal = null;
                    return bigDecimal;
                }
                remainsAmount = null;
            }
            catch (Throwable t) {
                this.log.error("failed calculate balance for cashRegisterWorkplace(Worklog)", t);
                throw new ServiceException("failed calculate balance for cashRegisterWorkplace(Worklog)", t);
            }
            boolean individualCashRemains = ProfileHelper.isIndividualCashRemains(salesPoint);
            CurrencyInfoReference currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
            remainsAmount = individualCashRemains ? BalanceHelper.calculateBalance(agency, (Date)date, (Date)date, (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_REMAINS_STASH, (DictionaryReference)currency, Collections.singletonMap(DimensionType.AGENT, agent)) : BalanceHelper.calculateBalance(agency, (Date)date, (Date)date, (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_REMAINS_STASH, (DictionaryReference)currency, Collections.singletonMap(DimensionType.CASH_REGISTER_WORKPLACE, cashRegisterWorkplace));
            BigDecimal bigDecimal = remainsAmount;
            return bigDecimal;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Money calculateBalanceCash(ServiceInvocationContext sic, EntityReference<Cash> cash, EntityReference<Organization> agency, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-calculateBalanceCash");
        try {
            this.checkContext(sic);
            try {
                Money remainsAmount = new Money();
                if (cash != null) {
                    String currency = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
                    CurrencyInfoReference currencyDictRef = new CurrencyInfoReference(currency);
                    remainsAmount.setCurrency(currency);
                    remainsAmount.setValue(BalanceHelper.calculateBalance(agency, (Date)date, (Date)date, (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_STASH, (DictionaryReference)currencyDictRef, Collections.singletonMap(DimensionType.CASH, cash)));
                }
                Money money = remainsAmount;
                return money;
            }
            catch (Throwable t) {
                this.log.error("failed calculate balance for cash(Worklog)", t);
                throw new ServiceException("failed calculate balance for cash(Worklog)", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>> checkAgentWorklog(ServiceInvocationContext sic, Worklog worklog, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-checkAgentWorklog");
        try {
            this.checkContext(sic);
            try {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cashRegisterWorkplace.name(), (Object)worklog.getCashRegisterWorkplace()));
                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)WorklogIndex.Property.types.name(), (Object)PersonType.AGENT));
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null));
                List worklogIndexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
                if (!worklogIndexes.isEmpty()) {
                    if (worklogIndexes.size() > 1) {
                        this.log.warn(String.format("found multiple active worklogs for cash register workplace %s", worklog.getCashRegisterWorkplace()));
                    }
                    MiscUtil.Pair pair = new MiscUtil.Pair((Object)((WorklogIndex)worklogIndexes.get(0)).getSource(), (Object)((WorklogIndex)worklogIndexes.get(0)).getEmployee());
                    return pair;
                }
                MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>> pair = null;
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed check agent worklog", t);
                throw new ServiceException("failed check agent worklog", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>> checkCashierClerkWorklog(ServiceInvocationContext sic, Worklog worklog, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-checkCashierClerkWorklog");
        try {
            this.checkContext(sic);
            try {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cashRegister.name(), (Object)worklog.getCashRegister()));
                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)WorklogIndex.Property.types.name(), (Object)PersonType.CASHIER_CLERK));
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null));
                List worklogIndexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
                if (!worklogIndexes.isEmpty()) {
                    if (worklogIndexes.size() > 1) {
                        this.log.warn(String.format("found multiple active worklogs for cash register %s", worklog.getCashRegister()));
                    }
                    MiscUtil.Pair pair = new MiscUtil.Pair((Object)((WorklogIndex)worklogIndexes.get(0)).getSource(), (Object)((WorklogIndex)worklogIndexes.get(0)).getEmployee());
                    return pair;
                }
                MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>> pair = null;
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed check cashier clerk worklog ", t);
                throw new ServiceException("failed check cashier clerk worklog", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>> checkCashierAccountantWorklog(ServiceInvocationContext sic, Worklog worklog, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-checkCashierAccountantWorklog");
        try {
            this.checkContext(sic);
            try {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cash.name(), (Object)worklog.getCash()));
                query.getCriteria().getCriterions().add(SearchCriterion.contains((String)WorklogIndex.Property.types.name(), (Object)PersonType.CASHIER_ACCOUNTANT));
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null));
                List worklogIndexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
                if (!worklogIndexes.isEmpty()) {
                    if (worklogIndexes.size() > 1) {
                        this.log.warn(String.format("found multiple active worklogs for cash %s", worklog.getCash()));
                    }
                    MiscUtil.Pair pair = new MiscUtil.Pair((Object)((WorklogIndex)worklogIndexes.get(0)).getSource(), (Object)((WorklogIndex)worklogIndexes.get(0)).getEmployee());
                    return pair;
                }
                MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>> pair = null;
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed check cashier accountant workplace worklog ", t);
                throw new ServiceException("failed check cashier accountant workplace worklog", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>> checkEmployeeWorklog(ServiceInvocationContext sic, Worklog worklog, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-checkEmployeeWorklog");
        try {
            this.checkContext(sic);
            try {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.employee.name(), (Object)worklog.getEmployee()));
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null));
                List worklogIndexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
                if (!worklogIndexes.isEmpty()) {
                    if (worklogIndexes.size() > 1) {
                        this.log.warn(String.format("found multiple active worklogs for employee %s", worklog.getEmployee()));
                    }
                    MiscUtil.Pair pair = new MiscUtil.Pair((Object)((WorklogIndex)worklogIndexes.get(0)).getSource(), (Object)((WorklogIndex)worklogIndexes.get(0)).getEmployee());
                    return pair;
                }
                MiscUtil.Pair<EntityReference<Worklog>, EntityReference<Person>> pair = null;
                return pair;
            }
            catch (Throwable t) {
                this.log.error("failed check employee worklog", t);
                throw new ServiceException("failed check employee worklog", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private EntityReference<Worklog> getRecentEmployeeWorklog(EntityReference<Person> employee, Date date) throws ServiceException {
        try {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.employee.name(), employee));
            query.getCriteria().getCriterions().add(SearchCriterion.lt((String)WorklogIndex.Property.endDate.name(), (Object)date));
            query.getCriteria().getOrders().put(WorklogIndex.Property.endDate.name(), SortOrder.DESC);
            List indexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
            return indexes.size() > 0 ? ((WorklogIndex)indexes.get(0)).getSource() : null;
        }
        catch (Throwable t) {
            this.log.error("failed get Recent Employee Worklog", t);
            throw new ServiceException("failed get Recent Employee Worklog", t);
        }
    }

    private EntityReference<Worklog> getRecentAgentWorklog(EntityReference<CashRegisterWorkplace> cashRegisterWorkplace, Date date) throws ServiceException {
        try {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cashRegisterWorkplace.name(), cashRegisterWorkplace));
            query.getCriteria().getCriterions().add(SearchCriterion.lt((String)WorklogIndex.Property.endDate.name(), (Object)date));
            query.getCriteria().getOrders().put(WorklogIndex.Property.endDate.name(), SortOrder.DESC);
            List indexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
            return indexes.size() > 0 ? ((WorklogIndex)indexes.get(0)).getSource() : null;
        }
        catch (Throwable t) {
            this.log.error("failed get recent agent worklog", t);
            throw new ServiceException("failed get recent agent worklog", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleWorklog(ServiceInvocationContext sic, Worklog worklog, Date date, BigDecimal cashRegistryWorkplaceFactualValue, BigDecimal cashRegistryWorkplaceCalculatedValue, BigDecimal cashFactualValue, BigDecimal cashCalculatedValue) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-handleWorklog");
        this.log.info(String.format("handle worklog of %s (%s) -> handle start -> user -> %s", worklog.getEmployee(), worklog.getUid(), sic.getUser()));
        this.log.info(String.format("handle worklog of %s (%s) -> worklog -> \n\n%s", worklog.getEmployee(), worklog.getUid(), DebugUtil.decorate((String)WorklogHelper.toString((Worklog)worklog), null, (String)"worklog", (boolean)true)));
        this.log.info(String.format("handle worklog of %s (%s) -> date -> %s", worklog.getEmployee(), worklog.getUid(), DebugUtil.toString((Date)date)));
        this.log.info(String.format("handle worklog of %s (%s) -> workplaceFactualValue -> %s", worklog.getEmployee(), worklog.getUid(), cashRegistryWorkplaceFactualValue));
        this.log.info(String.format("handle worklog of %s (%s) -> workplaceCalculatedValue -> %s", worklog.getEmployee(), worklog.getUid(), cashRegistryWorkplaceCalculatedValue));
        this.log.info(String.format("handle worklog of %s (%s) -> cashFactualValue -> %s", worklog.getEmployee(), worklog.getUid(), cashFactualValue));
        this.log.info(String.format("handle worklog of %s (%s) -> cashCalculatedValue -> %s", worklog.getEmployee(), worklog.getUid(), cashCalculatedValue));
        try {
            this.checkContext(sic);
            LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
            try {
                this.log.info(String.format("handle worklog of %s (%s) -> checking type", worklog.getEmployee(), worklog.getUid()));
                if (worklog.getTypes().contains(PersonType.AGENT)) {
                    this.log.info(String.format("handle worklog of %s (%s) -> type -> %s", worklog.getEmployee(), worklog.getUid(), PersonType.AGENT.name()));
                    this.handleAgentWorklog(worklog, date, cashRegistryWorkplaceFactualValue, cashRegistryWorkplaceCalculatedValue);
                }
                if (worklog.getTypes().contains(PersonType.CASHIER_ACCOUNTANT)) {
                    this.log.info(String.format("handle worklog of %s (%s) -> type -> %s", worklog.getEmployee(), worklog.getUid(), PersonType.CASHIER_ACCOUNTANT.name()));
                    this.handleCashierAccountantWorklog(worklog, date, cashFactualValue, cashCalculatedValue);
                }
                this.log.info(String.format("handle worklog of %s (%s) -> before save", worklog.getEmployee(), worklog.getUid()));
                EntityContainer worklogCtr = EntityContainer.create((BaseEntity)worklog);
                worklogCtr.getVersionInfo().setDataSource("fx-handle-worklog");
                EntityStorage.get().save(worklogCtr, true);
                this.log.info(String.format("handle worklog of %s (%s) -> after save", worklog.getEmployee(), worklog.getUid()));
                LogicalStorage.get().endUnitOfWork(ls, true);
                this.log.debug("worklog was successfully handled");
            }
            finally {
                LogicalStorage.get().cancelUnitOfWork(ls);
            }
        }
        catch (Throwable throwable) {
            this.log.info(String.format("handle worklog of %s (%s) -> handle end -> user -> %s", worklog.getEmployee(), worklog.getUid(), sic.getUser()));
            DebugUtil.restoreThreadName();
            throw throwable;
        }
        this.log.info(String.format("handle worklog of %s (%s) -> handle end -> user -> %s", worklog.getEmployee(), worklog.getUid(), sic.getUser()));
        DebugUtil.restoreThreadName();
    }

    public void handleAgentWorklog(Worklog worklog, Date date, BigDecimal factualAmount, BigDecimal calculatedAmount) throws ServiceException {
        try {
            boolean individualCashRemains = ProfileHelper.isIndividualCashRemains((EntityReference)worklog.getSalesPoint());
            this.log.info(String.format("handle worklog of %s (%s) -> individualCashRemains -> %s", worklog.getEmployee(), worklog.getUid(), String.valueOf(individualCashRemains)));
            EntityContainer recentWorklogContainer = EntityStorage.get().resolve(individualCashRemains ? this.getRecentEmployeeWorklog((EntityReference<Person>)worklog.getEmployee(), date) : this.getRecentAgentWorklog((EntityReference<CashRegisterWorkplace>)worklog.getCashRegisterWorkplace(), date));
            Worklog recentWorklog = recentWorklogContainer != null ? (Worklog)recentWorklogContainer.getEntity() : null;
            this.log.info(String.format("handle worklog of %s (%s) -> recentWorklog -> \n\n%s", worklog.getEmployee(), worklog.getUid(), recentWorklog != null ? DebugUtil.decorate((String)WorklogHelper.toString((Worklog)recentWorklog), null, (String)"recentWorklog", (boolean)true) : "not found"));
            this.log.info(String.format("handle worklog of %s (%s) -> creating transactions", worklog.getEmployee(), worklog.getUid()));
            TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REMAINS_AGENT_STASH, (EntityReference)worklog.getAgency()).date(date).amount(SystemHelper.getMoney((BigDecimal)MiscUtil.negate((BigDecimal)factualAmount), (String)DictHelper.getLocalCurrency2())).description("\u041f\u0440\u0438\u043d\u044f\u0442\u0438\u0435 \u043e\u0441\u0442\u0430\u0442\u043a\u0430").creditDimensionData().paymentType(PaymentType.CASH).salesPoint(worklog.getSalesPoint()).agent(worklog.getEmployee()).cash(worklog.getCash()).cashRegister(worklog.getCashRegister()).cashRegisterWorkplace(worklog.getCashRegisterWorkplace()).end().debitDimensionData().paymentType(PaymentType.CASH).salesPoint(recentWorklog != null ? recentWorklog.getSalesPoint() : null).agent(worklog.getEmployee()).cash(recentWorklog != null ? recentWorklog.getCash() : null).cashRegister(recentWorklog != null ? recentWorklog.getCashRegister() : null).cashRegisterWorkplace((EntityReference)(recentWorklog != null ? recentWorklog.getCashRegisterWorkplace() : (!individualCashRemains ? worklog.getCashRegisterWorkplace() : null))).end().build();
            HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
            data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
            IntegrationBusFacade.get().processRouteSync("finance:create-custom-transaction", data);
            this.log.info(String.format("handle worklog of %s (%s) -> transactions -> \n\n%s", worklog.getEmployee(), worklog.getUid(), DebugUtil.decorate((Iterable)((TransactionsComparisonResult)data.get(IBusFinanceContextKeys.TRANSACTIONS_COMPARISON_RESULT.name())).getTransactionsToCreate().stream().map(item -> FinanceIbusHelper.toString((EntityContainer)item, (String)"")).collect(Collectors.toList()), null, (String)"transactions", (boolean)true)));
            BigDecimal remainsDifference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{calculatedAmount, MiscUtil.negate((BigDecimal)factualAmount)});
            this.log.info(String.format("handle worklog of %s (%s) -> remainsDifference -> %s", worklog.getEmployee(), worklog.getUid(), remainsDifference));
            if (remainsDifference != null && remainsDifference.compareTo(BigDecimal.ZERO) != 0) {
                this.log.info(String.format("handle worklog of %s (%s) -> creating correction transactions", worklog.getEmployee(), worklog.getUid()));
                transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REMAINS_CORRECTION_STASH, (EntityReference)worklog.getAgency()).date(date).amount(SystemHelper.getMoney((BigDecimal)MiscUtil.negate((BigDecimal)remainsDifference), (String)DictHelper.getLocalCurrency2())).description("\u041a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u043f\u0440\u0438 \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0438 \u043e\u0441\u0442\u0430\u0442\u043a\u0430").creditDimensionData().paymentType(PaymentType.CASH).salesPoint(recentWorklog != null ? recentWorklog.getSalesPoint() : null).agent((EntityReference)(recentWorklog != null ? recentWorklog.getEmployee() : (individualCashRemains ? worklog.getEmployee() : null))).cash(recentWorklog != null ? recentWorklog.getCash() : null).cashRegister(recentWorklog != null ? recentWorklog.getCashRegister() : null).cashRegisterWorkplace((EntityReference)(recentWorklog != null ? recentWorklog.getCashRegisterWorkplace() : (!individualCashRemains ? worklog.getCashRegisterWorkplace() : null))).end().debitDimensionData().paymentType(PaymentType.CASH).salesPoint(recentWorklog != null ? recentWorklog.getSalesPoint() : null).agent((EntityReference)(recentWorklog != null ? recentWorklog.getEmployee() : (individualCashRemains ? worklog.getEmployee() : null))).cash(recentWorklog != null ? recentWorklog.getCash() : null).cashRegister(recentWorklog != null ? recentWorklog.getCashRegister() : null).cashRegisterWorkplace((EntityReference)(recentWorklog != null ? recentWorklog.getCashRegisterWorkplace() : (!individualCashRemains ? worklog.getCashRegisterWorkplace() : null))).end().build();
                data = new HashMap();
                data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
                IntegrationBusFacade.get().processRouteSync("finance:create-custom-transaction", data);
                this.log.info(String.format("handle worklog of %s (%s) -> correcton transactions -> \n\n%s", worklog.getEmployee(), worklog.getUid(), DebugUtil.decorate((Iterable)((TransactionsComparisonResult)data.get(IBusFinanceContextKeys.TRANSACTIONS_COMPARISON_RESULT.name())).getTransactionsToCreate().stream().map(item -> FinanceIbusHelper.toString((EntityContainer)item, (String)"")).collect(Collectors.toList()), null, (String)"correcton transactions", (boolean)true)));
            }
        }
        catch (Throwable t) {
            this.log.error("failed handle agent worklog", t);
            throw new ServiceException("failed handle agent worklog", t);
        }
    }

    public void handleCashierAccountantWorklog(Worklog worklog, Date date, BigDecimal factualAmount, BigDecimal calculatedAmount) throws ServiceException {
        try {
            EntityContainer recentWorklogContainer = EntityStorage.get().resolve(this.getRecentCashierAccountantWorklog((EntityReference<Cash>)worklog.getCash(), date));
            Worklog recentWorklog = recentWorklogContainer != null ? (Worklog)recentWorklogContainer.getEntity() : null;
            this.log.info(String.format("handle worklog of %s (%s) -> recentWorklog -> \n\n%s", worklog.getEmployee(), worklog.getUid(), recentWorklog != null ? DebugUtil.decorate((String)WorklogHelper.toString((Worklog)recentWorklog), null, (String)"recentWorklog", (boolean)true) : "not found"));
            this.log.info(String.format("handle worklog of %s (%s) -> creating transactions", worklog.getEmployee(), worklog.getUid()));
            TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_CASH_STASH, (EntityReference)worklog.getAgency()).date(date).amount(SystemHelper.getMoney((BigDecimal)MiscUtil.negate((BigDecimal)factualAmount), (String)DictHelper.getLocalCurrency2())).description("\u041f\u0440\u0438\u043d\u044f\u0442\u0438\u0435 \u043a\u0430\u0441\u0441\u044b").creditDimensionData().paymentType(PaymentType.CASH).salesPoint(worklog.getSalesPoint()).agent(worklog.getEmployee()).cash(worklog.getCash()).cashRegister(worklog.getCashRegister()).cashRegisterWorkplace(worklog.getCashRegisterWorkplace()).end().debitDimensionData().paymentType(PaymentType.CASH).salesPoint(recentWorklog != null ? recentWorklog.getSalesPoint() : null).agent(recentWorklog != null ? recentWorklog.getEmployee() : null).cash(recentWorklog != null ? recentWorklog.getCash() : null).cashRegister(recentWorklog != null ? recentWorklog.getCashRegister() : null).cashRegisterWorkplace(recentWorklog != null ? recentWorklog.getCashRegisterWorkplace() : null).end().build();
            HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
            data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
            IntegrationBusFacade.get().processRouteSync("finance:create-custom-transaction", data);
            this.log.info(String.format("handle worklog of %s (%s) -> transactions -> \n\n%s", worklog.getEmployee(), worklog.getUid(), DebugUtil.decorate((Iterable)((TransactionsComparisonResult)data.get(IBusFinanceContextKeys.TRANSACTIONS_COMPARISON_RESULT.name())).getTransactionsToCreate().stream().map(item -> FinanceIbusHelper.toString((EntityContainer)item, (String)"")).collect(Collectors.toList()), null, (String)"transactions", (boolean)true)));
            BigDecimal remainsDifference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{calculatedAmount, MiscUtil.negate((BigDecimal)factualAmount)});
            this.log.info(String.format("handle worklog of %s (%s) -> remainsDifference -> %s", worklog.getEmployee(), worklog.getUid(), remainsDifference));
            if (remainsDifference != null && remainsDifference.compareTo(BigDecimal.ZERO) != 0) {
                this.log.info(String.format("handle worklog of %s (%s) -> creating correction transactions", worklog.getEmployee(), worklog.getUid()));
                transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_CORRECTION_CASH_STASH, (EntityReference)worklog.getAgency()).date(date).amount(SystemHelper.getMoney((BigDecimal)MiscUtil.negate((BigDecimal)remainsDifference), (String)DictHelper.getLocalCurrency2())).description("\u041a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u043f\u0440\u0438 \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0438 \u043a\u0430\u0441\u0441\u044b").creditDimensionData().paymentType(PaymentType.CASH).salesPoint(recentWorklog != null ? recentWorklog.getSalesPoint() : null).agent(recentWorklog != null ? recentWorklog.getEmployee() : null).cash(recentWorklog != null ? recentWorklog.getCash() : null).cashRegister(recentWorklog != null ? recentWorklog.getCashRegister() : null).cashRegisterWorkplace(recentWorklog != null ? recentWorklog.getCashRegisterWorkplace() : null).end().debitDimensionData().paymentType(PaymentType.CASH).salesPoint(recentWorklog != null ? recentWorklog.getSalesPoint() : null).agent(recentWorklog != null ? recentWorklog.getEmployee() : null).cash(recentWorklog != null ? recentWorklog.getCash() : null).cashRegister(recentWorklog != null ? recentWorklog.getCashRegister() : null).cashRegisterWorkplace(recentWorklog != null ? recentWorklog.getCashRegisterWorkplace() : null).end().build();
                data = new HashMap();
                data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
                IntegrationBusFacade.get().processRouteSync("finance:create-custom-transaction", data);
                this.log.info(String.format("handle worklog of %s (%s) -> correcton transactions -> \n\n%s", worklog.getEmployee(), worklog.getUid(), DebugUtil.decorate((Iterable)((TransactionsComparisonResult)data.get(IBusFinanceContextKeys.TRANSACTIONS_COMPARISON_RESULT.name())).getTransactionsToCreate().stream().map(item -> FinanceIbusHelper.toString((EntityContainer)item, (String)"")).collect(Collectors.toList()), null, (String)"correcton transactions", (boolean)true)));
            }
        }
        catch (Throwable t) {
            this.log.error("failed handle cashier accountant worklog", t);
            throw new ServiceException("failed handle cashier accountant worklog", t);
        }
    }

    private EntityReference<Worklog> getRecentCashierAccountantWorklog(EntityReference<Cash> cash, Date date) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.cash.name(), cash));
        query.getCriteria().getCriterions().add(SearchCriterion.lt((String)WorklogIndex.Property.endDate.name(), (Object)date));
        query.getCriteria().getOrders().put(WorklogIndex.Property.endDate.name(), SortOrder.DESC);
        List indexes = EntityStorage.get().search(WorklogIndex.class, query).getData();
        return indexes.size() > 0 ? ((WorklogIndex)indexes.get(0)).getSource() : null;
    }

    public WorklogServiceResult loadDataForDialog(ServiceInvocationContext sic, AgentData agentData, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-loadDataForDialog");
        try {
            this.checkContext(sic);
            try {
                WorklogServiceResult result = new WorklogServiceResult();
                List listPersonType = result.getListPersonType();
                EntityReference personRef = agentData.getAgent();
                EntityContainer personCtr = EntityStorage.get().resolve(personRef);
                listPersonType.addAll(new ArrayList(((Person)personCtr.getEntity()).getTypes()));
                List listAgency = result.getListAgency();
                listAgency.addAll(this.getAgencyFromPerson((EntityContainer<Person>)personCtr, date));
                HashSet<EntityReference<SalesPoint>> allSalesPoint = new HashSet<EntityReference<SalesPoint>>();
                for (EntityReference entityReference : listAgency) {
                    this.loadSalesPoint((EntityReference<Organization>)entityReference, (EntityContainer<Person>)personCtr, allSalesPoint, result, date);
                    this.loadCashFromAgency((EntityReference<Organization>)entityReference, result);
                }
                for (EntityReference entityReference : allSalesPoint) {
                    this.loadCashFromSalesPoint((EntityReference<SalesPoint>)entityReference, result);
                    this.loadCashRegisterFromSalesPoint((EntityReference<SalesPoint>)entityReference, result);
                    this.loadCashRegisterWorkplaceFromSalesPoint((EntityReference<SalesPoint>)entityReference, result);
                }
                WorklogServiceResult worklogServiceResult = result;
                return worklogServiceResult;
            }
            catch (Throwable t) {
                this.log.error("failed load worklog data for dialog", t);
                throw new ServiceException("failed load worklog data for dialog", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private void loadCashRegisterWorkplaceFromSalesPoint(EntityReference<SalesPoint> salesPoint, WorklogServiceResult result) {
        ArrayList<EntityReference> cashRegisterWorkplaceReferences = new ArrayList<EntityReference>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        criterions.add(SearchCriterion.eq((String)CashRegisterWorkplaceIndex.Property.salesPoint.name(), salesPoint));
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        List cashRegisterWorkplaceIndexes = EntityStorage.get().search(CashRegisterWorkplaceIndex.class, searchQuery).getData();
        for (CashRegisterWorkplaceIndex cashRegisterWorkplaceIndex : cashRegisterWorkplaceIndexes) {
            cashRegisterWorkplaceReferences.add(cashRegisterWorkplaceIndex.getSource());
        }
        result.getMapSalesPointToCashRegisterWorkplace().put(salesPoint, cashRegisterWorkplaceReferences);
    }

    private void loadCashRegisterFromSalesPoint(EntityReference<SalesPoint> salesPoint, WorklogServiceResult result) {
        ArrayList<EntityReference> cashRegisterReferences = new ArrayList<EntityReference>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        criterions.add(SearchCriterion.eq((String)CashRegisterIndex.Property.salesPoint.name(), salesPoint));
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        List cashRegisterIndexes = EntityStorage.get().search(CashRegisterIndex.class, searchQuery).getData();
        for (CashRegisterIndex cashRegisterIndex : cashRegisterIndexes) {
            cashRegisterReferences.add(cashRegisterIndex.getSource());
        }
        result.getMapSalesPointToCashRegister().put(salesPoint, cashRegisterReferences);
    }

    private void loadCashFromSalesPoint(EntityReference<SalesPoint> salesPoint, WorklogServiceResult result) {
        ArrayList<EntityReference> cashReferences = new ArrayList<EntityReference>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        criterions.add(SearchCriterion.eq((String)CashIndex.Property.owner.name(), salesPoint));
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        List cashIndexes = EntityStorage.get().search(CashIndex.class, searchQuery).getData();
        for (CashIndex cashIndex : cashIndexes) {
            cashReferences.add(cashIndex.getSource());
        }
        result.getMapSalesPointToCash().put(salesPoint, cashReferences);
    }

    private void loadCashFromAgency(EntityReference<Organization> agencyRef, WorklogServiceResult result) {
        ArrayList<EntityReference> cashReferences = new ArrayList<EntityReference>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        criterions.add(SearchCriterion.eq((String)CashIndex.Property.owner.name(), agencyRef));
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        List cashIndexes = EntityStorage.get().search(CashIndex.class, searchQuery).getData();
        for (CashIndex cashIndex : cashIndexes) {
            cashReferences.add(cashIndex.getSource());
        }
        result.getMapAgencyToCash().put(agencyRef, cashReferences);
    }

    private void loadSalesPoint(EntityReference<Organization> agencyRef, EntityContainer<Person> personCtr, Set<EntityReference<SalesPoint>> salesPointsDest, WorklogServiceResult result, Date date) {
        ArrayList<Object> salesPoints = new ArrayList<Object>();
        for (PlaceOfSales placeOfSale : ((Person)personCtr.getEntity()).getSalesPoints()) {
            EntityReference salesPointReference;
            if (placeOfSale.getSalesPoint() == null || !SalesPoint.class.equals((Object)placeOfSale.getSalesPoint().getType()) || !MiscUtil.isBetween((Date)placeOfSale.getOpened(), (Date)placeOfSale.getClosed(), (Date)date) || salesPoints.contains(salesPointReference = placeOfSale.getSalesPoint())) continue;
            salesPoints.add(salesPointReference);
        }
        if (salesPoints.size() == 0) {
            salesPoints.addAll(this.getOrganizationSalesPoints(agencyRef));
        } else {
            salesPoints.retainAll(this.getOrganizationSalesPoints(agencyRef));
        }
        salesPointsDest.addAll(salesPoints);
        result.getMapAgencyToSalesPoint().put(agencyRef, salesPoints);
    }

    private Collection<EntityReference<SalesPoint>> getOrganizationSalesPoints(EntityReference<Organization> agency) {
        ArrayList<EntityReference<SalesPoint>> salesPointReferences = new ArrayList<EntityReference<SalesPoint>>();
        SearchQuery searchQuery = new SearchQuery();
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        criterions.add(SearchCriterion.eq((String)SalesPointIndex.Property.agency.name(), agency));
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        List salesPointIndexes = EntityStorage.get().search(SalesPointIndex.class, searchQuery).getData();
        for (SalesPointIndex salesPointIndex : salesPointIndexes) {
            salesPointReferences.add((EntityReference<SalesPoint>)salesPointIndex.getSource());
        }
        return salesPointReferences;
    }

    private Collection<EntityReference<Organization>> getAgencyFromPerson(EntityContainer<Person> personCtr, Date date) {
        ArrayList<EntityReference<Organization>> result = new ArrayList<EntityReference<Organization>>();
        List list = ((Person)personCtr.getEntity()).getEmployments().stream().filter(Objects::nonNull).filter(personEmployment -> Objects.nonNull(personEmployment.getOrganization()) && (Objects.isNull(date) || MiscUtil.isBetween((Date)personEmployment.getOpened(), (Date)personEmployment.getClosed(), (Date)date))).collect(Collectors.toList());
        for (PersonEmployment employment : list) {
            EntityContainer orgCtr = EntityStorage.get().resolve(employment.getOrganization());
            if (orgCtr == null || !((Organization)orgCtr.getEntity()).getTypes().contains(OrganizationType.AGENCY)) continue;
            result.add((EntityReference<Organization>)orgCtr.toReference());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWorklog(ServiceInvocationContext sic, EntityReference<Worklog> refWorklog, Date closeDate, boolean forcedEnd) throws ServiceException {
        block6: {
            DebugUtil.setThreadName((String)"FxWorklogServiceImpl-closeWorklog");
            try {
                this.checkContext(sic);
                try {
                    EntityContainer worklogCtr = EntityStorage.get().resolve(refWorklog);
                    if (worklogCtr != null) {
                        ((Worklog)worklogCtr.getEntity()).setEndDate(closeDate);
                        ((Worklog)worklogCtr.getEntity()).setForcedEnd(forcedEnd);
                        worklogCtr.getVersionInfo().setDataSource("fx-close-worklog");
                        EntityStorage.get().save(worklogCtr, true);
                        break block6;
                    }
                    throw new ServiceException(String.format("EntityContainer<Worklog> is null: %s", refWorklog));
                }
                catch (Throwable t) {
                    this.log.error("failed close worklog ", t);
                    throw new ServiceException("failed close worklog ", t);
                }
            }
            finally {
                DebugUtil.restoreThreadName();
            }
        }
    }

    public EntityReference<Worklog> getCurrentWorklog(ServiceInvocationContext sic) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-getCurrentWorklog");
        try {
            EntityReference employee;
            Date date;
            block8: {
                this.checkContext(sic);
                try {
                    date = new Date();
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)sic.getUser()));
                    query.getPreferredProperties().add(PersonIndex.Property.loginName.name());
                    List list = EntityStorage.get().search(PersonIndex.class, query).getData();
                    employee = null;
                    if (!list.isEmpty()) {
                        employee = ((PersonIndex)list.get(0)).getSource();
                    }
                    if (employee != null) break block8;
                    EntityReference<Worklog> entityReference = null;
                    return entityReference;
                }
                catch (Throwable t) {
                    this.log.error("failed to get worklog for current login ", t);
                    throw new ServiceException("failed to get worklog for current login ", t);
                }
            }
            SearchQuery searchQuery = new SearchQuery();
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)WorklogIndex.Property.employee.name(), (Object)employee));
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.le((String)WorklogIndex.Property.startDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.startDate.name(), null)}));
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)WorklogIndex.Property.endDate.name(), (Object)date), SearchCriterion.eq((String)WorklogIndex.Property.endDate.name(), null)}));
            List worklogIndexes = EntityStorage.get().search(WorklogIndex.class, searchQuery).getData();
            EntityReference entityReference = worklogIndexes.size() > 0 ? ((WorklogIndex)worklogIndexes.get(0)).getSource() : null;
            return entityReference;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityReference<Worklog> getWorklog(ServiceInvocationContext sic, EntityReference<Person> employee, PersonType type, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-getWorklog");
        try {
            this.checkContext(sic);
            EntityReference entityReference = WorklogHelper.getWorklog(employee, (PersonType)type, (Date)date);
            return entityReference;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityReference<Worklog> getAgentWorklog(ServiceInvocationContext sic, EntityReference<CashRegisterWorkplace> cashRegisterWorkplace, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-getAgentWorklog");
        try {
            this.checkContext(sic);
            EntityReference entityReference = WorklogHelper.getAgentWorklog(cashRegisterWorkplace, (Date)date);
            return entityReference;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityReference<Worklog> getCashierClerkWorklog(ServiceInvocationContext sic, EntityReference<CashRegister> cashRegister, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-getCashierClerkWorklog");
        try {
            this.checkContext(sic);
            EntityReference entityReference = WorklogHelper.getCashierClerkWorklog(cashRegister, (Date)date);
            return entityReference;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityReference<Worklog> getCashierAccountantWorklog(ServiceInvocationContext sic, EntityReference<Cash> cash, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-getCashierAccountantWorklog");
        try {
            this.checkContext(sic);
            EntityReference entityReference = WorklogHelper.getCashierAccountantWorklog(cash, (Date)date);
            return entityReference;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContainer<Worklog> loadWorklog(ServiceInvocationContext sic, EntityReference<Person> employee, PersonType type, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-loadWorklog");
        try {
            this.checkContext(sic);
            EntityContainer entityContainer = EntityStorage.get().resolve(this.getWorklog(sic, employee, type, date));
            return entityContainer;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContainer<Worklog> loadAgentWorklog(ServiceInvocationContext sic, EntityReference<CashRegisterWorkplace> cashRegisterWorkplace, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-loadAgentWorklog");
        try {
            this.checkContext(sic);
            EntityContainer entityContainer = EntityStorage.get().resolve(this.getAgentWorklog(sic, cashRegisterWorkplace, date));
            return entityContainer;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContainer<Worklog> loadCashierClerkWorklog(ServiceInvocationContext sic, EntityReference<CashRegister> cashRegister, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-loadCashierClerkWorklog");
        try {
            this.checkContext(sic);
            EntityContainer entityContainer = EntityStorage.get().resolve(this.getCashierClerkWorklog(sic, cashRegister, date));
            return entityContainer;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContainer<Worklog> loadCashierAccountantWorklog(ServiceInvocationContext sic, EntityReference<Cash> cash, Date date) throws ServiceException {
        DebugUtil.setThreadName((String)"FxWorklogServiceImpl-loadCashierAccountantWorklog");
        try {
            this.checkContext(sic);
            EntityContainer entityContainer = EntityStorage.get().resolve(this.getCashierAccountantWorklog(sic, cash, date));
            return entityContainer;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

