/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.uidata.SegmentUIData;
import com.gridnine.xtrip.common.model.booking.uidata.AdditionalServiceProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import com.gridnine.xtrip.server.fx.supplements.helpers.AirProductSupplementHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AdditionalServiceProductSupplementHandler
extends GeneralProductSupplementHandler {
    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof AdditionalServiceProduct).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (AdditionalServiceProduct)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    private AdditionalServiceProductUIData createProductUIData(BookingFile bookingFile, AdditionalServiceProduct product) {
        AdditionalServiceProductUIData uiData = new AdditionalServiceProductUIData();
        uiData.setRelatedProductUID(product.getUid());
        uiData.setSupplier(AdditionalServiceProductHelper.getSupplier((AdditionalServiceProduct)product));
        uiData.setAgency(AdditionalServiceProductHelper.getAgency((AdditionalServiceProduct)product));
        uiData.setSubagency(AdditionalServiceProductHelper.getSubagency((AdditionalServiceProduct)product));
        List<SegmentUIData> segmentUIData = AirProductSupplementHelper.buildSegmentUIData(product.getSegments());
        uiData.getSegmentsUIDataList().addAll(segmentUIData);
        uiData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        uiData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        this.addCommissionsAndFops((BaseProductUIData)uiData, (BaseProduct)product);
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof AdditionalServiceProduct).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof AdditionalServiceProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveProductUIData((AdditionalServiceProduct)modelProducts.get(product.getRelatedProductUID()), (AdditionalServiceProductUIData)product);
            }
        });
    }

    private void saveProductUIData(AdditionalServiceProduct product, AdditionalServiceProductUIData uiData) {
        AdditionalServiceProductHelper.setSupplier((AdditionalServiceProduct)product, (EntityReference)uiData.getSupplier());
        AdditionalServiceProductHelper.setAgency((AdditionalServiceProduct)product, (EntityReference)uiData.getAgency());
        AdditionalServiceProductHelper.setSubagency((AdditionalServiceProduct)product, (EntityReference)uiData.getSubagency());
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }
}

