/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.uidata.AeroexpressTicketUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.helpers.AeroExpressHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AeroExpressSupplementHandler
extends GeneralProductSupplementHandler {
    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof AeroexpressTicket).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (AeroexpressTicket)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    private AeroexpressTicketUIData createProductUIData(BookingFile bookingFile, AeroexpressTicket product) {
        AeroexpressTicketUIData uiData = new AeroexpressTicketUIData();
        uiData.setRelatedProductUID(product.getUid());
        uiData.setSupplier(AeroExpressHelper.getSupplier((AeroexpressTicket)product));
        uiData.setAgency(AeroExpressHelper.getAgency((AeroexpressTicket)product));
        uiData.setSubagency(AeroExpressHelper.getSubagency((AeroexpressTicket)product));
        uiData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        uiData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        this.addCommissionsAndFops((BaseProductUIData)uiData, (BaseProduct)product);
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof AeroexpressTicket).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof AeroexpressTicketUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((AeroexpressTicket)modelProducts.get(product.getRelatedProductUID()), (AeroexpressTicketUIData)product);
            }
        });
    }

    private void saveData(AeroexpressTicket product, AeroexpressTicketUIData uiData) {
        AeroExpressHelper.setAgency((AeroexpressTicket)product, (EntityReference)uiData.getAgency());
        AeroExpressHelper.setSubagency((AeroexpressTicket)product, (EntityReference)uiData.getSubagency());
        AeroExpressHelper.setSupplier((AeroexpressTicket)product, (EntityReference)uiData.getSupplier());
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }
}

