/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.uidata.AgencyMemoProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AgencyMemoProductSupplementHandler
extends GeneralProductSupplementHandler {
    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof AgencyMemoProduct).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (AgencyMemoProduct)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    private AgencyMemoProductUIData createProductUIData(BookingFile bookingFile, AgencyMemoProduct product) {
        AgencyMemoProductUIData uiData = new AgencyMemoProductUIData();
        uiData.setRelatedProductUID(product.getUid());
        uiData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        uiData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        this.addCommissionsAndFops((BaseProductUIData)uiData, (BaseProduct)product);
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof AgencyMemoProduct).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof AgencyMemoProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveProductUIData((AgencyMemoProduct)modelProducts.get(product.getRelatedProductUID()), (AgencyMemoProductUIData)product);
            }
        });
    }

    private void saveProductUIData(AgencyMemoProduct product, AgencyMemoProductUIData uiData) {
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }

    public double getPriority() {
        return 30.0;
    }
}

