/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouch;
import com.gridnine.xtrip.common.model.booking.uidata.AgentTouchProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.handlers.standard.AgentTouchProductHelper;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class AgentTouchProductSupplementHandler
extends GeneralProductSupplementHandler {
    AgentTouchProductSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof AgentTouch).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (AgentTouch)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    private AgentTouchProductUIData createProductUIData(BookingFile bookingFile, AgentTouch product) {
        AgentTouchProductUIData uiData = new AgentTouchProductUIData();
        uiData.setRelatedProductUID(product.getUid());
        uiData.setSupplier(AgentTouchProductHelper.getSupplier((AgentTouch)product));
        uiData.setAgency(AgentTouchProductHelper.getAgency((AgentTouch)product));
        uiData.setSubagency(AgentTouchProductHelper.getSubagency((AgentTouch)product));
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        this.addCommissionsAndFops((BaseProductUIData)uiData, (BaseProduct)product);
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof AgentTouch).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof AgentTouchProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((AgentTouch)modelProducts.get(product.getRelatedProductUID()), (AgentTouchProductUIData)product);
            }
        });
    }

    private void saveData(AgentTouch product, AgentTouchProductUIData uiData) {
        AgentTouchProductHelper.setAgency((AgentTouch)product, (EntityReference)uiData.getAgency());
        AgentTouchProductHelper.setSupplier((AgentTouch)product, (EntityReference)uiData.getSupplier());
        AgentTouchProductHelper.setSubagency((AgentTouch)product, (EntityReference)uiData.getSubagency());
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }
}

