/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TchCreditCardAccompanyingDocumentType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.uidata.AirProductUIData;
import com.gridnine.xtrip.common.model.booking.air.uidata.SegmentUIData;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.RoundingMode;
import com.gridnine.xtrip.common.model.booking.commission.RoundingValue;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsDiscountsFeesUIDataHandler;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.FeesUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BaseContractAppendix;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterQuotaReference;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.rate.RateHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import com.gridnine.xtrip.server.fx.supplements.helpers.AirProductSupplementHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirProductSupplementHandler
extends GeneralProductSupplementHandler {
    private static final Logger log = LoggerFactory.getLogger(AirProductSupplementHandler.class);
    private static final String FAKE_BSP_COMMISSION_UID = "fake_bsp";

    AirProductSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(AirProductHelper::isAirProductOrEMDOrBagage).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (Product)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(AirProductHelper::isAirProductOrEMDOrBagage).collect(Collectors.toMap(BaseIdentity::getUid, p -> p));
        supplement.getProducts().forEach(productData -> {
            if (productData instanceof AirProductUIData && modelProducts.containsKey(productData.getRelatedProductUID())) {
                this.saveAirProductData((Product)modelProducts.get(productData.getRelatedProductUID()), (AirProductUIData)productData);
            }
        });
    }

    private AirProductUIData createProductUIData(BookingFile bookingFile, Product product) {
        PassengerType pt;
        AirProductUIData airProductData = new AirProductUIData();
        NestedEntityReference validatorRef = product.getValidatorRef();
        airProductData.setTCHTicket(this.isTCHTicket(product));
        if (validatorRef != null) {
            validatorRef.setCaption(product.getValidatorCode());
        }
        this.addBaseProductFields((BaseProductUIData)airProductData, (BaseProduct)product, bookingFile);
        if (product.getPassengerType() != null && (pt = (PassengerType)DictionaryCache.get().resolveReference(product.getPassengerType())) != null) {
            airProductData.setPassengerType((String)pt.getCodeVariants().get(CodeSystem.IATA.name()));
        }
        this.addAirProductFields(airProductData, product);
        List<SegmentUIData> segmentUIData = this.buildSegmentUIData(product);
        airProductData.getSegmentsUIDataList().addAll(segmentUIData);
        this.addCommissionsAndFops(airProductData, product);
        EntityReference organizationReference = airProductData.getAgency() != null ? airProductData.getAgency() : bookingFile.getAgency();
        EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
        List bankNames = organizationContainer == null ? Collections.emptyList() : ((Organization)organizationContainer.getEntity()).getBankAccounts().stream().map(BankAccount::getBankName).collect(Collectors.toList());
        airProductData.getAgencyBanks().addAll(bankNames);
        airProductData.getOverallDestinations().addAll(AirProductSupplementHelper.buildSegmentsLocations(product));
        this.addContracts((BaseProductUIData)airProductData, (BaseProduct)product);
        return airProductData;
    }

    private boolean isTCHTicket(Product product) {
        if (!AirProductHelper.isTCHTicket((Product)product)) {
            return false;
        }
        List productFops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
        if (productFops.isEmpty()) {
            return false;
        }
        return productFops.stream().anyMatch(pf -> PaymentType.TICKET == pf.getType());
    }

    private void addAirProductFields(AirProductUIData airProductData, Product product) {
        Airline carrier;
        Airline airline;
        EntityContainer entityContainer;
        if (product.getBlankOwnerRef() != null && (entityContainer = EntityStorage.get().resolve(product.getBlankOwnerRef())) != null && ((Organization)entityContainer.getEntity()).getAirline() != null && (airline = (Airline)DictionaryCache.get().resolveReference(((Organization)entityContainer.getEntity()).getAirline())) != null) {
            airProductData.setBlankOwnerAirlineNumber(airline.getAirlineNumber());
            airProductData.setBlankOwnerAirlineCode(airline.getCode());
            if (TextUtil.isBlank((String)airline.getCode()) || airline.getCode().equals("BSP") || airline.getCode().equals("ARC") || !airline.getCode().equals("\u04281")) {
                // empty if block
            }
        }
        if ((carrier = (Airline)DictionaryCache.get().resolveReference(product.getCarrier())) != null) {
            airProductData.setValidatingCarrierAirlineNumber(carrier.getAirlineNumber());
        }
        airProductData.setSupplier(AirProductHelper.getSupplier((Product)product));
        airProductData.setAgency(AirProductHelper.getAgency((Product)product));
        airProductData.setSubagency(AirProductHelper.getSubagency((Product)product));
        airProductData.setTechnicalProvider(AirProductHelper.getTechnicalProvider((Product)product));
        airProductData.setTariffBaseFare(AirProductHelper.getBaseFare((Product)product));
        airProductData.setTariffEquivalentFare(AirProductHelper.getEquivalentFare((Product)product));
        airProductData.setTariffFareRate(this.loadTariffFareRate(product, airProductData.getTariffBaseFare()));
        airProductData.setTariffEquivalentVat(AirProductHelper.calculateTariffEquivalentVat((Product)product));
        airProductData.setTariffEquiveFareCurrency(product.getGdsCurrency() == null ? DictHelper.getEquivCurrency() : product.getGdsCurrency());
        airProductData.setTaxEquivalentAmount(AirProductHelper.calculateTaxesEquivalentAmount((Product)product));
        airProductData.setTaxEquivalentAddCollect(AirProductHelper.calculateTaxesEquivalentAddCollect((Product)product));
        airProductData.setTaxEquivalentVat(AirProductHelper.calculateTaxesVatAmount((Product)product));
        airProductData.setTotalEquivalentAmount(AirProductHelper.calculateTotalEquivalentFare((Product)product));
        airProductData.setTotalAdditionalAmount(AirProductHelper.calculateTotalAdditionalAmount((Product)product));
        airProductData.setTransportationType(this.getAirTicketTransportationTypeTitle(product));
        airProductData.setPenaltyVat(AirProductHelper.getPenaltyVatAmount((Product)product));
        airProductData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        airProductData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        SUBlockCharterAppendix forwardAppendix = this.loadContractAppendix(product.getCharterQuotaBinding().getForwardQuota());
        airProductData.setForwardAppendix(forwardAppendix);
        SUBlockCharterAppendix backwardAppendix = this.loadContractAppendix(product.getCharterQuotaBinding().getBackwardQuota());
        airProductData.setBackwardAppendix(backwardAppendix);
    }

    private SUBlockCharterAppendix loadContractAppendix(SUBlockCharterQuotaReference quotaReference) {
        EntityContainer contractContainer = EntityStorage.get().resolve(quotaReference.getContract());
        if (contractContainer != null) {
            String appendixUid = quotaReference.getAppendixUid();
            Optional<BaseContractAppendix> appendix = ((Contract)contractContainer.getEntity()).getCustomers().stream().flatMap(c -> c.getAppendices().stream()).filter(a -> a.getUid().equals(appendixUid)).findFirst();
            if (appendix.isPresent()) {
                return (SUBlockCharterAppendix)appendix.get();
            }
        }
        return null;
    }

    private List<SegmentUIData> buildSegmentUIData(Product product) {
        return AirProductSupplementHelper.buildSegmentUIData(product.getSegmentTariffs());
    }

    private Double loadTariffFareRate(Product product, Money baseFare) {
        CurrencyRate currencyRate;
        Date date;
        if (baseFare != null && baseFare.getCurrency() != null && (date = AirProductHelper.getCurrencyRateDate((Product)product)) != null && (currencyRate = product.getGdsCurrency() != null ? BookingHelper.findCurrencyRateWithIndirectChecking((String)baseFare.getCurrency(), (String)product.getGdsCurrency(), (Date)date, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)product.getTariffType(), (EntityReference)product.getBlankOwnerRef(), (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product)) : BookingHelper.findCurrencyRateWithIndirectChecking((String)baseFare.getCurrency(), (Date)date, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)product.getTariffType(), (EntityReference)product.getBlankOwnerRef(), (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product))) != null) {
            return currencyRate.getRate();
        }
        return null;
    }

    private void addCommissionsAndFops(AirProductUIData airProductData, Product product) {
        Commission fakeBSPCommission = this.createFakeBSPCommission(product);
        ArrayList<CommissionsDiscountsFeesUIDataHandler> handlers = new ArrayList<CommissionsDiscountsFeesUIDataHandler>();
        List relations = AirProductHelper.getContractRelations((Product)product);
        for (AirProductContractRelationData relation : relations) {
            List<String> commissionsUidList = relation.getFops().stream().flatMap(fop -> ((List)fop.getValue("commissions")).stream()).map(BaseIdentity::getUid).collect(Collectors.toList());
            List<ProductFopUIData> fopData = this.buildProductFopUIDataList((BaseContractRelationData)relation, product.getStatus(), commissionsUidList);
            airProductData.getFopsList().addAll(fopData);
            ContractType contractType = relation.getDescription() != null ? GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) : null;
            boolean isBspTicket = contractType == ContractType.VENDOR && AirProductHelper.isBSPTicket((Product)product);
            this.updateHandlers((BaseProduct)product, handlers, (BaseContractRelationData)relation, relation.getCommissions(), isBspTicket, fakeBSPCommission);
        }
        airProductData.getCommissionDiscountFeeHandlers().addAll(handlers);
    }

    @Override
    List<String> getFopCommissionUids(Fop productFop) {
        List commissions = (List)productFop.getValue("commissions");
        return commissions.stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    @Override
    protected ProductFopUIData buildBaseProductFopUIData(Fop productFop) {
        ProductFopUIData fopUiData = super.buildBaseProductFopUIData(productFop);
        fopUiData.setCategory(AirProductHelper.getProductFopCategory((ProductFop)((ProductFop)productFop)));
        Money amount = (Money)productFop.getValue("amount");
        EntityReference agent = (EntityReference)productFop.getValue("agent");
        Date operationDate = (Date)productFop.getValue("operationDate");
        Boolean refused = (Boolean)productFop.getValue("refused");
        String bankName = (String)productFop.getValue("bankName");
        String relatedTicketNumber = (String)productFop.getValue("relatedTicketNumber");
        PassengerStatus passengerStatus = (PassengerStatus)productFop.getValue("passengerStatus");
        EntityReference payer = (EntityReference)productFop.getValue("payer");
        TchCreditCardAccompanyingDocumentType tchCreditCardAccompanyingDocumentType = (TchCreditCardAccompanyingDocumentType)productFop.getValue("tchCCAccompanyingDocumentType");
        fopUiData.setAmount(amount == null ? null : amount.getValue());
        fopUiData.setCurrency(amount == null ? null : amount.getCurrency());
        fopUiData.setAgent(agent);
        fopUiData.setOperationDate(operationDate);
        fopUiData.setRefused(refused.booleanValue());
        fopUiData.setBankName(bankName);
        fopUiData.setNumber(relatedTicketNumber);
        fopUiData.setPassengerStatus(passengerStatus);
        fopUiData.setPayer(payer);
        fopUiData.setTchCCAccompanyingDocumentType(tchCreditCardAccompanyingDocumentType);
        return fopUiData;
    }

    private void saveAirProductData(Product product, AirProductUIData productData) {
        AirProductHelper.setSupplier((Product)product, (EntityReference)productData.getSupplier());
        AirProductHelper.setAgency((Product)product, (EntityReference)productData.getAgency());
        AirProductHelper.setSubagency((Product)product, (EntityReference)productData.getSubagency());
        AirProductHelper.setTechnicalProvider((Product)product, (EntityReference)productData.getTechnicalProvider());
        this.setAirProductFields(product, productData);
        AirProductHelper.setBaseFare((Product)product, (Money)productData.getTariffBaseFare());
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)productData.getTariffEquivalentFare());
        this.setAirProductRelations(product, productData.getFopsList(), productData.getCommissionDiscountFeeHandlers());
        this.saveContracts((BaseProduct)product, (BaseProductUIData)productData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)productData);
    }

    private void setAirProductFields(Product product, AirProductUIData productData) {
        Airline carrier = (Airline)DictionaryCache.get().resolveReference(product.getCarrier());
        if (carrier != null) {
            product.setCarrierNumber(carrier.getAirlineNumber());
        } else if (product.getCarrier() == null) {
            product.setCarrierNumber(null);
        }
        EntityContainer blankOwner = EntityStorage.get().resolve(product.getBlankOwnerRef());
        if (blankOwner != null) {
            Airline blankOwnerAirline = (Airline)DictionaryCache.get().resolveReference(((Organization)blankOwner.getEntity()).getAirline());
            if (blankOwnerAirline != null) {
                product.setBlankOwnerNumber(blankOwnerAirline.getAirlineNumber());
            } else {
                product.setBlankOwnerNumber(null);
            }
        } else if (product.getBlankOwnerRef() == null) {
            product.setBlankOwnerNumber(null);
        }
    }

    private void setAirProductRelations(Product product, List<ProductFopUIData> allUiFops, List<CommissionsDiscountsFeesUIDataHandler> commissionHandlers) {
        List relations = AirProductHelper.getContractRelations((Product)product);
        for (AirProductContractRelationData relation : relations) {
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
            ArrayList bspCommissions = new ArrayList();
            if (contractType == ContractType.VENDOR && AirProductHelper.isBSPTicket((Product)product)) {
                bspCommissions.addAll(GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.commissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null));
                bspCommissions.addAll(GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.discountPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null));
                this.updateBspCommission(product, commissionHandlers);
            }
            List<Commission> relationCommissions = this.getCommissionsFromHandlers(commissionHandlers, relation.getCommissions(), contractType);
            relation.getCommissions().clear();
            relation.getCommissions().addAll(bspCommissions);
            relation.getCommissions().addAll(relationCommissions);
            List<ProductFop> relationFops = this.toProductFops(relation.getFops(), this.filterFops(allUiFops, contractType), relation.getCommissions());
            relation.getFops().clear();
            relation.getFops().addAll(relationFops);
        }
    }

    private void updateBspCommission(Product product, List<CommissionsDiscountsFeesUIDataHandler> commissionHandlers) {
        List fakeBspCommissions = commissionHandlers.stream().flatMap(h -> h.getCommissions().stream()).filter(c -> FAKE_BSP_COMMISSION_UID.equals(c.getUid())).collect(Collectors.toList());
        if (!fakeBspCommissions.isEmpty()) {
            CommissionsUIData fakeBsp = (CommissionsUIData)fakeBspCommissions.get(0);
            product.setBspCommissionRate(fakeBsp.getRate());
            if (fakeBsp.getAmount() != null && fakeBsp.getCurrency() != null) {
                Money money = product.getBspCommissionValue() != null ? product.getBspCommissionValue() : new Money();
                money.setValue(fakeBsp.getAmount());
                money.setCurrency(fakeBsp.getCurrency());
                product.setBspCommissionValue(money);
            } else if (fakeBsp.getEquivalentAmount() != null) {
                Money money = new Money();
                money.setValue(fakeBsp.getEquivalentAmount());
                if (product.getGdsCurrency() != null) {
                    money.setCurrency(product.getGdsCurrency());
                }
                product.setBspCommissionValue(money);
            }
        }
    }

    private List<ProductFopUIData> filterFops(List<ProductFopUIData> allFops, ContractType contractType) {
        return allFops.stream().filter(fop -> fop.getContractType() == contractType).collect(Collectors.toList());
    }

    private List<Commission> getCommissionsFromHandlers(List<CommissionsDiscountsFeesUIDataHandler> commissionHandlers, List<Commission> relationCommissions, ContractType contractType) {
        Money money;
        Commission commission;
        ArrayList<Commission> commissions = new ArrayList<Commission>();
        Map<String, Commission> oldCommissions = relationCommissions.stream().collect(Collectors.toMap(BaseIdentity::getUid, c -> c, (oldCommission, newCommission) -> newCommission));
        List uiCommissions = commissionHandlers.stream().filter(h -> h.getContractType() == contractType).flatMap(h -> h.getCommissions().stream()).collect(Collectors.toList());
        List uiFees = commissionHandlers.stream().filter(h -> h.getContractType() == contractType).flatMap(h -> h.getFees().stream()).collect(Collectors.toList());
        for (CommissionsUIData uiCommission : uiCommissions) {
            if (FAKE_BSP_COMMISSION_UID.equals(uiCommission.getUid())) continue;
            commission = oldCommissions.get(uiCommission.getUid());
            if (commission == null) {
                commission = new Commission();
            }
            commission.setContractType(contractType);
            commission.setSegmentTariff(uiCommission.getSegmentTariff());
            if (uiCommission.getAmount() != null) {
                money = new Money();
                money.setValue(uiCommission.getAmount());
                money.setCurrency(uiCommission.getCurrency());
                commission.setAmount(money);
                commission.setRate(null);
            } else {
                commission.setAmount(null);
                commission.setRate(uiCommission.getRate());
            }
            commission.setEquivalentAmount(uiCommission.getEquivalentAmount());
            commission.setCommissionProperties(uiCommission.getCommissionProperty());
            commissions.add(commission);
        }
        for (FeesUIData uiFee : uiFees) {
            commission = oldCommissions.get(uiFee.getUid());
            if (commission == null) {
                commission = new Commission();
            }
            commission.setContractType(contractType);
            commission.setSegmentTariff(uiFee.getSegmentTariff());
            if (uiFee.getAmount() != null) {
                money = new Money();
                money.setValue(uiFee.getAmount());
                money.setCurrency(uiFee.getCurrency());
                commission.setAmount(money);
            }
            commission.setRate(uiFee.getRate());
            commission.setEquivalentAmount(uiFee.getEquivalentAmount());
            commission.setCommissionProperties(uiFee.getFeeProperty());
            commissions.add(commission);
        }
        return commissions;
    }

    private List<ProductFop> toProductFops(List<ProductFop> fops, List<ProductFopUIData> list, List<Commission> allCommissions) {
        Map<String, ProductFop> oldProductFops = fops.stream().collect(Collectors.toMap(BaseIdentity::getUid, fop -> fop));
        ArrayList<ProductFop> updatedFops = new ArrayList<ProductFop>();
        for (ProductFopUIData uiData : list) {
            ProductFop productFop = oldProductFops.get(uiData.getUid());
            if (productFop == null) {
                productFop = new ProductFop();
            }
            productFop.setUid(uiData.getUid());
            if (uiData.getAmount() != null || uiData.getCurrency() != null) {
                Money money = productFop.getAmount();
                if (money == null) {
                    money = new Money();
                }
                money.setValue(uiData.getAmount());
                money.setCurrency(uiData.getCurrency());
                productFop.setAmount(money);
            }
            productFop.setAgent(uiData.getAgent());
            productFop.setBankName(uiData.getBankName());
            productFop.setOperationDate(uiData.getOperationDate());
            productFop.setPassengerStatus(uiData.getPassengerStatus());
            productFop.setPayer(uiData.getPayer());
            productFop.setRefused(uiData.isRefused());
            productFop.setRelatedTicketNumber(uiData.getNumber());
            productFop.setType(uiData.getPaymentType());
            productFop.setTchCCAccompanyingDocumentType(uiData.getTchCCAccompanyingDocumentType());
            Card card = productFop.getCard();
            if (card == null) {
                productFop.setCard(uiData.getCard());
            } else if (uiData.getCard() != null) {
                try {
                    card.copyFrom((BaseEntity)uiData.getCard(), false, new HashMap());
                }
                catch (Exception e) {
                    log.error("unable to copy card", (Throwable)e);
                }
            } else {
                productFop.setCard(null);
            }
            List fopCommissions = allCommissions.stream().filter(c -> uiData.getCommissionUids().contains(c.getUid())).collect(Collectors.toList());
            productFop.getCommissions().clear();
            productFop.getCommissions().addAll(fopCommissions);
            updatedFops.add(productFop);
        }
        return updatedFops;
    }

    private Commission createFakeBSPCommission(Product product) {
        Commission fakeBSPCommission = new Commission();
        fakeBSPCommission.setContractType(ContractType.VENDOR);
        fakeBSPCommission.setUid(FAKE_BSP_COMMISSION_UID);
        fakeBSPCommission.setCommissionProperties(new EntityReference("bsp_commission", CommissionProperties.class, "BSP Commission"));
        fakeBSPCommission.setRate(null);
        fakeBSPCommission.setAmount(null);
        fakeBSPCommission.setEquivalentAmount(null);
        Double rate = product.getBspCommissionRate();
        Money value = product.getBspCommissionValue();
        if (rate != null || value != null && value.getValue() != null && value.getCurrency() != null) {
            if (rate != null) {
                fakeBSPCommission.setRate(rate);
            } else {
                fakeBSPCommission.setAmount(value);
            }
            if (value != null && value.getValue() != null) {
                String eqvCurrencyCode;
                BigDecimal equivalentAmount = value.getValue();
                AirProductContractRelationData vendorContractRelation = AirProductHelper.getVendorContractRelation((Product)product);
                String prefCurrencyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
                String string = eqvCurrencyCode = vendorContractRelation.getGeneralData().getCurrency() == null ? prefCurrencyCode : Optional.ofNullable(vendorContractRelation.getGeneralData().getCurrency()).map(DictionaryReference::getCode).orElse(prefCurrencyCode);
                if (!MiscUtil.equals((Object)value.getCurrency(), (Object)eqvCurrencyCode)) {
                    BigDecimal currencyRate = RateHelper.getCurrencyRate((String)eqvCurrencyCode, (String)value.getCurrency(), (Product)product, (boolean)false, new ArrayList());
                    equivalentAmount = equivalentAmount.multiply(currencyRate);
                    Collection bspCommissions = GeneralProductHelper.filterCommissions((Collection)AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), null, (Set)GeneralProductHelper.bspCommissionTypes, null);
                    if (bspCommissions.size() == 1) {
                        Commission bspCommission = (Commission)bspCommissions.iterator().next();
                        equivalentAmount = RulesHelper.roundDouble((BigDecimal)equivalentAmount, (RoundingMode)bspCommission.getRoundingMode(), (RoundingValue)bspCommission.getRoundingValue());
                    }
                }
                fakeBSPCommission.setEquivalentAmount(equivalentAmount);
            }
        }
        return fakeBSPCommission;
    }

    private TransportationType getAirTicketTransportationTypeTitle(Product product) {
        TransportationType type = AirProductHelper.getTransportationType((Product)product);
        if (type == null) {
            return TransportationType.NONE;
        }
        return type;
    }
}

