/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.fx.standard.helpers.FxProductsHelper;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.DetailsPriceUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.helpers.ProductStatusHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandlersRegistry;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class BookingFileSupplementHandler
extends GeneralProductSupplementHandler {
    BookingFileSupplementHandler() {
    }

    public double getPriority() {
        return 0.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        supplement.setSubagency(BookingHelper.getSubagency((BookingFile)((BookingFile)ctr.getEntity())));
        supplement.setAgentPhonesIsEmpty(SabrePassiveSegmentsUtil.getAgentPhones((BookingFile)((BookingFile)ctr.getEntity())).isEmpty());
        List list = supplement.getDetailsPriceUIData();
        list.clear();
        list.addAll(this.getDetailsPrice((BookingFile)ctr.getEntity()));
        Map resIsCreatedByClientMap = supplement.getResIsCreatedByClient();
        resIsCreatedByClientMap.clear();
        resIsCreatedByClientMap.putAll(this.getResIsCreatedByClientMap(ctr));
        BigDecimal total = BookingHelper.getTotalPrice((BookingFile)((BookingFile)ctr.getEntity()), (ContractType)ContractType.CLIENT);
        BigDecimal paid = BigDecimal.ZERO;
        for (Reservation reservation : ((BookingFile)ctr.getEntity()).getReservations()) {
            for (BaseProduct product : reservation.getProducts()) {
                ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
                ProductStatus status = handler.getStatus(product);
                List contractRelations = handler.getUnmodifiableContractRelations(product);
                for (GeneralProductContractRelationData contractRelation : contractRelations) {
                    ContractType contractType;
                    if (contractRelation.getDescription() == null || (contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())) != ContractType.CLIENT) continue;
                    for (GeneralProductFop fop : contractRelation.getFops()) {
                        if (fop.getOperationDate() == null || fop.isRefused()) continue;
                        paid = MiscUtil.sum((BigDecimal[])new BigDecimal[]{paid, ProductStatusHelper.get().negatesPrice(status) ? MiscUtil.negate((BigDecimal)fop.getEquivalentAmount()) : fop.getEquivalentAmount()});
                    }
                }
            }
        }
        supplement.setTotal(FinanceHelper.round((BigDecimal)total));
        supplement.setPaid(FinanceHelper.round((BigDecimal)paid));
        supplement.setHoldAmount(FinanceHelper.round((BigDecimal)this.getHoldAmount(ctr)));
        supplement.setHasNonStandardPayer(this.isHasNonStandardPayer((BookingFile)ctr.getEntity()));
        supplement.setHasRelatedShipment(BookingHelper.getProducts((BookingFile)((BookingFile)ctr.getEntity())).stream().anyMatch(ShipmentHelper::hasRelatedShipment));
    }

    private boolean isHasNonStandardPayer(BookingFile bookingFile) {
        return bookingFile.getReservations().stream().flatMap(it -> it.getProducts().stream()).flatMap(it -> GeneralProductHelper.getClientFops((BaseProduct)it).stream()).anyMatch(it -> it.getPayer() != null && bookingFile.getCustomerProfile() != null && !MiscUtil.equals((Object)it.getPayer(), (Object)bookingFile.getCustomerProfile()));
    }

    private Map<String, Boolean> getResIsCreatedByClientMap(EntityContainer<BookingFile> ctr) {
        return ((BookingFile)ctr.getEntity()).getReservations().stream().distinct().collect(Collectors.toMap(BaseIdentity::getUid, BookingHelper::isCreatedByClient));
    }

    private List<DetailsPriceUIData> getDetailsPrice(BookingFile model) {
        ArrayList<DetailsPriceUIData> result = new ArrayList<DetailsPriceUIData>();
        EnumSet<PaymentType> paymentTypesToPay = EnumSet.allOf(PaymentType.class);
        paymentTypesToPay.remove(PaymentType.TICKET);
        paymentTypesToPay.remove(PaymentType.VOUCHER);
        ProductStatusHelper statusHelper = ProductStatusHelper.get();
        Map productsWithNames = FxProductsHelper.collectProductsWithNames((BookingFile)model);
        for (Map.Entry entry : productsWithNames.entrySet()) {
            BaseProduct product = (BaseProduct)entry.getKey();
            String name = ((String)entry.getValue()).trim();
            BigDecimal price = null;
            BigDecimal fee = null;
            BigDecimal discount = null;
            BigDecimal total = null;
            BigDecimal pay = null;
            ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)product);
            if (!ProductStatusHandler.getAllVoidStatuses().contains(status)) {
                price = GeneralProductHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT).getTotal();
                if (statusHelper.productHelperNegatesPrice(status)) {
                    price = MiscUtil.negate((BigDecimal)price);
                }
                fee = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getClientCommissions((BaseProduct)product), (Set)GeneralProductHelper.feePropertyTypes, null, null));
                discount = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)GeneralProductHelper.getClientCommissions((BaseProduct)product), (Set)GeneralProductHelper.discountPropertyTypes, null, null)).negate();
                total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{price, fee, discount});
                BigDecimal bigDecimal = pay = status != ProductStatus.EXCHANGE ? GeneralProductHelper.calculateFopsEquivalentValue((Collection)GeneralProductHelper.filterFops((Collection)GeneralProductHelper.getClientFops((BaseProduct)product), null, paymentTypesToPay, null)) : BigDecimal.ZERO;
            }
            if (statusHelper.negatesPrice(status)) {
                price = MiscUtil.negate((BigDecimal)price);
                fee = MiscUtil.negate(fee);
                discount = MiscUtil.negate(discount);
                total = MiscUtil.negate(total);
                pay = MiscUtil.negate(pay);
            }
            price = MiscUtil.nonNull((BigDecimal)price);
            fee = MiscUtil.nonNull(fee);
            discount = MiscUtil.nonNull(discount);
            total = MiscUtil.nonNull(total);
            pay = MiscUtil.nonNull(pay);
            DetailsPriceUIData item = new DetailsPriceUIData();
            item.setName(name);
            item.setPrice(price);
            item.setFee(fee);
            item.setDiscount(discount);
            item.setTotal(total);
            item.setPay(pay);
            item.setUidProduct(product.getUid());
            result.add(item);
        }
        return result;
    }

    private BigDecimal getHoldAmount(EntityContainer<BookingFile> ctr) {
        BigDecimal holdAmount = BigDecimal.ZERO;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.bookingUid.name(), (Object)ctr.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
        List indices = EntityStorage.get().search(TransactionSplitIndex.class, query).getData();
        List<ChartOfAccountsElementType> holdTypes = Arrays.asList(ChartOfAccountsElementType.SUPPLIER_HOLD_PAYMENT, ChartOfAccountsElementType.SUPPLIER_HOLD_SERVICE);
        for (TransactionSplitIndex index : indices) {
            EntityContainer accountContainer = EntityStorage.get().load(ChartOfAccountsElement.class, index.getAccountUid());
            if (accountContainer == null || !holdTypes.contains(((ChartOfAccountsElement)accountContainer.getEntity()).getType())) continue;
            holdAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{holdAmount, index.isCredit() ? MiscUtil.negate((BigDecimal)ModelHelper.long2BigDecimal((long)index.getAmount())) : ModelHelper.long2BigDecimal((long)index.getAmount())});
        }
        return holdAmount;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        EntityReference subagency = supplement.getSubagency();
        ((BookingFile)ctr.getEntity()).getReservations().stream().peek(reservation -> reservation.setSubagency(subagency)).flatMap(reservation -> reservation.getProducts().stream()).forEach(baseProduct -> {
            ProductFXHandler<BaseProduct> handler = ProductFXHandlersRegistry.get().getForProduct((BaseProduct)baseProduct);
            if (handler != null) {
                handler.setSubAgency((BaseProduct)baseProduct, (EntityReference<Organization>)subagency);
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("server FX handler not found for product of type " + baseProduct.getClass().getName());
            }
        });
    }
}

