/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductHelper;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CarRentalProductUIData;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CarRentalProductSupplementHandler
extends GeneralProductSupplementHandler {
    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof CarRentalProduct).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (CarRentalProduct)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    private CarRentalProductUIData createProductUIData(BookingFile bookingFile, CarRentalProduct product) {
        CarRentalProductUIData uiData = new CarRentalProductUIData();
        uiData.setRelatedProductUID(product.getUid());
        uiData.setSupplier(CarRentalProductHelper.getSupplier((CarRentalProduct)product));
        uiData.setAgency(CarRentalProductHelper.getAgency((CarRentalProduct)product));
        uiData.setSubagency(CarRentalProductHelper.getSubagency((CarRentalProduct)product));
        uiData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        uiData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        DictionaryReference startLocation = product.getStartLocation();
        GeoLocation startLocationCountry = (GeoLocation)DictionaryCache.get().resolveReference(startLocation);
        uiData.setStartLocationCountry(startLocationCountry != null ? startLocationCountry.getCountry() : null);
        DictionaryReference endLocation = product.getEndLocation();
        GeoLocation endLocationCountry = (GeoLocation)DictionaryCache.get().resolveReference(endLocation);
        uiData.setEndLocationCountry(endLocationCountry != null ? endLocationCountry.getCountry() : null);
        this.addCurrencyRatesData(uiData, product);
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        this.addCommissionsAndFops((BaseProductUIData)uiData, (BaseProduct)product);
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    private void addCurrencyRatesData(CarRentalProductUIData uiData, CarRentalProduct product) {
        if (product.getFare() == null || product.getFare().getCurrency() == null || product.getEquivalentFare() == null || product.getEquivalentFare().getCurrency() == null) {
            return;
        }
        String productCurrencyCode = product.getFare().getCurrency();
        String productEqCurrencyCode = product.getEquivalentFare().getCurrency();
        Date productIssueDate = product.getIssueDate();
        CurrencyRate currencyRate = DictHelper.findCurrencyRate((String)productCurrencyCode, (String)productEqCurrencyCode, (Date)productIssueDate, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)TariffType.REGULAR, (EntityReference)product.getBlankOwner(), (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product));
        DictionaryReference currencyRateRef = DictHelper.toReference((BaseDictionary)currencyRate);
        if (currencyRate != null) {
            uiData.setBaseCurrency(currencyRate.getCurrency());
            uiData.setEqCurrency(currencyRate.getBaseCurrency());
            uiData.setRate(Double.valueOf(currencyRate.getRate()));
            uiData.setCurrencyRate(currencyRateRef);
        }
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof CarRentalProduct).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof CarRentalProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveProductUIData((CarRentalProduct)modelProducts.get(product.getRelatedProductUID()), (CarRentalProductUIData)product);
            }
        });
    }

    private void saveProductUIData(CarRentalProduct product, CarRentalProductUIData uiData) {
        CarRentalProductHelper.setAgency((CarRentalProduct)product, (EntityReference)uiData.getAgency());
        CarRentalProductHelper.setSubagency((CarRentalProduct)product, (EntityReference)uiData.getSubagency());
        CarRentalProductHelper.setSupplier((CarRentalProduct)product, (EntityReference)uiData.getSupplier());
        product.setCurrencyRate(uiData.getCurrencyRate());
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }
}

