/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsDiscountsFeesUIDataHandler;
import com.gridnine.xtrip.common.model.booking.uidata.DeliveryUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.MetroStation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

class DeliveryProductSupplementHandler
extends GeneralProductSupplementHandler {
    DeliveryProductSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> product instanceof Delivery).map(prod -> this.createDeliveryUIData((BookingFile)ctr.getEntity(), (Delivery)prod)).collect(Collectors.toCollection(() -> ((BookingFileUIData)supplement).getProducts()));
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof Delivery).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof DeliveryUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((Delivery)modelProducts.get(product.getRelatedProductUID()), (DeliveryUIData)product);
            }
        });
    }

    private DeliveryUIData createDeliveryUIData(BookingFile entity, Delivery product) {
        DeliveryUIData result = new DeliveryUIData();
        result.setRelatedProductUID(product.getUid());
        DictionaryReference metroStationReference = product.getMetroStation();
        MetroStation metroStation = metroStationReference != null ? (MetroStation)DictionaryCache.get().resolveReference(metroStationReference) : null;
        result.setMetroLine(metroStation != null ? metroStation.getLine() : null);
        this.addBaseProductFields((BaseProductUIData)result, (BaseProduct)product, entity);
        this.addCommissionsAndFops(result, product);
        this.addContracts((BaseProductUIData)result, (BaseProduct)product);
        return result;
    }

    private void addCommissionsAndFops(DeliveryUIData result, Delivery product) {
        ProductHandler productHandler = HandlersRegistry.get().findProductHandler(Delivery.class);
        List contractRelations = productHandler.getUnmodifiableContractRelations((BaseProduct)product);
        ArrayList<CommissionsDiscountsFeesUIDataHandler> handlers = new ArrayList<CommissionsDiscountsFeesUIDataHandler>();
        GeneralProductContractRelationData clientRelation = (GeneralProductContractRelationData)contractRelations.get(0);
        List<ProductFopUIData> fopData = this.buildProductFopUIDataList((BaseContractRelationData)clientRelation, DeliveryHelper.getProductStatus((Delivery)product), clientRelation.getCommissions().stream().map(BaseIdentity::getUid).collect(Collectors.toList()));
        result.getFopsList().addAll(fopData);
        this.updateHandlers((BaseProduct)product, handlers, (BaseContractRelationData)clientRelation, clientRelation.getCommissions(), false, null);
        result.getCommissionDiscountFeeHandlers().addAll(handlers);
    }

    @Override
    protected ProductFopUIData buildBaseProductFopUIData(Fop productFop) {
        ProductFopUIData fopUiData = super.buildBaseProductFopUIData(productFop);
        fopUiData.setCategory(this.categoryFor((GeneralProductFop)productFop));
        EntityReference agent = (EntityReference)productFop.getValue("agent");
        Date operationDate = (Date)productFop.getValue("operationDate");
        Boolean refused = (Boolean)productFop.getValue("refused");
        String relatedTicketNumber = (String)productFop.getValue("relatedTicketNumber");
        EntityReference payer = (EntityReference)productFop.getValue("payer");
        fopUiData.setAmount(((GeneralProductFop)productFop).getEquivalentAmount());
        fopUiData.setAgent(agent);
        fopUiData.setOperationDate(operationDate);
        fopUiData.setRefused(refused.booleanValue());
        fopUiData.setNumber(relatedTicketNumber);
        fopUiData.setPayer(payer);
        return fopUiData;
    }

    private void saveData(Delivery product, DeliveryUIData supplement) {
        Map oldCommissions = product.getCommissions().stream().collect(Collectors.toMap(BaseIdentity::getUid, UnaryOperator.identity()));
        product.getClientFops().clear();
        product.getCommissions().clear();
        supplement.getCommissionDiscountFeeHandlers().stream().flatMap(handler -> handler.getCommissions().stream()).map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            BigDecimal amount = uiCommission.getAmount();
            this.convertUiAmount(result, amount, uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setCommissionProperties(uiCommission.getCommissionProperty());
            result.setContractType(ContractType.CLIENT);
            return result;
        }).collect(Collectors.toCollection(() -> ((Delivery)product).getCommissions()));
        supplement.getCommissionDiscountFeeHandlers().stream().flatMap(handler -> handler.getFees().stream()).map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            BigDecimal amount = uiCommission.getAmount();
            this.convertUiAmount(result, amount, uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setContractType(ContractType.CLIENT);
            result.setCommissionProperties(uiCommission.getFeeProperty());
            return result;
        }).collect(Collectors.toCollection(() -> ((Delivery)product).getCommissions()));
        supplement.getFopsList().stream().filter(fop -> fop.getContractType().equals((Object)ContractType.CLIENT)).map(fop -> this.convertUiDataToGeneralFop((ProductFopUIData)fop, product.getCommissions())).collect(Collectors.toCollection(() -> ((Delivery)product).getClientFops()));
        this.saveContracts((BaseProduct)product, (BaseProductUIData)supplement);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)supplement);
    }
}

