/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentUIData;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentUIShipmentData;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FinanceDocumentSupplementHandler
implements SupplementHandler<FinanceDocument, FinanceDocumentUIData> {
    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<FinanceDocument> container, FinanceDocumentUIData supplement) {
        FinanceDocument financeDocument = (FinanceDocument)container.getEntity();
        EntityStorageContext storageContext = new EntityStorageContext();
        List billingItems = FinanceDocumentHelper.getBillingItems((List)financeDocument.getBillingItems(), (EntityStorageContext)storageContext).parallelStream().sorted(MiscUtil.comparator(Arrays.asList(MiscUtil.comparator(item -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getProduct(), (EntityStorageContext)storageContext), (Comparator)FinanceDocumentsHelper.productComparator), MiscUtil.comparator(BillingItem::getServiceType, (Comparator)FinanceDocumentsHelper.serviceTypeComparator), MiscUtil.comparator(item -> item.getFopComponents().stream().map(component -> (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)component, (EntityStorageContext)storageContext)).filter(Objects::nonNull).max(FinanceDocumentsHelper.fopComponentComparator).orElse(null), (Comparator)FinanceDocumentsHelper.fopComponentComparator), MiscUtil.comparator(BillingItem::getName)))).collect(Collectors.toList());
        supplement.getBillingItems().clear();
        supplement.getBillingItems().addAll(billingItems);
        PaymentItemsList paymentItems = new PaymentItemsList();
        financeDocument.getPaymentItems().forEach(payment -> {
            PaymentItem item = (PaymentItem)EntityStorageHelper.resolve((NestedEntityReference)payment, (EntityStorageContext)storageContext);
            if (item != null) {
                paymentItems.getData().add(item);
            }
        });
        supplement.setPaymentItems(paymentItems);
        ArrayList relatedShipments = new ArrayList();
        financeDocument.getRelatedShipments().forEach(shipmentRef -> {
            EntityContainer shipmentCtr = EntityStorageHelper.resolve((EntityReference)shipmentRef, (EntityStorageContext)storageContext);
            if (shipmentCtr != null) {
                Shipment shipmentEntity = (Shipment)shipmentCtr.getEntity();
                FinanceDocumentUIShipmentData shipmentData = new FinanceDocumentUIShipmentData();
                shipmentData.setDate(shipmentEntity.getDate());
                shipmentData.setNumber(shipmentEntity.getNumber());
                shipmentData.setShipmentReference(shipmentRef);
                relatedShipments.add(shipmentData);
            }
        });
        supplement.getRelatedShipments().addAll(relatedShipments);
        for (PaymentItem pi : paymentItems.getData()) {
            financeDocument.getPaymentDocuments().stream().map(EntityStorageHelper::resolve).filter(Objects::nonNull).filter(doc -> ((BasePaymentDocument)doc.getEntity()).getPaymentItems().stream().anyMatch(ref -> TextUtil.equals((String)ref.getNestedEntityUid(), (String)pi.getUid(), (boolean)false))).findFirst().ifPresent(paymentDocument -> supplement.getPaymentItemPaymentDocumentMap().put(pi, paymentDocument.toReference()));
        }
    }

    public Class<FinanceDocument> getEntityClass() {
        return FinanceDocument.class;
    }

    public Class<FinanceDocumentUIData> getSupplementClass() {
        return FinanceDocumentUIData.class;
    }

    public void populateEntity(FinanceDocumentUIData supplement, EntityContainer<FinanceDocument> container) {
        FinanceDocument financeDocument = (FinanceDocument)container.getEntity();
        EntityStorageContext storageContext = new EntityStorageContext();
        Map<String, BillingItem> supplementBillingItemUids = supplement.getBillingItems().stream().collect(Collectors.toMap(BaseIdentity::getUid, item -> item));
        Map billingItemListGroups = FinanceDocumentHelper.getBillingItemsLists((List)financeDocument.getBillingItems(), (EntityStorageContext)storageContext);
        for (Map.Entry entry : billingItemListGroups.entrySet()) {
            EntityContainer billingItemsListContainer = (EntityContainer)entry.getKey();
            Collection billingItems = (Collection)entry.getValue();
            boolean save = false;
            for (BillingItem billingItem2 : billingItems) {
                BillingItem supplementBillingItem = supplementBillingItemUids.get(billingItem2.getUid());
                if (supplementBillingItem == null) continue;
                if (!TextUtil.isSame((String)supplementBillingItem.getName(), (String)billingItem2.getName())) {
                    billingItem2.setName(supplementBillingItem.getName());
                    save = true;
                }
                if (FinanceDocumentsHelper.isPrepayment((FinanceDocumentType)financeDocument.getType()) && billingItems.stream().allMatch(bi -> bi.getProduct() == null)) {
                    if (supplementBillingItem.getPaymentType() != billingItem2.getPaymentType()) {
                        billingItem2.setPaymentType(supplementBillingItem.getPaymentType());
                        save = true;
                    }
                    if (supplementBillingItem.getAmount() != null && !supplementBillingItem.getAmount().equals((Object)billingItem2.getAmount())) {
                        billingItem2.setAmount(supplementBillingItem.getAmount());
                        save = true;
                    }
                }
                supplementBillingItemUids.keySet().removeIf(bi -> bi.equals(billingItem2.getUid()));
            }
            for (String deletedBillingItemUid : supplement.getDeletedBillingItemUids()) {
                save |= ((BillingItemsList)billingItemsListContainer.getEntity()).getData().removeIf(billingItem -> deletedBillingItemUid.equals(billingItem.getUid()));
            }
            if (!save) continue;
            billingItemsListContainer.getVersionInfo().setDataSource("finance-document-save");
            EntityStorage.get().save(billingItemsListContainer, true);
        }
        if (!supplementBillingItemUids.isEmpty()) {
            EntityContainer billingItemsListContainer = (EntityContainer)CollectionUtil.head(billingItemListGroups.keySet());
            if (billingItemsListContainer == null) {
                billingItemsListContainer = EntityContainer.create((BaseEntity)new BillingItemsList());
            }
            ((BillingItemsList)billingItemsListContainer.getEntity()).getData().addAll(supplementBillingItemUids.values());
            for (BillingItem billingItem3 : supplementBillingItemUids.values()) {
                financeDocument.getBillingItems().add(new NestedEntityReference(billingItemsListContainer, (BaseEntity)billingItem3));
            }
            billingItemsListContainer.getVersionInfo().setDataSource("finance-document-save");
            EntityStorage.get().save(billingItemsListContainer, true);
        }
        for (String string : supplement.getDeletedBillingItemUids()) {
            financeDocument.getBillingItems().removeIf(billingItemReference -> deletedBillingItemUid.equals(billingItemReference.getNestedEntityUid()));
        }
    }
}

