/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.booking.VendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsDiscountsFeesUIDataHandler;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.DiscountsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.FeesUIData;
import com.gridnine.xtrip.common.model.booking.uidata.PersonCostCodesUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductContractUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductPrepaymentDocumentUIData;
import com.gridnine.xtrip.common.model.booking.uidata.VendorFinanceDocumentDataUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.ProductFopCategory;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class GeneralProductSupplementHandler
implements SupplementHandler<BookingFile, BookingFileUIData> {
    public Class<BookingFile> getEntityClass() {
        return BookingFile.class;
    }

    public Class<BookingFileUIData> getSupplementClass() {
        return BookingFileUIData.class;
    }

    protected void addBaseProductFields(BaseProductUIData productUiData, BaseProduct product, BookingFile bookingFile) {
        EntityContainer<Organization> customerProfile = this.loadCustomerProfile(bookingFile);
        EntityStorageContext storageContext = new EntityStorageContext();
        EntityContainer subagency = EntityStorageHelper.resolve((EntityReference)GeneralProductHelper.getSubagency((BaseProduct)product), (EntityStorageContext)storageContext);
        EntityContainer agency = EntityStorageHelper.resolve((EntityReference)GeneralProductHelper.getAgency((BaseProduct)product), (EntityStorageContext)storageContext);
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        Date issueDate = handler.findIssueDate(product);
        productUiData.setRelatedProductUID(product.getUid());
        productUiData.setSystemNumber(GeneralProductHelper.getSystemNumber((BaseProduct)product));
        productUiData.setProductTotalPrice(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.CLIENT));
        productUiData.setProductPayPrice(this.calculatePayPrice(product));
        productUiData.getPayersUids().clear();
        Collection<String> agencyPayersUids = BookingFileHelper.getAvailablePayersUids((EntityContainer<Organization>)agency, false);
        productUiData.getPayersUids().put(ContractType.VENDOR, new ArrayList<String>(agencyPayersUids));
        productUiData.getPayersUids().put(ContractType.SUBAGENCY, subagency != null && !subagency.equals((Object)agency) ? new ArrayList<String>(BookingFileHelper.getAvailablePayersUids((EntityContainer<Organization>)subagency, false)) : new ArrayList<String>(agencyPayersUids));
        productUiData.getPayersUids().put(ContractType.CLIENT, new ArrayList<String>(BookingFileHelper.getAvailablePayersUids(customerProfile, true)));
        productUiData.setMediator(GeneralProductHelper.getClientRelationMediator((BaseProduct)product));
        if (customerProfile != null) {
            Stream<Object> propertiesStream = ((Organization)customerProfile.getEntity()).getCostCodeProperties().stream();
            if (issueDate != null) {
                Date date = MiscUtil.clearTime((Date)issueDate);
                propertiesStream = propertiesStream.filter(item -> MiscUtil.isBetween((Date)item.getStartDate(), (Date)item.getEndDate(), (Date)date));
            }
            List propertiesList = propertiesStream.collect(Collectors.toList());
            List costCodes = ((Organization)customerProfile.getEntity()).getCostCodes().stream().filter(cc -> propertiesList.stream().anyMatch(ccp -> ccp.equals((Object)cc.getCostCodeProperties()))).collect(Collectors.toList());
            productUiData.getProfileReasonCodes().clear();
            productUiData.getProfileReasonCodes().addAll(((Organization)customerProfile.getEntity()).getReasonCodes());
            productUiData.getProfileCostCodeProperties().clear();
            productUiData.getProfileCostCodeProperties().addAll(propertiesList);
            productUiData.getProfileCostCodes().clear();
            productUiData.getProfileCostCodes().addAll(costCodes);
            Collection travellers = handler.getTravellers(product);
            for (Traveller traveller : travellers) {
                EntityContainer person = EntityStorage.get().resolve(traveller.getPassenger());
                if (person == null) continue;
                PersonCostCodesUIData personCostCodeUIData = new PersonCostCodesUIData();
                personCostCodeUIData.setTraveller(traveller);
                personCostCodeUIData.getPersonCostCodes().addAll(((Person)person.getEntity()).getCostCodes().stream().filter(cc -> MiscUtil.equals((Object)cc.getOrganization(), (Object)bookingFile.getCustomerProfile())).collect(Collectors.toList()));
                productUiData.getPersonCostCodes().add(personCostCodeUIData);
            }
        }
        productUiData.setHasClientRelatedShipment(ShipmentHelper.hasClientRelatedShipment((BaseProduct)product));
        productUiData.setHasSubagentRelatedShipment(ShipmentHelper.hasSubagentRelatedShipment((BaseProduct)product));
        this.fillProductPrepaymentDocumentUIData(product, productUiData);
        this.fillVendorFinanceDocumentsDataUIData(product, productUiData);
    }

    protected void addCommissionsAndFops(BaseProductUIData uiData, BaseProduct product) {
        ArrayList<CommissionsDiscountsFeesUIDataHandler> handlers = new ArrayList<CommissionsDiscountsFeesUIDataHandler>();
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        List contractRelations = handler.getUnmodifiableContractRelations(product);
        for (GeneralProductContractRelationData relation : contractRelations) {
            List<String> commissionsUidList = relation.getFops().stream().flatMap(fop -> fop.getCommissions().stream()).map(BaseIdentity::getUid).collect(Collectors.toList());
            List<ProductFopUIData> fopData = this.buildProductFopUIDataList(relation, product, commissionsUidList);
            uiData.getFopsList().addAll(fopData);
            this.updateHandlers(product, handlers, (BaseContractRelationData)relation, relation.getCommissions(), false, null);
        }
        uiData.getCommissionDiscountFeeHandlers().addAll(handlers);
    }

    protected List<ProductFopUIData> buildProductFopUIDataList(GeneralProductContractRelationData relation, BaseProduct product, List<String> commissionsUidList) {
        ArrayList<ProductFopUIData> fopUIDataList = new ArrayList<ProductFopUIData>();
        DictionaryReference currencyInfo = relation.getGeneralData().getCurrency();
        String currency = currencyInfo != null ? currencyInfo.getCode() : null;
        EntityContainer contractRelationDescriptionContainer = EntityStorage.get().resolve(relation.getDescription());
        List fops = relation.getFops();
        for (GeneralProductFop productFop : fops) {
            ProductFopUIData fopUiData = this.buildProductFopUIData(product, currency, productFop);
            fopUiData.setContractType(GeneralProductHelper.getContractType((EntityReference)relation.getDescription()));
            if (contractRelationDescriptionContainer != null) {
                fopUiData.setContractTypeName(L10nStringHelper.getValue((L10nString)((ContractRelationDescription)contractRelationDescriptionContainer.getEntity()).getName(), (Locale)LocaleManager.get().getCurrentLocale(), (boolean)false));
            }
            List commissionsUids = commissionsUidList.stream().filter(commissionUid -> this.getFopCommissionUids(productFop).contains(commissionUid)).collect(Collectors.toList());
            fopUiData.getCommissionUids().addAll(commissionsUids);
            fopUIDataList.add(fopUiData);
        }
        return fopUIDataList;
    }

    @Deprecated
    protected List<ProductFopUIData> buildProductFopUIDataList(BaseContractRelationData relation, ProductStatus productStatus, List<String> commissionsUidList) {
        ArrayList<ProductFopUIData> list = new ArrayList<ProductFopUIData>();
        EntityContainer contractRelationDescriptionContainer = EntityStorage.get().resolve(relation.getDescription());
        ContractType contractType = null;
        String contractTypeName = null;
        if (contractRelationDescriptionContainer != null) {
            contractType = relation.getDescription() != null ? GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) : null;
            contractTypeName = L10nStringHelper.getValue((L10nString)((ContractRelationDescription)contractRelationDescriptionContainer.getEntity()).getName(), (Locale)LocaleManager.get().getCurrentLocale(), (boolean)false);
        }
        List fops = (List)relation.getValue("fops");
        for (Fop productFop : fops) {
            ProductFopUIData fopUiData = this.buildBaseProductFopUIData(productFop);
            if (contractRelationDescriptionContainer != null) {
                fopUiData.setContractType(contractType);
                fopUiData.setContractTypeName(contractTypeName);
            }
            commissionsUidList.stream().filter(commissionUid -> this.getFopCommissionUids(productFop).contains(commissionUid)).collect(Collectors.toCollection(() -> ((ProductFopUIData)fopUiData).getCommissionUids()));
            list.add(fopUiData);
        }
        return list;
    }

    private List<String> getFopCommissionUids(GeneralProductFop productFop) {
        return productFop.getCommissions().stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    @Deprecated
    List<String> getFopCommissionUids(Fop productFop) {
        List commissions = (List)productFop.getValue("commissions");
        return commissions.stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    protected ProductFopUIData buildProductFopUIData(BaseProduct product, String currency, GeneralProductFop productFop) {
        ProductFopUIData fopUiData = this.buildBaseProductFopUIData((Fop)productFop);
        fopUiData.setCategory(this.categoryFor(productFop));
        fopUiData.setAmount(productFop.getEquivalentAmount());
        fopUiData.setAgent(productFop.getAgent());
        fopUiData.setOperationDate(productFop.getOperationDate());
        fopUiData.setRefused(productFop.isRefused());
        fopUiData.setNumber(productFop.getRelatedTicketNumber());
        fopUiData.setPayer(productFop.getPayer());
        fopUiData.setCurrency(currency);
        return fopUiData;
    }

    protected ProductFopUIData buildBaseProductFopUIData(Fop productFop) {
        ProductFopUIData fopUiData = new ProductFopUIData();
        fopUiData.setUid(productFop.getUid());
        fopUiData.setPaymentType(productFop.getType());
        fopUiData.setCard(productFop.getCard());
        return fopUiData;
    }

    protected void updateHandlers(BaseProduct baseProduct, List<CommissionsDiscountsFeesUIDataHandler> handlers, BaseContractRelationData relation, List<? extends BaseCommission> relationCommissions, boolean isBspTicket, Commission fakeBspCommission) {
        ContractType contractType = relation.getDescription() != null ? GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) : null;
        ArrayList<Commission> commissions = new ArrayList<Commission>();
        ArrayList discounts = new ArrayList();
        ArrayList fees = new ArrayList();
        commissions.clear();
        commissions.addAll(GeneralProductHelper.filterCommissions(relationCommissions, (Set)GeneralProductHelper.commissionPropertyTypes, null, null));
        discounts.clear();
        discounts.addAll(GeneralProductHelper.filterCommissions(relationCommissions, (Set)GeneralProductHelper.discountPropertyTypes, null, null));
        fees.clear();
        fees.addAll(GeneralProductHelper.filterCommissions(relationCommissions, (Set)GeneralProductHelper.feePropertyTypes, null, null));
        if (isBspTicket) {
            ArrayList bspCommissions = new ArrayList();
            bspCommissions.clear();
            bspCommissions.addAll(GeneralProductHelper.filterCommissions(relationCommissions, (Set)GeneralProductHelper.commissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null));
            commissions.removeAll(bspCommissions);
            commissions.add(fakeBspCommission);
        }
        CommissionsDiscountsFeesUIDataHandler commissionsDiscountsFeesUIDataHandler = new CommissionsDiscountsFeesUIDataHandler();
        commissionsDiscountsFeesUIDataHandler.setUid(relation.getUid());
        commissionsDiscountsFeesUIDataHandler.setContractType(contractType);
        handlers.add(commissionsDiscountsFeesUIDataHandler);
        String equivalentCurrency = Optional.ofNullable(relation.getGeneralData().getCurrency()).map(item -> item.getCode()).orElse(null);
        for (BaseCommission baseCommission : commissions) {
            CommissionsUIData commissionData = new CommissionsUIData();
            commissionData.setUid(baseCommission.getUid());
            if (baseCommission.getAmount() != null) {
                commissionData.setAmount(baseCommission.getAmount().getValue());
                String currency = baseCommission.getAmount().getCurrency();
                commissionData.setCurrency(currency);
                if (currency != null) {
                    commissionData.setCurrencyInfo((DictionaryReference)new CurrencyInfoReference(DictHelper.getCurrencyInfoByAnyCode((String)currency)));
                } else {
                    commissionData.setCurrencyInfo(null);
                }
            }
            commissionData.setRate(baseCommission.getRate());
            commissionData.setCommissionProperty(baseCommission.getCommissionProperties());
            commissionData.setEquivalentAmount(baseCommission.getEquivalentAmount());
            commissionData.setEquivalentCurrency(equivalentCurrency);
            commissionData.setSegmentTariff((SegmentTariff)this.getFieldOrNull((BaseEntity)baseCommission, "segmentTariff"));
            commissionsDiscountsFeesUIDataHandler.getCommissions().add(commissionData);
        }
        for (BaseCommission baseCommission : discounts) {
            DiscountsUIData discountData = new DiscountsUIData();
            discountData.setUid(baseCommission.getUid());
            if (baseCommission.getAmount() != null) {
                discountData.setAmount(Double.valueOf(baseCommission.getAmount().getValue().doubleValue()));
                discountData.setCurrency(baseCommission.getAmount().getCurrency());
                discountData.setCurrencyInfo((DictionaryReference)new CurrencyInfoReference(DictHelper.getCurrencyInfoByAnyCode((String)baseCommission.getAmount().getCurrency())));
            }
            discountData.setRate(baseCommission.getRate());
            discountData.setDiscountProperty(baseCommission.getCommissionProperties());
            discountData.setEquivalentAmount(baseCommission.getEquivalentAmount());
            discountData.setEquivalentCurrency(equivalentCurrency);
            discountData.setSegmentTariff((SegmentTariff)this.getFieldOrNull((BaseEntity)baseCommission, "segmentTariff"));
            commissionsDiscountsFeesUIDataHandler.getDiscounts().add(discountData);
        }
        for (BaseCommission baseCommission : fees) {
            FeesUIData feeData = new FeesUIData();
            feeData.setUid(baseCommission.getUid());
            if (baseCommission.getAmount() != null && baseCommission.getAmount().getValue() != null) {
                feeData.setAmount(baseCommission.getAmount().getValue());
                feeData.setCurrency(baseCommission.getAmount().getCurrency());
                if (baseCommission.getAmount().getCurrency() != null) {
                    feeData.setCurrencyInfo((DictionaryReference)new CurrencyInfoReference(DictHelper.getCurrencyInfoByAnyCode((String)baseCommission.getAmount().getCurrency())));
                }
            }
            feeData.setFeeProperty(baseCommission.getCommissionProperties());
            feeData.setEquivalentAmount(baseCommission.getEquivalentAmount());
            feeData.setEquivalentCurrency(equivalentCurrency);
            feeData.setRate(baseCommission.getRate());
            feeData.setSegmentTariff((SegmentTariff)this.getFieldOrNull((BaseEntity)baseCommission, "segmentTariff"));
            commissionsDiscountsFeesUIDataHandler.getFees().add(feeData);
        }
    }

    protected boolean isHavingErrors(List<ValidationMessage> validationMessages, Identity product) {
        return GeneralProductHelper.filterValidationMessages(this.mixValidationMessages(validationMessages, product), null, (Set)GeneralProductHelper.errorSeverities).size() > 0;
    }

    protected boolean isHavingWarnings(List<ValidationMessage> validationMessages, Identity product) {
        return GeneralProductHelper.filterValidationMessages(this.mixValidationMessages(validationMessages, product), null, Collections.singleton(ValidationMessageSeverity.WARNING)).size() > 0;
    }

    protected void addContracts(BaseProductUIData uiData, BaseProduct product) {
        List contractRelations = GeneralProductHelper.getHandler((BaseProduct)product).getUnmodifiableContractRelations(product);
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            ProductContractUIData contractUIData = this.buildProductContractUIData(contractRelation);
            uiData.getContractsList().add(contractUIData);
            uiData.getContractCurrencies().put(GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()), contractRelation.getGeneralData().getRate());
        }
        uiData.getPaymentCurrencies().clear();
        uiData.getPaymentCurrencies().putAll(product.getPaymentCurrencies());
    }

    private ProductContractUIData buildProductContractUIData(GeneralProductContractRelationData relation) {
        ProductContractUIData contractUIData = new ProductContractUIData();
        contractUIData.setContractType(GeneralProductHelper.getContractType((EntityReference)relation.getDescription()));
        contractUIData.setContract(relation.getGeneralData().getContractData().getContract());
        contractUIData.setManualContract(relation.getGeneralData().getContractData().getManualContract());
        contractUIData.setContractUid(relation.getGeneralData().getContractData().getUid());
        return contractUIData;
    }

    private void fillProductPrepaymentDocumentUIData(BaseProduct product, BaseProductUIData productUIData) {
        productUIData.getPrepaymentDocumentsList().clear();
        EntityStorageContext storageContext = new EntityStorageContext();
        for (EntityReference documentReference : product.getPrepaymentDocuments()) {
            EntityContainer documentContainer = EntityStorage.get().resolve(documentReference);
            if (documentContainer == null) continue;
            ProductPrepaymentDocumentUIData documentUIData = new ProductPrepaymentDocumentUIData();
            documentUIData.setUid(documentContainer.getUid());
            documentUIData.setDocument(documentContainer.toReference());
            EntityContainer contractContainer = EntityStorageHelper.resolve((EntityReference)((FinanceDocument)documentContainer.getEntity()).getContract(), (EntityStorageContext)storageContext);
            if (contractContainer != null) {
                documentUIData.setContractType(((Contract)contractContainer.getEntity()).getContractType());
            }
            documentUIData.setAmount(((FinanceDocument)documentContainer.getEntity()).getBillingItems().stream().map(item -> (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)item, (EntityStorageContext)storageContext)).filter(Objects::nonNull).filter(item -> item.getAmount() != null && item.getProduct() != null && item.getProduct().getNestedEntityUid().equals(product.getUid())).map(item -> item.getAmount().getTotal()).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO));
            productUIData.getPrepaymentDocumentsList().add(documentUIData);
        }
    }

    private void fillVendorFinanceDocumentsDataUIData(BaseProduct product, BaseProductUIData productUIData) {
        productUIData.getVendorFinanceDocumentsDataList().clear();
        for (VendorFinanceDocumentData vendorFinanceDocumentData : product.getVendorFinanceDocumentsData()) {
            VendorFinanceDocumentDataUIData data = new VendorFinanceDocumentDataUIData();
            data.setFinanceDocumentType(vendorFinanceDocumentData.getType());
            data.setNumber(vendorFinanceDocumentData.getNumber());
            data.setDate(vendorFinanceDocumentData.getDate());
            data.setVendorNumber(vendorFinanceDocumentData.getVendorNumber());
            data.setVendorDate(vendorFinanceDocumentData.getVendorDate());
            data.setVendorShippingDocumentNumber(vendorFinanceDocumentData.getVendorShippingDocumentNumber());
            data.setVendorShippingDocumentDate(vendorFinanceDocumentData.getVendorShippingDocumentDate());
            data.setSequenceNumber(vendorFinanceDocumentData.getSequenceNumber());
            productUIData.getVendorFinanceDocumentsDataList().add(data);
        }
    }

    protected void saveContracts(BaseProduct product, BaseProductUIData productUIData) {
        List contractRelations = GeneralProductHelper.getHandler((BaseProduct)product).getUnmodifiableContractRelations(product);
        GeneralProductContractRelationData clientContractRelation = null;
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            this.convertContractsFromUIData(contractRelation, productUIData);
            if (clientContractRelation != null || GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) != ContractType.CLIENT) continue;
            clientContractRelation = contractRelation;
        }
        if (clientContractRelation != null) {
            clientContractRelation.getGeneralData().setMediator(productUIData.getMediator());
        }
        GeneralProductHelper.getHandler((BaseProduct)product).updateContractRelations(product, contractRelations);
        this.savePaymentCurrencies(product, productUIData);
    }

    private void convertContractsFromUIData(GeneralProductContractRelationData contractRelation, BaseProductUIData productUIData) {
        ContractType contractType = GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription());
        ProductContractUIData contractUIData = productUIData.getContractsList().stream().filter(productContractUIData -> productContractUIData.getContractType().equals((Object)contractType)).findFirst().orElse(new ProductContractUIData());
        contractRelation.getGeneralData().getContractData().setContract(contractUIData.getContract());
        contractRelation.getGeneralData().getContractData().setManualContract(contractUIData.getManualContract());
        if (TextUtil.nonBlank((String)contractUIData.getContractUid())) {
            contractRelation.getGeneralData().getContractData().setUid(contractUIData.getContractUid());
        }
    }

    GeneralProductFop convertUiDataToGeneralFop(ProductFopUIData productFopUIData, Collection<GeneralProductCommission> commissions) {
        List fopCommissions = commissions.stream().filter(commission -> productFopUIData.getCommissionUids().contains(commission.getUid())).collect(Collectors.toList());
        GeneralProductFop result = new GeneralProductFop();
        result.setUid(productFopUIData.getUid());
        result.setAgent(productFopUIData.getAgent());
        result.setOperationDate(productFopUIData.getOperationDate());
        result.setPayer(productFopUIData.getPayer());
        result.setRefused(productFopUIData.isRefused());
        result.setType(productFopUIData.getPaymentType());
        result.getCommissions().addAll(fopCommissions);
        result.setEquivalentAmount(productFopUIData.getAmount());
        result.setCard(productFopUIData.getCard());
        return result;
    }

    protected void saveContractRelations(BaseProduct product, BaseProductUIData uiData) {
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        List contractRelations = handler.getUnmodifiableContractRelations(product);
        GeneralProductContractRelationData clientContractRelation = null;
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            this.saveCommissionsAndFeesAndFops(contractRelation, uiData);
            this.convertContractsFromUIData(contractRelation, uiData);
            if (clientContractRelation != null || GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription()) != ContractType.CLIENT) continue;
            clientContractRelation = contractRelation;
        }
        if (clientContractRelation != null) {
            clientContractRelation.getGeneralData().setMediator(uiData.getMediator());
        }
        handler.updateContractRelations(product, contractRelations);
        this.savePaymentCurrencies(product, uiData);
    }

    protected void savePaymentCurrencies(BaseProduct product, BaseProductUIData uiData) {
        product.getPaymentCurrencies().clear();
        product.getPaymentCurrencies().putAll(uiData.getPaymentCurrencies());
    }

    protected void saveVendorFinanceDocumentsData(BaseProduct product, BaseProductUIData productUIData) {
        product.getVendorFinanceDocumentsData().clear();
        productUIData.getVendorFinanceDocumentsDataList().forEach(data -> {
            VendorFinanceDocumentData vendorFinanceDocumentData = new VendorFinanceDocumentData();
            vendorFinanceDocumentData.setType(data.getFinanceDocumentType());
            vendorFinanceDocumentData.setNumber(data.getNumber());
            vendorFinanceDocumentData.setDate(data.getDate());
            vendorFinanceDocumentData.setVendorNumber(data.getVendorNumber());
            vendorFinanceDocumentData.setVendorDate(data.getVendorDate());
            vendorFinanceDocumentData.setVendorShippingDocumentNumber(data.getVendorShippingDocumentNumber());
            vendorFinanceDocumentData.setVendorShippingDocumentDate(data.getVendorShippingDocumentDate());
            vendorFinanceDocumentData.setSequenceNumber(data.getSequenceNumber());
            product.getVendorFinanceDocumentsData().add(vendorFinanceDocumentData);
        });
    }

    private void saveCommissionsAndFeesAndFops(GeneralProductContractRelationData relation, BaseProductUIData supplement) {
        ContractType relationContractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
        List fops = relation.getFops();
        Map oldCommissions = relation.getCommissions().stream().collect(Collectors.toMap(BaseIdentity::getUid, UnaryOperator.identity()));
        fops.clear();
        relation.getCommissions().clear();
        supplement.getCommissionDiscountFeeHandlers().stream().filter(handler -> handler.getContractType() != null && handler.getContractType().equals((Object)relationContractType)).forEach(handler -> {
            this.saveCommissions(handler.getCommissions(), oldCommissions, (CommissionsDiscountsFeesUIDataHandler)handler, relation);
            this.saveFees(handler.getFees(), oldCommissions, (CommissionsDiscountsFeesUIDataHandler)handler, relation);
        });
        supplement.getFopsList().stream().filter(productFopUIData -> productFopUIData.getContractType() != null && productFopUIData.getContractType().equals((Object)relationContractType)).map(uiFop -> this.convertUiDataToGeneralFop((ProductFopUIData)uiFop, oldCommissions.values())).collect(Collectors.toCollection(() -> fops));
    }

    private void saveCommissions(List<CommissionsUIData> uiCommissions, Map<String, GeneralProductCommission> oldCommissions, CommissionsDiscountsFeesUIDataHandler handler, GeneralProductContractRelationData relation) {
        uiCommissions.stream().map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            this.convertUiAmount(result, uiCommission.getAmount(), uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setCommissionProperties(uiCommission.getCommissionProperty());
            result.setContractType(handler.getContractType());
            return result;
        }).collect(Collectors.toCollection(() -> ((GeneralProductContractRelationData)relation).getCommissions()));
    }

    private void saveFees(List<FeesUIData> uiFees, Map<String, GeneralProductCommission> oldCommissions, CommissionsDiscountsFeesUIDataHandler handler, GeneralProductContractRelationData relation) {
        uiFees.stream().map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            this.convertUiAmount(result, uiCommission.getAmount(), uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setContractType(handler.getContractType());
            result.setCommissionProperties(uiCommission.getFeeProperty());
            return result;
        }).collect(Collectors.toCollection(() -> ((GeneralProductContractRelationData)relation).getCommissions()));
    }

    private Collection<ValidationMessage> mixValidationMessages(List<ValidationMessage> validationMessages, Identity product) {
        String TAG = "create-export-documents";
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SysLogItem.Property.referenceUid.name(), (Object)product.getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.ilike((String)SysLogItem.Property.tag.name(), (String)(TAG + "%")));
        query.getCriteria().getOrders().put(SysLogItem.Property.eventDate.name(), SortOrder.DESC);
        SearchResult result = AssetsStorage.get().search(SysLogItem.class, query);
        if (result.getData().size() == 0) {
            return validationMessages;
        }
        SysLogItem item = (SysLogItem)result.getData().get(0);
        if (item.getMessage().getType() != MessageType.ERROR) {
            return validationMessages;
        }
        String tag = item.getTag();
        ArrayList<ValidationMessage> mv = new ArrayList<ValidationMessage>(validationMessages);
        for (SysLogItem data : result.getData()) {
            if (!tag.equals(data.getTag())) continue;
            ValidationMessage msg = new ValidationMessage();
            msg.setSeverity(ValidationMessageSeverity.ERROR);
            msg.setMessage(data.getMessage().getMessage());
            msg.setDetails(data.getMessage().getDetails());
            mv.add(msg);
            if (!tag.equals(TAG)) continue;
            break;
        }
        return mv;
    }

    private BigDecimal calculatePayPrice(BaseProduct product) {
        BigDecimal pay = BigDecimal.ZERO;
        HashSet<PaymentType> allPaymentTypesExceptTicket = new HashSet<PaymentType>(Arrays.asList(PaymentType.values()));
        allPaymentTypesExceptTicket.remove(PaymentType.TICKET);
        ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)product);
        if (!ProductStatusHandler.getAllVoidStatuses().contains(status)) {
            BigDecimal bigDecimal = pay = status != ProductStatus.EXCHANGE ? GeneralProductHelper.calculateFopsEquivalentValue((Collection)GeneralProductHelper.filterFops((Collection)GeneralProductHelper.getClientFops((BaseProduct)product), null, allPaymentTypesExceptTicket, null)) : BigDecimal.ZERO;
        }
        if (status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE) {
            pay = MiscUtil.negate((BigDecimal)pay);
        }
        return pay;
    }

    private EntityContainer<Organization> loadCustomerProfile(BookingFile bookingFile) {
        EntityReference ref = bookingFile.getCustomerProfile();
        if (ref != null) {
            EntityContainer container = EntityStorage.get().resolve(ref);
            return container;
        }
        return null;
    }

    private Object getFieldOrNull(BaseEntity entity, String fieldName) {
        try {
            return entity.getValue(fieldName);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    protected ProductFopCategory categoryFor(GeneralProductFop productFop) {
        return GeneralProductHelper.getProductFopCategory((GeneralProductFop)productFop);
    }

    protected void convertUiAmount(GeneralProductCommission result, BigDecimal amount, String currency) {
        if (amount != null) {
            result.setAmount(MoneyHelper.buildMoney((BigDecimal)amount, (String)currency));
        }
    }
}

