/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.air.uidata.HotelProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsDiscountsFeesUIDataHandler;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsUIData;
import com.gridnine.xtrip.common.model.booking.uidata.FeesUIData;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class HotelProductSupplementHandler
extends GeneralProductSupplementHandler {
    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof HotelProduct).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (HotelProduct)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof HotelProduct).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof HotelProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((HotelProduct)modelProducts.get(product.getRelatedProductUID()), (HotelProductUIData)product);
            }
        });
    }

    private HotelProductUIData createProductUIData(BookingFile bookingFile, HotelProduct product) {
        HotelProductUIData uiData = new HotelProductUIData();
        uiData.setRelatedProductUID(product.getUid());
        uiData.setSupplier(HotelProductHelper.getSupplier((HotelProduct)product));
        uiData.setAgency(HotelProductHelper.getAgency((HotelProduct)product));
        uiData.setSubagency(HotelProductHelper.getSubagency((HotelProduct)product));
        uiData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        uiData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        Money basePrice = HotelProductHelper.calcBasePrice((HotelProduct)product);
        Double currencyRate = null;
        if (basePrice != null && basePrice.getCurrency() != null) {
            if (product.getGdsCurrencyRate() != null) {
                currencyRate = product.getGdsCurrencyRate();
            } else if (product.getVendorCurrencyRate() != null) {
                currencyRate = product.getVendorCurrencyRate();
            } else {
                ExchangeRateData rate = GeneralProductHelper.getVendorContractRelation((BaseProduct)product).getGeneralData().getRate();
                if (rate != null) {
                    currencyRate = rate.getRateWithCoefficient();
                } else {
                    CurrencyRate currencyRateDict = DictHelper.findCurrencyRate((String)basePrice.getCurrency(), (Date)product.getIssueDate(), (CurrencyRateType)CurrencyRateType.CBR, (TariffType)TariffType.REGULAR, (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product));
                    if (currencyRateDict != null) {
                        currencyRate = currencyRateDict.getRate();
                    }
                }
            }
        }
        if (currencyRate != null) {
            uiData.setCurrencyRate(currencyRate.doubleValue());
        }
        uiData.setStatus(product.getStatus());
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        uiData.setSubProviderRecordLocator(HotelProductHelper.getSubProviderRecordLocator((HotelProduct)product));
        this.addCommissionsAndFops(uiData, product);
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    private void addCommissionsAndFops(HotelProductUIData uiData, HotelProduct product) {
        ArrayList<CommissionsDiscountsFeesUIDataHandler> handlers = new ArrayList<CommissionsDiscountsFeesUIDataHandler>();
        List relations = HotelProductHelper.getContractRelations((HotelProduct)product);
        for (HotelProductContractRelationData relation : relations) {
            List<String> commissionsUidList = relation.getFops().stream().flatMap(fop -> ((List)fop.getValue("commissions")).stream()).map(BaseIdentity::getUid).collect(Collectors.toList());
            List<ProductFopUIData> fopData = this.buildProductFopUIDataList((BaseContractRelationData)relation, product.getStatus(), commissionsUidList);
            uiData.getFopsList().addAll(fopData);
            this.updateHandlers((BaseProduct)product, handlers, (BaseContractRelationData)relation, relation.getCommissions(), false, null);
        }
        uiData.getCommissionDiscountFeeHandlers().addAll(handlers);
    }

    @Override
    protected ProductFopUIData buildBaseProductFopUIData(Fop fop) {
        HotelProductFop productFop = (HotelProductFop)fop;
        ProductFopUIData fopUiData = super.buildBaseProductFopUIData((Fop)productFop);
        fopUiData.setCategory(this.categoryFor((GeneralProductFop)productFop));
        EntityReference agent = (EntityReference)productFop.getValue("agent");
        Date operationDate = (Date)productFop.getValue("operationDate");
        Boolean refused = (Boolean)productFop.getValue("refused");
        String relatedTicketNumber = (String)productFop.getValue("relatedTicketNumber");
        EntityReference payer = (EntityReference)productFop.getValue("payer");
        if (productFop.getAmount() != null) {
            fopUiData.setAmount(productFop.getAmount().getValue());
            fopUiData.setCurrency(productFop.getAmount().getCurrency());
        }
        fopUiData.setAgent(agent);
        fopUiData.setOperationDate(operationDate);
        fopUiData.setRefused(refused.booleanValue());
        fopUiData.setNumber(relatedTicketNumber);
        fopUiData.setPayer(payer);
        return fopUiData;
    }

    private void saveData(HotelProduct product, HotelProductUIData uiData) {
        HotelProductHelper.setAgency((HotelProduct)product, (EntityReference)uiData.getAgency());
        HotelProductHelper.setSubagency((HotelProduct)product, (EntityReference)uiData.getSubagency());
        HotelProductHelper.setSupplier((HotelProduct)product, (EntityReference)uiData.getSupplier());
        this.convertUIFops(product, uiData);
        this.saveContracts((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveBlankOwnerCode(product);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }

    private void saveBlankOwnerCode(HotelProduct product) {
        if (product.getBlankOwnerRef() == null) {
            product.setBlankOwnerCode(null);
            return;
        }
        try {
            product.setBlankOwnerCode(HotelProductHelper.getBlankOwnerCode((EntityReference)product.getBlankOwnerRef()));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get blank owner code", e);
        }
    }

    private void convertUIFops(HotelProduct product, HotelProductUIData uiData) {
        List relations = HotelProductHelper.getContractRelations((HotelProduct)product);
        relations.forEach(relation -> this.saveCommissionsAndFeesAndFops((HotelProductContractRelationData)relation, uiData, product));
    }

    private void saveCommissionsAndFeesAndFops(HotelProductContractRelationData relation, HotelProductUIData supplement, HotelProduct product) {
        ContractType relationContractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
        List fops = relation.getFops();
        Map oldCommissions = relation.getCommissions().stream().collect(Collectors.toMap(BaseIdentity::getUid, UnaryOperator.identity()));
        fops.clear();
        relation.getCommissions().clear();
        supplement.getCommissionDiscountFeeHandlers().stream().filter(handler -> handler.getContractType().equals((Object)relationContractType)).forEach(handler -> {
            this.saveCommissions(handler.getCommissions(), oldCommissions, (CommissionsDiscountsFeesUIDataHandler)handler, relation);
            this.saveFees(handler.getFees(), oldCommissions, (CommissionsDiscountsFeesUIDataHandler)handler, relation);
        });
        supplement.getFopsList().stream().filter(productFopUIData -> productFopUIData.getContractType().equals((Object)relationContractType)).map(uiFop -> this.toFop((ProductFopUIData)uiFop, oldCommissions)).collect(Collectors.toCollection(() -> fops));
    }

    private void saveCommissions(List<CommissionsUIData> uiCommissions, Map<String, GeneralProductCommission> oldCommissions, CommissionsDiscountsFeesUIDataHandler handler, HotelProductContractRelationData relation) {
        uiCommissions.stream().map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            this.convertUiAmount(result, uiCommission.getAmount(), uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setCommissionProperties(uiCommission.getCommissionProperty());
            result.setContractType(handler.getContractType());
            return result;
        }).collect(Collectors.toCollection(() -> ((HotelProductContractRelationData)relation).getCommissions()));
    }

    private void saveFees(List<FeesUIData> uiFees, Map<String, GeneralProductCommission> oldCommissions, CommissionsDiscountsFeesUIDataHandler handler, HotelProductContractRelationData relation) {
        uiFees.stream().map(uiCommission -> {
            GeneralProductCommission result = (GeneralProductCommission)oldCommissions.get(uiCommission.getUid());
            if (result == null) {
                result = new GeneralProductCommission();
            }
            BigDecimal amount = uiCommission.getAmount();
            this.convertUiAmount(result, amount, uiCommission.getCurrency());
            result.setRate(uiCommission.getRate());
            result.setEquivalentAmount(uiCommission.getEquivalentAmount());
            result.setContractType(handler.getContractType());
            result.setCommissionProperties(uiCommission.getFeeProperty());
            return result;
        }).collect(Collectors.toCollection(() -> ((HotelProductContractRelationData)relation).getCommissions()));
    }

    private HotelProductFop toFop(ProductFopUIData productFopUIData, Map<String, GeneralProductCommission> commissions) {
        List fopCommissions = commissions.values().stream().filter(commission -> productFopUIData.getCommissionUids().contains(commission.getUid())).collect(Collectors.toList());
        HotelProductFop result = new HotelProductFop();
        result.setUid(productFopUIData.getUid());
        result.setAgent(productFopUIData.getAgent());
        result.setOperationDate(productFopUIData.getOperationDate());
        result.setPayer(productFopUIData.getPayer());
        result.setRefused(productFopUIData.isRefused());
        result.setType(productFopUIData.getPaymentType());
        result.getCommissions().addAll(fopCommissions);
        if (result.getAmount() == null) {
            result.setAmount(new Money());
        }
        result.getAmount().setValue(productFopUIData.getAmount());
        result.setEquivalentAmount(productFopUIData.getAmount());
        result.getAmount().setCurrency(productFopUIData.getCurrency());
        result.setCard(productFopUIData.getCard());
        return result;
    }
}

