/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.InsuranceUIData;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.Map;
import java.util.stream.Collectors;

final class InsuranceAccidentProductSupplementHandler
extends GeneralProductSupplementHandler {
    InsuranceAccidentProductSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> product instanceof InsuranceAccident).map(prod -> this.createInsuranceUIData((BookingFile)ctr.getEntity(), (InsuranceAccident)prod)).collect(Collectors.toCollection(() -> ((BookingFileUIData)supplement).getProducts()));
    }

    private InsuranceUIData createInsuranceUIData(BookingFile entity, InsuranceAccident product) {
        InsuranceUIData result = new InsuranceUIData();
        result.setRelatedProductUID(product.getUid());
        result.setAgency(InsuranceAccidentHelper.getAgency((InsuranceAccident)product));
        result.setSupplier(InsuranceAccidentHelper.getSupplier((InsuranceAccident)product));
        result.setSubagency(InsuranceAccidentHelper.getSubagency((InsuranceAccident)product));
        result.setCurrency(DictHelper.getLocalCurrency());
        result.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        result.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addBaseProductFields((BaseProductUIData)result, (BaseProduct)product, entity);
        this.addCommissionsAndFops((BaseProductUIData)result, (BaseProduct)product);
        this.addContracts((BaseProductUIData)result, (BaseProduct)product);
        return result;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof InsuranceAccident).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof InsuranceUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((InsuranceAccident)modelProducts.get(product.getRelatedProductUID()), (InsuranceUIData)product);
            }
        });
    }

    private void saveData(InsuranceAccident product, InsuranceUIData supplement) {
        InsuranceAccidentHelper.setAgency((InsuranceAccident)product, (EntityReference)supplement.getAgency());
        InsuranceAccidentHelper.setSupplier((InsuranceAccident)product, (EntityReference)supplement.getSupplier());
        InsuranceAccidentHelper.setSubagency((InsuranceAccident)product, (EntityReference)supplement.getSubagency());
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)supplement);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)supplement);
    }
}

