/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.InsuranceUIData;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.Map;
import java.util.stream.Collectors;

class InsuranceTouristicProductSupplementHandler
extends GeneralProductSupplementHandler {
    InsuranceTouristicProductSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(product -> product instanceof InsuranceTouristic).map(prod -> this.createInsuranceUIData((InsuranceTouristic)prod, (BookingFile)ctr.getEntity())).collect(Collectors.toCollection(() -> ((BookingFileUIData)supplement).getProducts()));
    }

    private InsuranceUIData createInsuranceUIData(InsuranceTouristic product, BookingFile entity) {
        InsuranceUIData result = new InsuranceUIData();
        result.setRelatedProductUID(product.getUid());
        result.setAgency(InsuranceTouristicHelper.getAgency((InsuranceTouristic)product));
        result.setSupplier(InsuranceTouristicHelper.getSupplier((InsuranceTouristic)product));
        result.setSubagency(InsuranceTouristicHelper.getSubagency((InsuranceTouristic)product));
        result.setCurrency(DictHelper.getLocalCurrency());
        result.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        result.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addBaseProductFields((BaseProductUIData)result, (BaseProduct)product, entity);
        this.addCommissionsAndFops((BaseProductUIData)result, (BaseProduct)product);
        this.addContracts((BaseProductUIData)result, (BaseProduct)product);
        return result;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof InsuranceTouristic).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof InsuranceUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((InsuranceTouristic)modelProducts.get(product.getRelatedProductUID()), (InsuranceUIData)product);
            }
        });
    }

    private void saveData(InsuranceTouristic product, InsuranceUIData supplement) {
        InsuranceTouristicHelper.setAgency((InsuranceTouristic)product, (EntityReference)supplement.getAgency());
        InsuranceTouristicHelper.setSupplier((InsuranceTouristic)product, (EntityReference)supplement.getSupplier());
        InsuranceTouristicHelper.setSubagency((InsuranceTouristic)product, (EntityReference)supplement.getSubagency());
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)supplement);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)supplement);
    }
}

