/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class MCOFeesProductSupplementHandler
extends GeneralProductSupplementHandler {
    MCOFeesProductSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof MCOFees).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (MCOFees)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof MCOFees).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((MCOFees)modelProducts.get(product.getRelatedProductUID()), (BaseProductUIData)product);
            }
        });
    }

    private BaseProductUIData createProductUIData(BookingFile bookingFile, MCOFees product) {
        BaseProductUIData uiData = new BaseProductUIData();
        uiData.setRelatedProductUID(product.getUid());
        this.addBaseProductFields(uiData, (BaseProduct)product, bookingFile);
        uiData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        uiData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        return uiData;
    }

    private void saveData(MCOFees product, BaseProductUIData uiData) {
    }
}

