/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.metadata.uidata.MetadataUIData;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationContractData;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationContractRuleData;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationUIData;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.system.MetadataKeyCategory;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptor;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class OrganizationSupplementHandler
implements SupplementHandler<Organization, OrganizationUIData> {
    public Class<Organization> getEntityClass() {
        return Organization.class;
    }

    public Class<OrganizationUIData> getSupplementClass() {
        return OrganizationUIData.class;
    }

    public void populateSupplement(EntityContainer<Organization> ctr, OrganizationUIData supplement) {
        supplement.getMetadataUiData().clear();
        DictionaryCache.get().getAll(MetadataKeyDescriptor.class).values().stream().filter(desc -> MetadataKeyCategory.ORGANIZATION == desc.getCategory()).forEach(desc -> {
            String defaultCaption = (String)CollectionUtil.head(desc.getTranslations().values());
            String caption = desc.getTranslations().getOrDefault(LocaleManager.get().getCurrentLocale(), defaultCaption);
            MetadataUIData data = new MetadataUIData();
            data.setMetadata((DictionaryReference)desc.toReference());
            data.setCategory(desc.getCategory());
            data.setValueType(desc.getValueType());
            data.setPredefined(desc.isPredefined());
            data.setCaption(caption);
            supplement.getMetadataUiData().add(data);
        });
        List contractIndexList = ProfileDao.searchSupplierContracts((EntityReference)ctr.toReference());
        List suppliers = contractIndexList.stream().map(ContractIndex::getSupplier).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (suppliers.size() == 1) {
            supplement.setDefaultSupplier(EntityStorage.get().actualize((EntityReference)suppliers.get(0)));
        } else {
            supplement.setDefaultSupplier(null);
        }
        if (((Organization)ctr.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT) && !ProfileHelper.isRetailProfile(ctr)) {
            EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
            EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
            ArrayList<ContractIndex> clientContracts = new ArrayList<ContractIndex>(contractIndexList);
            clientContracts.addAll(ProfileDao.searchContracts((EntityReference)ctr.toReference(), (EntityReference)allAgenciesProfile));
            clientContracts.addAll(ProfileDao.searchContracts((EntityReference)allClientsProfile, (EntityReference)allAgenciesProfile));
            this.fillContractRules(supplement, clientContracts);
        }
    }

    private void fillContractRules(OrganizationUIData supplement, List<ContractIndex> contractIndexList) {
        for (ContractIndex contractIndex : contractIndexList) {
            if (!contractIndex.isNewModel()) continue;
            Date now = new Date();
            OrganizationContractData contractData = new OrganizationContractData();
            contractData.setContract(contractIndex.getSource());
            EntityContainer contractCtr = EntityStorage.get().resolve(contractIndex.getSource());
            List ruleContainers = ProfileHelper.getRuleContainers((EntityContainer)contractCtr, null);
            for (EntityContainer ruleContainer : ruleContainers) {
                ProfileDao.getCommissionsRuleSettingsStream((EntityContainer)ruleContainer, (Date)now).map(rs -> this.buildRule((RuleSettings)rs, (EntityReference<? extends BaseRulesContainer>)ruleContainer.toReference())).forEach(contractData.getRules()::add);
            }
            if (contractData.getRules().isEmpty()) continue;
            supplement.getContractData().add(contractData);
        }
    }

    private OrganizationContractRuleData buildRule(RuleSettings ruleSettings, EntityReference<? extends BaseRulesContainer> rulesContainerRef) {
        OrganizationContractRuleData result = new OrganizationContractRuleData();
        result.setRuleTargetCaption(ruleSettings.getTarget().getDisplayName());
        result.setRuleUid(ruleSettings.getUid());
        result.setName(ruleSettings.getName());
        StringBuilder sb = new StringBuilder();
        ruleSettings.buildRestrictionsInfo(sb, false);
        result.setConditions(sb.toString());
        ArrayList commissionsProperties = new ArrayList();
        ArrayList values = new ArrayList();
        ProfileDao.fillCommissionsRuleSettingsData((RuleSettings)ruleSettings, commissionsProperties, values);
        result.setCommissionProperties(TextUtil.join((String)"\n", commissionsProperties));
        result.setValues(TextUtil.join((String)"\n", values));
        result.setRuleContainerRef(rulesContainerRef);
        return result;
    }

    public void populateEntity(OrganizationUIData supplement, EntityContainer<Organization> ctr) {
    }

    public double getPriority() {
        return 10.0;
    }
}

