/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.metadata.uidata.MetadataUIData;
import com.gridnine.xtrip.common.model.person.uidata.PersonUIData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.MetadataKeyCategory;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptor;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import java.util.Objects;
import org.apache.http.util.TextUtils;

public class PersonSupplementHandler
implements SupplementHandler<Person, PersonUIData> {
    public Class<Person> getEntityClass() {
        return Person.class;
    }

    public Class<PersonUIData> getSupplementClass() {
        return PersonUIData.class;
    }

    public void populateSupplement(EntityContainer<Person> ctr, PersonUIData supplement) {
        PersonSupplementHandler.clearSupplement(supplement);
        ((Person)ctr.getEntity()).getEmployments().stream().map(PersonEmployment::getOrganization).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(Objects::nonNull).forEach(org -> {
            PersonSupplementHandler.buildCostCodesToFill(supplement, (EntityContainer<Organization>)org);
            PersonSupplementHandler.buildMaskUdidsOrganization(supplement, (EntityContainer<Organization>)org);
        });
        DictionaryCache.get().getAll(MetadataKeyDescriptor.class).values().stream().filter(desc -> MetadataKeyCategory.PERSON == desc.getCategory()).forEach(desc -> {
            String defaultCaption = (String)CollectionUtil.head(desc.getTranslations().values());
            String caption = desc.getTranslations().getOrDefault(LocaleManager.get().getCurrentLocale(), defaultCaption);
            MetadataUIData data = new MetadataUIData();
            data.setMetadata((DictionaryReference)desc.toReference());
            data.setCategory(desc.getCategory());
            data.setValueType(desc.getValueType());
            data.setPredefined(desc.isPredefined());
            data.setCaption(caption);
            supplement.getMetadataUiData().add(data);
        });
        ((Person)ctr.getEntity()).getSalesPoints().stream().filter(Objects::nonNull).map(PlaceOfSales::getSalesPoint).filter(Objects::nonNull).filter(ref -> ref.getType().isAssignableFrom(SalesPoint.class)).distinct().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(Objects::nonNull).forEach(spCtr -> supplement.getSalesPointOrganizationMap().put(spCtr.toReference(), ((SalesPoint)spCtr.getEntity()).getAgency()));
    }

    private static void buildCostCodesToFill(PersonUIData supplement, EntityContainer<Organization> org) {
        supplement.getCostCodesToFill().addAll(ProfileHelper.getCostCodesToFillInTravellerProfile(org));
    }

    private static void buildMaskUdidsOrganization(PersonUIData supplement, EntityContainer<Organization> org) {
        ((Organization)org.getEntity()).getCostCodeProperties().stream().filter(Objects::nonNull).filter(costCodeProperties -> !TextUtils.isBlank((CharSequence)costCodeProperties.getMask())).forEach(costCodeProperties -> supplement.getMaskUdidsOrganizationMap().putIfAbsent(costCodeProperties.getCategory(), costCodeProperties.getMask()));
    }

    public static void clearSupplement(PersonUIData supplement) {
        supplement.getCostCodesToFill().clear();
        supplement.getSalesPointOrganizationMap().clear();
        supplement.getMetadataUiData().clear();
        supplement.getMaskUdidsOrganizationMap().clear();
    }

    public void populateEntity(PersonUIData supplement, EntityContainer<Person> ctr) {
    }

    public double getPriority() {
        return 10.0;
    }
}

