/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.PaymentItem;
import com.gridnine.xtrip.common.model.finance.PaymentItemsList;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.ShipmentUIData;
import com.gridnine.xtrip.common.model.finance.ShipmentUIFinanceDocumentData;
import com.gridnine.xtrip.common.model.finance.ShipmentUIFinancePrepaymentDocumentData;
import com.gridnine.xtrip.common.model.finance.ShipmentUIVendorFinanceDocumentData;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.supplements.SupplementHandler;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ShipmentSupplementHandler
implements SupplementHandler<Shipment, ShipmentUIData> {
    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<Shipment> container, ShipmentUIData supplement) {
        Shipment shipment = (Shipment)container.getEntity();
        EntityStorageContext storageContext = new EntityStorageContext();
        List billingItems = FinanceDocumentHelper.getBillingItems((List)shipment.getBillingItems(), (EntityStorageContext)storageContext).parallelStream().sorted(MiscUtil.comparator(Arrays.asList(MiscUtil.comparator(item -> (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getProduct(), (EntityStorageContext)storageContext), (Comparator)FinanceDocumentsHelper.productComparator), MiscUtil.comparator(BillingItem::getServiceType, (Comparator)FinanceDocumentsHelper.serviceTypeComparator), MiscUtil.comparator(item -> item.getFopComponents().stream().map(component -> (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)component, (EntityStorageContext)storageContext)).filter(Objects::nonNull).max(FinanceDocumentsHelper.fopComponentComparator).orElse(null), (Comparator)FinanceDocumentsHelper.fopComponentComparator), MiscUtil.comparator(BillingItem::getName)))).collect(Collectors.toList());
        supplement.getBillingItems().clear();
        supplement.getBillingItems().addAll(billingItems);
        PaymentItemsList paymentItems = new PaymentItemsList();
        shipment.getPaymentItems().forEach(payment -> {
            PaymentItem item = (PaymentItem)EntityStorageHelper.resolve((NestedEntityReference)payment, (EntityStorageContext)storageContext);
            if (item != null) {
                paymentItems.getData().add(item);
            }
        });
        supplement.setPaymentItems(paymentItems);
        ArrayList financeDocuments = new ArrayList();
        shipment.getFinanceDocuments().forEach(finDocRef -> {
            FinanceDocument finDoc;
            EntityContainer finDocCtr = EntityStorageHelper.resolve((EntityReference)finDocRef, (EntityStorageContext)storageContext);
            if (finDocCtr != null && !(finDoc = (FinanceDocument)finDocCtr.getEntity()).isVendorDocument()) {
                ShipmentUIFinanceDocumentData financeData = new ShipmentUIFinanceDocumentData();
                financeData.setDate(finDoc.getDate());
                financeData.setNumber(finDoc.getNumber());
                financeData.setType(finDoc.getType());
                financeData.setDeliveryReference(finDoc.getDelivery());
                financeData.setFinanceDocumentReference(finDocRef);
                financeDocuments.add(financeData);
            }
        });
        supplement.getFinanceDocuments().addAll(financeDocuments);
        ArrayList vendorFinanceDocuments = new ArrayList();
        shipment.getFinanceDocuments().forEach(finDocRef -> {
            FinanceDocument finDoc;
            EntityContainer finDocCtr = EntityStorageHelper.resolve((EntityReference)finDocRef, (EntityStorageContext)storageContext);
            if (finDocCtr != null && (finDoc = (FinanceDocument)finDocCtr.getEntity()).isVendorDocument()) {
                ShipmentUIVendorFinanceDocumentData financeData = new ShipmentUIVendorFinanceDocumentData();
                financeData.setDate(finDoc.getDate());
                financeData.setNumber(finDoc.getNumber());
                financeData.setType(finDoc.getType());
                financeData.setDeliveryReference(finDoc.getDelivery());
                financeData.setFinanceDocumentReference(finDocRef);
                vendorFinanceDocuments.add(financeData);
            }
        });
        supplement.getVendorFinanceDocuments().addAll(vendorFinanceDocuments);
        ArrayList prepaymentFinanceDocuments = new ArrayList();
        shipment.getPrepaymentFinanceDocuments().forEach(finDocRef -> {
            EntityContainer finDocCtr = EntityStorageHelper.resolve((EntityReference)finDocRef, (EntityStorageContext)storageContext);
            if (finDocCtr != null) {
                FinanceDocument finDoc = (FinanceDocument)finDocCtr.getEntity();
                ShipmentUIFinancePrepaymentDocumentData financeData = new ShipmentUIFinancePrepaymentDocumentData();
                financeData.setDate(finDoc.getDate());
                financeData.setNumber(finDoc.getNumber());
                financeData.setType(finDoc.getType());
                financeData.setAmount((BigDecimal)finDoc.getBillingItems().stream().map(itemRef -> (BillingItem)EntityStorageHelper.resolve((NestedEntityReference)itemRef, (EntityStorageContext)storageContext)).filter(Objects::nonNull).map(BillingItem::getAmount).filter(Objects::nonNull).map(VatAmount::getTotal).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null));
                financeData.setFinanceDocumentReference(finDocRef);
                prepaymentFinanceDocuments.add(financeData);
            }
        });
        supplement.getPrepaymentFinanceDocuments().addAll(prepaymentFinanceDocuments);
        for (PaymentItem pi : paymentItems.getData()) {
            shipment.getPaymentDocuments().stream().map(EntityStorageHelper::resolve).filter(Objects::nonNull).filter(doc -> ((BasePaymentDocument)doc.getEntity()).getPaymentItems().stream().anyMatch(ref -> TextUtil.equals((String)ref.getNestedEntityUid(), (String)pi.getUid(), (boolean)false))).findFirst().ifPresent(paymentDocument -> supplement.getPaymentItemPaymentDocumentMap().put(pi, paymentDocument.toReference()));
        }
    }

    public Class<Shipment> getEntityClass() {
        return Shipment.class;
    }

    public Class<ShipmentUIData> getSupplementClass() {
        return ShipmentUIData.class;
    }

    public void populateEntity(ShipmentUIData supplement, EntityContainer<Shipment> container) {
        Shipment shipment = (Shipment)container.getEntity();
        EntityStorageContext storageContext = new EntityStorageContext();
        Map<String, BillingItem> supplementBillingItemUids = supplement.getBillingItems().stream().collect(Collectors.toMap(item -> item.getUid(), item -> item));
        Map billingItemListGroups = FinanceDocumentHelper.getBillingItemsLists((List)shipment.getBillingItems(), (EntityStorageContext)storageContext);
        for (Map.Entry billingItemListGroup : billingItemListGroups.entrySet()) {
            EntityContainer billingItemsListContainer = (EntityContainer)billingItemListGroup.getKey();
            Collection billingItems = (Collection)billingItemListGroup.getValue();
            boolean save = false;
            for (BillingItem billingItem : billingItems) {
                BillingItem supplementBillingItem = supplementBillingItemUids.get(billingItem.getUid());
                if (supplementBillingItem == null || TextUtil.isSame((String)supplementBillingItem.getName(), (String)billingItem.getName())) continue;
                billingItem.setName(supplementBillingItem.getName());
                save = true;
            }
            if (!save) continue;
            EntityStorage.get().save(billingItemsListContainer, false);
        }
    }
}

