/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiHelper;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.TaxiProductUIData;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TaxiProductSupplementHandler
extends GeneralProductSupplementHandler {
    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof TaxiProduct).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (TaxiProduct)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    private TaxiProductUIData createProductUIData(BookingFile bookingFile, TaxiProduct product) {
        TaxiProductUIData uiData = new TaxiProductUIData();
        uiData.setRelatedProductUID(product.getUid());
        uiData.setSupplier(TaxiHelper.getSupplier((TaxiProduct)product));
        uiData.setAgency(TaxiHelper.getAgency((TaxiProduct)product));
        uiData.setSubagency(TaxiHelper.getSubagency((TaxiProduct)product));
        uiData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        uiData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addCurrencyRatesData(uiData, product);
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        this.addCommissionsAndFops((BaseProductUIData)uiData, (BaseProduct)product);
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    private void addCurrencyRatesData(TaxiProductUIData uiData, TaxiProduct product) {
        if (product.getFare() == null || product.getFare().getCurrency() == null || product.getEquivalentFare() == null || product.getEquivalentFare().getCurrency() == null) {
            return;
        }
        String productCurrencyCode = product.getFare().getCurrency();
        String productEqCurrencyCode = product.getEquivalentFare().getCurrency();
        Date productIssueDate = product.getIssueDate();
        CurrencyRate currencyRate = DictHelper.findCurrencyRate((String)productCurrencyCode, (String)productEqCurrencyCode, (Date)productIssueDate, (CurrencyRateType)CurrencyRateType.IATA, (TariffType)TariffType.REGULAR, (EntityReference)product.getBlankOwner(), (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product));
        DictionaryReference currencyRateRef = DictHelper.toReference((BaseDictionary)currencyRate);
        if (currencyRate != null) {
            uiData.setBaseCurrency(currencyRate.getCurrency());
            uiData.setEqCurrency(currencyRate.getBaseCurrency());
            uiData.setRate(Double.valueOf(currencyRate.getRate()));
            uiData.setCurrencyRate(currencyRateRef);
        }
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof TaxiProduct).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof TaxiProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveProductUIData((TaxiProduct)modelProducts.get(product.getRelatedProductUID()), (TaxiProductUIData)product);
            }
        });
    }

    private void saveProductUIData(TaxiProduct product, TaxiProductUIData uiData) {
        TaxiHelper.setAgency((TaxiProduct)product, (EntityReference)uiData.getAgency());
        TaxiHelper.setSubagency((TaxiProduct)product, (EntityReference)uiData.getSubagency());
        TaxiHelper.setSupplier((TaxiProduct)product, (EntityReference)uiData.getSupplier());
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }
}

