/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.UniversalProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UniversalProductSupplementHandler
extends GeneralProductSupplementHandler {
    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof UniversalProduct).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (UniversalProduct)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    private UniversalProductUIData createProductUIData(BookingFile bookingFile, UniversalProduct product) {
        UniversalProductUIData uiData = new UniversalProductUIData();
        uiData.setSupplier(UniversalProductHelper.getSupplier((UniversalProduct)product));
        uiData.setAgency(UniversalProductHelper.getAgency((UniversalProduct)product));
        uiData.setSubagency(UniversalProductHelper.getSubagency((UniversalProduct)product));
        uiData.setRelatedProductUID(product.getUid());
        uiData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        uiData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        uiData.setVatAmount(GeneralProductHelper.getHandler((BaseProduct)product).calculateProductPrice(null, (BaseProduct)product));
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        this.addCommissionsAndFops((BaseProductUIData)uiData, (BaseProduct)product);
        uiData.getFopsList().stream().filter(e -> e.getContractType().equals((Object)ContractType.VENDOR)).forEach(e -> e.setAgent(null));
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof UniversalProduct).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof UniversalProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveProductUIData((UniversalProduct)modelProducts.get(product.getRelatedProductUID()), (UniversalProductUIData)product);
            }
        });
    }

    private void saveProductUIData(UniversalProduct product, UniversalProductUIData uiData) {
        UniversalProductHelper.setAgency((UniversalProduct)product, (EntityReference)uiData.getAgency());
        UniversalProductHelper.setSubagency((UniversalProduct)product, (EntityReference)uiData.getSubagency());
        UniversalProductHelper.setSupplier((UniversalProduct)product, (EntityReference)uiData.getSupplier());
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }
}

