/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.VisaProductUIData;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VisaProductSupplementHandler
extends GeneralProductSupplementHandler {
    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof VisaProduct).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (VisaProduct)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    private VisaProductUIData createProductUIData(BookingFile bookingFile, VisaProduct product) {
        VisaProductUIData uiData = new VisaProductUIData();
        uiData.setRelatedProductUID(product.getUid());
        uiData.setSupplier(VisaProductHelper.getSupplier((VisaProduct)product));
        uiData.setAgency(VisaProductHelper.getAgency((VisaProduct)product));
        uiData.setSubagency(VisaProductHelper.getSubagency((VisaProduct)product));
        uiData.setHasErrors(this.isHavingErrors(product.getValidationMessages(), (Identity)product));
        uiData.setHasWarnings(this.isHavingWarnings(product.getValidationMessages(), (Identity)product));
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        this.addCommissionsAndFops((BaseProductUIData)uiData, (BaseProduct)product);
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof VisaProduct).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof VisaProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveProductUIData((VisaProduct)modelProducts.get(product.getRelatedProductUID()), (VisaProductUIData)product);
            }
        });
    }

    private void saveProductUIData(VisaProduct product, VisaProductUIData uiData) {
        VisaProductHelper.setAgency((VisaProduct)product, (EntityReference)uiData.getAgency());
        VisaProductHelper.setSubagency((VisaProduct)product, (EntityReference)uiData.getSubagency());
        VisaProductHelper.setSupplier((VisaProduct)product, (EntityReference)uiData.getSupplier());
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }
}

