/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.handlers;

import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.booking.uidata.VoidingProductUIData;
import com.gridnine.xtrip.server.fx.supplements.handlers.GeneralProductSupplementHandler;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class VoidingProductSupplementHandler
extends GeneralProductSupplementHandler {
    VoidingProductSupplementHandler() {
    }

    public double getPriority() {
        return 30.0;
    }

    public void populateSupplement(EntityContainer<BookingFile> ctr, BookingFileUIData supplement) {
        List products = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof ProductVoiding).map(prod -> this.createProductUIData((BookingFile)ctr.getEntity(), (ProductVoiding)prod)).collect(Collectors.toList());
        supplement.getProducts().addAll(products);
    }

    private VoidingProductUIData createProductUIData(BookingFile bookingFile, ProductVoiding product) {
        VoidingProductUIData uiData = new VoidingProductUIData();
        uiData.setRelatedProductUID(product.getUid());
        this.addBaseProductFields((BaseProductUIData)uiData, (BaseProduct)product, bookingFile);
        this.addCommissionsAndFops((BaseProductUIData)uiData, (BaseProduct)product);
        this.addContracts((BaseProductUIData)uiData, (BaseProduct)product);
        return uiData;
    }

    public void populateEntity(BookingFileUIData supplement, EntityContainer<BookingFile> ctr) {
        Map<String, BaseProduct> modelProducts = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(r -> r.getProducts().stream()).filter(product -> product instanceof ProductVoiding).collect(Collectors.toMap(BaseIdentity::getUid, product -> product));
        supplement.getProducts().forEach(product -> {
            if (product instanceof VoidingProductUIData && modelProducts.containsKey(product.getRelatedProductUID())) {
                this.saveData((ProductVoiding)modelProducts.get(product.getRelatedProductUID()), (VoidingProductUIData)product);
            }
        });
    }

    private void saveData(ProductVoiding product, VoidingProductUIData uiData) {
        this.saveContractRelations((BaseProduct)product, (BaseProductUIData)uiData);
        this.saveVendorFinanceDocumentsData((BaseProduct)product, (BaseProductUIData)uiData);
    }
}

