/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.supplements.helpers;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.uidata.SegmentUIData;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AirProductSupplementHelper {
    private static final List<String> CODE_SYSTEM_NAMES = Stream.of(CodeSystem.values()).map(Enum::name).collect(Collectors.toList());

    public static List<SegmentUIData> buildSegmentUIData(List<SegmentTariff> segmentTariffs) {
        ArrayList<SegmentUIData> data = new ArrayList<SegmentUIData>();
        for (SegmentTariff segmentTariff : segmentTariffs) {
            for (Segment segment : segmentTariff.getSegments()) {
                Airline airline;
                GeoLocation gl;
                SegmentUIData segmentData = new SegmentUIData();
                segmentData.setRelatedSegmentUID(segment.getUid());
                CodeSystem[] codeSystems = AirProductSupplementHelper.getSegmentCodeSystems(segment);
                if (segment.getArriveLocation() != null) {
                    gl = (GeoLocation)DictionaryCache.get().resolveReference(segment.getArriveLocation());
                    segmentData.setTo(AirProductSupplementHelper.toStringLocation(gl, codeSystems));
                }
                if (segment.getDepartureLocation() != null) {
                    gl = (GeoLocation)DictionaryCache.get().resolveReference(segment.getDepartureLocation());
                    segmentData.setFrom(AirProductSupplementHelper.toStringLocation(gl, codeSystems));
                }
                if (segment.getAirline() != null && (airline = (Airline)DictionaryCache.get().resolveReference(segment.getAirline())) != null) {
                    List<String> filteredVariants = AirProductSupplementHelper.filterCodeVariantsByEnum(airline.getCodeVariants(), CODE_SYSTEM_NAMES);
                    String codes = String.join((CharSequence)",", filteredVariants);
                    segmentData.setCarrierCodes(codes);
                }
                data.add(segmentData);
            }
        }
        return data;
    }

    public static Set<DictionaryReference<GeoLocation>> buildSegmentsLocations(Product product) {
        HashSet<DictionaryReference<GeoLocation>> allLocations = new HashSet<DictionaryReference<GeoLocation>>();
        List arriveLocations = product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).map(s -> {
            CodeSystem[] codeSystems = AirProductSupplementHelper.getSegmentCodeSystems(s);
            return AirProductSupplementHelper.transformLocationCaption((DictionaryReference<GeoLocation>)s.getArriveLocation(), codeSystems);
        }).collect(Collectors.toList());
        List departureLocations = product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).map(s -> {
            CodeSystem[] codeSystems = AirProductSupplementHelper.getSegmentCodeSystems(s);
            return AirProductSupplementHelper.transformLocationCaption((DictionaryReference<GeoLocation>)s.getDepartureLocation(), codeSystems);
        }).collect(Collectors.toList());
        allLocations.addAll(arriveLocations);
        allLocations.addAll(departureLocations);
        return allLocations;
    }

    private static CodeSystem[] getSegmentCodeSystems(Segment segment) {
        CodeSystem[] codeSystemArray;
        if (segment.getDefaultCodeSystem() == null) {
            CodeSystem[] codeSystemArray2 = new CodeSystem[4];
            codeSystemArray2[0] = CodeSystem.IATA;
            codeSystemArray2[1] = CodeSystem.ISO;
            codeSystemArray2[2] = CodeSystem.ISO_ALPHA3;
            codeSystemArray = codeSystemArray2;
            codeSystemArray2[3] = CodeSystem.CRT;
        } else {
            CodeSystem[] codeSystemArray3 = new CodeSystem[1];
            codeSystemArray = codeSystemArray3;
            codeSystemArray3[0] = segment.getDefaultCodeSystem();
        }
        return codeSystemArray;
    }

    private static DictionaryReference<GeoLocation> transformLocationCaption(DictionaryReference<GeoLocation> ref, CodeSystem[] codeSystems) {
        DictionaryCache dictCache = DictionaryCache.get();
        GeoLocation location = (GeoLocation)dictCache.resolveReference(ref);
        if (location == null) {
            return null;
        }
        GeoLocationReference reference = location.toReference();
        reference.setCaption(AirProductSupplementHelper.toStringLocation(location, codeSystems));
        return reference;
    }

    private static List<String> filterCodeVariantsByEnum(Map<String, String> variants, List<String> enumNames) {
        return variants.entrySet().stream().filter(entry -> enumNames.contains(entry.getKey())).map(entry -> (String)entry.getValue()).collect(Collectors.toList());
    }

    private static String toStringLocation(GeoLocation value, CodeSystem[] codeSystems) {
        Country country;
        GeoLocation parent;
        if (value == null) {
            return null;
        }
        String code = AirProductSupplementHelper.getCode((BaseDictionary)value, codeSystems);
        if (code == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(code);
        if (value.getType() == LocationType.AIRPORT && (parent = (GeoLocation)DictionaryCache.get().resolveReference(value.getParent())) != null) {
            sb.append(',').append(AirProductSupplementHelper.getCode((BaseDictionary)parent, codeSystems));
        }
        if ((country = (Country)DictionaryCache.get().resolveReference(value.getCountry())) != null) {
            sb.append(',').append(AirProductSupplementHelper.getCode((BaseDictionary)country, codeSystems));
        }
        return sb.toString();
    }

    private static String getCode(BaseDictionary value, CodeSystem[] codeSystems) {
        for (CodeSystem sys : codeSystems) {
            String code = (String)value.getCodeVariants().get(sys.name());
            if (code == null) continue;
            return code;
        }
        return value.getCode();
    }
}

