/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCode;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassOfServiceTable {
    public static final Map<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> TABLE = new ConcurrentHashMap<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService>(1024, 0.75f, 2);
    private static final Logger log = LoggerFactory.getLogger(ClassOfServiceTable.class);

    public static void fillTable(Map<MiscUtil.Pair<DictionaryReference<Airline>, String>, ClassOfService> data) {
        TABLE.putAll(data);
    }

    public static void cleanAll() {
        log.warn("CLEANUP SUBTASK: Do not run repeatedly!");
        Collection list = DictionaryCache.get().getAll(ClassOfServiceCode.class).values();
        for (ClassOfServiceCode code : list) {
            try {
                DictionaryStorage.get().delete((BaseDictionary)code);
            }
            catch (Exception e) {
                log.error(String.format("Error while cleaning up %s", code), (Throwable)e);
            }
        }
    }

    public static List<String> checkDuplicates() {
        Collection classOfServiceCodes = DictHelper.getAllClassOfServiceCodes();
        ArrayList<String> result = new ArrayList<String>(classOfServiceCodes.size());
        for (ClassOfServiceCode checkedClassOfServiceCode : classOfServiceCodes) {
            DictionaryReference checkedAirline = checkedClassOfServiceCode.getAirline();
            String checkedAirlineCode = checkedAirline == null ? null : checkedAirline.getCode();
            Set checkedBookingClasses = checkedClassOfServiceCode.getCodes();
            for (ClassOfServiceCode matchedClassOfServiceCode : classOfServiceCodes) {
                DictionaryReference matchedAirline;
                String matchedAirlineCode;
                if (matchedClassOfServiceCode == checkedClassOfServiceCode || !StringUtils.equals((String)(matchedAirlineCode = (matchedAirline = matchedClassOfServiceCode.getAirline()) == null ? null : matchedAirline.getCode()), (String)checkedAirlineCode)) continue;
                if (matchedClassOfServiceCode.getClassOfService() == checkedClassOfServiceCode.getClassOfService()) {
                    result.add(String.format("Service class %s is listed more than once for airline %s", checkedClassOfServiceCode.getClassOfService(), checkedAirlineCode));
                }
                Set matchedBookingClasses = matchedClassOfServiceCode.getCodes();
                for (String checkedBookingClass : checkedBookingClasses) {
                    if (!matchedBookingClasses.contains(checkedBookingClass)) continue;
                    result.add(String.format("Booking class %s for %s is both %s and %s", checkedBookingClass, checkedAirlineCode, checkedClassOfServiceCode.getClassOfService(), matchedClassOfServiceCode.getClassOfService()));
                }
            }
        }
        return result;
    }
}

