/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class GDSRepriceHelper {
    public static Product findProduct(Reservation res, MiscUtil.Pair<Traveller, DictionaryReference<PassengerType>> pair) {
        return (Product)CollectionUtil.find(GDSHelper.getProducts(res), pair, (CollectionUtil.Equator)new CollectionUtil.Equator<Product, MiscUtil.Pair<Traveller, DictionaryReference<PassengerType>>>(){

            public boolean equal(Product p, MiscUtil.Pair<Traveller, DictionaryReference<PassengerType>> psgrInfo) {
                return GDSRepriceHelper.sameTraveller((MiscUtil.Pair<Traveller, DictionaryReference<PassengerType>>)new MiscUtil.Pair((Object)p.getTraveller(), (Object)p.getPassengerType()), psgrInfo);
            }
        });
    }

    static boolean sameTraveller(MiscUtil.Pair<Traveller, DictionaryReference<PassengerType>> pair, MiscUtil.Pair<Traveller, DictionaryReference<PassengerType>> pair2) {
        Traveller t1 = (Traveller)pair.getFirst();
        Traveller t2 = (Traveller)pair2.getFirst();
        DictionaryReference pt1 = (DictionaryReference)pair.getSecond();
        DictionaryReference pt2 = (DictionaryReference)pair2.getSecond();
        return GDSRepriceHelper.sameText(t1.getPassport().getFirstName(), t2.getPassport().getFirstName()) && GDSRepriceHelper.sameText(t1.getPassport().getLastName(), t2.getPassport().getLastName()) && GDSRepriceHelper.sameText(t1.getPassport().getMiddleName(), t2.getPassport().getMiddleName()) && GDSRepriceHelper.weakEquals(t1.getGender(), t2.getGender()) && GDSRepriceHelper.weakEquals(pt1, pt2);
    }

    private static boolean sameText(String s1, String s2) {
        String localS1 = GDSRepriceHelper.xform(s1);
        String localS2 = GDSRepriceHelper.xform(s2);
        int minLength = Math.min(localS1.length(), localS2.length());
        localS1 = localS1.substring(0, minLength);
        localS2 = localS2.substring(0, minLength);
        return localS1.equalsIgnoreCase(localS2);
    }

    private static boolean weakEquals(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return true;
        }
        return o1.equals(o2);
    }

    private static String xform(String s) {
        return TextUtil.nonNullStr((String)s).trim().toUpperCase(Locale.ENGLISH).replace(" ", "").replace("-", "");
    }

    public static boolean isSameTaxes(List<Tax> taxes, List<Tax> taxes2) {
        if (taxes.size() != taxes2.size()) {
            return false;
        }
        CollectionUtil.Equator<Tax, Tax> eq = new CollectionUtil.Equator<Tax, Tax>(){

            public boolean equal(Tax o1, Tax o2) {
                if (MiscUtil.equals((Object)o1.getCode(), (Object)o2.getCode())) {
                    BigDecimal ta = o1.getEquivalentAmount();
                    BigDecimal ta2 = o2.getEquivalentAmount();
                    return ((BigDecimal)MiscUtil.guarded((Object)ta, (Object)BigDecimal.ZERO)).compareTo((BigDecimal)MiscUtil.guarded((Object)ta2, (Object)BigDecimal.ZERO)) == 0;
                }
                return false;
            }
        };
        return CollectionUtil.sameCollections(taxes, taxes2, (CollectionUtil.Equator)eq);
    }

    public static ProductFare getFare(Product product) {
        for (ProductFare fare : product.getFares()) {
            if (fare.getSegmentTariff() != null) continue;
            return fare;
        }
        ProductFare result = new ProductFare();
        product.getFares().add(result);
        return result;
    }

    public static String productTitle(Product product) {
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            return product.getSystemNumber();
        }
        if (product.getTraveller() != null && !TextUtil.isBlank((String)product.getTraveller().getName())) {
            return product.getTraveller().getName();
        }
        return product.getUid();
    }

    public static BigDecimal getTotal(Product prod) {
        BigDecimal result = BigDecimal.ZERO;
        result = result.add((BigDecimal)MiscUtil.guarded((Object)GDSRepriceHelper.getEquivalentFare(prod), (Object)BigDecimal.ZERO));
        for (Tax tax : prod.getTaxes()) {
            result = result.add((BigDecimal)MiscUtil.guarded((Object)tax.getEquivalentAmount(), (Object)BigDecimal.ZERO));
        }
        return result;
    }

    public static BigDecimal getEquivalentFare(Product product) {
        List fares = product.getFares();
        if (fares.isEmpty()) {
            return null;
        }
        BigDecimal segmentResult = null;
        BigDecimal productResult = null;
        for (ProductFare fare : fares) {
            BigDecimal equivalentFare = fare.getEquivalentFare();
            if (equivalentFare == null) continue;
            if (fare.getSegmentTariff() == null) {
                productResult = productResult != null ? productResult.add(equivalentFare) : equivalentFare;
                continue;
            }
            segmentResult = segmentResult != null ? segmentResult.add(equivalentFare) : equivalentFare;
        }
        return productResult != null ? productResult : segmentResult;
    }

    public static BigDecimal getBaseTotal(Product prod) {
        BigDecimal result = BigDecimal.ZERO;
        result = result.add((BigDecimal)MiscUtil.guarded((Object)GDSRepriceHelper.getBaseFare(prod), (Object)BigDecimal.ZERO));
        result = result.add((BigDecimal)MiscUtil.guarded((Object)GDSRepriceHelper.getBaseTax(prod), (Object)BigDecimal.ZERO));
        return result;
    }

    public static BigDecimal getEquivalentTax(Product prod) {
        return prod.getTaxes().stream().map(Tax::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static BigDecimal getBaseTax(Product prod) {
        return GDSRepriceHelper.getBaseTax(prod, prod.getGdsCurrency());
    }

    public static BigDecimal getBaseTax(Product prod, String gdsCurrency) {
        BigDecimal result = BigDecimal.ZERO;
        for (Tax tax : prod.getTaxes()) {
            if (!gdsCurrency.equals(tax.getAmount().getCurrency())) {
                throw new RuntimeException(String.format("base currency of tax %s (%s) differs from reservation system currency of product %s (%s)", tax.getCode(), tax.getAmount().getCurrency(), AirProductHelper.getProductTitle((Product)prod), gdsCurrency));
            }
            result = result.add((BigDecimal)MiscUtil.guarded((Object)tax.getAmount().getValue(), (Object)BigDecimal.ZERO));
        }
        return result;
    }

    public static BigDecimal getBaseFare(Product product) {
        return GDSRepriceHelper.getBaseFare(product, product.getGdsCurrency());
    }

    public static BigDecimal getBaseFare(Product product, String gdsCurrency) {
        List fares = product.getFares();
        if (fares.isEmpty()) {
            return null;
        }
        BigDecimal segmentResult = null;
        BigDecimal productResult = null;
        for (ProductFare fare : fares) {
            if (!gdsCurrency.equals(fare.getBaseFare().getCurrency())) {
                throw new RuntimeException("invalid base currency");
            }
            BigDecimal amount = fare.getBaseFare().getValue();
            if (amount == null) continue;
            if (fare.getSegmentTariff() == null) {
                productResult = productResult != null ? productResult.add(amount) : amount;
                continue;
            }
            segmentResult = segmentResult != null ? segmentResult.add(amount) : amount;
        }
        return productResult != null ? productResult : segmentResult;
    }

    public static void updateAndCheckProductPrices(Product prod, UpdateProductPrices productUpdater, List<Message> messages) throws Exception {
        BigDecimal oldEF = MiscUtil.guarded((BigDecimal)GDSRepriceHelper.getEquivalentFare(prod));
        ArrayList<Tax> oldTaxes = new ArrayList<Tax>(prod.getTaxes());
        BigDecimal oldTotal = MiscUtil.guarded((BigDecimal)GDSRepriceHelper.getTotal(prod));
        prod.getFares().clear();
        prod.getTaxes().clear();
        productUpdater.process(prod);
        BigDecimal newEF = MiscUtil.guarded((BigDecimal)GDSRepriceHelper.getEquivalentFare(prod));
        ArrayList<Tax> newTaxes = new ArrayList<Tax>(prod.getTaxes());
        BigDecimal newTotal = MiscUtil.guarded((BigDecimal)GDSRepriceHelper.getTotal(prod));
        if (!(oldEF.equals(newEF) && GDSRepriceHelper.isSameTaxes(oldTaxes, newTaxes) || oldTotal.equals(newTotal))) {
            BigDecimal hiddenFee = GDSRepriceHelper.getHiddenFee(prod);
            prod.setContractRulesApplied(false);
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043f\u043e\u043b\u043d\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u0431\u0438\u043b\u0435\u0442\u0430 {0}, \u0446\u0435\u043d\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0430 \u0441 {1} \u043d\u0430 {2}", (Object[])new Object[]{GDSRepriceHelper.productTitle(prod), oldTotal.add(hiddenFee), newTotal.add(hiddenFee)}));
        }
    }

    public static BigDecimal getHiddenFee(Product product) {
        ProductHandler handler = HandlersRegistry.get().findProductHandler(Product.class);
        List relations = handler.getUnmodifiableContractRelations((BaseProduct)product);
        return GeneralProductHelper.calculateHiddenFeesEquivalentValue((Collection)((GeneralProductContractRelationData)relations.get(relations.size() - 1)).getCommissions());
    }

    public static class ProductKey {
        private final Product product;

        public ProductKey(Product prod) {
            this.product = prod;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ProductKey)) {
                return false;
            }
            ProductKey other = (ProductKey)obj;
            return GDSRepriceHelper.sameTraveller((MiscUtil.Pair<Traveller, DictionaryReference<PassengerType>>)new MiscUtil.Pair((Object)other.product.getTraveller(), (Object)other.product.getPassengerType()), (MiscUtil.Pair<Traveller, DictionaryReference<PassengerType>>)new MiscUtil.Pair((Object)this.product.getTraveller(), (Object)this.product.getPassengerType()));
        }

        public Product getProduct() {
            return this.product;
        }
    }

    public static class ProductPriceState {
        private final BigDecimal equivalentFare;
        private final List<MiscUtil.Pair<String, BigDecimal>> taxes = new ArrayList<MiscUtil.Pair<String, BigDecimal>>();
        private final BigDecimal total;

        public ProductPriceState(Product product) {
            this.equivalentFare = GDSRepriceHelper.getFare(product).getEquivalentFare();
            for (Tax tax : product.getTaxes()) {
                this.taxes.add((MiscUtil.Pair<String, BigDecimal>)new MiscUtil.Pair((Object)tax.getCode(), (Object)tax.getEquivalentAmount()));
            }
            this.total = GDSRepriceHelper.getTotal(product);
        }

        public BigDecimal getTotal() {
            return this.total;
        }

        public int hashCode() {
            return 765 * this.equivalentFare.hashCode() + 81 * this.taxes.hashCode() + 9841;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ProductPriceState)) {
                return false;
            }
            ProductPriceState other = (ProductPriceState)obj;
            return MiscUtil.equals((Object)this.equivalentFare, (Object)other.equivalentFare) && CollectionUtil.equals(this.taxes, other.taxes, (boolean)true);
        }
    }

    public static interface UpdateProductPrices {
        public void process(Product var1) throws Exception;
    }
}

