/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.bookability;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsBookabilityItem;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdsBookability {
    private static final transient Logger log = LoggerFactory.getLogger(GdsBookability.class);

    public static GdsBookabilityItem buildBookabilityItem(Flight flight, String description) {
        ArrayList<FlightSegment> segments = new ArrayList<FlightSegment>();
        for (FlightSegmentTariff tariff : flight.getSegmentTariffs()) {
            for (FlightSegment segment : tariff.getSegments()) {
                segments.add(segment);
            }
        }
        FlightSegment segment = null;
        if (segments.size() == 1) {
            segment = (FlightSegment)segments.get(0);
        }
        return GdsBookability.buildBookabilityItem(flight, segment, description);
    }

    public static GdsBookabilityItem buildBookabilityItem(Flight flight, FlightSegment segment, String description) {
        byte[] flightData = GdsBookability.getFlightData(flight);
        GdsName gds = flight.getGds();
        int seatsCount = GDSHelper.getTotalSeats(flight.getSeats());
        Set<DictionaryReference<PassengerType>> passengerTypes = GDSHelper.getPassengerTypes(flight.getSeats());
        GdsBookabilityItem bookabilityItem = new GdsBookabilityItem();
        bookabilityItem.setFlightData(flightData);
        bookabilityItem.setGds(gds);
        if (segment != null) {
            bookabilityItem.setAirline(segment.getAirline());
            bookabilityItem.setArrivalLocation(segment.getLocationEnd());
            bookabilityItem.setDepartureLocation(segment.getLocationBegin());
            bookabilityItem.setFlightNumber(segment.getFlightNumber());
            bookabilityItem.setDateBegin(segment.getDateBegin());
            bookabilityItem.setDateEnd(segment.getDateEnd());
            bookabilityItem.setBookingClass(segment.getBookingClass());
        }
        bookabilityItem.setDescription(description);
        bookabilityItem.setDate(new Date());
        bookabilityItem.setSeatsCount(Integer.valueOf(seatsCount));
        bookabilityItem.getPassengerTypes().addAll(passengerTypes);
        return bookabilityItem;
    }

    public static byte[] getFlightData(Flight flight) {
        if (flight == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XUtil.serialize((XSerializable)flight, (OutputStream)baos);
        }
        catch (Exception ex) {
            log.error("buildBookabilityItem failed", (Throwable)ex);
        }
        return baos.toByteArray();
    }
}

