/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.corp;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.server.gds.corp.AFS;
import com.gridnine.xtrip.server.gds.corp.FlightAFS;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;

public abstract class AbstractAFS<T>
implements AFS<T> {
    protected static final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.IATA.name()});
    private static final Map<AFSType, FlightAFS> flightAfsMap = new EnumMap<AFSType, FlightAFS>(AFSType.class);

    public static <T> AFS<T> getAFS(AFSType type, GdsName gdsName) {
        throw new NotImplementedException("Not yet implemented!");
    }

    public static <T> FlightAFS<T> getFlightAFS(AFSType type) {
        FlightAFS result = flightAfsMap.get(type);
        return result;
    }

    static {
        flightAfsMap.put(AFSType.DEST, new DEST());
        flightAfsMap.put(AFSType.OCCL, new OCCL());
        flightAfsMap.put(AFSType.VALC, new VALC());
        flightAfsMap.put(AFSType.ATF1, new ATF1());
        flightAfsMap.put(AFSType.ATF2, new ATF2());
    }

    public static class ATF2
    implements FlightAFS<Double> {
        @Override
        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setAtf2Tkt(value);
            } else {
                statData.setAtf2Bkg(value);
            }
        }

        @Override
        public Double getStatisticalValue(Flight flight) {
            DictionaryReference adultType = DictHelper.getAdultPassengerType();
            double value = FlightHelper.getEquivalentFare((Flight)flight, (DictionaryReference)adultType).doubleValue();
            return (value += FlightHelper.getEquivalentTaxSum((Flight)flight, (DictionaryReference)adultType).doubleValue()) <= 0.0 ? null : Double.valueOf(value);
        }

        @Override
        public AFSType getAFSType() {
            return AFSType.ATF2;
        }

        @Override
        public Double fromString(String stringValue) {
            return Double.valueOf(stringValue);
        }

        @Override
        public String convertToString(Double value) {
            return value.toString();
        }
    }

    public static class ATF1
    implements FlightAFS<Double> {
        @Override
        public AFSType getAFSType() {
            return AFSType.ATF1;
        }

        @Override
        public void saveValueToMOM(Double value, StatisticalData statData, boolean isTicketing) {
            if (isTicketing) {
                statData.setAtf1Tkt(value);
            } else {
                statData.setAtf1Bkg(value);
            }
        }

        @Override
        public Double getStatisticalValue(Flight flight) {
            double value = FlightHelper.getEquivalentFare((Flight)flight, (DictionaryReference)DictHelper.getAdultPassengerType()).doubleValue();
            return value <= 0.0 ? null : Double.valueOf(value);
        }

        @Override
        public Double fromString(String stringValue) {
            return Double.valueOf(stringValue);
        }

        @Override
        public String convertToString(Double value) {
            return value.toString();
        }
    }

    public static class DEST
    implements FlightAFS<DictionaryReference<GeoLocation>> {
        @Override
        public void saveValueToMOM(DictionaryReference<GeoLocation> value, StatisticalData statData, boolean isTicketing) {
            statData.setOverallDestination(value);
        }

        @Override
        public DictionaryReference<GeoLocation> getStatisticalValue(Flight flight) {
            DictionaryReference farthestLocationRef = FlightHelper.getFinalDestinationLocationRef((Flight)flight);
            if (farthestLocationRef == null) {
                return null;
            }
            return farthestLocationRef;
        }

        @Override
        public AFSType getAFSType() {
            return AFSType.DEST;
        }

        @Override
        public DictionaryReference<GeoLocation> fromString(String stringValue) {
            throw Xeption.forDeveloper((String)"Creating DEST AFS from String is not supported yet", (Object[])new Object[0]);
        }

        @Override
        public String convertToString(DictionaryReference<GeoLocation> value) {
            return codeTranslator.getNativeCode(value);
        }
    }

    public static class VALC
    implements FlightAFS<DictionaryReference<Airline>> {
        @Override
        public AFSType getAFSType() {
            return AFSType.VALC;
        }

        @Override
        public void saveValueToMOM(DictionaryReference<Airline> value, StatisticalData statData, boolean isTicketing) {
            if (!isTicketing) {
                statData.setValidatingCarrier(value);
            }
        }

        @Override
        public DictionaryReference<Airline> getStatisticalValue(Flight flight) {
            DictionaryReference validatingCarrierRef = flight.getCarrier();
            if (validatingCarrierRef == null) {
                return null;
            }
            return validatingCarrierRef;
        }

        @Override
        public String convertToString(DictionaryReference<Airline> value) {
            return value.getCode();
        }

        @Override
        public DictionaryReference<Airline> fromString(String stringValue) {
            throw Xeption.forDeveloper((String)"Creating VALC AFS from String is not supported yet", (Object[])new Object[0]);
        }
    }

    public static class OCCL
    implements FlightAFS<String> {
        @Override
        public void saveValueToMOM(String value, StatisticalData statData, boolean isTicketing) {
            if (!isTicketing) {
                statData.setOverallClassService(value);
            }
        }

        @Override
        public String getStatisticalValue(Flight flight) {
            String result;
            ClassOfService overallClass = null;
            block6: for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
                for (FlightSegment fs : fst.getSegments()) {
                    ClassOfService segmentClass = FlightHelper.getClassOfService((FlightSegment)fs);
                    if (overallClass == null) {
                        overallClass = segmentClass;
                        continue;
                    }
                    if (segmentClass == null || segmentClass.equals((Object)overallClass)) continue;
                    overallClass = null;
                    result = "X";
                    break block6;
                }
            }
            if (overallClass != null) {
                switch (overallClass) {
                    case ECONOMY: {
                        result = "Y";
                        break;
                    }
                    case PREMIUM: {
                        result = "W";
                        break;
                    }
                    case BUSINESS: {
                        result = "C";
                        break;
                    }
                    case FIRST: {
                        result = "F";
                        break;
                    }
                    default: {
                        result = null;
                        break;
                    }
                }
            } else {
                result = null;
            }
            return result;
        }

        @Override
        public AFSType getAFSType() {
            return AFSType.OCCL;
        }

        @Override
        public String fromString(String stringValue) {
            return stringValue;
        }

        @Override
        public String convertToString(String value) {
            return value;
        }
    }
}

