/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.db.update;

import com.gridnine.xtrip.common.gds.model.CommonAirlineSettings;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineFilteringCategories;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineRulesHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;

public abstract class BaseCommonRulesMigrationHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        EntityContainer<SalesPoint> salesPointCtr = this.getMainSalesPointContainer();
        EntityContainer settingsCtr = CommonAirlineRulesHelper.getCommonAirlineSettingsContainer();
        this.copy(((SalesPoint)salesPointCtr.getEntity()).getRuleSet(), ((CommonAirlineSettings)settingsCtr.getEntity()).getRuleSet());
        settingsCtr.getVersionInfo().setDataSource(MiscUtil.getSimpleClassName(this.getClass()));
        EntityStorage.get().save(settingsCtr, true);
        for (SalesPointIndex idx : EntityStorage.get().search(SalesPointIndex.class, new SearchQuery()).getData()) {
            EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
            this.remove(((SalesPoint)ctr.getEntity()).getRuleSet());
            ctr.getVersionInfo().setDataSource(MiscUtil.getSimpleClassName(this.getClass()));
            EntityStorage.get().save(ctr, true);
        }
    }

    protected abstract EntityContainer<SalesPoint> getMainSalesPointContainer();

    protected Set<String> getMigratingFilteringCategories() {
        HashSet<String> result = new HashSet<String>();
        result.add(CommonAirlineFilteringCategories.DOCO_DOCA.getId());
        result.add(CommonAirlineFilteringCategories.VOID_SETTINGS.getId());
        result.add(CommonAirlineFilteringCategories.FOID.getId());
        return result;
    }

    protected void copy(RuleSet from, RuleSet to) {
        if (from == null) {
            return;
        }
        Set<String> categories = this.getMigratingFilteringCategories();
        for (RuleSettings rs : from.getRules()) {
            if (rs.getFilteringCategory() == null || !categories.contains(rs.getFilteringCategory().getId())) continue;
            to.getRules().add(rs);
        }
    }

    protected void remove(RuleSet rules) {
        if (rules == null) {
            return;
        }
        Set<String> categories = this.getMigratingFilteringCategories();
        Iterator iter = rules.getRules().iterator();
        while (iter.hasNext()) {
            RuleSettings rs = (RuleSettings)iter.next();
            if (rs.getFilteringCategory() == null || !categories.contains(rs.getFilteringCategory().getId())) continue;
            iter.remove();
        }
    }
}

