/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.db.update;

import com.gridnine.xtrip.common.gds.model.BrandedFareInformation;
import com.gridnine.xtrip.common.gds.model.BrandedFareInformationIndex;
import com.gridnine.xtrip.common.gds.model.CommonAirlineSettings;
import com.gridnine.xtrip.common.gds.rules.airline.BrandedFaresActions;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineFilteringCategories;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineRulesHelper;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineTargets;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class BrandedFaresMigrationHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        EntityContainer ctr = CommonAirlineRulesHelper.getCommonAirlineSettingsContainer();
        SearchQuery query = new SearchQuery();
        for (BrandedFareInformationIndex idx : EntityStorage.get().search(BrandedFareInformationIndex.class, query).getData()) {
            RuleRestriction rr;
            BrandedFareInformation bfi = (BrandedFareInformation)EntityStorage.get().resolve(idx.getSource()).getEntity();
            RuleSettings rs = new RuleSettings();
            rs.setTarget((RuleTarget)CommonAirlineTargets.AIRLINE_RULES);
            rs.setName(String.format("%s / %s", bfi.getCarrier(), bfi.getName()));
            rs.setFilteringCategory((RuleFilteringCategory)CommonAirlineFilteringCategories.BRANDED_FARES);
            if (bfi.getCarrier() != null) {
                rr = new RuleRestriction();
                rr.setProperty((RuleProperty)Properties.CARRIERS);
                rr.setCondition((RuleCondition)Conditions.INCLUDE);
                rr.setValue((Object)bfi.getCarrier().getCode());
                rs.getRestrictions().add(rr);
            }
            if (!bfi.getBookingClasses().isEmpty()) {
                rr = new RuleRestriction();
                rr.setProperty((RuleProperty)Properties.BOOKING_CLASSES);
                rr.setCondition((RuleCondition)Conditions.INCLUDE);
                rr.setValue((Object)CollectionUtil.collectionToString((Iterable)bfi.getBookingClasses(), (String)",", (boolean)true));
                rs.getRestrictions().add(rr);
            }
            if (!bfi.getFareBasisPatterns().isEmpty()) {
                rr = new RuleRestriction();
                rr.setProperty((RuleProperty)Properties.FARE_BASIS);
                rr.setCondition((RuleCondition)Conditions.INCLUDE);
                rr.setValue((Object)CollectionUtil.collectionToString((Iterable)bfi.getFareBasisPatterns(), (String)",", (boolean)true));
                rs.getRestrictions().add(rr);
            }
            if (!StringUtils.isBlank((String)bfi.getName())) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.BRAND_NAME);
                rr.setValue((Object)bfi.getName());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getLuggageInfo() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.LUGGAGE_INFO);
                rr.setValue((Object)bfi.getDetails().getLuggageInfo());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getPaidLuggageInfo() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.PAID_LUGGAGE_INFO);
                rr.setValue((Object)bfi.getDetails().getPaidLuggageInfo());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getPaidLuggagePrice() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.PAID_LUGGAGE_PRICE);
                rr.setValue((Object)bfi.getDetails().getPaidLuggagePrice());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getCabinLuggageInfo() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.CABIN_LUGGAGE_INFO);
                rr.setValue((Object)bfi.getDetails().getCabinLuggageInfo());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getPaidCabinLuggageInfo() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.PAID_CABIN_LUGGAGE_INFO);
                rr.setValue((Object)bfi.getDetails().getPaidCabinLuggageInfo());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getPaidCabinLuggagePrice() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.PAID_CABIN_LUGGAGE_PRICE);
                rr.setValue((Object)bfi.getDetails().getPaidCabinLuggagePrice());
                rs.getResults().add(rr);
            }
            if (bfi.getPenaltiesInfo().getRefundableBeforeDeparture() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.REFUNDABLE_BEFORE_DEPARTURE_SEGMENT);
                rr.setValue((Object)bfi.getPenaltiesInfo().getRefundableBeforeDeparture());
                rs.getResults().add(rr);
            }
            if (bfi.getPenaltiesInfo().getRefundableAfterDeparture() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.REFUNDABLE_AFTER_DEPARTURE_SEGMENT);
                rr.setValue((Object)bfi.getPenaltiesInfo().getRefundableAfterDeparture());
                rs.getResults().add(rr);
            }
            if (bfi.getPenaltiesInfo().getExchangableBeforeDeparture() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.EXCHANGABLE_BEFORE_DEPARTURE_SEGMENT);
                rr.setValue((Object)bfi.getPenaltiesInfo().getExchangableBeforeDeparture());
                rs.getResults().add(rr);
            }
            if (bfi.getPenaltiesInfo().getExchangableAfterDeparture() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.EXCHANGABLE_AFTER_DEPARTURE_SEGMENT);
                rr.setValue((Object)bfi.getPenaltiesInfo().getExchangableAfterDeparture());
                rs.getResults().add(rr);
            }
            if (bfi.getPenaltiesInfo().getRefundBeforeDeparture() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.REFUND_BEFORE_DEPARTURE_SEGMENT);
                rr.setValue((Object)bfi.getPenaltiesInfo().getRefundBeforeDeparture());
                rs.getResults().add(rr);
            }
            if (bfi.getPenaltiesInfo().getRefundAfterDeparture() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.REFUND_AFTER_DEPARTURE_SEGMENT);
                rr.setValue((Object)bfi.getPenaltiesInfo().getRefundAfterDeparture());
                rs.getResults().add(rr);
            }
            if (bfi.getPenaltiesInfo().getExchangeBeforeDeparture() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.EXCHANGE_BEFORE_DEPARTURE_SEGMENT);
                rr.setValue((Object)bfi.getPenaltiesInfo().getExchangeBeforeDeparture());
                rs.getResults().add(rr);
            }
            if (bfi.getPenaltiesInfo().getExchangeAfterDeparture() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.EXCHANGE_AFTER_DEPARTURE_SEGMENT);
                rr.setValue((Object)bfi.getPenaltiesInfo().getExchangeAfterDeparture());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getMealService() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.MEAL_SERVICE);
                rr.setValue((Object)bfi.getDetails().getMealService());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getBusinessLoungeAccess() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.BUSINESS_LOUNGE_ACCESS);
                rr.setValue((Object)bfi.getDetails().getBusinessLoungeAccess());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getClassUpgradeAvailable() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.CLASS_UPGRADE_AVAILABLE);
                rr.setValue((Object)bfi.getDetails().getClassUpgradeAvailable());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getExtraMileageBonus() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.EXTRA_MILEAGE_BONUS);
                rr.setValue((Object)bfi.getDetails().getExtraMileageBonus());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getPriorityBoarding() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.PRIORITY_BOARDING);
                rr.setValue((Object)bfi.getDetails().getPriorityBoarding());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getSeatChoice() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.SEAT_CHOICE);
                rr.setValue((Object)bfi.getDetails().getSeatChoice());
                rs.getResults().add(rr);
            }
            if (bfi.getDetails().getTransferIncluded() != null) {
                rr = new RuleResult();
                rr.setAction((RuleAction)BrandedFaresActions.TRANSFER_INCLUDED);
                rr.setValue((Object)bfi.getDetails().getTransferIncluded());
                rs.getResults().add(rr);
            }
            ((CommonAirlineSettings)ctr.getEntity()).getRuleSet().getRules().add(rs);
        }
        ctr.getVersionInfo().setDataSource("migration");
        EntityStorage.get().save(ctr, true);
    }
}

