/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.helper;

import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BookingServiceHelper {
    public static void updateProducts(Reservation reservation, SalesContext salesContext, Fop fop) throws Exception {
        for (Product product : GDSHelper.getProducts(reservation)) {
            for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)product)) {
                ContractType ctype = GeneralProductHelper.getContractType((EntityReference)item.getDescription());
                if (ctype == ContractType.VENDOR) continue;
                for (ProductFop prodFop : item.getFops()) {
                    prodFop.setAgent(salesContext.getAgent());
                    prodFop.setType(fop.getType());
                    prodFop.setCard((Card)XCloneHelper.clone((XCloneable)fop.getCard(), (boolean)true));
                    prodFop.setOperationDate(new Date());
                }
            }
            ProductFop prodFop = new ProductFop();
            prodFop.setAgent(salesContext.getAgent());
            prodFop.setType(fop.getType());
            Money amount = new Money();
            amount.setCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)null));
            amount.setValue(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.VENDOR).getTotal());
            prodFop.setAmount(amount);
            prodFop.setOperationDate(new Date());
            AirProductHelper.addFopToAllContractRelations((Product)product, (ProductFop)prodFop);
            List vendorFops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
            ProductFop lastVendorFop = (ProductFop)vendorFops.get(vendorFops.size() - 1);
            lastVendorFop.setType(PaymentType.INVOICE);
            lastVendorFop.setCard(null);
        }
    }

    public static Payment findPayment(BookingFile bf) {
        for (Payment payment : bf.getPayments()) {
            if (payment.isCanceled()) continue;
            return payment;
        }
        return null;
    }

    public static EntityContainer<BookingFile> selectFOP(EntityContainer<BookingFile> bfCtr, Fop fop, List<Message> result) throws Exception {
        HashSet messages = new HashSet();
        Payment payment = null;
        for (Payment pmt : ((BookingFile)bfCtr.getEntity()).getPayments()) {
            if (pmt.isCanceled()) continue;
            payment = pmt;
            break;
        }
        if (payment == null) {
            Set products = FinanceDocumentsHelper.getProductsForPayment((BookingFile)((BookingFile)bfCtr.getEntity()), (boolean)true);
            payment = FinanceDocumentsHelper.addPayment((Collection)products, (List)FinanceDocumentsHelper.getAppropriateFinanceDocuments((Collection)products, (List)FinanceDocumentsHelper.getAllFinanceDocuments(messages)), messages);
            result.addAll(messages);
            if (payment == null) {
                result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0441\u0447\u0435\u0442 \u043d\u0435 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d", (Object[])new Object[0]));
                return bfCtr;
            }
        }
        payment.setFop((Fop)XCloneHelper.clone((XCloneable)fop, (boolean)true));
        bfCtr.getVersionInfo().setDataSource("web");
        return EntityStorage.get().save(bfCtr, true);
    }
}

