/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.helper;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FrequentTravellerAgreements;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequentFlyerHelper {
    private static final Logger log = LoggerFactory.getLogger(FrequentFlyerHelper.class);

    public static boolean isSameAirline(DictionaryReference<Airline> segAirlineRef, DictionaryReference<Airline> bonusAirlineRef) {
        return bonusAirlineRef != null && bonusAirlineRef.equals(segAirlineRef);
    }

    private static DictionaryReference<AirlineAlliance> getAirlineAllianceRef(DictionaryReference<Airline> airlineRef) {
        Airline airline = (Airline)DictionaryCache.get().resolveReference(airlineRef);
        if (airline == null) {
            return null;
        }
        return airline.getAlliance();
    }

    public static boolean isSameAlliance(DictionaryReference<Airline> segAirlineRef, DictionaryReference<Airline> bonusAirlineRef) {
        DictionaryReference<AirlineAlliance> segAllianceRef;
        DictionaryReference<AirlineAlliance> bonusCardAllianceRef = FrequentFlyerHelper.getAirlineAllianceRef(bonusAirlineRef);
        return bonusCardAllianceRef != null && bonusCardAllianceRef.equals(segAllianceRef = FrequentFlyerHelper.getAirlineAllianceRef(segAirlineRef));
    }

    private static Collection<FrequentTravellerAgreements> getPartnerAgreements(DictionaryReference<Airline> bonusAirlineRef) {
        Airline bonusAirline = (Airline)DictionaryCache.get().resolveReference(bonusAirlineRef);
        return bonusAirline == null ? Collections.emptyList() : DictionaryCache.get().search(FrequentTravellerAgreements.class, DictSearchCriterion.eq((String)FrequentTravellerAgreements.Property.owningCarrier.name(), (Object)bonusAirline.toReference()));
    }

    public static Collection<FrequentTravellerAgreements> getSegmentPartnerAgreements(DictionaryReference<Airline> segmentAirlineRef) {
        return DictionaryCache.get().search(FrequentTravellerAgreements.class, DictSearchCriterion.eq((String)FrequentTravellerAgreements.Property.receivingCarrier.name(), segmentAirlineRef));
    }

    private static boolean isPartnerAirline(DictionaryReference<Airline> segAirlineRef, Collection<FrequentTravellerAgreements> partnerAgreements) {
        for (FrequentTravellerAgreements fta : partnerAgreements) {
            if (!segAirlineRef.equals((Object)fta.getReceivingCarrier())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPartnerAirline(DictionaryReference<Airline> segAirlineRef, DictionaryReference<Airline> bonusAirlineRef) {
        return FrequentFlyerHelper.isPartnerAirline(segAirlineRef, FrequentFlyerHelper.getPartnerAgreements(bonusAirlineRef));
    }

    public static AirlineBonusCard getMostAppropriateBonusCard(Flight flight, List<AirlineBonusCard> bonusCards, boolean considerAlliances, boolean considerPartners, boolean considerCardsWithOnlyPartnerFlights) {
        List<AirlineBonusCard> applicableCards = FrequentFlyerHelper.getApplicableBonusCards(flight, bonusCards, considerAlliances, considerPartners, considerCardsWithOnlyPartnerFlights);
        if (applicableCards.isEmpty()) {
            return null;
        }
        return applicableCards.get(0);
    }

    @Deprecated
    public static List<AirlineBonusCard> getOrderedAppropriateBonusCards(Flight flight, List<AirlineBonusCard> bonusCards, boolean considerAlliances, boolean considerPartners, boolean considerCardsWithOnlyPartnerFlights) {
        return FrequentFlyerHelper.getApplicableBonusCards(flight, bonusCards, considerAlliances, considerPartners, considerCardsWithOnlyPartnerFlights);
    }

    public static boolean isApplicableBonusCard(Flight flight, AirlineBonusCard bonusCard, boolean considerAlliances, boolean considerPartners) {
        return FrequentFlyerHelper.isApplicableBonusCard(flight, bonusCard, considerAlliances, considerPartners, false);
    }

    public static boolean isApplicableBonusCard(Flight flight, AirlineBonusCard bonusCard, boolean considerAlliances, boolean considerPartners, boolean considerOperatingCarrier) {
        DictionaryReference bonusAirlineRef = bonusCard.getAirline();
        List<FrequentTravellerAgreements> partnerAgreements = considerPartners ? FrequentFlyerHelper.getPartnerAgreements((DictionaryReference<Airline>)bonusAirlineRef) : Collections.emptyList();
        DictionaryReference prevAirlineRef = null;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                DictionaryReference segOperatingAirlineRef;
                DictionaryReference segMarketingAirlineRef = fs.getAirline();
                if (prevAirlineRef != null && prevAirlineRef.equals((Object)segMarketingAirlineRef)) continue;
                if (FrequentFlyerHelper.isApplicableAirlineRef((DictionaryReference<Airline>)segMarketingAirlineRef, (DictionaryReference<Airline>)bonusAirlineRef, partnerAgreements, considerAlliances)) {
                    return true;
                }
                if (considerOperatingCarrier && !segMarketingAirlineRef.equals((Object)(segOperatingAirlineRef = fs.getOperatingAirline())) && FrequentFlyerHelper.isApplicableAirlineRef((DictionaryReference<Airline>)segOperatingAirlineRef, (DictionaryReference<Airline>)bonusAirlineRef, partnerAgreements, considerAlliances)) {
                    return true;
                }
                prevAirlineRef = segMarketingAirlineRef;
            }
        }
        return false;
    }

    private static boolean isApplicableAirlineRef(DictionaryReference<Airline> segAirlineRef, DictionaryReference<Airline> bonusAirlineRef, Collection<FrequentTravellerAgreements> partnerAgreements, boolean considerAlliances) {
        if (FrequentFlyerHelper.isSameAirline(segAirlineRef, bonusAirlineRef)) {
            return true;
        }
        if (considerAlliances && FrequentFlyerHelper.isSameAlliance(segAirlineRef, bonusAirlineRef)) {
            return true;
        }
        return FrequentFlyerHelper.isPartnerAirline(segAirlineRef, partnerAgreements);
    }

    public static List<AirlineBonusCard> getApplicableBonusCards(Flight flight, List<AirlineBonusCard> bonusCards, boolean considerAlliances, boolean considerPartners, boolean considerCardsWithOnlyPartnerFlights) {
        if (bonusCards == null || bonusCards.isEmpty()) {
            return Collections.emptyList();
        }
        if (bonusCards.size() == 1) {
            AirlineBonusCard bonusCard = bonusCards.get(0);
            if (FrequentFlyerHelper.isApplicableBonusCard(flight, bonusCard, considerAlliances, considerPartners)) {
                return Collections.singletonList(bonusCard);
            }
            return Collections.emptyList();
        }
        ArrayList<BonusCardPrioritizationHolder> prioritizationList = new ArrayList<BonusCardPrioritizationHolder>();
        for (AirlineBonusCard bonusCard : bonusCards) {
            BonusCardPrioritizationHolder pri = null;
            Collection<FrequentTravellerAgreements> partnerAgreements = null;
            for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
                for (FlightSegment fs : fst.getSegments()) {
                    DictionaryReference bonusAirlineRef;
                    DictionaryReference segAirlineRef = fs.getAirline();
                    if (FrequentFlyerHelper.isSameAirline((DictionaryReference<Airline>)segAirlineRef, (DictionaryReference<Airline>)(bonusAirlineRef = bonusCard.getAirline()))) {
                        if (pri == null) {
                            pri = new BonusCardPrioritizationHolder(bonusCard);
                        }
                        pri.addNativeSegment(fs);
                    }
                    if (considerAlliances && FrequentFlyerHelper.isSameAlliance((DictionaryReference<Airline>)segAirlineRef, (DictionaryReference<Airline>)bonusAirlineRef)) {
                        if (pri == null) {
                            pri = new BonusCardPrioritizationHolder(bonusCard);
                        }
                        pri.addCompatibleSegments(fs);
                    }
                    if (!considerPartners) continue;
                    if (partnerAgreements == null) {
                        partnerAgreements = FrequentFlyerHelper.getPartnerAgreements((DictionaryReference<Airline>)bonusAirlineRef);
                    }
                    if (!FrequentFlyerHelper.isPartnerAirline((DictionaryReference<Airline>)segAirlineRef, partnerAgreements)) continue;
                    if (pri == null) {
                        pri = new BonusCardPrioritizationHolder(bonusCard);
                    }
                    pri.addCompatibleSegments(fs);
                }
            }
            if (pri == null || !considerCardsWithOnlyPartnerFlights && pri.getNumNativeSegments() <= 0) continue;
            prioritizationList.add(pri);
        }
        if (prioritizationList.isEmpty()) {
            return Collections.emptyList();
        }
        if (prioritizationList.size() == 1) {
            return Collections.singletonList(((BonusCardPrioritizationHolder)prioritizationList.get(0)).getBonusCard());
        }
        Collections.sort(prioritizationList);
        ArrayList<AirlineBonusCard> applicableCards = new ArrayList<AirlineBonusCard>(prioritizationList.size());
        for (BonusCardPrioritizationHolder holder : prioritizationList) {
            applicableCards.add(holder.getBonusCard());
        }
        return applicableCards;
    }

    private static class BonusCardPrioritizationHolder
    implements Comparable<BonusCardPrioritizationHolder> {
        private final AirlineBonusCard bonusCard;
        private List<FlightSegment> nativeSegments;
        private List<FlightSegment> compatibleSegments;
        private int numNativeSegments = -1;
        private int numCompatibleSegments = -1;
        private int totalDistance = -1;

        public BonusCardPrioritizationHolder(AirlineBonusCard bonusCardParam) {
            this.bonusCard = bonusCardParam;
        }

        public void addNativeSegment(FlightSegment segment) {
            if (this.nativeSegments == null) {
                this.nativeSegments = new ArrayList<FlightSegment>();
            }
            this.nativeSegments.add(segment);
        }

        public void addCompatibleSegments(FlightSegment segment) {
            if (this.compatibleSegments == null) {
                this.compatibleSegments = new ArrayList<FlightSegment>();
            }
            this.compatibleSegments.add(segment);
        }

        public AirlineBonusCard getBonusCard() {
            return this.bonusCard;
        }

        public int getNumNativeSegments() {
            if (this.numNativeSegments < 0) {
                this.numNativeSegments = this.nativeSegments == null ? 0 : this.nativeSegments.size();
            }
            return this.numNativeSegments;
        }

        public int getNumCompatibleSegments() {
            if (this.numCompatibleSegments < 0) {
                this.numCompatibleSegments = this.compatibleSegments == null ? 0 : this.compatibleSegments.size();
            }
            return this.numCompatibleSegments;
        }

        public int getTotalDistance() {
            if (this.totalDistance < 0) {
                this.totalDistance = 0;
                if (this.nativeSegments != null) {
                    for (FlightSegment flightSegment : this.nativeSegments) {
                    }
                }
                if (this.compatibleSegments != null) {
                    for (FlightSegment flightSegment : this.compatibleSegments) {
                    }
                }
            }
            return this.totalDistance;
        }

        @Override
        public int compareTo(BonusCardPrioritizationHolder otherCardInfo) {
            int result = otherCardInfo.getTotalDistance() - this.getTotalDistance();
            if (result == 0 && (result = otherCardInfo.getNumNativeSegments() - this.getNumNativeSegments()) == 0) {
                result = otherCardInfo.getNumCompatibleSegments() - this.getNumCompatibleSegments();
            }
            return result;
        }

        public String toString() {
            return this.getBonusCard().getAirline().getCode() + " " + this.getBonusCard().getNumber() + " (NS:" + this.numNativeSegments + "; CS:" + this.numCompatibleSegments + "; TD:" + this.totalDistance + ")";
        }
    }
}

