/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.helper;

import com.gridnine.bof.midoffice.trace.TraceDataPolicy;
import com.gridnine.bof.midoffice.trace.Tracer;
import com.gridnine.bof.midoffice.trace.TracerConfiguration;
import com.gridnine.bof.midoffice.trace.UnlimitedFilesPolicy;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsOperation;
import com.gridnine.xtrip.common.gds.model.GdsOperationsProperties;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.RouteType;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineCityInfo;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestDict;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PccParameterName;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.CalculationLineParsingResult;
import com.gridnine.xtrip.common.parsers.model.CalculationLineSegmentParsingResult;
import com.gridnine.xtrip.common.parsers.model.CalculationLineSegmentTariffParsingResult;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.metrics.Metrics;
import com.gridnine.xtrip.server.model.helpers.vat.air.AirProductVatCalculator;
import com.gridnine.xtrip.server.parsers2.common.avia.CalculationLineParsingProcessor;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GDSHelper {
    private static final transient Logger log = LoggerFactory.getLogger(GDSHelper.class);
    private static final CalculationLineParsingProcessor CALCULATION_LINE_PARSING_PROCESSOR = new CalculationLineParsingProcessor();
    private static final String SELECT_FLIGHT_TRACE_TEMPORAL_OBJECT_UID = "gds:select-flight-trace";
    private static final String FLIGHT_CONTENT_TEMPORAL_OBJECT_UID = "gds:flight-content";
    public static AirProductVatCalculator.VatProductAdapter<Flight, FlightTax, FlightSegmentTariff, FlightSegment> flightVatAdapter = new AirProductVatCalculator.VatProductAdapter<Flight, FlightTax, FlightSegmentTariff, FlightSegment>(){

        public List<FlightTax> getTaxes(Flight product, DictionaryReference<PassengerType> passengerType) {
            return product.getTaxes().stream().filter(tax -> passengerType.equals((Object)tax.getPassengerType())).collect(Collectors.toList());
        }

        public String getUid(FlightTax tax) {
            return tax.getUid();
        }

        public BigDecimal getPenalty(Flight product) {
            return null;
        }

        public BigDecimal getEquivalentAmount(FlightTax tax) {
            return tax.getEquivalentAmount();
        }

        public ProductStatus getStatus(Flight product) {
            return ProductStatus.BOOKING;
        }

        public BigDecimal getEquivalentFare(Flight product, DictionaryReference<PassengerType> passengerType) {
            return product.getFares().stream().filter(fare -> fare.getEquivalentAmount() != null && passengerType.equals((Object)fare.getPassengerType())).map(FlightFare::getEquivalentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }

        public Date getIssueDate(Flight product) {
            return new Date();
        }

        public boolean isAddValidationMessages() {
            return false;
        }

        public String getTitle(Flight product) {
            return null;
        }

        public void addValidationMessage(Flight product, ValidationMessage validationMessage) {
        }

        public DictionaryReference<Airline> getValidatingAirline(Flight product) {
            return product.getCarrier();
        }

        public MCOCategory getMcoCategory(Flight product) {
            return null;
        }

        public ProductCategory getProductCategory(Flight product) {
            return ProductCategory.AIR;
        }

        public String getTaxCode(FlightTax tax) {
            return tax.getCode();
        }

        public Date getVatIssueDate(Flight prod) {
            return new Date();
        }

        public List<FlightSegmentTariff> getSegmentTariffs(Flight product) {
            return product.getSegmentTariffs();
        }

        public List<FlightSegment> getSegments(FlightSegmentTariff segmentTariff) {
            return segmentTariff.getSegments();
        }

        public DictionaryReference<GeoLocation> getDepartureLocation(FlightSegment seg) {
            return seg.getLocationBegin();
        }

        public DictionaryReference<GeoLocation> getArrivalLocation(FlightSegment seg) {
            return seg.getLocationEnd();
        }

        public EntityReference<Organization> getSupplier(Flight product) {
            return GeneralProductHelper.getContractor((SalesChain)product.getSalesChain(), (PredefinedContractorType)PredefinedContractorType.SUPPLIER);
        }

        public String getBlankOwnerNumber(Flight product) {
            return null;
        }

        public EntityReference<Organization> getBlankOwner(Flight product) {
            return product.getBlankOwner();
        }

        public Flight getTransportationTypeProduct(Flight prod) {
            return prod;
        }

        public DictionaryReference<Airline> getMarketingAirline(FlightSegment seg) {
            return seg.getAirline();
        }

        public String getGdsCurrency(Flight prod) {
            return prod.getGdsCurrencyCode();
        }

        public EntityReference<? extends BaseEntity> getGdsAccount(Flight product) {
            return product.getGdsAccount();
        }
    };

    public static RouteType getRouteType(List<? extends RouteSegment> route) {
        if (route.size() == 0) {
            return null;
        }
        if (route.size() == 1) {
            return RouteType.ONEWAY;
        }
        if (route.size() > 2) {
            return RouteType.MULTISTOP;
        }
        if (!MiscUtil.equals((Object)route.get(0).getLocationEnd(), (Object)route.get(1).getLocationBegin())) {
            return RouteType.MULTISTOP;
        }
        if (!MiscUtil.equals((Object)route.get(1).getLocationEnd(), (Object)route.get(0).getLocationBegin())) {
            return RouteType.MULTISTOP;
        }
        return RouteType.ROUNDTRIP;
    }

    public static File getConfigurationFile(GdsName gds, boolean forSave) {
        String path = String.format("gds/%s.properties", gds.name());
        File result = new File(Environment.getConfigurationFolder(), path);
        if (forSave) {
            result.getParentFile().mkdirs();
            return result;
        }
        return result;
    }

    public static SalesContext createSalesContext(Reservation res) {
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            SalesContext result = new SalesContext();
            result.setAgency(AirProductHelper.getAgency((Product)prod));
            result.setAgent(prod.getCashier());
            result.setClient(res.getBookingFile().getCustomerProfile());
            result.setSalesPoint(prod.getSalesPoint());
            result.setSubagency(AirProductHelper.getSubagency((Product)prod));
            return result;
        }
        return null;
    }

    public static Tracer createTracer(GdsName gds) {
        Tracer result = new Tracer();
        TracerConfiguration tracerConfig = new TracerConfiguration();
        tracerConfig.setFolder(new File(Environment.getTempFolder(), "gds-trace/" + gds.name()));
        tracerConfig.setPolicy((TraceDataPolicy)ReflectionUtil.createBySystemPropertyName((String)"gds.tracer.policy", (Logger)log, UnlimitedFilesPolicy::new));
        result.setConfiguration(tracerConfig);
        return result;
    }

    public static void checkEquivCurrency(String curr) {
        String val = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
        if (val == null) {
            return;
        }
        GDSHelper.checkEquivCurrency(curr, val);
    }

    public static void checkEquivCurrency(String curr, String equiveCurr) {
        if (equiveCurr == null) {
            return;
        }
        if (!equiveCurr.equals(curr)) {
            throw new IllegalStateException(String.format("invalid equivalent currency, expected %s, found %s", equiveCurr, curr));
        }
    }

    public static DictionaryReference<Airline> getValidatingCarrier(Flight flight) {
        return flight.getCarrier();
    }

    public static DictionaryReference<Airline> getCarrier(Reservation reservation) {
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            if (prod.getCarrier() != null) {
                return prod.getCarrier();
            }
            for (SegmentTariff st : prod.getSegmentTariffs()) {
                for (Segment seg : st.getSegments()) {
                    if (seg.getAirline() == null) continue;
                    return seg.getAirline();
                }
            }
        }
        return null;
    }

    public static Set<DictionaryReference<Airline>> getCarriers(Flight flight) {
        HashSet<DictionaryReference<Airline>> result = new HashSet<DictionaryReference<Airline>>();
        for (FlightSegmentTariff tariff : flight.getSegmentTariffs()) {
            for (FlightSegment segment : tariff.getSegments()) {
                result.add((DictionaryReference<Airline>)segment.getAirline());
            }
        }
        return result;
    }

    public static String flight2str(Flight flight) {
        StringBuilder result = new StringBuilder();
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            List segments = st.getSegments();
            Iterator iterator = segments.iterator();
            while (iterator.hasNext()) {
                FlightSegment seg = (FlightSegment)iterator.next();
                if (result.length() > 0) {
                    result.append('-');
                }
                result.append(seg.getAirline().getCode()).append(seg.getFlightNumber());
            }
        }
        DictionaryReference adultRef = DictHelper.getAdultPassengerType();
        BigDecimal tariff = BigDecimal.ZERO;
        for (Object fare : flight.getFares()) {
            if (fare.getPassengerType() != null && !fare.getPassengerType().equals((Object)adultRef)) continue;
            tariff = tariff.add(fare.getEquivalentAmount());
        }
        BigDecimal taxes = BigDecimal.ZERO;
        for (Object tax : flight.getTaxes()) {
            if (tax.getPassengerType() != null && !tax.getPassengerType().equals((Object)adultRef)) continue;
            taxes = taxes.add(tax.getEquivalentAmount());
        }
        BigDecimal fees = BigDecimal.ZERO;
        for (GdsCommission fee : FlightHelper.getFees((Flight)flight, (ContractType)ContractType.CLIENT, (DictionaryReference)adultRef, (boolean)true)) {
            fees = fees.add(fee.getEquivalentAmount());
        }
        DecimalFormat nf = new DecimalFormat("#0.00");
        result.append(", tariff=").append(nf.format(tariff)).append(", taxes=").append(nf.format(taxes)).append(", fees=").append(nf.format(fees));
        result.append(", currency=").append(flight.getGdsCurrencyCode());
        return result.toString();
    }

    public static String flightSegment2str(FlightSegment seg) {
        return seg.getAirline().getCode() + seg.getFlightNumber();
    }

    public static boolean withErrors(List<Message> messages) {
        for (Message msg : messages) {
            if (msg.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }

    public static Set<DictionaryReference<Airline>> getCarriers(Reservation reservation) {
        HashSet<DictionaryReference<Airline>> result = new HashSet<DictionaryReference<Airline>>();
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            for (SegmentTariff tariff : prod.getSegmentTariffs()) {
                for (Segment segment : tariff.getSegments()) {
                    result.add((DictionaryReference<Airline>)segment.getAirline());
                }
            }
        }
        return result;
    }

    private GDSHelper() {
    }

    public static EntityReference<Organization> getBlankOwnerRefByAirline(DictionaryReference<Airline> airlineRef) {
        return EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.airline.name(), airlineRef).toReference();
    }

    public static String constructTimeWindow(Integer timeBegin, Integer timeEnd) {
        if (timeBegin == null && timeEnd == null) {
            return "00002359";
        }
        return GDSHelper.convertTimeToString(timeBegin) + GDSHelper.convertTimeToString(timeEnd);
    }

    private static String convertTimeToString(Integer time) {
        int timeValue = time == null ? 0 : time;
        int hours = timeValue / 60;
        int minutes = timeValue - hours * 60;
        String hoursStr = hours < 10 ? "0" + hours : String.valueOf(hours);
        String minutesStr = minutes < 10 ? "0" + minutes : String.valueOf(minutes);
        return hoursStr + minutesStr;
    }

    public static void statForMonitoringData(GdsName gds, String operation, long startTime) {
        Metrics.get().timingAndEvent(String.format("profiling.gds.%s.%s", Metrics.cleanKeyPart((String)operation), gds.name()), startTime);
        if (Environment.isPublished(Profiler.class)) {
            StringBuilder sb = new StringBuilder();
            sb.append("ext.");
            sb.append(gds.name());
            sb.append('.');
            sb.append(operation);
            String key = sb.toString();
            if (Profiler.get().isProfilingEnabled(key)) {
                Profiler.get().updateTiming(key, startTime, null);
            }
        }
    }

    public static CalculationLineParsingResult parseCalculationLine(String fareCalcLine) throws Exception {
        try {
            MessageContext ctx = new MessageContext();
            ctx.putObject((Enum)IBusParsersContextKeys.CALCULATION_LINE, (Object)fareCalcLine);
            CALCULATION_LINE_PARSING_PROCESSOR.process(ctx);
            return (CalculationLineParsingResult)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.CALCULATION_LINE_PARSING_RESULT);
        }
        catch (Exception ex) {
            log.error("fare calc line parse failed: " + fareCalcLine, (Throwable)ex);
            throw ex;
        }
    }

    public static List<FlightSegmentTariff> tryBuildFlightSegmentTariffs(List<FlightSegment> flightSegments, String fareCalcLine) {
        try {
            return GDSHelper.buildFlightSegmentTariffs(flightSegments, fareCalcLine);
        }
        catch (Exception ex) {
            log.error("fare calc line parse failed: " + fareCalcLine, (Throwable)ex);
            ArrayList<FlightSegmentTariff> result = new ArrayList<FlightSegmentTariff>(1);
            FlightSegmentTariff fst = new FlightSegmentTariff();
            fst.getSegments().addAll(flightSegments);
            result.add(fst);
            return result;
        }
    }

    public static List<FlightSegmentTariff> buildFlightSegmentTariffs(List<FlightSegment> flightSegments, String fareCalcLine) throws Exception {
        CalculationLineParsingResult calculationLineParsingResult = GDSHelper.parseCalculationLine(fareCalcLine);
        ArrayList<FlightSegmentTariff> result = new ArrayList<FlightSegmentTariff>(calculationLineParsingResult.getSegmentTariffs().size());
        Iterator<FlightSegment> fsIter = flightSegments.iterator();
        for (CalculationLineSegmentTariffParsingResult cst : calculationLineParsingResult.getSegmentTariffs()) {
            FlightSegmentTariff fst = new FlightSegmentTariff();
            for (CalculationLineSegmentParsingResult cs : cst.getSegments()) {
                if (!fsIter.hasNext()) {
                    log.error("fare calc line parse failed: " + fareCalcLine);
                    throw Xeption.forDeveloper((String)GDSHelper.getInfoOnSegmentsCountMismatch(flightSegments.size(), calculationLineParsingResult, fareCalcLine), (Object[])new Object[0]);
                }
                fst.getSegments().add(fsIter.next());
            }
            result.add(fst);
        }
        if (fsIter.hasNext()) {
            log.error("fare calc line parse failed: " + fareCalcLine);
            throw Xeption.forDeveloper((String)GDSHelper.getInfoOnSegmentsCountMismatch(flightSegments.size(), calculationLineParsingResult, fareCalcLine), (Object[])new Object[0]);
        }
        return result;
    }

    public static List<SegmentTariff> buildSegmentTariffs(Collection<Segment> segments, String fareCalcLine) throws Exception {
        CalculationLineParsingResult calculationLineParsingResult = GDSHelper.parseCalculationLine(fareCalcLine);
        ArrayList<SegmentTariff> result = new ArrayList<SegmentTariff>(calculationLineParsingResult.getSegmentTariffs().size());
        Iterator<Segment> sIter = segments.iterator();
        for (CalculationLineSegmentTariffParsingResult cst : calculationLineParsingResult.getSegmentTariffs()) {
            SegmentTariff st = new SegmentTariff();
            for (CalculationLineSegmentParsingResult cs : cst.getSegments()) {
                if (!sIter.hasNext()) {
                    log.error("fare calc line parse failed: " + fareCalcLine);
                    throw Xeption.forDeveloper((String)GDSHelper.getInfoOnSegmentsCountMismatch(segments.size(), calculationLineParsingResult, fareCalcLine), (Object[])new Object[0]);
                }
                st.getSegments().add(sIter.next());
            }
            result.add(st);
        }
        if (sIter.hasNext()) {
            log.error("fare calc line parse failed: " + fareCalcLine);
            throw Xeption.forDeveloper((String)GDSHelper.getInfoOnSegmentsCountMismatch(segments.size(), calculationLineParsingResult, fareCalcLine), (Object[])new Object[0]);
        }
        return result;
    }

    private static String getInfoOnSegmentsCountMismatch(int segmentListSize, CalculationLineParsingResult calculationLineParsingResult, String fareCalcLine) {
        int calcLineSegmentListSize = (int)calculationLineParsingResult.getSegmentTariffs().stream().flatMap(segTariff -> segTariff.getSegments().stream()).count();
        return String.format("segment count mismatch: seg:%d, calcSeg:%d, fareCalcLine: %s", segmentListSize, calcLineSegmentListSize, fareCalcLine);
    }

    @Deprecated
    public static List<FlightSegmentTariff> divideIntoSegmentTariffs(List<FlightSegment> segments, GdsName gds, CalculationLineParsingResult calculationLineParsingResult) {
        ArrayList<FlightSegmentTariff> result = new ArrayList<FlightSegmentTariff>(calculationLineParsingResult.getSegmentTariffs().size());
        Iterator<FlightSegment> fsIter = segments.iterator();
        for (CalculationLineSegmentTariffParsingResult cst : calculationLineParsingResult.getSegmentTariffs()) {
            FlightSegmentTariff fst = new FlightSegmentTariff();
            fst.setGds(gds);
            for (CalculationLineSegmentParsingResult cs : cst.getSegments()) {
                if (!fsIter.hasNext()) {
                    throw Xeption.forDeveloper((String)"segment count mismatch", (Object[])new Object[0]);
                }
                fst.getSegments().add(fsIter.next());
            }
            result.add(fst);
        }
        if (fsIter.hasNext()) {
            throw Xeption.forDeveloper((String)"segment count mismatch", (Object[])new Object[0]);
        }
        return result;
    }

    @Deprecated
    public static List<SegmentTariff> divideIntoSegmentTariffs(List<Segment> segments, CalculationLineParsingResult calculationLineParsingResult) {
        ArrayList<SegmentTariff> result = new ArrayList<SegmentTariff>(calculationLineParsingResult.getSegmentTariffs().size());
        Iterator<Segment> sIter = segments.iterator();
        for (CalculationLineSegmentTariffParsingResult cst : calculationLineParsingResult.getSegmentTariffs()) {
            SegmentTariff st = new SegmentTariff();
            for (CalculationLineSegmentParsingResult cs : cst.getSegments()) {
                if (!sIter.hasNext()) {
                    throw Xeption.forDeveloper((String)"segment count mismatch", (Object[])new Object[0]);
                }
                st.getSegments().add(sIter.next());
            }
            result.add(st);
        }
        if (sIter.hasNext()) {
            throw Xeption.forDeveloper((String)"segment count mismatch", (Object[])new Object[0]);
        }
        return result;
    }

    public static int getTotalSeats(List<SeatPreferences> seats) {
        return GDSHelper.getTotalSeats(seats, true);
    }

    public static int getTotalSeats(List<SeatPreferences> seats, boolean excludeWithoutSeats) {
        int result = 0;
        for (SeatPreferences sp : seats) {
            if (excludeWithoutSeats && GdsDictHelper.isWithoutSeat((DictionaryReference)sp.getPassengerType())) continue;
            result += sp.getCount();
        }
        return result;
    }

    public static int getTotalSeats(GdsReservationCreationParameters params) {
        int result = 0;
        for (GdsTraveller gdsTraveller : params.getGdsTravellers()) {
            if (GdsDictHelper.isWithoutSeat((DictionaryReference)gdsTraveller.getPassengerType())) continue;
            ++result;
        }
        return result;
    }

    public static DictionaryReference<PassengerType> findAdultPassengerType(List<SeatPreferences> seats) {
        for (SeatPreferences sp : seats) {
            if (!DictHelper.isAdultPassengerTypeCategory((DictionaryReference)sp.getPassengerType())) continue;
            return sp.getPassengerType();
        }
        return null;
    }

    public static Set<DictionaryReference<PassengerType>> getPassengerTypes(List<SeatPreferences> seats) {
        HashSet<DictionaryReference<PassengerType>> result = new HashSet<DictionaryReference<PassengerType>>();
        for (SeatPreferences sp : seats) {
            result.add((DictionaryReference<PassengerType>)sp.getPassengerType());
        }
        return result;
    }

    public static Map<DictionaryReference<PassengerType>, Integer> getPassengerTypesMap(List<SeatPreferences> seats) {
        HashMap<DictionaryReference<PassengerType>, Integer> result = new HashMap<DictionaryReference<PassengerType>, Integer>();
        for (SeatPreferences sp : seats) {
            int count = MiscUtil.guarded((Integer)((Integer)result.get(sp.getPassengerType())));
            result.put((DictionaryReference<PassengerType>)sp.getPassengerType(), count + sp.getCount());
        }
        return result;
    }

    public static Map<DictionaryReference<PassengerType>, Integer> seatPreferencesToMap(List<SeatPreferences> seatPreferences) {
        return seatPreferences.stream().collect(Collectors.toMap(SeatPreferences::getPassengerType, SeatPreferences::getCount, Integer::sum));
    }

    public static List<SeatPreferences> getSeatPreferences(Map<DictionaryReference<PassengerType>, Integer> travellers) {
        ArrayList<SeatPreferences> result = new ArrayList<SeatPreferences>();
        for (Map.Entry<DictionaryReference<PassengerType>, Integer> entry : travellers.entrySet()) {
            DictionaryReference<PassengerType> travellerType = entry.getKey();
            int value = MiscUtil.guarded((Integer)entry.getValue());
            if (value == 0) continue;
            SeatPreferences sp = new SeatPreferences();
            sp.setPassengerType(travellerType);
            sp.setCount(value);
            result.add(sp);
        }
        return result;
    }

    public static List<SeatPreferences> sortByPassengerType(List<SeatPreferences> seats) {
        return seats.stream().sorted(new SeatsPreferencesComparator()).collect(Collectors.toList());
    }

    public static ArrayList<ArrayList<Product>> groupProductsByTickets(Collection<Product> allProducts) {
        Collection airs = allProducts.stream().filter(product -> product.getProductCategory() == ProductCategory.AIR).collect(Collectors.toCollection(ArrayList::new));
        return airs.stream().map(air -> allProducts.stream().filter(product -> product.getRelatedProducts().contains(air)).collect(Collectors.toCollection(ArrayList::new))).collect(Collectors.toCollection(ArrayList::new));
    }

    public static Validator findValidatorByBlankOwner(EntityReference<SalesPoint> salesPoint, EntityReference<Organization> blankOwner) {
        if (blankOwner == null) {
            return null;
        }
        EntityContainer spCtr = EntityStorage.get().resolve(salesPoint);
        if (spCtr == null) {
            return null;
        }
        Date date = new Date();
        for (Validator validator : ((SalesPoint)spCtr.getEntity()).getValidators()) {
            if (!blankOwner.equals((Object)validator.getBlankOwner()) || validator.getOpened() != null && validator.getOpened().after(date) || validator.getClosed() != null && validator.getClosed().before(date)) continue;
            return validator;
        }
        return null;
    }

    public static Validator findValidatorByPccAndBlankOwner(EntityReference<SalesPoint> salesPoint, String pcc, EntityReference<Organization> blankOwner) {
        if (TextUtil.isBlank((String)pcc)) {
            return null;
        }
        EntityContainer spCtr = EntityStorage.get().resolve(salesPoint);
        if (spCtr == null) {
            return null;
        }
        for (Pcc item : ((SalesPoint)spCtr.getEntity()).getPccs()) {
            Validator validator;
            if (!pcc.equalsIgnoreCase(item.getCode()) || (validator = GDSHelper.findValidator((EntityContainer<SalesPoint>)spCtr, item, blankOwner)) == null) continue;
            return validator;
        }
        return null;
    }

    public static Validator findValidator(EntityContainer<SalesPoint> spCtr, Pcc pcc, EntityReference<Organization> blankOwner) {
        if (spCtr == null || pcc == null) {
            return null;
        }
        Date date = new Date();
        if (pcc.getOpened() != null && pcc.getOpened().after(date)) {
            return null;
        }
        if (pcc.getClosed() != null && pcc.getClosed().before(date)) {
            return null;
        }
        for (Validator validator : ((SalesPoint)spCtr.getEntity()).getValidators()) {
            if (validator.getOpened() != null && validator.getOpened().after(date) || validator.getClosed() != null && validator.getClosed().before(date) || blankOwner != null && validator.getBlankOwner() != null && !blankOwner.equals((Object)validator.getBlankOwner()) || !pcc.equals((Object)validator.getPCC())) continue;
            return validator;
        }
        return null;
    }

    public static Collection<Product> getProductsByGdsId(Reservation reservation, String gdsId) {
        HashSet<Product> result = new HashSet<Product>();
        for (BaseProduct bp : reservation.getProducts()) {
            Product prod = (Product)bp;
            if (!gdsId.equals(prod.getGdsId())) continue;
            result.add(prod);
        }
        return result;
    }

    public static Product findProductByGdsId(Reservation reservation, String gdsId) {
        for (BaseProduct bp : reservation.getProducts()) {
            Product prod = (Product)bp;
            if (!gdsId.equals(prod.getGdsId())) continue;
            return prod;
        }
        return null;
    }

    public static Collection<Product> findProductsByGdsId(Reservation reservation, String gdsId) {
        HashSet<Product> result = new HashSet<Product>();
        for (BaseProduct bp : reservation.getProducts()) {
            Product prod = (Product)bp;
            if (!gdsId.equals(prod.getGdsId())) continue;
            result.add(prod);
        }
        return result;
    }

    public static Segment findSegmentByGdsId(Product product, String gdsId) {
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment s : st.getSegments()) {
                if (!gdsId.equals(s.getGdsId())) continue;
                return s;
            }
        }
        return null;
    }

    public static Segment findSegmentByGdsId(Collection<Product> products, String gdsId) {
        for (Product product : products) {
            Segment segment = GDSHelper.findSegmentByGdsId(product, gdsId);
            if (segment == null) continue;
            return segment;
        }
        return null;
    }

    public static MiscUtil.Pair<Product, Segment> findProductAndSegmentBySegmentGdsId(Collection<Product> products, String gdsId) {
        for (Product product : products) {
            Segment segment = GDSHelper.findSegmentByGdsId(product, gdsId);
            if (segment == null) continue;
            return new MiscUtil.Pair((Object)product, (Object)segment);
        }
        return null;
    }

    public static int compareLocationsIgnoreType(GeoLocation o1, GeoLocation o2, String pattern, Locale locale) {
        int result = MiscUtil.compare((int)GDSHelper.getPatternPosition(o1, pattern, locale), (int)GDSHelper.getPatternPosition(o2, pattern, locale));
        if (result == 0) {
            result = -MiscUtil.compare((int)o1.getWeight(), (int)o2.getWeight());
        }
        if (result == 0) {
            result = MiscUtil.compare((Comparable)((Comparable)MiscUtil.findByLocale((Map)o1.getTranslations(), (Locale)locale)), (Comparable)((Comparable)MiscUtil.findByLocale((Map)o2.getTranslations(), (Locale)locale)));
        }
        return result;
    }

    public static int getPatternPosition(GeoLocation location, String pattern, Locale locale) {
        String name = GDSHelper.getName(location, locale);
        int result = name.toLowerCase(locale).indexOf(pattern.toLowerCase(locale));
        for (String code : location.getCodeVariants().values()) {
            if (result >= 0) break;
            result = code.toUpperCase(locale).indexOf(pattern.toUpperCase(locale));
        }
        if (result == -1) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }

    private static String getName(GeoLocation location, Locale locale) {
        String name = (String)MiscUtil.findByLocale((Map)location.getTranslations(), (Locale)locale);
        if (name == null) {
            name = (String)MiscUtil.findByLocale((Map)location.getTranslations(), (Locale)LocaleManager.get().getDefaultLocale());
        }
        if (name == null) {
            name = location.toReference().toString();
        }
        return name == null ? "" : name;
    }

    public static String correctLastName(String lastName) {
        if (TextUtil.isBlank((String)lastName)) {
            return lastName;
        }
        if (lastName.length() == 1) {
            return lastName.concat(lastName);
        }
        return lastName;
    }

    public static String getSelectFlightTraceTemporalObjectUid(Flight flight) {
        return NamedValueHelper.getValueForName((String)SELECT_FLIGHT_TRACE_TEMPORAL_OBJECT_UID, (Collection)flight.getCustomProperties());
    }

    public static String getFlightContentTemporalObjectUid(Flight flight) {
        return NamedValueHelper.getValueForName((String)FLIGHT_CONTENT_TEMPORAL_OBJECT_UID, (Collection)flight.getCustomProperties());
    }

    public static void setSelectFlightTraceTemporalObjectUid(Flight flight, String uid) {
        NamedValueHelper.setValueForName((String)SELECT_FLIGHT_TRACE_TEMPORAL_OBJECT_UID, (String)uid, (Collection)flight.getCustomProperties());
    }

    public static void setFlightContentTemporalObjectUid(Flight flight, String uid) {
        NamedValueHelper.setValueForName((String)FLIGHT_CONTENT_TEMPORAL_OBJECT_UID, (String)uid, (Collection)flight.getCustomProperties());
    }

    public static String getTravellerGdsIdWithFallback(Product prod) {
        String gdsId = prod.getTravellerGdsId();
        if (StringUtils.isBlank((String)gdsId)) {
            gdsId = prod.getGdsId();
        }
        return gdsId;
    }

    public static Product findProductBySystemNumber(Reservation reservation, String systemNumber) {
        if (TextUtil.isBlank((String)systemNumber)) {
            return null;
        }
        List products = BookingStreamHelper.getProductsStream((Reservation)reservation, Product.class).filter(p -> systemNumber.equals(p.getSystemNumber())).collect(Collectors.toList());
        long count = products.size();
        if (count > 1L) {
            throw Xeption.forDeveloper((String)"was found {0} products with number {1}", (Object[])new Object[]{count, systemNumber});
        }
        return products.isEmpty() ? null : (Product)products.get(0);
    }

    public static Product findProductByTravellerGdsId(Reservation reservation, String travellerGdsId, ProductCategory category) {
        if (TextUtil.isBlank((String)travellerGdsId) || category == null) {
            return null;
        }
        return BookingStreamHelper.getProductsStream((Reservation)reservation, Product.class).filter(p -> category.equals((Object)p.getProductCategory())).filter(p -> travellerGdsId.equals(p.getTravellerGdsId())).findFirst().orElse(null);
    }

    public static List<Product> collectProductsByTravellerGdsId(Reservation reservation, String travellerGdsId) {
        return GDSHelper.collectProductsByTravellerGdsId(reservation.getProducts(), travellerGdsId);
    }

    public static List<Product> collectProductsByTravellerGdsId(Collection<BaseProduct> baseProducts, String travellerGdsId) {
        if (CollectionUtil.isEmpty(baseProducts) || TextUtil.isBlank((String)travellerGdsId)) {
            return Collections.emptyList();
        }
        return BookingStreamHelper.getProductsStream(baseProducts.stream(), Product.class).filter(p -> travellerGdsId.equals(p.getTravellerGdsId())).collect(Collectors.toList());
    }

    public static Map<DictionaryReference<PassengerType>, String> getFareBasises(FlightSegment segment) {
        HashMap<DictionaryReference<PassengerType>, String> result = new HashMap<DictionaryReference<PassengerType>, String>();
        segment.getFareInfos().forEach(di -> {
            if (di != null && di.getPassengerType() != null && !TextUtil.isBlank((String)di.getFareBasis())) {
                result.put(di.getPassengerType(), di.getFareBasis());
            }
        });
        return result;
    }

    public static String buildRouteInfo(FlightSearchParameters fsp) {
        StringBuilder sb = new StringBuilder();
        String lastCode = null;
        for (RouteSegment rs : fsp.getRoute()) {
            String begin = rs.getLocationBegin().getCode();
            String end = rs.getLocationEnd().getCode();
            if (!MiscUtil.equals((Object)begin, lastCode)) {
                if (sb.length() > 0) {
                    sb.append("_");
                }
                sb.append(begin);
            }
            sb.append("-").append(end);
            lastCode = end;
        }
        return sb.toString();
    }

    public static BigDecimal exchangeFareAmount(BigDecimal amount, CurrencyRate rate) {
        BigDecimal val = FinanceHelper.exchange((BigDecimal)amount, (CurrencyRate)rate);
        return val == null ? null : MiscUtil.ceil((BigDecimal)val, (BigDecimal)BigDecimal.ONE);
    }

    public static BigDecimal exchangeTaxAmount(BigDecimal amount, CurrencyRate rate) {
        BigDecimal val = FinanceHelper.exchange((BigDecimal)amount, (CurrencyRate)rate);
        return val == null ? null : MiscUtil.ceil((BigDecimal)val, (BigDecimal)BigDecimal.ONE);
    }

    public static AirlineCityInfo getAirlineCityInfo(DictionaryReference<Airline> airline) {
        for (AirlineCityInfo aci : DictionaryCache.get().getAll(AirlineCityInfo.class).values()) {
            if (!airline.equals((Object)aci.getAirline())) continue;
            return aci;
        }
        return null;
    }

    public static boolean isRouteInAirlineGrid(Collection<RouteSegment> route, AirlineCityInfo aci) {
        for (RouteSegment rs : route) {
            if (!aci.getCities().contains(DictHelper.findCity((DictionaryReference)rs.getLocationBegin()).toReference())) {
                return false;
            }
            if (aci.getCities().contains(DictHelper.findCity((DictionaryReference)rs.getLocationEnd()).toReference())) continue;
            return false;
        }
        return true;
    }

    public static String getBrandId(FareInfo fareInfo) {
        return GDSHelper.getBrandId(fareInfo.getFareDetails());
    }

    public static String getBrandId(Segment segment) {
        return GDSHelper.getBrandId(segment.getFareDetails());
    }

    private static String getBrandId(FareDetails fareDetails) {
        if (fareDetails == null) {
            return null;
        }
        if (fareDetails.getPricingParameters() == null) {
            return null;
        }
        return fareDetails.getPricingParameters().getBrandId();
    }

    public static void setBrandId(FareInfo fareInfo, String brandId) {
        GDSHelper.setBrandId(fareInfo, brandId, "fareDetails");
    }

    public static void setBrandId(Segment segment, String brandId) {
        GDSHelper.setBrandId(segment, brandId, "fareDetails");
    }

    private static <T extends Introspectable> void setBrandId(T object, String brandId, String propertyName) {
        if (!StringUtils.isBlank((String)brandId)) {
            FareDetails fareDetails;
            if (object.getValue(propertyName) == null) {
                object.setValue(propertyName, (Object)new FareDetails());
            }
            if ((fareDetails = (FareDetails)object.getValue(propertyName)).getPricingParameters() == null) {
                fareDetails.setPricingParameters(new FarePricingParameters());
            }
            fareDetails.getPricingParameters().setBrandId(brandId);
        }
    }

    public static Boolean hasLuggage(FareDetails fareDetails) {
        if (fareDetails != null && fareDetails.getLuggageInfo() != null) {
            ExtendedLuggageInfo luggageInfo = fareDetails.getLuggageInfo();
            if (luggageInfo.getPieces() != null && luggageInfo.getPieces() > 0) {
                return Boolean.TRUE;
            }
            if (luggageInfo.getWeight() != null && luggageInfo.getWeight() > 0) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public static SpecialServiceRequest findSsr(Segment s, DictionaryReference<SpecialServiceRequestDict> type) {
        for (SpecialServiceRequest ssr : s.getSsrs()) {
            if (!type.equals((Object)ssr.getType())) continue;
            return ssr;
        }
        return null;
    }

    public static List<Product> getProducts(List<BaseProduct> baseProducts) {
        return BookingStreamHelper.getProductsStream(baseProducts.stream(), Product.class).collect(Collectors.toList());
    }

    public static List<Product> getAllProducts(Reservation reservation) {
        return BookingStreamHelper.getProductsStream((Reservation)reservation, Product.class).collect(Collectors.toList());
    }

    public static List<Product> getAllEffectiveProducts(Reservation reservation) {
        return BookingStreamHelper.getProductsStream((Reservation)reservation, Product.class).filter(pr -> pr.getNextProduct() == null).collect(Collectors.toList());
    }

    public static List<Product> getProducts(Reservation reservation) {
        return GDSHelper.getProductsStream(reservation).collect(Collectors.toList());
    }

    public static Stream<Product> getProductsStream(Reservation reservation) {
        return reservation.getProducts().stream().filter(bp -> bp instanceof Product).map(bp -> (Product)bp).filter(p -> p.getProductCategory() == ProductCategory.AIR);
    }

    public static List<Product> getMcoProducts(Reservation reservation) {
        return GDSHelper.getMcoProductsStream(reservation.getProducts()).collect(Collectors.toList());
    }

    public static Stream<Product> getMcoProductsStream(Collection<BaseProduct> baseProducts) {
        return BookingStreamHelper.getProductsStream(baseProducts.stream(), Product.class).filter(p -> p.getProductCategory() == ProductCategory.MCO);
    }

    public static List<Product> getProducts(Reservation reservation, ProductCategory ... category) {
        List<ProductCategory> cats = Arrays.asList(category);
        return BookingStreamHelper.getProductsStream((Reservation)reservation, Product.class).filter(p -> cats.contains(p.getProductCategory())).collect(Collectors.toList());
    }

    public static String buildSavedFareRulesContainerUid(Reservation reservation, String remarkSearchContext) {
        return String.join((CharSequence)"-", "fareRules", reservation.getUid(), DigestUtils.md5Hex((String)remarkSearchContext));
    }

    public static ZoneId getPccTimeZone(Pcc pcc) {
        String timeZoneParameter = PccHelper.getPccParameter((Pcc)pcc, (PccParameterName)PccParameterName.SABRE_TIME_ZONE);
        if (StringUtils.isBlank((String)timeZoneParameter)) {
            return ZoneId.systemDefault();
        }
        return ZoneId.of(timeZoneParameter);
    }

    public static Date convertTimelimitFromPcc(Date timelimit, Pcc pcc) {
        return GDSHelper.convertTimelimit(timelimit, pcc, true);
    }

    public static Date convertTimelimitToPcc(Date timelimit, Pcc pcc) {
        return GDSHelper.convertTimelimit(timelimit, pcc, false);
    }

    private static Date convertTimelimit(Date timelimit, Pcc pcc, boolean from) {
        ZoneId pccTimeZone = GDSHelper.getPccTimeZone(pcc);
        long pccOffset = (long)pccTimeZone.getRules().getOffset(timelimit.toInstant()).getTotalSeconds() * 1000L;
        ZoneId serverTimeZone = ZoneId.systemDefault();
        long serverOffset = (long)serverTimeZone.getRules().getOffset(timelimit.toInstant()).getTotalSeconds() * 1000L;
        long delta = serverOffset - pccOffset;
        if (!from) {
            delta = -1L * delta;
        }
        return new Date(timelimit.getTime() + delta);
    }

    public static String getDepartureCityCodeFromFirstSegment(Flight flight) {
        FlightSegment firstSegment = FlightHelper.getFirstSegment((Flight)flight);
        if (firstSegment == null) {
            log.error("first segment is null");
            return null;
        }
        DictionaryReference locationRef = firstSegment.getLocationBegin();
        if (locationRef != null) {
            GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(locationRef);
            if (location.getType() == LocationType.CITY) {
                return DictHelper.getCodeVariant((BaseDictionary)location, (CodeSystem)CodeSystem.IATA);
            }
            if (location.getType() == LocationType.AIRPORT) {
                if (location.getParent() == null) {
                    log.error(String.format("airport %s has no parent", location.getCode()));
                    return null;
                }
                GeoLocation city = (GeoLocation)DictionaryCache.get().resolveReference(location.getParent());
                if (city.getType() == LocationType.CITY) {
                    return DictHelper.getCodeVariant((BaseDictionary)city, (CodeSystem)CodeSystem.IATA);
                }
                log.error("unexpected location type " + city.getType().name());
            }
            log.error("unexpected location type " + location.getType().name());
        }
        log.error("begin location is null");
        return null;
    }

    public static boolean isGdsOperationAvailable(GdsOperation operation, GdsOperationsProperties operationsProperties) {
        return GDSHelper.isGdsOperationAvailable(operation, operationsProperties, false);
    }

    public static boolean isGdsOperationAvailable(GdsOperation operation, GdsOperationsProperties operationsProperties, boolean defaultResult) {
        Objects.requireNonNull(operation);
        return (Boolean)MiscUtil.guarded((Object)GDSHelper.getGdsOperationAvailable(operation, operationsProperties), (Object)defaultResult);
    }

    public static Boolean getGdsOperationAvailable(GdsOperation operation, GdsOperationsProperties operationsProperties) {
        Objects.requireNonNull(operation);
        if (operationsProperties == null) {
            return null;
        }
        switch (operation) {
            case ANCILLARY_SERVICES: {
                return operationsProperties.isAncillaryServices();
            }
            case CANCEL_BOOKING: {
                return operationsProperties.isCancelBooking();
            }
            case VISA_DURING_BOOKING: {
                return operationsProperties.isVisaDuringBooking();
            }
            case VOID: {
                return operationsProperties.isVoidOperation();
            }
            case VOID_PARTIAL: {
                return operationsProperties.isVoidPartial();
            }
            case REFUND: {
                return operationsProperties.isRefund();
            }
            case SEATS_MAP: {
                return operationsProperties.isSeatsMap();
            }
            case TICKETING: {
                return operationsProperties.isTicketing();
            }
            case REPRICE: {
                return operationsProperties.isReprice();
            }
            case EXCHANGE: {
                return operationsProperties.isExchange();
            }
        }
        return null;
    }

    public static boolean isImmediateTicketing(GdsOperationsProperties operationsProperties, boolean defaultValue) {
        return operationsProperties == null ? defaultValue : operationsProperties.isImmediateTicketing();
    }

    public static boolean isImmediateTicketing(GdsOperationsProperties operationProperties) {
        return GDSHelper.isImmediateTicketing(operationProperties, true);
    }

    public static boolean isUnconfirmedMco(Product mco) {
        return mco.getMcoReservationRequestStatus() == MCOReservationRequestStatus.PENDING || mco.getMcoReservationRequestStatus() == MCOReservationRequestStatus.REJECTED;
    }

    public static java.sql.Date getPassportExpirationDate(Passport passport, Flight flight) {
        List segments = FlightHelper.getSegments((Flight)flight);
        Date lastSegmentStartDate = MiscUtil.clearTime((Date)((FlightSegment)segments.get(segments.size() - 1)).getDateBegin());
        switch (passport.getType()) {
            case INTERNAL: 
            case BIRTHDAY_NOTIFICATION: {
                return new java.sql.Date(MiscUtil.addYearsToDate((Date)lastSegmentStartDate, (int)1).getTime());
            }
        }
        return new java.sql.Date(passport.getExpired().getTime());
    }

    public static AirlineBonusCard getOrganizationAirlineBonusCard(Customer customer, EntityReference<Person> agentRef, SalesChain salesChain, DictionaryReference<Airline> airlineRef) {
        if (customer == null || agentRef == null || salesChain == null || airlineRef == null) {
            return null;
        }
        for (AirlineBonusCard card : customer.getAirlineBonusCards()) {
            if (!MiscUtil.equals((Object)card.getAirline(), airlineRef)) continue;
            return card;
        }
        for (AirlineBonusCard card : ((Person)EntityStorage.get().resolve(agentRef).getEntity()).getAirlineAgentBonusCards()) {
            if (!MiscUtil.equals((Object)card.getAirline(), airlineRef)) continue;
            return card;
        }
        LinkedList contractors = new LinkedList(salesChain.getContractors());
        Iterator iter = contractors.descendingIterator();
        while (iter.hasNext()) {
            Organization organization;
            Contractor contractor = (Contractor)iter.next();
            EntityContainer orgCtr = EntityStorage.get().resolve(contractor.getContractor());
            if (orgCtr == null || !(organization = (Organization)orgCtr.getEntity()).getTypes().contains(OrganizationType.AGENCY) && !organization.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) continue;
            for (AirlineBonusCard card : organization.getAirlineBonusCards()) {
                if (!MiscUtil.equals((Object)card.getAirline(), airlineRef)) continue;
                return card;
            }
        }
        return null;
    }

    public static String stripZeroesInFlightNumber(String number) {
        if (number.charAt(0) != '0') {
            return number;
        }
        int i = 0;
        while (number.charAt(i) == '0') {
            ++i;
        }
        return number.substring(i);
    }

    public static String getDisplayBrandName(FareDetails fareDetails, Locale locale) {
        String displayName = L10nStringHelper.getValue((L10nString)fareDetails.getDisplayBrandName(), (Locale)locale, (boolean)false);
        if (!StringUtils.isBlank((String)displayName)) {
            return displayName;
        }
        String providerName = L10nStringHelper.getValue((L10nString)fareDetails.getBrandName(), (Locale)locale, (boolean)false);
        if (!StringUtils.isBlank((String)providerName)) {
            return providerName;
        }
        return null;
    }

    public static Product buildMcoProduct(Product mainProduct, AncillaryFee af) throws Exception {
        Product mcoProduct = new Product();
        AirProductHelper.setTechnicalProvider((Product)mcoProduct, (EntityReference)AirProductHelper.getTechnicalProvider((Product)mainProduct));
        mcoProduct.setSalesOriginContent(mainProduct.getSalesOriginContent());
        mcoProduct.setSalesOriginProvider(mainProduct.getSalesOriginProvider());
        GDSHelper.copyValuesFromMainProduct(mcoProduct, mainProduct);
        mcoProduct.setGdsId(af.getGdsId());
        mcoProduct.setProductCategory(ProductCategory.MCO);
        mcoProduct.setMcoCategory(GdsDictHelper.convertToMcoCategory((AncillaryFeeType)af.getType()));
        mcoProduct.setAncillaryFeeDescription(af.getDescription());
        mcoProduct.getRelatedProducts().add(mainProduct);
        mcoProduct.setMcoCancellationAllowed(true);
        List mainSegments = AirProductHelper.getSegments((Collection)mainProduct.getSegmentTariffs());
        SegmentTariff st = new SegmentTariff();
        mcoProduct.getSegmentTariffs().add(st);
        Iterator iterator = af.getSegmentNumbers().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            st.getSegments().add(XCloneHelper.clone((XCloneable)((XCloneable)mainSegments.get(n)), (boolean)true));
        }
        ProductFare pf = new ProductFare();
        pf.setBaseFare(af.getBaseAmount());
        pf.setEquivalentFare(af.getEquivalentAmount());
        mcoProduct.getFares().add(pf);
        return mcoProduct;
    }

    private static void copyValuesFromMainProduct(Product mco, Product mainProduct) {
        mco.setReservation(mainProduct.getReservation());
        mco.setGdsCurrency(mainProduct.getGdsCurrency());
        mco.setCarrier(mainProduct.getCarrier());
        mco.setTariffType(mainProduct.getTariffType());
        mco.setPassengerType(mainProduct.getPassengerType());
        mco.setTraveller(mainProduct.getTraveller());
        mco.setTravellerGdsId(mainProduct.getTravellerGdsId());
    }

    public static class SeatsPreferencesComparator
    implements Comparator<SeatPreferences> {
        @Override
        public int compare(SeatPreferences sp1, SeatPreferences sp2) {
            int i1 = this.getPassengerTypeIndex((DictionaryReference<PassengerType>)sp1.getPassengerType());
            int i2 = this.getPassengerTypeIndex((DictionaryReference<PassengerType>)sp2.getPassengerType());
            return MiscUtil.compare((int)i1, (int)i2);
        }

        private int getPassengerTypeIndex(DictionaryReference<PassengerType> passengerType) {
            if (DictHelper.isInfantPassengerTypeCategory(passengerType)) {
                return 2;
            }
            if (DictHelper.isChildPassengerTypeCategory(passengerType)) {
                return 1;
            }
            return 0;
        }
    }
}

