/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.helper;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SegmentUpdateHelper {
    public static Map<String, Set<List<SegmentEssentials>>> getDataToCompare(Reservation reservation) {
        return AirProductHelper.getAirProductsStream((Reservation)reservation).collect(Collectors.groupingBy(p -> p.getTraveller().getUid())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(p -> AirProductHelper.getProductSegmentsStream((Product)p).map(SegmentEssentials::new).collect(Collectors.toList())).collect(Collectors.toSet())));
    }

    public static Map<String, Set<List<SegmentEssentials>>> getDataToCompare(Flight flight, Collection<Traveller> travellers) {
        Set<List<SegmentEssentials>> ticketSegmentData = SegmentUpdateHelper.getTicketSegmentData(flight);
        return travellers.stream().collect(Collectors.toMap(BaseIdentity::getUid, t -> ticketSegmentData));
    }

    private static Set<List<SegmentEssentials>> getTicketSegmentData(Flight flight) {
        if (flight.getMultiTicketBreakdown().isEmpty()) {
            return Collections.singleton(FlightHelper.getSegments((Flight)flight).stream().map(SegmentEssentials::new).collect(Collectors.toList()));
        }
        return flight.getMultiTicketBreakdown().stream().map(item -> item.getSegmentTariffs().stream().map(FlightSegmentTariff::getSegments).flatMap(Collection::stream).map(SegmentEssentials::new).collect(Collectors.toList())).collect(Collectors.toSet());
    }

    public static class SegmentEssentials {
        private final Date startDate;
        private final DictionaryReference<GeoLocation> startLocation;
        private final String startTerminal;
        private final Date endDate;
        private final DictionaryReference<GeoLocation> endLocation;
        private final String endTerminal;
        private final String flightNumber;
        private final DictionaryReference<Aircraft> aircraft;

        SegmentEssentials(Segment segment) {
            this.startDate = segment.getStartDate();
            this.startLocation = segment.getDepartureLocation();
            this.startTerminal = segment.getDepartTerminal();
            this.endDate = segment.getEndDate();
            this.endLocation = segment.getArriveLocation();
            this.endTerminal = segment.getArriveTerminal();
            this.flightNumber = segment.getFlightNo();
            this.aircraft = segment.getBoard();
        }

        SegmentEssentials(FlightSegment segment) {
            this.startDate = segment.getDateBegin();
            this.startLocation = segment.getLocationBegin();
            this.startTerminal = segment.getTerminalBegin();
            this.endDate = segment.getDateEnd();
            this.endLocation = segment.getLocationEnd();
            this.endTerminal = segment.getTerminalEnd();
            this.flightNumber = segment.getFlightNumber();
            this.aircraft = segment.getBoard();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SegmentEssentials that = (SegmentEssentials)o;
            return Objects.equals(this.startDate, that.startDate) && Objects.equals(this.startLocation, that.startLocation) && Objects.equals(this.startTerminal, that.startTerminal) && Objects.equals(this.endDate, that.endDate) && Objects.equals(this.endLocation, that.endLocation) && Objects.equals(this.endTerminal, that.endTerminal) && Objects.equals(this.flightNumber, that.flightNumber) && Objects.equals(this.aircraft, that.aircraft);
        }

        public int hashCode() {
            return Objects.hash(this.startDate, this.startLocation, this.startTerminal, this.endDate, this.endLocation, this.endTerminal, this.flightNumber, this.aircraft);
        }
    }
}

