/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.helper;

import com.gridnine.xtrip.common.gds.corp.CorporateBookingParameters;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.CostCodeType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UdidIterator
implements Iterator<CostCodeProperties> {
    private static final Logger log = LoggerFactory.getLogger(UdidIterator.class);
    private final Organization client;
    private final Iterator<CostCodeProperties> costCodePropertiesIterator;
    private final Set<CostCodeType> existingCostCodeTypes = new TreeSet<CostCodeType>();
    private int udidCode;
    private String udidName;
    private String udidValue;

    public static UdidIterator getUdidIterator(Organization client, final List<NamedValue> customParameters) {
        return new UdidIterator(client){

            @Override
            protected String findUdidValue(CostCodeType cct) {
                return NamedValueHelper.getValueForName((String)("udid." + StatisticsHelper.getCostCodeTypeId((CostCodeType)cct)), (Collection)customParameters);
            }
        };
    }

    public static UdidIterator getUdidIterator(Organization client, final Map<CostCodeType, CorporateBookingParameters.CostCodeValue> udids) {
        return new UdidIterator(client){

            @Override
            protected String findUdidValue(CostCodeType cct) {
                return this.findUdidValue(cct, CorporateBookingParameters.CostCodeValue.Priority.NORMAL);
            }

            @Override
            protected String findUdidValue(CostCodeType cct, CorporateBookingParameters.CostCodeValue.Priority priority) {
                CorporateBookingParameters.CostCodeValue costCodeValue = (CorporateBookingParameters.CostCodeValue)udids.get(cct);
                if (costCodeValue != null && priority == costCodeValue.getPriority()) {
                    return costCodeValue.getValue();
                }
                return null;
            }
        };
    }

    protected UdidIterator(Organization clientVal) {
        this.client = clientVal;
        List costCodeProperties = this.client.getCostCodeProperties();
        this.costCodePropertiesIterator = costCodeProperties.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.costCodePropertiesIterator.hasNext();
    }

    @Override
    public CostCodeProperties next() {
        CostCodeProperties ccp = this.costCodePropertiesIterator.next();
        CostCodeType cct = ccp.getType();
        if (!this.existingCostCodeTypes.add(cct)) {
            throw new IllegalArgumentException("Duplicate cost code type " + cct);
        }
        this.udidCode = StatisticsHelper.getCostCodeTypeId((CostCodeType)cct);
        this.udidName = ccp.getSabreShortName();
        if (this.udidName == null) {
            this.udidName = ccp.getName();
            if (this.udidName == null) {
                log.warn("udid #" + StatisticsHelper.getCostCodeTypeId((CostCodeType)cct) + " for client #" + this.client.getClientID() + " does not have a name");
                DictionaryReference cccRef = ccp.getCategory();
                if (cccRef == null || (this.udidName = cccRef.getCode()) == null) {
                    throw new IllegalArgumentException("udid #" + StatisticsHelper.getCostCodeTypeId((CostCodeType)cct) + " for client #" + this.client.getClientID() + " neither has a name nor a category");
                }
            }
        }
        if (this.udidName.length() > 15) {
            this.udidName = this.udidName.substring(0, 15);
        } else if (this.udidName.length() < 15) {
            StringBuilder sb = new StringBuilder(15);
            sb.append(this.udidName);
            for (int i = this.udidName.length(); i < 15; ++i) {
                sb.append('.');
            }
            this.udidName = sb.toString();
        }
        this.udidValue = this.findUdidValue(cct, CorporateBookingParameters.CostCodeValue.Priority.HIGH);
        if (StringUtils.isBlank((String)this.udidValue)) {
            this.udidValue = ProfileHelper.getPredefinedUdidValue((CostCodeProperties)ccp, (List)this.client.getCostCodes());
        }
        if (StringUtils.isBlank((String)this.udidValue)) {
            this.udidValue = this.findUdidValue(cct);
            if (StringUtils.isBlank((String)this.udidValue)) {
                log.warn("udid #" + this.udidCode + " is blank for ");
                this.udidValue = "BLANK";
            }
        }
        return ccp;
    }

    protected abstract String findUdidValue(CostCodeType var1);

    protected String findUdidValue(CostCodeType cct, CorporateBookingParameters.CostCodeValue.Priority priority) {
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("not implemented");
    }

    public int getUdidCode() {
        return this.udidCode;
    }

    public String getUdidName() {
        return this.udidName;
    }

    public String getUdidValue() {
        return this.udidValue;
    }

    public Set<CostCodeType> getExistingCostCodeTypes() {
        if (this.hasNext()) {
            throw new IllegalStateException("Didn't check all UDIDs yet");
        }
        return this.existingCostCodeTypes;
    }

    public class Udid
    extends CostCodeProperties {
        private final Organization client;
        private List<NamedValue> customParameters;

        public Udid(Organization clientVal) {
            this.client = clientVal;
        }

        public int getUdidCode() {
            return StatisticsHelper.getCostCodeTypeId((CostCodeType)this.getType());
        }

        public String getUdidName() {
            String udidName = this.getSabreShortName();
            if (udidName == null && (udidName = this.getName()) == null) {
                log.warn("udid #" + StatisticsHelper.getCostCodeTypeId((CostCodeType)this.getType()) + " for client #" + this.client.getClientID() + " does not have a name");
                DictionaryReference cccRef = this.getCategory();
                if (cccRef == null || (udidName = cccRef.getCode()) == null) {
                    throw new IllegalArgumentException("udid #" + StatisticsHelper.getCostCodeTypeId((CostCodeType)this.getType()) + " for client #" + this.client.getClientID() + " neither has a name nor a category");
                }
            }
            if (udidName.length() > 15) {
                udidName = udidName.substring(0, 15);
            } else if (udidName.length() < 15) {
                StringBuilder sb = new StringBuilder(15);
                sb.append(udidName);
                for (int i = udidName.length(); i < 15; ++i) {
                    sb.append('.');
                }
                udidName = sb.toString();
            }
            return udidName;
        }

        public String getUdidValue() {
            String udidValue = ProfileHelper.getPredefinedUdidValue((CostCodeProperties)this, (List)this.client.getCostCodes());
            if (StringUtils.isBlank((String)udidValue) && StringUtils.isBlank((String)(udidValue = NamedValueHelper.getValueForName((String)("udid." + this.getUdidCode()), this.customParameters)))) {
                log.warn("udid #" + this.getUdidCode() + " is blank for ");
                udidValue = "BLANK";
            }
            return udidValue;
        }
    }
}

