/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.List;

public class AddVendorFopProcessor
extends BaseProcessor {
    public void process(MessageContext context) {
        PaymentType paymentType = (PaymentType)context.getMandatoryObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        Reservation reservation = (Reservation)context.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        for (Product product : GDSHelper.getAllProducts(reservation)) {
            List fops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
            if (!fops.isEmpty()) continue;
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            BigDecimal price = handler.calculateProductPrice((BaseProduct)product, ContractType.VENDOR).getTotal();
            if (product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) {
                price = price.negate();
            }
            Money money = new Money();
            money.setValue(price);
            money.setCurrency(DictHelper.getLocalCurrency2());
            ProductFop fop = new ProductFop();
            fop.setType(paymentType);
            fop.setAmount(money);
            fops.add(fop);
        }
    }
}

